var KTFormControls = function() {
    var language = function() {
        var e = $("#form-import"),
            r = $(".alert-danger", e),
            i = $(".alert-success", e);
        e.validate({
            errorElement: "span",
            errorClass: "help-block help-block-error",
            focusInvalid: !1,
            ignore: "",
            rules: {
                file: {
                    required: true,
                    extension: "zip"
                }
            },
            invalidHandler: function(event, validator) {
                Command: toastr["error"] ("You have some form errors. Please check below."); 
            },
            submitHandler: function(e) {
                var formData = new FormData();
                formData.append('file', $('#file')[0].files[0]);
                $.ajax({
                    url: app_url+'/translation/upload',
                    type: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    cache: false,
                    beforeSend: function () {
                        $(".blockUI").show();
                    },
                    complete: function () {
                        $(".blockUI").hide();
                    },
                    success: function (result) {
                        if(result.status=='validation_failed')
                        {
                            messages = result.messages;
                            for (let x in messages) {
                                Command: toastr["error"](messages[x]);
                                break;
                            }
                        }
                        else
                        {
                            $("#modal-import").modal("hide");
                            Command: toastr["success"](result.message);
                            $("#form-import")[0].reset();
                            setTimeout(() => {
                            location.reload();
                            }, 2000);
                        }
                    },
                    error: function (jqXHR, status, err) {
                        $('.blockUI').hide();
                        if(jqXHR.responseJSON.message!==undefined) {
                            var message = jqXHR.responseJSON.message;
                            if(jqXHR.responseJSON.file!==undefined)
                                message = message+' at '+jqXHR.responseJSON.file
                            if(jqXHR.responseJSON.line!==undefined) {
                                message = message+' on line '+jqXHR.responseJSON.line;
                                $("#error-msg").css("display", "flex");
                                $("#error-msg-upload").text(message);
                                // toastr.error(message);
                            }
                                
                        }


                    }
                });
            }
        })
    };
    var duplicate_language = function() {
        var e = $("#form-duplicate"),
            r = $(".alert-danger", e),
            i = $(".alert-success", e);
        e.validate({
            errorElement: "span",
            errorClass: "help-block help-block-error",
            focusInvalid: !1,
            ignore: "",
            rules: {
                folder_name: {
                    required: true
                },
                name: {
                    required: true
                },
                author: {
                    required: true
                },
                fallback: {
                    required: true
                },
                direction: {
                    required: true
                },
                
            },
            invalidHandler: function(e, t) {
                Command: toastr["error"] ("You have some form errors. Please check below."); 
            },
            success: function(e, r) {
                var i = $(r).parent(".input-icon").children("i");
                $(r).closest(".form-group").removeClass("has-error").addClass("has-success"), i.removeClass("fa-warning").addClass("fa-check")
            },
            submitHandler: function(e) {
                r.hide();
                var formData = { 
                    s_lang : $("#s_lang").val(),
                    folder_name : $("#folder_name").val(),
                    lang_name : $("#lang_name").val(),
                    author_name : $("#author_name").val(),
                    fallback_name : $("#fallback_name").val(),
                    direction_name : $("#direction_name").val(),
                }
                $.ajax({
                    url: app_url+'/translation/duplicate',
                    type: "POST",
                    data: formData,
                    beforeSend: function () {
                        $(".blockUI").show();
                    },
                    complete: function () {
                        $(".blockUI").hide();
                    },
                    success: function (result) {
                        if(result.status=='error'){
                            Command: toastr["error"](result.message);
                            return;
                        }else{
                            $("#modal-duplicate").modal("hide");
                            Command: toastr["success"](result.message);
                            $('#form-duplicate')[0].reset();
                            
                            setTimeout(() => {
                                location.reload();
                            }, 2000);
                        }

                        setTimeout(() => {
                            $(".blockUI").hide();
                            return false;
                        }, 2000);

                    },
                    error: function (jqXHR, status, err) {
                        $('.blockUI').hide();
                        if(jqXHR.responseJSON.message!==undefined) {
                            var message = jqXHR.responseJSON.message;
                            if(jqXHR.responseJSON.file!==undefined)
                                message = message+' at '+jqXHR.responseJSON.file
                            if(jqXHR.responseJSON.line!==undefined) {
                                message = message+' on line '+jqXHR.responseJSON.line;
                                $("#error-msg").css("display", "flex");
                                $("#error-msg-upload").text(message);
                                // toastr.error(message);
                            }
                                
                        }


                    }
                });
            }
        })
    };
    return {
        init: function() {
            language();
            duplicate_language();
        }
    }
}();
jQuery(document).ready(function() {
    KTFormControls.init();
});

