@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
<link href="{{ url('/') }}/resources/assets/css/codemirror.css?v={{$local_version}}" rel="stylesheet" type="text/css" />
<link href="{{ url('/') }}/resources/assets/css/neo.css?v={{$local_version}}" rel="stylesheet" type="text/css" />
<link href="{{ url('/') }}/resources/assets/css/db-check.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<style>
    .index-row {
        display: flex;
        align-items: center;
        border-top: 1px solid #eee !important;
        border-color: #eee !important;
    }
    .index-row>div {
        padding: 10px 12px;
        min-width: 100px;
        text-align: center;
        width: 30%;
    }
    .index-row .table-name {
        width: 70%;
        text-align: left;
    }
    .index-row:hover {
        color: #555 !important;
        background-color: #fafbfc !important;
    }
    .index-row:nth-of-type(odd) {
        background-color: #f7f8fa;
    }
    .index-main {
        border-bottom: 1px solid #eee !important;
    }
    .accordion .card .card-body {
        border-top: 1px solid #ddd;
        padding: 26px;
    }
    .table-action .actions {
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .table-action .actions .action-processing, 
    .table-action .action-failed, 
    .table-action .action-done, 
    .table-action .action-success {
        display: none;
    }
    .table-action .actions .action-apply {
        cursor: pointer;
    }
    .index-main {
        max-height: 350px;
        overflow: hidden;
        overflow-y: scroll;
        overflow-y: overlay;
        display: block;
        width: 100%;
        border-left: 1px solid #DDD;
    }
    .action-apply-all {
        cursor: pointer;
        width: auto;
        display: inline-block;
        float: right;
    }
    .action-apply-all:hover {
        color: #5578eb;
    }
    .fa-hourglass-half:before {
        content: "\f252";
    }
    .md-wait i.fa {
        color: #666;
    }
    #modal-indexes .actions span {
        display: none;
    }
    #modal-indexes .actions span.md-wait {
        display: block;
    }
    #loading1 {
        position: absolute;
        left: 0;
        top: 0;
        right: 0;
        bottom: 0;
        width: 100%;
        display:none;
        z-index: 9999;
    }
    #loading1 i.fa {
        font-size: 50px;
        color: #c2c2c2;
        position: absolute;
        left: 50%;
        top: 50%;
        margin-top: -25px;
        margin-left: -25px;
    }
    #index-error, 
    #index-success {
        display: none;
    }
    #abort-index {
        min-width: 80px !important;
        font-weight: 500;
    }
    a.action-apply.btn-sm {
        padding: 2px 8px !important;
    }
    a.action-apply.btn-sm:hover {
        color:#FFF;
    }
    .table-action .table-index {
        display: none;
    }
    .table-action.indexed .actions span, .table-action.indexed .actions a.action-apply {
        /* display: none; */
    }
    .table-action.indexed .table-index {
        display: block;
    }
    .action-processing i.fa-spinner {
        margin-left: 5px;
        font-size: 16px;
    }
    .index-row {
        min-height: 50px;
    }
    .action-all {
        display: flex;
        width: 100%;
        justify-content: flex-end;
        align-items: center;
    }
    .indexes-head .table-name, .indexes-head .table-action {
        font-weight: 500;
        color: #333;
    }
    .table-action {
        width: 210px;
        text-align: center;
        min-width: 210px !important;
    }
    .indexes-head .table-action {
        margin-right: 10px;
    }
    .fa-hourglass-start:before {
        content: "\f251";
    }
    .fa-hourglass-start {
        animation: 3s execute infinite;
    }
    input.index-ids {
        display: none;
    }
    h3.kt-portlet__head-title {
        white-space: normal;
        min-width: 150px;
    }
    .indexes-head.index-row {
        background: #FFF !important;
    }
    .indexes-head {
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
        border-bottom: 1px solid #ddd;
        min-height: 45px;
    }
    .index-main .index-row:first-child {
        border-top: 0 !important;
    }
    .accordion .card .card-body .kt-portlet__body {
        padding: 20px;
    }
    .accordion {
        box-shadow: 0 0 5px var(--kt-portlet-shadow-color);
    }
    .accordion .card .card-body .kt-portlet {
        margin-bottom: 0;
    }
    .swal2-styled.swal2-cancel {
        background-color: #6e7d88 !important;
    }
    .swal2-styled.swal2-confirm {
        background-color: #3085d6 !important;
    }
    .accordion .card button .notify-warn {
        font-size: 12px !important;
        width: 17px;
        height: 17px;
        line-height: 18px;
    }
    .action-apply-all {
        cursor: pointer;
        width: auto;
        display: inline-block;
        float: right;
        color: #FFF !important;
        padding: 3px 8px !important;
        font-size: 12px !important;
    }
    @keyframes execute {
    0% {
        transform: rotate(0deg);
        transition: .5s ease all;
    }
    50% {
        transform: rotate(180deg);
        transition: .5s ease all;
    }
    100% {
        transform: rotate(360deg);
        transition: .5s ease all;
    }
    }
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
<script src="/themes/default/js/codemirror.js" type="text/javascript"></script>
<script src="/themes/default/js/javascript.js" type="text/javascript"></script>
<script src="/themes/default/js/htmlmixed.js" type="text/javascript"></script>
<script src="/themes/default/js/css.js" type="text/javascript"></script>
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script type="text/javascript">
  
	function copyFunction() {
	  var copyText = document.getElementById("queries");
        copyText.select();
        document.execCommand("copy");
	 Command: toastr["success"] ("@lang('db_check.view.success_message.sql_copied')"); 
	}
	function move() {
	  var bar = new ProgressBar.Line(progress, {
	  strokeWidth: 4,
	  easing: 'easeInOut',
	  duration: 3000,
	  color: '#333',
	  trailColor: '#eee',
	  trailWidth: 1,
	  svgStyle: {width: '100%', height: '100%'}
	});

	bar.animate(1.0);  // Number from 0.0 to 1.0
    }
    function compare_database() {
        // $(".blockUI ").show();
        $.ajax({
            type: "POST",
            url: '{{route('compare_database')}}',
            cache: false,
            beforeSend: function() {
               $(".step1").removeClass("active");
               $(".error-check").hide();
               $("#run-migrate-block").hide();
               $(".error-check .errors").css("display",'none');
               $(".step2").addClass("active");
            },
            success: function (result) {
                // $(".blockUI ").hide();
                if (result.success==1) { // Database has some changes
                    $(".step2").removeClass("active");
                    $(".step3").addClass("active");
                    if (result.output =="") { // Datatbase is uptodate
                    $(".data-updated").addClass('active');
                    $(".data-missing").removeClass('active');
                    return false;
                    }
                    $("#queries").text(result.output);
                    var code = $("#queries")[0];
                    var editor = CodeMirror.fromTextArea(code, {
                        lineNumbers: !0,
                        matchBrackets: !0,
                        styleActiveLine: !0,
                        theme: "neo",
                        mode: "javascript",
                        readOnly: false
                    });
                    editor.on("change", function(){
                        editor.save();
                    });
                    
                }else{
                    $(".step2").removeClass("active");
                    try {
                    var result=JSON.parse(result.output);
                    var html='';
                    $.each(result.data,function(i,val){
                        var icon= val.host_blocked==1 || val.port_blocked==1 ? '<i class="fa fa-times text-danger"></i>':'<i class="fa fa-check text-success"></i>';
                        if(val.host_blocked==1 || val.host_blocked==0){
                            html+='<tr>\
                                        <th> IP</th>\
                                        <td>'+val.host+' </td>\
                                        <td width="50px"> '+icon+'</td>\
                                    </tr>';
                        }
                        if(val.port_blocked==1 || val.port_blocked==0){

                          html+='<tr>\
                                        <th> {{trans('common.label.port')}}</th>\
                                        <td> '+val.port+' </td>\
                                        <td width="50px"> '+icon+'</td>\
                                    </tr>';
                        }
                    });
                        $(".error-check .errors h4").text(result.output);
                        $('.issue-table tbody').html(html);
                        $("#run-migrate-block").hide();
                        $('.issue-table').show();
                        $(".error-check").show();
                        $(".error-check .errors").css("display",'block'); 
  
                    }
                    catch(err) {
                        console.log(err.message);
                        $("#run-migrate-block").hide();
                        $(".error-check").show();
                        $(".error-check .errors h4").text(result.output);
                        $('.issue-table').hide();
                        $(".error-check .errors").css("display",'block'); 
                    }
                    
                    
                }
                
            }
        });
    }
    function rerun_migration() {
        $.ajax({
            type: "POST",
            url: '{{route('rerunMigrations')}}',
            cache: false,
            beforeSend: function() {
                $(".blockUI ").show();
                $("#mg-icon").addClass("fa-spin");
            },
            success: function (result) {
                $(".blockUI ").hide();
                $("#mg-icon").removeClass("fa-spin");
                Command: toastr["success"] ("@lang('db_check.view.success_message.migration_run')"); 
            }
        });
    }
    function store_quries() {
        $.ajax({
            type: "POST",
            url: '{{route('store_quries')}}',
            cache: false,
            data: {queries:$('#queries').val()},
            beforeSend: function() {
               $(".overlay").show();
            },
            success: function (result) {
                $(".overlay").hide();
                if (result.success) {
                    $(".step3").removeClass("active");
                    $(".step4").addClass("active");
                    
                }else{
                   alert(result.output);
                }
                
            }, error: function (result) {
                $(".overlay").hide();
            }
        });
    }
    function getIndexedRequest() {
        var timestamp = new Date().getTime();
        $.ajax({
            type: "GET",
            url: '{{route('getIndexedTables')}}?' + timestamp,
            success: function(result) {
                // Add result to the element with id = base-indexes
                $("#base-indexes").html(result);
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error("Error in AJAX request: ", textStatus, errorThrown);
            }
        });
    }
        <?php
         $tab_index = DB::table('application_settings')->where('setting_name', 'table_indexes_status')->value('setting_value');
         $table_indexed = isset($tab_index) && $tab_index == 1  ? $tab_index : 0;

         $tab_processing = DB::table('application_settings')->where('setting_name', 'table_indexes_process')->value('setting_value');
         $tab_process = isset($tab_processing) && $tab_processing == 1  ? $tab_processing : 0;
              if($tab_process == 0) {
               ?>
                setInterval(() => {
                    getIndexedRequest();
                }, 5000);
               <?php
            }
        ?>
        
	$(document).ready(function() {
        // after 5 seconds function call recursive
        getIndexedRequest();
        $("#abort-index").click(function() {
            $("#modal-indexes").css("opacity", "0.4");
            $("#loading1").show();
            setTimeout(() => {
                $("#loading1").hide();
                $("#index-error").css("display", "flex");
                setTimeout(() => {
                    $("#modal-apply-all").modal("hide");
                    location.reload();
                }, 1500);
            }, 1500);
        });
        var execution_html = `<span class="action-processing" style="display:block"><i class="fa fa-hourglass-start fa-lg"></i> Wait for Execution</span>`;
        var waiting_html = `<span class="action-processing custom" style="display:block"><i class="fa fa-spin fa-spinner fa-lg"></i> Applying Index </span>`;
        $(".action-apply-all").click(function() {
            Swal.fire({
                title: "",
                text: "{{ trans('db_check.view.alert_confirm.apply_indexes') }}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                cancelButtonText: "{{trans('Cancel')}}",
                confirmButtonText: "{{trans('Confirm')}}",
            }).then((result) => {
                if (result.isConfirmed) {
                    var myArray = [];
                    $(".blockUI").show();
                    $(":checkbox:checked").each(function() {
                        myArray.push(this.value);   
                    });
                    for (let index = 0; index < myArray.length; index++) {
                        const element = myArray[index];
                        $("#" + element).children(".table-action").children(".actions").html(execution_html);
                        setTimeout(() => {
                            $("#" + element).children(".table-action").children(".actions").html(waiting_html); 
                            $.ajax({
                                type: "GET",
                                url: 'dbcheck/fixIndexed/'+ element,
                                success: function(result) {
                                    // Add result to the element with id = base-indexes
                                    // console.log(element);
                                    // console.log(result);
                                    $("#" + element).html(result);
                                },
                                error: function(jqXHR, textStatus, errorThrown) {
                                    console.error( "@lang('db_check.view.alert_error.apply_indexes')" , textStatus, errorThrown);
                                }
                            });

                        }, 3000);             
                    }

                    setInterval(() => {
                            getIndexedRequest();
                        }, 5000);
                    document.querySelector('[data-name="menu.tools"] .notify-warn').style.display = "none";
                    document.querySelector('[data-name="menu.db_check"] .notify-warn').style.display = "none";
                    document.querySelector('#headingOne .notify-warn').style.display = "none";             
                    $("#apply_all").css('display', 'none');
                    $(".blockUI").hide();
                }
            }); 
        });

      

        $("body").on("click", ".action-apply", function() {
            var value=$(this).attr("data-name");

            $("#" + value).children(".table-action").children(".actions").html(execution_html);
            setTimeout(() => {
                $("#" + value).children(".table-action").children(".actions").html(waiting_html);   
                $(".blockUI").show();
                $.ajax({
                type: "GET",
                url: 'dbcheck/fixIndexed/'+$(this).attr("data-name"),
                success: function (result) {
                        //add result in id = base-indexes   
                        $("#" + value).children(".table-action").children(".actions").html(waiting_html);          
                        $("#" + value).html(result);   
                        $(".blockUI").hide();
                        setInterval(() => {
                            getIndexedRequest();
                        }, 5000);
                    }
                });
            }, 3000);


        });
        function getMultipleIndexedRequest() {
                
                for (let index = 0; index < 10; index++) {
                    
                   
                }

            }
        $("#table-index").dataTable({
            "aoColumnDefs": [{"bSortable": false, "aTargets": [1,2]}],
            "aaSorting": [[0, "asc"]],
            "sPaginationType": "full_numbers",
            "aLengthMenu": [[5, 10, 50, 100, 500], [5, 10, 50, 100, 500]]
        });
		
		$("#fix-no").click(function() {
			$(".overlay").show();
			setTimeout(function() {
				$(".overlay").hide();
				Command: toastr["success"] ("@lang('db_check.view.success_message.changes_cancelled')"); 
				$(".step3").removeClass("active");
				$(".step5").addClass("active");
			}, 1500);
		});
		
	});
</script>
@endsection

@section(decide_content())

<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="oZyuBLNL">
    {{ Session::get('msg') }}
</div>
@endif
<div id="msg" class="display-hide" data-name="wouonRNG">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>

<div class="row" data-name="BOkBwkCn">
    <div class="col-md-8" data-name="OblPWunJ">
        <div class="kt-portlet kt-portlet--height-fluid" data-name="RUeSLiGx">
        	<div class="kt-portlet__head" data-name="MhywPQnx">
                <div class="kt-portlet__head-label" data-name="jOEbLQpA">
                    <h3 class="kt-portlet__head-title">{{trans('db_check.view.widget_heading.check_database')}}</h3>
                </div>
            </div>
            <div class="kt-portlet__body" data-name="HOTVwIkG">
            	<div class="overlay" data-name="eAhVKVIr">
            		<i class="fa fa-spinner fa-spin" id="loading"></i>
            	</div>
            	<?php
                    $appliction_setting = getApplicationSettings();
                    $updated_date = isset($appliction_setting["updated_date"]) ? $appliction_setting["updated_date"] : date("d-m-Y", filemtime(base_path('version')));
                      $updated_version = $appliction_setting["updated_version"]; 
                      if(empty($appliction_setting["updated_version"])) {   
                            $newVersionAvailable=checkForNewVersion();
                            if($newVersionAvailable['success']==1){
                               $updated_version=$newVersionAvailable['updated_version'];
                            }
                        }
                     
                    // Loading config file
                    require base_path().'/app/Libraries/dbdiff/config.php';
                    // Pinging Source server
                    $host=$params['server1']['host'];
                    $port=$params['server1']['port'];
                    $username=$params['server1']['user'];
                    $password=$params['server1']['password'];
                    $db=$params['input']['source']['db'];
                    $source_server=ping_server($host,$port);
                    // print_r($source_server);exit;

                    // Check connection
                    $error='';
                    try {
                        $mysqli = new mysqli($host,"$username","$password","$db",$port);
                        if ($mysqli->connect_errno) {
                            throw new \Exception($mysqli ->connect_error, 1);
                            
                        }
                        $connection=true;
                    } catch (\Exception $e) {
                       $error=$e->getMessage();
                        $connection=false;
                    }
                    ?>

                <div class="kt-portlet kt-portlet--bordered" data-name="pJODGrH5" id="run-migrate-block">
                    <div class="kt-portlet__head" data-name="qTHZIBmc">
                        <div class="kt-portlet__head-label" data-name="ATccxBNh">
                            <h3 class="kt-portlet__head-title" style="">{{trans('db_check.view.widget_heading.run_migrations')}}</h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body" data-name="vztGIoPd">
                        <div class="steps step1 active" data-name="TfPjnLHH">
                            <i class="fab fa-galactic-republic" id="mg-icon"></i>
                            <p>{{trans('db_check.view.alert_message.migration_run_description')}}</p>
                            
                            <button class="btn btn-info" onclick="rerun_migration();" id="checkUpdateMigration">{{trans('db_check.view.widget_heading.run_migrations')}}</button>
                        </div> 
                    </div>
                </div>   
                   
                
                <div class="hide">
                    <!-- Checking for new version -->
                    @if(trim($updated_version) != trim($local_version) and Auth::user()->role_id == 1) 	
                    <div class="steps error-check active" data-name="rElbldTa">
                        <div class="errors version active" data-name="uMnFEpNf">
                            <div class="kt-portlet kt-portlet--bordered" data-name="pJODGrH5" id="update-app-block">
                                <div class="kt-portlet__head" data-name="qTHZIBmc" style="">
                                    <div class="kt-portlet__head-label" data-name="ATccxBNh">
                                        <h3 class="kt-portlet__head-title" style="">Update Application</h3>
                                    </div>
                                </div>
                                <div class="kt-portlet__body" data-name="vztGIoPd">
                                    <div class="alert alert-danger alert-bold" role="alert" data-name="QMoNdeme">
                                        <div class="alert-text" data-name="UPYRmfdf">
                                            {!! trans('db_check.view.error_message.old_version') !!}
                                        </div>
                                    </div>
                                    <h4 class="text-danger">{{trans('db_check.view.error_message.update_to_latest')}}</h4>
                                    <div class="updateBlk" data-name="myUgLRFt">
                                        <div class="row" data-name="vBLKlvVQ">
                                            <div class="col-md-6 versBlk" data-name="ofHMCPMd">
                                                <span class="nBlk alert-warning">
                                                <small>{{trans('common.label.installed_version')}}</small>
                                            {{$local_version}}
                                                <small>{{trans('common.label.last_updated')}}<br>{{$local_version_date}}</small>
                                                </span>
                                            </div>
                                            <div class="col-md-6 versBlk" data-name="sZZqkokU">
                                                <span class="nBlk alert-success">
                                                <small>{{trans('common.label.latest_version')}}</small>
                                                {{$updated_version}}
                                                <small>{{trans('common.label.release_date')}}<br>{{$updated_date}}</small>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="{{ url('update') }}" class="btn btn-success">{{trans('db_check.view.button.update_application')}}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @elseif(!empty($source_server) && ( (isset( $source_server[0]['host_blocked']) && $source_server[0]['host_blocked']==1) || ( isset($source_server[1]['port_blocked']) && $source_server[1]['port_blocked']==1) || $connection==false ))
                    <!-- Step 2 -->
                    <!-- Showing error when not connection to source or target -->
                    <!-- if Error Encountered, Show Error -->
                    <div class="error-check active" data-name="fFACIfFq">
                        <div class="errors connect active" data-name="IRRavmSo">
                            <div class="alert alert-danger alert-bold" role="alert" data-name="qMmOxRlL">
                                <div class="alert-text" data-name="bmUcbqNb">
                                {!! trans('db_check.view.error_message.error_encountered') !!}
                                </div>
                            </div>
                            @if($error)
                            <h4 class="text-danger">Access denied to the remote server</h4>
                            @else
                            <h4 class="text-danger">{!! trans('db_check.view.error_message.unable_to_connect') !!}</h4>
                            @endif
                            <div class="issue-table active" data-name="ABCoYzdl">
                                <table class="table table-striped table-bordered table-hover responsive">
                                    <tbody>
                                        @foreach($source_server as $server)
                                        <tr>
                                            <th>{{( isset($server['host_blocked']) && ($server['host_blocked']==1 || $server['host_blocked']==0)) ? trans('common.label.host') : trans('common.label.port')}}</th>
                                            <td>{{( isset($server['host_blocked']) && ($server['host_blocked']==1 || $server['host_blocked']==0)) ? $server['host'] : $server['port']}}</td>
                                            <td width="50px">{!! ((isset($server['host_blocked']) && $server['host_blocked']==1) || (isset($server['port_blocked']) && $server['port_blocked']==1)) ? '<i class="fa fa-times text-danger"></i>':'<i class="fa fa-check text-success"></i>' !!}</td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-center" data-name="DTPDmsOC">
                                <button class="btn btn-info" onclick="location.reload();" id="checkUpdate">{{trans('db_check.view.button.check_again')}}</button>
                            </div>

                        </div>
                        @if($error)
                        <h4 class="text-danger">{{trans('db_check.view.error_message.remote_server_heading')}}</h4>
                        @else
                        <h4 class="text-danger">{!! trans('db_check.view.error_message.unable_to_connect') !!}</h4>
                        @endif
                        <div class="issue-table active" data-name="ABCoYzdl">
                            <table class="table table-striped table-bordered table-hover responsive">
                                <tbody>
                                    @foreach($source_server as $server)
                                    <tr>
                                        <th>{{( isset($server['host_blocked']) && ($server['host_blocked']==1 || $server['host_blocked']==0)) ? trans('common.label.host') : trans('common.label.port')}}</th>
                                        <td>{{( isset($server['host_blocked']) && ($server['host_blocked']==1 || $server['host_blocked']==0)) ? $server['host'] : $server['port']}}</td>
                                        <td width="50px">{!! ((isset($server['host_blocked']) && $server['host_blocked']==1) || (isset($server['port_blocked']) && $server['port_blocked']==1)) ? '<i class="fa fa-times text-danger"></i>':'<i class="fa fa-check text-success"></i>' !!}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center" data-name="DTPDmsOC">
                            <button class="btn btn-info" onclick="location.reload();" id="checkUpdate">{{trans('db_check.view.button.check_again')}}</button>

                        </div>
                    </div>
                    @else
                    <!-- Step 3 -->
                    <!-- Connection established, update DB -->
                    <div class="steps step1 active" data-name="TfPjnLHH">
                        <i class="fa fa-database"></i> 
                        <p>{{trans('db_check.view.alert_message.press_button')}}</p>
                        <button class="btn btn-info" onclick="compare_database();" id="checkUpdateMigration">{{trans('db_check.view.button.check_remote_schema')}}</button>
                    </div> 
                    <!-- if Error Encountered, Show Error -->
                    <div class="error-check" data-name="XmzoXNFu">
                        <div class="errors connect" data-name="aZJmOOYj">
                            <div class="alert alert-danger alert-bold" role="alert" data-name="ZwcrHDlT">
                                <div class="alert-text" data-name="gGeBTUZW">
                                {!! trans('db_check.view.error_message.error_encountered') !!}
                                </div>
                            </div>
                            <h4 class="text-danger">{!! trans('db_check.view.error_message.unable_to_connect') !!}</h4>
                            <div class="issue-table" data-name="kpPSsGtI">
                                <table class="table table-striped table-bordered table-hover responsive">
                                    <tbody>
                                        
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-center" data-name="GjhEZHHo">
                                <button class="btn btn-info" onclick="compare_database();" id="checkUpdate">{{trans('db_check.view.button.check_again')}}</button>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="steps step2 waiting" data-name="mEimxRfZ">
                        <i class="fa fa-cog fa-spin"></i>
                        <span class="checking">{!! trans('db_check.view.label.checking_db') !!} <span class="one">.</span><span class="two">.</span><span class="three">.</span></span>
                        <div class="progress" data-name="dJNQvPUt">
                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-info" id="progress" role="progressbar" style="width: 100%" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" data-name="jQIMYqfh"></div>
                        </div>
                    </div>

                    <div class="steps step3 result1" data-name="QTsmvZmv">
                        <div class="data-updated" data-name="RHyApVda">
                            <div class="alert alert-success alert-bold" role="alert" data-name="kwlbwHxd">
                                <div class="alert-text" data-name="dIuALxhi">{!! trans('db_check.view.alert_success.db_uptodate') !!}</div>
                            </div>
                            <a href="{{ url('/') }}/dashboard" class="btn btn-success">{!! trans('db_check.view.button.go_to_dashboard') !!}</a>
                        </div>
                        <div class="data-missing active" data-name="QWwDGvDd">
                            <div class="alert alert-warning alert-bold" role="alert" data-name="HqyHKGNY">
                                <div class="alert-text" data-name="JaCWcvNm">{!! trans('db_check.view.error_message.sql_missing_queries') !!}</div>
                            </div>
                            <div class="codearea" data-name="NqJiLGBp">

                                <a href="javascript:;" class="text-sucess pull-right" onclick="copyFunction()" id="menual"><i class="la la-copy"></i> {!! trans('db_check.view.label.copy_sql') !!}</a>
                                <textarea id="queries" class="codemirror-textarea">	</textarea>
                            </div>
                            <button class="btn btn-default btn-sm" id="fix-no"> @lang('common.form.button.cancel') </button>
                            <button class="btn btn-success pull-right btn-sm" onclick="store_quries();" id="finalupdate">@lang('common.form.button.update')</button>
                        </div>	
                    </div>

                    <div class="steps step4 finished" data-name="qUhNgqaP">
                        <div class="success text-success" data-name="NttJpHEb">
                            <i class="fa fa-thumbs-up"></i>
                        </div>
                        <p>{!! trans('db_check.view.alert_message.process_started') !!}</p>
                        <a href="{{ url('/') }}/dashboard" class="btn btn-success">{!! trans('db_check.view.button.go_to_dashboard') !!}</a>
                    </div>

                    <div class="steps step5 cancel" data-name="xjutbFOF">
                        <div class="cancelled" data-name="GYYeSWyf">
                            <i class="fa fa-window-close"></i>
                        </div>
                        <p>{!! trans('db_check.view.alert_message.operation_cancelled') !!}</p>
                        <a href="{{ url('/') }}/dashboard" class="btn btn-success">{!! trans('db_check.view.button.go_to_dashboard') !!}</a>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<div class="row" data-name="BOkBwkCn">
    <div class="col-md-8" data-name="OblPWunJ">
        <div class="accordion" id="accordionIndex">
            <div class="card mb1">
                <div class="card-header" id="headingOne">
                    <h2 class="mb-0">
                        <button class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            {{trans('db_check.view.widget_title.database_indexes')}} <?php if($table_indexed == 0) { ?> <span class="notify-warn">!</span> <?php } ?>
                        </button>
                    </h2>
                </div>
                <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordionIndex">
                    <div class="card-body">
                        <div class="kt-portlet kt-portlet--bordered" data-name="pJODGr96">
                            <div class="kt-portlet__head" data-name="qTHZIBmc">
                                <div class="kt-portlet__head-label" data-name="ATccxBNh">
                                    <h3 class="kt-portlet__head-title" style="">{{trans('db_check.view.widget_title.all_indexes')}}</h3>
                                </div>
                                <?php 
                                if($table_indexed == 0) {
                                    ?>
                                    <div class="kt-portlet__head-label action-all">
                                        <a href="javascript:;" id="apply_all" class="action-apply-all btn btn-sm btn-info">{{trans('db_check.view.button.apply_all')}}</a>
                                    </div>
                                    <?php
                                }
                                else {
                                ?>
                                <div class="kt-portlet__head-label action-all">
                                    <a href="javascript:;" class="disabled btn btn-sm btn-success " style="display:none">{{trans('db_check.view.button.apply_all')}}</a>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                            <div class="kt-portlet__body" data-name="vztGIoPd">
                                <div class="indexes-head index-row">
                                    <div class="table-name">
                                        {{trans('db_check.view.table_heading.table_name')}}
                                    </div>
                                    <div class="table-action">
                                        {{trans('db_check.view.table_heading.indexes')}}
                                    </div>
                                </div>
                                <div class="index-main scroll" id="base-indexes">
                                
                                </div>
                            </div>
                        </div>                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>       
@endsection