<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["title"] = "Split Tests";
$lang["view"]["description"] = "Manage advanced split testing by comparing multiple variations of your email campaigns. This feature ensures optimal performance by automatically analyzing and selecting the best-performing variations for your audience.";
$lang["view"]["table_heading"]["name"] = "Split Test Name";
$lang["view"]["table_heading"]["based_on"] = "Based on";
$lang["view"]["table_heading"]["type"] = "Criteria";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["add"]["title"] = "Create a Split Test";
$lang["add"]["description"] = "Create a new split test to experiment with different campaign variations. Customize the variations to be tested, and " . $lang["variables"]["site_title"] . " will analyze performance, selecting the best-performing option to maximize engagement and deliverability.";
$lang["form_heading"] = "Split Test Settings";
$lang["form"]["label"]["split_test_name"] = "Split Test Name";
$lang["form"]["label"]["split_test_name_description"] = "Specify the name for the split test being created to identify easily.";
$lang["form"]["label_option"]["based_on_campaign_performance"] = "Based on broadcast performance";
$lang["form"]["label_option"]["based_on_campaign_performance_description"] = "Choose the best variant of the broadcast";
$lang["form"]["label_option"]["based_on_description"] = "Choose from the broadcasts listed below to include in the split test. A minimum of two selections is required to proceed with the test.";
$lang["form"]["label"]["winning_criteria"] = "Winning criteria";
$lang["form"]["label"]["winning_criteria_description"] = "<p>Choose how the winning element will be determined:<br>
<b>Open Rate: </b>&nbsp; Select the element with the highest open rate.<br>
<b>Click-through Rate: </b>&nbsp; Select the element with the highest click-through rate<br>
<b>Click-through Rate for a Specific Hyperlink: </b>&nbsp; Select the element with the highest click-through rate for a specific link.</p>";
$lang["form"]["label"]["winning_criteria_option"]["open_rate"] = "Open Rate";
$lang["form"]["label"]["decision_percentage"] = "Decision percentage";
$lang["form"]["label"]["decision_percentage_description"] = "Specify the percentage of your total audience that will receive the selected broadcasts. For example, if set to 10% and your total audience is 100,000, each variation will be sent to an equal portion of 2,000 recipients, totaling 10,000 emails. The system will then analyze the results before selecting the winning broadcast.";
$lang["form"]["label"]["send_remaining_after"] = "Duration to wait for the results";
$lang["form"]["label"]["send_remaining_after_description"] = "The time duration to wait before determining the winning element and sending the rest of the emails.";
$lang["form"]["label"]["action_to_perform"] = "Action to perform";
$lang["form"]["label"]["action_to_perform_description"] = "Select an action to perform when the winning element has been decided.";
$lang["form"]["label"]["action_to_perform_option"]["action_to_perform_opt1"] = "Find winning element and update the results";
$lang["form"]["label"]["action_to_perform_option"]["action_to_perform_opt2"] = "Find winning element and send leftover to it";
$lang["form"]["label"]["winning_criteria_option"]["click_through_rate"] = "Unique click-through rate";
$lang["add_new"]["form"]["click_through_rate_specific_link"] = "Unique click-through rate for a specific link";
$lang["edit"]["title"] = "Edit Split Test";
$lang["edit"]["description"] = "Adjust and fine-tune your split test parameters to compare variations of your campaigns. Evaluate performance metrics and optimize content for improved engagement and conversion rates.";
$lang["form"]["label"]["decision_percentage_note"] = "Emails will be sent in equal groups to this percentage of the audience.";
$lang["form"]["label"]["send_remaining_after_note"] = "The winning element will be identified after this duration, and the remaining portion of the list will receive that version.";
$lang["update"]["notification"]["activity_title"] = "Split Test";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
