<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["description"] = "Manage and configure your sending nodes, which are responsible for processing and delivering emails through your infrastructure. Set up, edit, and monitor sending nodes to optimize your email sending performance and ensure efficient routing of emails.";
$lang["view"]["tab_title"]["nodes"] = "Nodes";
$lang["view"]["filter_option"]["all"] = "All";
$lang["view"]["filter_option"]["smtp"] = "SMTPs";
$lang["view"]["filter_option"]["sendgrid"] = "Sendgrid";
$lang["view"]["filter_option"]["mailgun"] = "Mailgun";
$lang["view"]["tab_title"]["servers"] = "Servers";
$lang["view"]["table_heading"]["name"] = "Node Name";
$lang["view"]["table_heading"]["group"] = "Group";
$lang["view"]["table_heading"]["type"] = "Type";
$lang["view"]["table_heading"]["from_name"] = "From Name";
$lang["view"]["table_heading"]["reply_email"] = "Reply Email";
$lang["view"]["table_heading"]["sr"] = "No.";
$lang["view"]["table_heading"]["server_name"] = "Server Name";
$lang["view"]["table_heading"]["host"] = "Host";
$lang["view"]["table_heading"]["server_ip"] = "Server IP";
$lang["modal"]["heading"]["edit_configuration"] = "Edit Credentials";
$lang["modal"]["label"]["server_name"] = "Server Name";
$lang["modal"]["label"]["server_ip"] = "Server IP";
$lang["modal"]["label"]["root_user"] = "Username";
$lang["modal"]["label"]["password"] = "Password";
$lang["modal"]["label"]["ssh_port"] = "SSH Port";
$lang["modal"]["label"]["protocol"] = "Webmonitor Protocol";
$lang["modal"]["protocol_option"]["http"] = "http";
$lang["modal"]["protocol_option"]["https"] = "https";
$lang["modal"]["table_heading"]["smtp_name"] = "Node Name";
$lang["modal"]["table_heading"]["group_name"] = "Node Group";
$lang["modal"]["label"]["connectivity_description"] = "This process will begin testing the connectivity of the selected sending nodes. Please select from the following actions if required:";
$lang["view"]["bulk_actions_dropdown"]["connection"] = "Test Connection";
$lang["modal"]["connectivity_option"]["set_successful"] = "Activate functional sending nodes";
$lang["modal"]["connectivity_option"]["set_unsuccessful"] = "Deactivate non-functional sending nodes";
$lang["modal"]["connectivity_description"]["note"] = "Please note: This functionality only works for the SMTP type sending nodes. For other types of sending nodes, you must send a test email to verify their functionality.";
$lang["modal"]["button"]["start"] = "Start Testing";
$lang["modal"]["table_heading"]["type"] = "Type";
$lang["modal"]["link"]["download_results"] = "Download Results";
$lang["modal"]["heading"]["import_smtp"] = "Import Nodes";
$lang["modal"]["label"]["smtp_type"] = "Node Type";
$lang["modal"]["link"]["download_sample"] = "Download Sample File";
$lang["modal"]["table_heading"]["sr"] = "No.";
$lang["modal"]["table_heading"]["name"] = "Node Name";
$lang["modal"]["table_heading"]["import_status"] = "Import Status";
$lang["modal"]["table_heading"]["errors"] = "Errors and Notices";
$lang["upload_file"]["error_message"]["missing_column"] = "Missing :name column.";
$lang["upload_file"]["error_message"]["missing_value"] = "<b>Skipped (missing value):</b> :label";
$lang["upload_file"]["error_message"]["wrong_format"] = "<b>Skipped (wrong format):</b> :label";
$lang["upload_file"]["error_message"]["domain_missing"] = "<b>Skipped:</b> The domain doesn't exist in your sending domains";
$lang["upload_file"]["error_message"]["tracking_domain_not_exist"] = "<b>Skipped:</b> The tracking domain doesn't exist in your sending domains";
$lang["upload_file"]["error_message"]["bounce_email_missing"] = "<b>Skipped:</b> The bounce email doesn't exist in your bounce addresses";
$lang["upload_file"]["error_message"]["notice"] = "<b>Notice:</b> Missing value for :column, so updating to the default value <b>:default</b>";
$lang["add"]["title"] = "Add Sending Node";
$lang["add"]["description"] = "Configure a new sending node to manage email delivery. Choose from various types of sending nodes, such as SMTP, API-based services, or custom setups. Input the required details like hostname, port, and authentication credentials to ensure smooth connectivity and efficient email routing.";
$lang["add_new"]["account_tab"]["title"] = "Account";
$lang["add_new"]["account_tab"]["description"] = "Account";
$lang["add_new"]["account_tab"]["form"]["heading"] = "Sending Node Details";
$lang["form"]["heading_description"] = "Integration details and sender information of the sending node.";
$lang["form"]["label"]["status_description"] = "<p><strong>Active:</strong> Active sending nodes are ready to relay emails.
<strong>Inactive:</strong> Inactive sending nodes do not appear in the scheduling process.</p>";
$lang["form"]["label"]["node_name"] = "Node Name";
$lang["form"]["label"]["node_name_description"] = "Provide a friendly name for the sending node for identification purposes.";
$lang["form"]["label"]["mail_encoding"] = "Mail Encoding";
$lang["form"]["label"]["mail_encoding_description"] = "Choose the mail encoding method for the emails sent from this node.";
$lang["add_new"]["form"]["quoted_printable"] = "Quoted-Printable";
$lang["add_new"]["form"]["8bit"] = "8-bit";
$lang["add_new"]["form"]["base64"] = "Base64";
$lang["add_new"]["form"]["binary"] = "Binary";
$lang["form"]["label"]["sender_name"] = "Sender Name";
$lang["form"]["label"]["sender_name_description"] = "The name that will appear as the sender in the recipient's mailbox.";
$lang["form"]["label"]["sender_email"] = "Sender Email";
$lang["form"]["label"]["sender_email_description"] = "The email address that will appear as the sender in the recipient's mailbox.";
$lang["form"]["bounce_email_placeholder"]["choose_bounce_email"] = "Select bounce email";
$lang["form"]["label"]["tracking_domain"] = "Tracking Domain";
$lang["form"]["masked_domain_placeholder"]["choose_tracking_domain"] = "Select tracking domain";
$lang["form"]["label"]["tracking_domain_description"] = "The tracking domain will appear in all hyperlinks, image URLs, and tracking pixels for outgoing emails.";
$lang["add_new"]["form"]["host"] = "SMTP Host";
$lang["add_new"]["form"]["host_help"] = "The hostname of the SMTP server to connect with.";
$lang["add_new"]["form"]["username_help"] = "The username required to authenticate with the SMTP server.";
$lang["add_new"]["form"]["password_help"] = "The password required to authenticate with the SMTP server.";
$lang["add_new"]["form"]["port"] = "Port";
$lang["add_new"]["form"]["port_help"] = "The port number to be used for connecting to the SMTP server.";
$lang["add_new"]["form"]["encryption_help"] = "<td>Encryption ensures that the email content is protected from being accessed by anyone other than the intended recipients.<br><br>
<span style='font-size:14px'><strong>None:</strong> No encryption is applied; the SMTP server sends emails in plain text.<br><strong>TLS:</strong> TLS is a cryptographic protocol that provides end-to-end security for communications over networks, widely used for internet communications and transactions.<br><strong>SSL:</strong> SSL adds an encryption layer over plaintext communication, allowing secure transmission between email servers.</span></td>";
$lang["add_new"]["form"]["validate"] = "Validate Connection";
$lang["add_new"]["form"]["show_logs"] = "Show logs";
$lang["form"]["label"]["additional_headers"] = "Additional Headers";
$lang["form"]["label"]["additional_headers_description"] = "<ul><li><strong>Header:</strong> The custom header that will be added to every outgoing email.</li><li><strong>Value:</strong> The content or data associated with the header, which can include custom fields, system variables, spintax, or dynamic tags for more personalized emails.</li></ul>";
$lang["add_new"]["sender_tab"]["title"] = "Sender";
$lang["add_new"]["sender_tab"]["description"] = "Sender";
$lang["form_heading"] = "Sending Node Settings";
$lang["form_heading_description"] = "Select a sending node type and input the authentication details.";
$lang["add_new"]["connectivity_tab"]["title"] = "Connectivity";
$lang["add_new"]["connectivity_tab"]["description"] = "Connectivity";
$lang["add_new"]["settings_tab"]["title"] = "Settings";
$lang["add_new"]["settings_tab"]["description"] = "Settings";
$lang["form"]["label"]["additional_headers_description"] = "Add custom email headers which will be embedded to the email when this sending node is used. These can be set as per your requirement or other tracking purposes.";
$lang["form"]["label"]["additional_headers_note"] = "<b>Note:</b> No special characters or spaces are supported except hyphens (-).";
$lang["edit"]["page"]["title"] = "Edit Sending Node";
$lang["edit"]["page"]["description"] = "Modify the sending node's settings, including sender details, SMTP configuration, and advanced options like encryption and additional headers. Ensure the sending node is optimized for proper email delivery and compliance with authentication protocols.";
$lang["method"] = "Method";
$lang["signin_to_go_security_page"] = "Sign in and go to your Account security page.";
$lang["turn_on_verification"] = "Turn on Two-Step Verification if it's not.";
$lang["turn_off_verification"] = "Turn off Two-Step Verification if it's not.";
$lang["generate_app_password"] = "Click Generate app password or Manage app passwords";
$lang["select_other_app"] = "Select 'other app' from the drop down menu, write " . $lang["variables"]["site_title"] . " and click Generate.";
$lang["app_password_as_smtp"] = "Use this app password as SMTP Password.";
$lang["method_two"] = "Method 2";
$lang["using_app_password"] = "Using App Password";
$lang["enable_allow_apps"] = "Enable Allow apps that use less secure sign-in.";
$lang["process_delivery_reports"] = "Process Delivery Reports";
$lang["process_details_title"] = "Configuring :app Webhooks";
$lang["process_delivery_reports_help"] = "Enable it if you want to process delivery status reports for all recipients";
$lang["api_key_link"] = "Not sure where to find API Key?";
$lang["api_key"] = "API Key";
$lang["get_api_keys"] = "Obtaining :app API Key";
$lang["api_key_help"] = "Insert your :app API key";
$lang["domain_name"] = "Domain Name";
$lang["domain_name_eg"] = "e.g mg.mydomain.com";
$lang["connectivity"]["sendgrid"]["title"] = "Sendgrid Integration";
$lang["connectivity"]["sendgrid"]["description"] = "Connect your Sendgrid account by filling up the required fields below.";
$lang["connectivity"]["sendgrid"]["form"]["to_your_sendgrid_account"] = "to your SendGrid Account";
$lang["connectivity"]["sendgrid"]["form"]["navigate_to_settings"] = "Navigate to Settings";
$lang["connectivity"]["sendgrid"]["form"]["create_api_key"] = "Click on 'Create API Key?' button and copy the key";
$lang["connectivity"]["sendgrid"]["form"]["api_key"] = "Click on 'Create API Key?' button and copy the key";
$lang["connectivity"]["sendgrid"]["form"]["webhooks_recommended"] = "Webhooks (Recommended)";
$lang["connectivity"]["sendgrid"]["form"]["webhooks_recommended_help"] = "<p><strong>Webbooks:</strong> Use webhooks to postback delivery status notifications to " . $lang["variables"]["site_title"] . ".</p>";
$lang["connectivity"]["sendgrid"]["form"]["mail_settings"] = "Mail Settings";
$lang["connectivity"]["sendgrid"]["form"]["turn_on_notification"] = "Turn on Event Notification, select from the actions you want to get processed and paste the callback URL you see in " . $lang["variables"]["site_title"] . "";
$lang["connectivity"]["sendgrid"]["form"]["click_copy_button"] = "Click on button to copy URL";
$lang["connectivity"]["mailgun"]["title"] = "Mailgun Integration";
$lang["connectivity"]["mailgun"]["description"] = "Connect your Mailgun account by filling up the required fields below.";
$lang["connectivity"]["mailgun"]["api_key_find_help"] = "<div class='api_key_find_help'>
 <p>Inside the <b>Mailgun Control Panel</b> (options displayed down the left-hand side on a dark column), the API keys appear on only one page. To view the API keys, use the following instructions:</p>
 <ol>
  <li>Click on <b>Settings</b> on the left-hand side of your <a href='https://app.mailgun.com/app/dashboard' target='_blank'>Mailgun dashboard</a></li>
  <li>Select <b>Security & Users</b> from the menu below on the left-hand side</li>
  <li>Click on the <b>API security</b> tab</li>
  <li>On the following page, under the <b>API Keys</b> section, you'll see both your Private and Public API keys</li>
  <li>Click on the <b>eye</b> icon to make the Private API key visible and copy it</li>
 </ol></div>";
$lang["connectivity"]["mailgun"]["api_configure_help"] = "<div class='api_key_find_help'>
 <p>Configure Mailgun webhooks by following the steps below to process the delivery status notifications for the outgoing message</p>
 <ol>
  <li>Click on <b>Sending </b> on the left-hand side of your <a href='https://app.mailgun.com/app/dashboard' target='_blank'>Mailgun dashboard</a></li>
  <li>Click on <b>Webhooks</b> and select the domain from the top dropdown</li>
  <li>Click on <b>Add Webhook</b> button</li>
  <li>Select from the <b>Event Types</b> and paste the <b>Callback</b> URL you see in " . $lang["variables"]["site_title"] . " and press <b>Create Webhook</b> button</li>
 </ol></div>";
$lang["connectivity"]["amazon"]["title"] = "Amazon Integration";
$lang["connectivity"]["amazon"]["description"] = "Connect your Amazon account by filling up the required fields below.";
$lang["connectivity"]["amazon"]["form"]["access_key_id"] = "Access Key ID";
$lang["connectivity"]["amazon"]["form"]["secret_access_key"] = "Secret Access Key";
$lang["connectivity"]["amazon"]["form"]["region"]["title"] = "Region";
$lang["form"]["amazon_region"]["option_1"] = "US East (Ohio)us-east-2";
$lang["form"]["amazon_region"]["option_2"] = "US East (N. Virginia)";
$lang["form"]["amazon_region"]["option_3"] = "US West (N. California)";
$lang["form"]["amazon_region"]["option_4"] = "US West (Oregon)";
$lang["form"]["amazon_region"]["option_5"] = "Asia Pacific (Mumbai)";
$lang["form"]["amazon_region"]["option_6"] = "Asia Pacific (Osaka-Local)**";
$lang["form"]["amazon_region"]["option_7"] = "Asia Pacific (Seoul)";
$lang["form"]["amazon_region"]["option_8"] = "Asia Pacific (Singapore)";
$lang["form"]["amazon_region"]["option_9"] = "Asia Pacific (Sydney)";
$lang["form"]["amazon_region"]["option_10"] = "Asia Pacific (Tokyo)";
$lang["form"]["amazon_region"]["option_11"] = "Canada (Central)";
$lang["form"]["amazon_region"]["option_12"] = "China (Beijing)";
$lang["form"]["amazon_region"]["option_13"] = "China (Ningxia)";
$lang["form"]["amazon_region"]["option_14"] = "EU (Frankfurt)";
$lang["form"]["amazon_region"]["option_15"] = "EU (Ireland)";
$lang["form"]["amazon_region"]["option_16"] = "EU (London)";
$lang["form"]["amazon_region"]["option_17"] = "EU (Paris)";
$lang["form"]["amazon_region"]["option_18"] = "EU (Stockholm)";
$lang["form"]["amazon_region"]["option_19"] = "South America (SÃ£o Paulo)";
$lang["connectivity"]["amazon"]["form"]["get_api_keys"] = "Obtaining Amazon SES API Credentials";
$lang["connectivity"]["amazon"]["form"]["how_to_get_api_keys"] = "<p>Follow the steps below to obtain Amazon SES API Credentials to connect it with " . $lang["variables"]["site_title"] . ".<br>&nbsp;</p>
 <ol>
 <li><strong><a href=\"https://console.aws.amazon.com/console/home\" target=\"_blank\">Login</a></strong>&nbsp;to <strong>Amazon AWS Console</strong></li>
 <li>Click on your Name in the top navigation and navigate to&nbsp;<strong><a href=\"https://console.aws.amazon.com/iam/home?#/security_credential\" target=\"_blank\">My Security Credentials</a></strong></li>
 <li>Click on <strong>Users</strong> and <strong>Add New</strong></li>
 <li>Write a <strong>Username</strong>, choose access type as <strong>Programmatic Access</strong> and click Next.</li>
 <li>Select <strong>\"Attach existing policies directly\"</strong> and select <strong>\"AmazonSESFullAccess\"</strong> from the list</li>
 <li>Click next and then click <strong>Next: Review</strong></li>
 <li>Click <strong>Create User</strong> and copy the <strong>Access Key ID</strong> and <strong>Secret Access Key</strong>.</li>
 </ol>";
$lang["connectivity"]["amazon"]["form"]["simple_notification_service"] = "Simple Notification Service (SNS)";
$lang["connectivity"]["amazon"]["form"]["process_delivery_reports_using_sns"] = "Configuring Simple Notification Service (SNS) in Amazon";
$lang["connectivity"]["amazon"]["form"]["configure_sns"] = "<ol>
 <li><strong><a href=\"https://console.aws.amazon.com/console/home\" target=\"_blank\">Login</a></strong>&nbsp;to Amazon <strong>AWS Console</strong></li>
 <li>Now Navigate to&nbsp;<strong><a href=\"https://console.aws.amazon.com/ses/home\" target=\"_blank\">SES Home</a></strong></li>
 <li>Click on <strong>Configuration Sets</strong></li>
 <li>Click on the&nbsp;<strong>\"Create Configuration Set\"</strong> button and define a name e.g " . $lang["variables"]["site_title"] . "-Report. (This configuration set name will be used in step 21)</li>
 <li>Click on the <strong>recently created</strong> Configuration Set</li>
 <li>In <strong>\"Add Destination\"</strong> and choose <strong>SNS</strong> from the dropdown</li>
 <li>Write a <strong>name</strong> e.g " . $lang["variables"]["site_title"] . "-SNS and select the <strong>event types</strong> you want " . $lang["variables"]["site_title"] . " to process. Most commonly used events are
 <ul>
 <li>Reject</li>
 <li>Delivery</li>
 <li>Bounce</li>
 <li>Complaint</li>
 <li>Rendering Failure</li>
 </ul>
 </li>
 <li>From the Topic dropdown, select <strong>\"Create SNS Topic\"</strong></li>
 <li>Define a <strong>Topic Name</strong> e.g " . $lang["variables"]["site_title"] . "-SNS-Topic and Display Name</li>
 <li>Press <strong>Save</strong></li>
 <li>Now Navigate to&nbsp;<strong><a href=\"https://console.aws.amazon.com/sns/v3\" target=\"_blank\">Amazon Simple Notification Service (SNS)</a></strong></li>
 <li>Navigate to <strong>Topics</strong></li>
 <li>Click on the <strong>recently created</strong> topic ARN</li>
 <li>Click on <strong>\"Create Subscription\"</strong> button</li>
 <li>Use the correct <strong>protocol</strong> i.e HTTP or HTTPS</li>
 <li>
 In <strong>Endpoint</strong>, paste the <strong>callback</strong><br>
 <div class=\"urldmn\"><input type=\"text\" id=\"copyurl2\" class=\"form-control\" name=\"\" value=\"" . $lang["variables"]["site_title"] . "\" readonly=\"\" aria-invalid=\"false\"><i class=\"fa fa-copy\" title=\"Click on button to copy URL\" onclick=\"copyFunction2()\"></i></div>
 </li>
 <li>Click <strong>\"Create Subscription\"</strong></li>
 <li><button type=\"button\" id=\"process1\" class=\"btn btn-info btn-xs\">Click Here</button> if you are done with all the steps listed above</li>
 <li><button type=\"button\" id=\"process2\" disabled=\"\" class=\"btn btn-info btn-xs\">Click Here</button> to fetch the confirmation URL and then click the button below to confirm subscription.</li>
 <li>Now click on the&nbsp;<strong>\"Confirm Subscription\"</strong> button to open the confirmation page in a new tab. Once you see the confirmed message in XML format, it means the confirmation was <strong>successful</strong></li>
 <li>Paste the <strong>Configuration Set Name</strong> in the textbox that you have&nbsp;created in step 4.</li>
 </ol>";
$lang["connectivity"]["amazon"]["form"]["confirm_subscription"] = "Confirm Subscription";
$lang["connectivity"]["amazon"]["form"]["you_are_all_set_now"] = "You are all set now. Just write your Configuration Set name in the field below";
$lang["connectivity"]["amazon"]["form"]["configuration_set_name"] = "Configuration Set Name";
$lang["connectivity"]["amazon"]["form"]["configuration_set_name_step4"] = "Configuration Set Name is the one that you setup in Step #4.";
$lang["connectivity"]["sparkPost"]["title"] = "SparkPost";
$lang["connectivity"]["sparkPost"]["description"] = "Connect your SparkPost account by filling up the required fields below.";
$lang["connectivity"]["sparkPost"]["form"]["howto_find_sparkpost_apikey"] = "<ol>
 <li><strong><a href=\"https://app.sparkpost.com/auth\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Sparkpost</strong> Account</li>
 <li>Navigate to Configuration -&gt;&nbsp;<strong><a href=\"https://app.sparkpost.com/account/api-keys\" target=\"_blank\">API Keys</a></strong></li>
 <li>Click on <strong>\"Create API Key\"</strong> button</li>
 <li>Write any <strong>API Key Name</strong></li>
 <li>Select \"All\" for <strong>API Permissions</strong></li>
 <li>Click on <strong>\"Create API Key\"</strong> button and copy it</li>
 </ol>";
$lang["connectivity"]["sparkPost"]["form"]["configuring_sparkpost_apikey"] = "<ol>
 <li><strong><a href=\"https://app.sparkpost.com/auth\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Sparkpost</strong> account</li>
 <li>Navigate to Configuration -&gt;&nbsp;<strong><a href=\"https://app.sparkpost.com/webhooks\" target=\"_blank\">Webhooks</a></strong>&nbsp;and click on&nbsp;<strong><a href=\"https://app.sparkpost.com/webhooks/create\" target=\"_blank\">Create Webhook</a></strong>&nbsp;button</li>
 <li>Write any webhook name, copy the <strong>callback</strong> URL from " . $lang["variables"]["site_title"] . " and paste&nbsp;into <strong>Target</strong> field</li>
 <li>Select from the <strong>Events</strong> you want to be processed by " . $lang["variables"]["site_title"] . ". If you want to process all events then select \"All Events\". <span style=\"font-size:14px;\">(<strong>Important</strong>: this option may overload your server, so just select the events that really matter)</span></li>
 <li><strong>Authentication</strong> should be \"None\"</li>
 <li>Click on <strong>\"Create Webhook\"</strong> button and it should be all set</li>
 </ol>:input";
$lang["connectivity"]["elastic_email"]["title"] = "Elastic Email";
$lang["connectivity"]["elastic_email"]["description"] = "Connect your Elastic Email account by filling up the required fields below.";
$lang["connectivity"]["elastic_email"]["form"]["howto_find_elastic_email_apikey"] = "<ol>
 <li><strong><a href=\"https://elasticemail.com/account\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Elastic Email</strong> Account</li>
 <li>Navigate to <strong>Settings</strong></li>
 <li>Click on&nbsp;<strong><a href=\"https://elasticemail.com/account#/settings/apikey\" target=\"_blank\">API</a></strong></li>
 <li>Click on <strong>Create API Key</strong>&nbsp;button</li>
 <li>Write a friendly <strong>API Key Name</strong></li>
 <li>Select <strong>Full Permissions</strong>&nbsp;for API Permissions</li>
 <li>Click on the&nbsp;<strong>Create</strong> button</li>
 <li>Copy the <strong>API Key</strong> and paste into <strong>" . $lang["variables"]["site_title"] . "</strong></li>
 </ol>";
$lang["connectivity"]["elastic_email"]["form"]["configuring_apikey"] = "<ol>
 <li><strong><a href=\"https://elasticemail.com/account\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Elastic Email</strong> account</li>
 <li>Now Navigate to&nbsp;<strong>Webhooks</strong>&nbsp;and click on plus sign [+] to create the webhook</li>
 <li>Insert the following URL in Target :input</li>
 <li>Select the <strong>Notifications</strong> you want to be processed</li>
 <li>Insert the <strong>Notification Link</strong> in inbound email (URL where Inbound email notifications will be available)</li>
 <li>Insert the <strong>inbound domain</strong></li>
 <li>Click on <strong>Save</strong>&nbsp;button</li>
 </ol>";
$lang["connectivity"]["mailjet"]["title"] = "Mailjet";
$lang["connectivity"]["mailjet"]["description"] = "Connect your Mailjet account by filling up the required fields below.";
$lang["connectivity"]["mailjet"]["form"]["api_public_key"] = "API Public Key";
$lang["connectivity"]["mailjet"]["form"]["api_public_key_help"] = "Insert your Mailjet API Public Key";
$lang["connectivity"]["mailjet"]["form"]["api_secret_key"] = "API Secret Key";
$lang["connectivity"]["mailjet"]["form"]["api_secret_key_help"] = "Insert your Mailjet API Secret Key";
$lang["connectivity"]["mailjet"]["form"]["howto_find_mailjet_apikey"] = "<ol>
 <li><strong><a href=\"https://app.mailjet.com/signin\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Mailjet</strong> Account.</li>
 <li>Navigate to Account settings -&gt;&nbsp;<strong><a href=\"https://app.mailjet.com/account\" target=\"_blank\">REST API</a></strong></li>
 <li>Click on <strong><a href=\"https://app.mailjet.com/account/api_keys\">Master API Key & Sub API key management</a></strong>&nbsp;Link</li>
 <li>Here you'll find the API Public Key and Secret Key</li>
 </ol>";
$lang["connectivity"]["mailjet"]["form"]["configuring_mailjet_apikey"] = "<ol>
 <li><strong><a href=\"https://app.mailjet.com/signin\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Mailjet</strong> Account</li>
 <li>Navigate to Account settings -&gt; <strong><a href=\"https://app.mailjet.com/account\">REST API</a></strong></li>
 <li>Click on <strong><a href=\"https://app.mailjet.com/account/triggers\">Event notifications (webhooks)</a></strong> Link</li>
 <li>Insert the following URL in Select All box if you want to keep it same click on Apply to all :input</li>
 </ol>";
$lang["connectivity"]["smtp2go"]["title"] = "Smtp2go";
$lang["connectivity"]["smtp2go"]["description"] = "Connect your Smtp2go account by filling up the required fields below.";
$lang["connectivity"]["smtp2go"]["form"]["howto_find_smtp2go_apikey"] = "<ol>
 <li><strong><a href=\"https://app.smtp2go.com/login\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>SMTP2GO</strong> Account</li>
 <li>Navigate to <strong>Settings</strong> and then click on <strong>API Keys</strong></li>
 <li>Click on <strong>Add API Key</strong></li>
 <li>Select all&nbsp;under the <strong>Permissions</strong> tab</li>
 <li>Press <strong>Save</strong></li>
 <li>Copy the <strong>API Key</strong> and paste into <strong>" . $lang["variables"]["site_title"] . "</strong></li>
 </ol>";
$lang["connectivity"]["smtp2go"]["form"]["configuring_smtp2go_apikey"] = "<ol>
 <li><strong><a href=\"https://app.smtp2go.com/login/\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>SMTP2GO</strong> Account</li>
 <li>Navigate to <strong>Settings</strong> and then click on <strong>Webhooks</strong></li>
 <li>Click on <strong>Add Webhook</strong></li>
 <li>Here set your webhook URL and select the events you want to process.:input</li>
 <li>In <strong>Users</strong>, select the <strong>API Key</strong> or Select All</li>
 <li>Select the <strong>events</strong> you want to be processed</li>
 <li>In Headers textbox, write&nbsp;<span style=\"background-color:#ecf0f1\">email_log_id</span></li>
 <li>Click <strong>Save</strong></li>
 </ol>";
$lang["connectivity"]["postmark"]["title"] = "Postmark";
$lang["connectivity"]["postmark"]["description"] = "Connect your Postmark account by filling up the required fields below.";
$lang["connectivity"]["postmark"]["form"]["howto_find_postmark_apikey"] = "<ol>
 <li><strong><a href=\"https://account.postmarkapp.com/login\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Postmark</strong> Account</li>
 <li>Go to <strong>Servers</strong> and click on the desired server</li>
 <li>Click on&nbsp;<strong>API Tokens</strong></li>
 <li>Copy the <strong>token</strong> and paste into <strong>" . $lang["variables"]["site_title"] . "</strong></li>
 </ol>";
$lang["connectivity"]["postmark"]["form"]["configuring_postmark_apikey"] = "<ol>
 <li><strong><a href=\"https://account.postmarkapp.com/login\" target=\"_blank\">Login</a></strong>&nbsp;to your <strong>Postmark</strong> Account</li>
 <li>Navigate to&nbsp;<strong>Servers</strong> and&nbsp;select the desired server</li>
 <li>Click on <strong>Webhooks</strong></li>
 <li>Click on <strong>Add webhook</strong></li>
 <li>Here set your webhook URL and select the <strong>events</strong> you want to get processed :input</li>
 <li>Click <strong>Save webhook</strong></li>
 </ol>";
$lang["form"]["gmail_problem"]["title"] = "Having problems getting Gmail to work with " . $lang["variables"]["site_title"] . "?";
$lang["problem_with_gmail"]["method_gmail_smtp"] = "There are two methods to use Gmail SMTP with " . $lang["variables"]["site_title"] . "";
$lang["problem_with_gmail"]["method_one"] = "Method 1";
$lang["problem_with_gmail"]["go_to_your"] = "Go to your";
$lang["problem_with_gmail"]["google_account"] = "Google Account";
$lang["problem_with_gmail"]["left_click_security"] = "On the left navigation panel, click Security.";
$lang["problem_with_gmail"]["signing_in_google_panel_password"] = "On the Signing in to Google panel, click App passwords. Note: If you can't get to the page, 2-Step Verification is";
$lang["problem_with_gmail"]["not_set_up_for_your_account"] = "Not set up for your account";
$lang["problem_with_gmail"]["set_up_for_security_keys_only"] = "Set up for security keys only";
$lang["problem_with_gmail"]["select_app_youre_using"] = "At the bottom, click Select app and choose the app you're using.";
$lang["problem_with_gmail"]["select_device_youre_using"] = "Click Select device and choose the device you're using.";
$lang["problem_with_gmail"]["click_generate"] = "Click Generate.";
$lang["problem_with_gmail"]["use_your_password_gmail_validate"] = "Use the app password instead of your Gmail password and click Validate.";
$lang["problem_with_gmail"]["login_to_your"] = "Login to your";
$lang["problem_with_gmail"]["gmail_account"] = "Gmail Account";
$lang["problem_with_gmail"]["my_account"] = "My Account";
$lang["problem_with_gmail"]["turn_off_2step_verification"] = "Turn off 2-Step Verification";
$lang["problem_with_gmail"]["turn_on_access_for"] = "Turn on access for";
$lang["problem_with_gmail"]["less_secure_apps_link"] = "Less Secure Apps";
$lang["form"]["outlook_problem"]["title"] = "Having problems getting Hotmail to work with " . $lang["variables"]["site_title"] . "?";
$lang["problem_with_hotmail"]["connect_hotmail_smtp"] = "Connecting with hotmail SMTP is the simplest thing.";
$lang["problem_with_hotmail"]["username_field_hotmail"] = "Just enter your hotmail email address in the smtp username field";
$lang["problem_with_hotmail"]["password_field_hotmail"] = "Write your hotmail password for the SMTP password";
$lang["form"]["yahoo_problem"]["title"] = "Having problems getting Yahoo to work with " . $lang["variables"]["site_title"] . "?";
$lang["problem_with_yahoo"]["methods_to_use_yahoo_smtp"] = "There are two methods to use Yahoo SMTP with " . $lang["variables"]["site_title"] . "";
$lang["problem_with_yahoo"]["method_one_recommended"] = "Method 1 (Recommended):";
$lang["problem_with_yahoo"]["yahoo_password_as_smtp"] = "Use your Yahoo email password as the SMTP password.";
$lang["form"]["aol_problem"]["title"] = "Having problems getting aol to work with " . $lang["variables"]["site_title"] . "?";
$lang["problem_with_aol"]["methods_to_use_aol_smtp"] = "There are two methods to use AOL SMTP with " . $lang["variables"]["site_title"] . "";
$lang["problem_with_aol"]["method_one_recommended"] = "Method 1 (Recommended):";
$lang["problem_with_aol"]["aol_password_as_smtp"] = "Use your AOL email password as the SMTP password.";
$lang["message"]["tracking_domain_status_off"] = "<strong>Note</strong>: The status of this tracking domain is off and the intellectual pattern to select the tracking domain is enabled, so the primary domain will appear in the tracking links.";
$lang["message"]["tracking_domain_intellectual_status_off"] = "<strong>Note</strong>: The status of this tracking domain is off and the intellectual pattern to select the tracking domain is also disabled, so the tracking domain will still appear in the tracking links. If your tracking domain is not functional, it will result in broken tracking links.";
$lang["form"]["error_message"]["add_sending_domain"] = "You need to have at least one sending domain before you can add a sending node.";
$lang["form"]["success_message"]["domain_url_copied"] = "The URL has been copied successfully.";
$lang["message"]["congratulations"] = "Congratulations!";
$lang["message"]["success_node_configure"] = "The sending node has been successfully configured.";
$lang["form"]["success_message"]["copies_created"] = "Duplicated copies have been created for the selected sending nodes.";
$lang["form"]["error_message"]["smtp_limit_exceeded"] = "The maximum number of sending nodes has been reached for your account.";
$lang["form"]["error_message"]["domain_not_allowed"] = "You are not allowed to add this domain";
$lang["update"]["error_message"]["not_allowed"] = "You are not allowed to use this from email address";
$lang["update"]["error_message"]["test_email"] = "Please enter a valid email address.";
$lang["form"]["success_message"]["preview_email"] = "The test email has been sent successfully.";
$lang["form"]["success_message"]["smtp_status"] = "Status has been updated for the selected sending nodes.";
$lang["form"]["success_message"]["success_import"] = "Sending nodes have been imported successfully.";
$lang["form"]["error_message"]["error_import"] = "Invalid file format. Supported format is CSV.";
$lang["form"]["heml_preview"]["email_content"] = "<html><body><p>Hi,</p>
<p>This is the sending node test email. If you have received this email, it means your sending node is working fine. The details of the test are as follows:</p>
<ul>
  <li><strong>Sending Node:</strong> :name</li>
  <li><strong>Node Type:</strong> :nodeType</li>
  <li><strong>Status:</strong> Successful</li>
  <li><strong>Date:</strong> :date</li>
</ul>
<p><br><br>If you did not initiate this test, please ignore this message.</p></body></html>";
$lang["form"]["form_heading"]["test_email"] = "Send a Test Email";
$lang["test_email"]["form"]["get_debug_log"] = "Get debug log";
$lang["form"]["test_email"]["link"]["debug_log"] = "View debug log";
$lang["update"]["notification"]["activity_log"] = "Campaign Group";
$lang["form"]["host_placeholder"]["choose_domain"] = "Select domain";
$lang["form"]["label_description"]["signup"] = "If you don't have an account with :app, you can";
$lang["signup_here"] = "Signup Here";
$lang["auto_inactive"] = "Auto-disabled";
$lang["modal"]["heading"]["debug_log"] = "Debug Log";
$lang["form"]["link_tooltip"]["rename_group"] = "Rename Group";
$lang["form"]["link_tooltip"]["delete_move"] = "Delete this group and move sending nodes to the Unsorted group.";
$lang["form"]["link_tooltip"]["delete"] = "Delete this group and all sending nodes inside";
$lang["update"]["notification"]["mailgun_account"] = "Mailgun Account";
$lang["view"]["modal_heading"]["smtp_failed_reason"] = "Failed Reason";
$lang["form"]["gateway_option"]["select_gateway"] = "Select gateway";
$lang["form"]["error_message"]["select_gateway"] = "Select a gateway";
$lang["form"]["label_message"]["validate_node"] = "Validation process will send a test email to";
$lang["form"]["label_message"]["validating_node"] = "Validating the sending node";
$lang["form"]["label_message"]["validated"] = "Sending node has been successfully validated.";
$lang["view"]["alert_message"]["delete_node"] = "<b>Error: </b> Un-assign the sending node \":node\" from the associated assets before you can delete it.";
$lang["view"]["alert_message"]["delete_node_message"] = "Dependency Check";
$lang["view"]["alert_message"]["assign_to_other"] = "You can reassign the assets to another sending node.";
$lang["view"]["smtp_placeholder"]["select_smtp"] = "Select sending node";
$lang["form"]["error_message"]["move_to_label"] = "Reassign to another sending node";
$lang["form"]["help_content"]["gmail"] = "<div class=\"helpheader\"><p>There are two methods to use Gmail SMTP with " . $lang["variables"]["site_title"] . "</p> </div> <h3 class=\"m-form__heading-title\"> Method 1:</h3> <h6 class=\"sbold\">Using App Password</h6> <ol class=\"helpList\"> <li>Go to your <a href=\"https://myaccount.google.com/\" target=\"_blank\">Google Account</a>.</li> <li>On the left navigation panel, click Security.</li> <li> On the Signing in to Google panel, click App passwords. Note: If you can't get to the page, 2-Step Verification is: <ul class=\"helpListChild\"> <li>Not set up for your account</li> <li>Set up for security keys only</li> </ul> </li> <li>At the bottom, click Select app and choose the app you're using.</li> <li>Click Select device and choose the device you're using.</li> <li>Click Generate.</li> <li>Use the app password instead of your Gmail password and click Validate.</li> </ol> <hr> <h3 class=\"m-form__heading-title\"> Method 2: </h3> <ol class=\"helpList\"> <li>Login to your<a href=\"https://www.gmail.com/\" target=\"_blank\">Gmail Account</a></li> <li>Go to <a href=\"https://myaccount.google.com/\" target=\"_blank\">My Account</a></li> <li>Turn off 2-Step Verification</li> <li>Turn on access for<a href=\"https://www.google.com/settings/security/lesssecureapps\" target=\"_blank\">Less Secure Apps</a></li></ol>";
$lang["form"]["help_content"]["aol"] = "<div class=\"helpheader\"> <p>There are two methods to use AOL SMTP with " . $lang["variables"]["site_title"] . "</p> </div> <h3 class=\"m-form__heading-title\"> Method 1 (Recommended): </h3> <ol> <li><a href=\"https://login.aol.com/account/security\" target=\"_blank\">Sign in and go to your Account security page.</a>.</li> <li>Turn on Two-Step Verification if it's not.</li> <li>Click Generate app password or Manage app passwords</li> <li>Select 'other app' from the drop down menu, write " . $lang["variables"]["site_title"] . " and click Generate.</li> <li>Use this app password as SMTP Password.</li> </ol> <hr> <h3 class=\"m-form__heading-title\"> Method 2 </h3> <h6 class=\"sbold\">Using App Password</h6> <ol> <li><a href=\"https://login.aol.com/account/security\" target=\"_blank\">Sign in and go to your Account security page.</a></li> <li>Turn off Two-Step Verification if it's not.</li> <li>Enable Allow apps that use less secure sign-in.</li> <li>Use your AOL email password as the SMTP password.</li> </ol>";
$lang["form"]["help_content"]["outlook"] = "<div class=\"card-body\"> <div class=\"helpheader\"> <p>Connecting with hotmail SMTP is the simplest thing.</p> </div> <h3 class=\"m-form__heading-title\"> Method: </h3> <h6 class=\"sbold\">Using App Password</h6> <ol> <li>Just enter your hotmail email address in the smtp username field</li> <li>Write your hotmail password for the SMTP password</li> </ol> </div>";
$lang["form"]["help_content"]["yahoo"] = "<div class=\"card-body\"> <div class=\"helpheader\"> <p>There are two methods to use Yahoo SMTP with " . $lang["variables"]["site_title"] . "</p> </div> <h3 class=\"m-form__heading-title\"> Method 1 (Recommended): </h3> <ol> <li><a href=\"https://login.yahoo.com/account/security\" target=\"_blank\">Sign in and go to your Account security page.</a>.</li> <li>Turn on Two-Step Verification if it's not.</li> <li>Click Generate app password or Manage app passwords</li> <li>Select 'other app' from the drop down menu, write " . $lang["variables"]["site_title"] . " and click Generate.</li> <li>Use this app password as SMTP Password.</li> </ol> <hr> <h3 class=\"m-form__heading-title\"> Method 2: </h3> <h6 class=\"sbold\">Using App Password</h6> <ol> <li><a href=\"https://login.yahoo.com/account/security\" target=\"_blank\">Sign in and go to your Account security page.</a></li> <li>Turn off Two-Step Verification if it's not.</li> <li>Enable Allow apps that use less secure sign-in.</li> <li>Use your Yahoo email password as the SMTP password.</li> </ol> </div>";
$lang["form"]["success_message"]["sendgrid_created"] = "Sendgrid successfully created";
$lang["form"]["success_message"]["smtp_created"] = "Sending node has been added successfully.";
$lang["form"]["label"]["drip_groups"] = "Drip Groups";
$lang["step_blade"]["self_signed_certificates_label"] = "Allow Self-signed Certificates";
$lang["step_blade"]["verify_peer_certificates_label"] = "Verify Peer Certificate";
$lang["step_blade"]["verify_peer_name_label"] = "Verify Peer Name";
$lang["step_blade"]["yes_only_label"] = "Yes";
$lang["step_blade"]["no_only_label"] = "No";
$lang["form"]["success_message"]["value_copied"] = "The value has been copied successfully.";
$lang["form"]["success_message"]["code_copied"] = "The code has been copied successfully.";
$lang["form"]["label"]["gateway_relay_email_tooltip"] = "Select a gateway responsible to relay the emails for this sending node.";
$lang["form"]["label"]["test_email_heading_email_required"] = "Email address is required to send a test.";
$lang["form"]["phpmailer_option"]["debug_log_input"] = "Get debug log";
$lang["form"]["label"]["copy"] = "Copy";
$lang["form"]["label"]["gateway"] = "Gateway";
$lang["important_blade"]["importing_smtps_span"] = "Importing sending nodes from";
$lang["important_blade"]["fields_dropdown_para"] = "Select the fields from each dropdown to correctly map the headers of the imported file with the corresponding fields.";
$lang["view"]["alert_message"]["label_notice"] = "Notice!";
$lang["view"]["link"]["switch_now_action"] = "Switch Now";
$lang["view"]["button"]["add_powermta"] = "Add PowerMTA";
$lang["view"]["button"]["nodes_limit"] = "Sending Nodes Limit:";
$lang["view"]["smtp_type_option"]["select_smtp"] = "SMTP";
$lang["view"]["smtp_type_option"]["select_gmail"] = "Gmail";
$lang["view"]["smtp_type_option"]["select_outlook"] = "Outlook";
$lang["view"]["smtp_type_option"]["select_aol"] = "AOL";
$lang["view"]["smtp_type_option"]["select_yahoo"] = "Yahoo";
$lang["view"]["error_message"]["status_changed_failed"] = "Unable to change the status.";
$lang["view"]["success_message"]["status_changed_successfully"] = "The status has been changed successfully.";
$lang["view"]["success_message"]["record_update_successfully"] = "The record has been updated successfully.";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["smtp_create_blade"]["verify_peer_name_label"] = "Verify Peer Name";
$lang["smtp_create_blade"]["verify_peer_certificate_label"] = "Verify Peer Certificate";
$lang["smtp_create_blade"]["self_signed_certificate_label"] = "Allow Self-signed Certificates";
$lang["smtp_create_blade"]["eg_txt_key_div"] = "e.g key-hs892hs872tsix872gkkzhx41fas72hsl6gq1";
$lang["view"]["error_message"]["missing_parameter_bounce"] = "Error: Missing required parameter, bounce email";
$lang["view"]["error_message"]["missing_parameter_reply"] = "Error: Missing required parameter, reply email";
$lang["view"]["error_message"]["file_type_return"] = "Invalid file type.";
$lang["include_header_blade"]["months_ago_span"] = "5 months ago";
$lang["include_header_blade"]["trash_all_action"] = "Trash all Records";
$lang["include_topbar_blade"]["hi_txt_span"] = "Hi,";
$lang["view"]["alert_message"]["please_enter_valid_ip"] = "Please enter a valid IP and Port";
$lang["view"]["alert_message"]["please_enter_valid_ip4"] = "Please enter a valid IPv4";
$lang["view"]["alert_message"]["invalid_ip_address"] = "Invalid IP address";
$lang["view"]["alert_message"]["letters_numbers"] = "Only letters, numbers, and underscores.";
$lang["view"]["bulk_actions_dropdown"]["import_smtps"] = "Import sending nodes";
$lang["view"]["bulk_actions_dropdown"]["export_smtps"] = "Export sending nodes";
$lang["add_new"]["form"]["label"]["get_gmail_concent"] = "Connect Google Account";
$lang["add_new"]["form"]["label"]["get_gmail_concent_description"] = "Use your Gmail account to send emails.";
$lang["add_new"]["form"]["label"]["reconnect_gmail_api"] = "Connection is broken.";
$lang["add_new"]["form"]["label"]["authorize_with_gmail_api_description"] = "An issue occurred with the gmail API.";
$lang["add_new"]["form"]["button"]["link_account"] = "Link Account";
$lang["add_new"]["form"]["button"]["unlink_account"] = "Unlink Account";
$lang["add_new"]["form"]["button"]["reconnect"] = "Reconnect";
$lang["add_new"]["form"]["label"]["gnail_coonect_description"] = "Click here to connect/disconnect Google account.";
$lang["add_new"]["form"]["label"]["auth_code"] = "Authorization Code";
$lang["add_new"]["form"]["button"]["verify"] = "Validate";
$lang["add_new"]["form"]["button"]["verifying"] = "Validating...";
$lang["add_new"]["success_message"]["gmail_api_authorize"] = "Authorization code has been validated successfully.";
$lang["add_new"]["form"]["label"]["gmail_api_connected"] = "Account Connected";
$lang["add_new"]["form"]["label"]["authorized_gmail_api"] = "email@domainname.com";
$lang["add_new"]["alert_confirm"]["are_you_sure"] = "Are you sure?";
$lang["add_new"]["alert_confirm"]["link_google_account"] = "This will unlink your connected Google Account.";
$lang["add_new"]["confirm_message"]["unlinked"] = "Unlinked";
$lang["add_new"]["confirm_message"]["successfully_unlink"] = "The Google account has been unlinked.";
$lang["add_new"]["confirm_message"]["successfully_unlinked"] = "The Google account has been unlinked successfully.";
$lang["add_new"]["form"]["description"]["paste_oath_key"] = "Paste your Google OAuth key here to validate it for email relaying access";
$lang["gmail_authorize"]["widget_heading"] = "Paste your Google OAuth credentials here to validate your account for email relaying access.";
$lang["gmail_authorize"]["form"]["label"]["key_description"] = "Copy this key and paste it into the Authorization Code field.";
$lang["gmail_authorize"]["alert_message"]["error_message"] = "An error occurred. Please go to the sending node page and try linking your account again.";
$lang["gmail_authorize"]["confirm_message"]["copied_successfully"] = "Authorization code has been copied successfully.";
$lang["additional_headers"]["rule"] = "Only hyphens (-) can be used. Spaces and special characters are not supported.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
