<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["description"] = "Review and manage all your created segments. Segments are virtual lists of contacts grouped by specific filters and characteristics, allowing targeted actions like campaigns or broadcasts. Easily view, edit, or delete segments, and apply additional filters to refine your audience for more precise targeting.";
$lang["edit"]["title"] = "Edit Segment";
$lang["edit"]["description"] = "Modify the criteria and filters that define your segment to refine your audience further. Update contact filters based on behaviors, demographics, or other attributes to ensure your segment stays relevant and effective for targeted campaigns.";
$lang["view"]["counting"] = "Counting";
$lang["any_list"] = "Any contact list";
$lang["activity"]["title"] = "Segment";
$lang["form"]["footer"]["contacts_count"] = "Count";
$lang["view"]["model"]["heading"]["select_lists"] = "Contact Lists";
$lang["view"]["model"]["heading"]["copy_to_list"] = "Copy contacts to a list";
$lang["view"]["model"]["label"]["choose_group"] = "Select Group";
$lang["view"]["model"]["label"]["duplicate"] = "Duplicates";
$lang["view"]["model"]["label"]["duplicate_placeholder"] = "Select an action";
$lang["view"]["table_heading"]["sr"] = "No.";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["view"]["table_heading"]["created_by"] = "" . $lang["variables"]["created_by"] . "";
$lang["view"]["table_heading"]["type"] = "Segment Type";
$lang["view"]["table_heading"]["contacts"] = "Contacts";
$lang["view"]["table_heading"]["description"] = "Description";
$lang["view"]["table_heading"]["action_performed_at"] = "Action Performed at";
$lang["view_segment_list"]["view_segemnt"] = "View Segment";
$lang["view"]["table_heading"]["actions"]["recount"] = "Recount";
$lang["view"]["table_heading"]["actions"]["move"] = "Move contacts to a list";
$lang["view"]["table_heading"]["actions"]["copy"] = "Copy contacts to a list";
$lang["form"]["alert_confirmation"]["segment_no_subscriber"] = "Are you sure you want to create a segment with 0 subscribers?";
$lang["form"]["alert_confirmation"]["segment_total_subscriber"] = "Are you sure you want to create a segment with :subscribers_total subscribers?";
$lang["form"]["alert_message"]["recount_success"] = "The process has been scheduled to recount the segmented contacts.";
$lang["form"]["alert_message"]["recount_fail"] = "There was an issue recounting the contacts.";
$lang["form"]["alert_message"]["select_user"] = "Select a user.";
$lang["add"]["title"] = "Add New Segment";
$lang["add"]["description"] = "Create a new segment by selecting contact lists and applying filters to group your contacts based on specific criteria. Define your segment’s name, choose lists, and apply filters such as contact details or engagement metrics to tailor your audience. This allows you to send more personalized and relevant content to targeted segments of your database.";
$lang["form_heading"] = "Segment Settings";
$lang["form"]["label"]["name"] = "Segment Name";
$lang["form"]["label"]["segment_based_list"] = "Based on contact lists";
$lang["form"]["label"]["segment_based_list_description"] = "Group your contacts from multiple lists based on shared field values or statuses, allowing you to target specific audiences across different contact lists.";
$lang["form"]["label"]["segment_based_statistics"] = "Based on statistics";
$lang["form"]["label"]["segment_based_statistics_description"] = "Segment your contacts based on engagement metrics and activities, such as opens, clicks, or other interaction data, to target more engaged audiences.";
$lang["form"]["heading"]["filter_by_list"] = "Filter by contact list";
$lang["form"]["label"]["any_contact_list"] = "Any list";
$lang["form"]["label"]["any_contact_list_help"] = "Ignores list-specific criteria and applies filters across all lists globally.";
$lang["form"]["label"]["contact_lists_help"] = "Select one or more contact lists to filter contacts from.";
$lang["form"]["label"]["our_contact_list"] = "Admin lists";
$lang["form"]["label"]["user_specific_lists"] = "User lists";
$lang["form"]["label"]["option_specific"] = "Selected lists";
$lang["form"]["label"]["option_users_lists"] = "User lists";
$lang["add_new"]["field"]["all_lists"] = "All lists";
$lang["form"]["label"]["list_type"] = "Criteria";
$lang["form"]["label"]["select_list"] = "List Source";
$lang["form"]["label"]["option_groups"] = "Member of";
$lang["form"]["label"]["option_custom_criteria"] = "Custom criteria";
$lang["form"]["label"]["option_custom_criteria_help"] = "Apply filters based on list names or groups to automatically select lists that match your criteria.";
$lang["form"]["label"]["option_advance_criteria"] = "Advanced criteria";
$lang["form"]["label"]["broadcasts_type"] = "Broadcast Source";
$lang["form"]["label"]["our_broadcasts"] = "Admin broadcasts";
$lang["form"]["label"]["option_user_specific_broadcasts"] = "User broadcasts";
$lang["form"]["label"]["option_all_broadcasts"] = "Any broadcast";
$lang["form"]["label"]["select_all"] = "Select all";
$lang["form"]["label"]["select_group"] = "Groups";
$lang["form"]["label"]["select_group_help"] = "It will include all current and future contact lists within the selected groups.";
$lang["form"]["label"]["select_one_list_error_message"] = "Select at least one contact list.";
$lang["form"]["label"]["select_criteria"] = "Criteria";
$lang["form"]["label"]["option_list_name"] = "List Name";
$lang["form"]["label"]["option_group_name"] = "Group Name";
$lang["form"]["label"]["option_any_broadcast"] = "Any broadcast";
$lang["form"]["label"]["broadcasts"] = "Select Broadcast";
$lang["form"]["label"]["option_select_broadcast"] = "Selected broadcasts";
$lang["form_heading_apply_filters"] = "Apply Filters";
$lang["form"]["label"]["dropdown_select_option"] = "Select an option";
$lang["form"]["label"]["placeholder_comma_separated_list"] = "Comma-separated values";
$lang["form"]["alert_confirmation"]["confirmed"] = "Confirmed";
$lang["form"]["alert_confirmation"]["get_values_unconfirmed"] = "Unconfirmed";
$lang["form"]["option_field_values_text"] = "Text";
$lang["form"]["option_field_values_html"] = "HTML";
$lang["form"]["option_field_values_not_bounced"] = "Not Bounced";
$lang["form"]["option_field_values_hard_bounce"] = "Hard Bounced";
$lang["form"]["option_field_values_soft_bounce"] = "Soft Bounced";
$lang["form"]["placeholder_date_field"] = "Date Field";
$lang["form"]["placeholder_select_duration"] = "Select Duration";
$lang["form"]["placeholder_xx_days"] = "Value";
$lang["form"]["option_date_duration_values_after"] = "After";
$lang["form"]["option_date_duration_values_before"] = "Before";
$lang["form"]["option_date_duration_values_exactly"] = "Exactly";
$lang["form"]["option_date_duration_values_between"] = "Between";
$lang["form"]["option_date_duration_values_is_due_in"] = "Occurring after";
$lang["form"]["option_date_duration_values_is_overdue_for"] = "Occurred before";
$lang["form"]["option_date_duration_values_past"] = "For the past";
$lang["form"]["option_date_duration_values_older_than"] = "Older than";
$lang["form"]["label"]["country"] = "Country";
$lang["form"]["label"]["option_any_country"] = "Any country";
$lang["form"]["label"]["option_selected_country"] = "Selected countries";
$lang["form"]["placeholder_choose_country"] = "Select countries";
$lang["form"]["placeholder_choose_state"] = "Select states";
$lang["form"]["placeholder_choose_city"] = "Select cities";
$lang["form"]["placeholder_choose_zip"] = "Select zip codes";
$lang["form"]["placeholder_choose_browser"] = "Select browsers";
$lang["form"]["placeholder_choose_os"] = "Select operating systems";
$lang["form"]["placeholder_choose_campaign"] = "Select campaigns";
$lang["form"]["placeholder_state"] = "State";
$lang["form"]["label"]["option_any_state"] = "Any state";
$lang["form"]["label"]["option_selected_state"] = "Selected states";
$lang["form"]["label"]["city"] = "City";
$lang["form"]["label"]["option_any_city"] = "Any city";
$lang["form"]["label"]["option_selected_city"] = "Selected cities";
$lang["form"]["label"]["zip"] = "Zip code";
$lang["form"]["label"]["option_any_zip"] = "Any zip code";
$lang["form"]["label"]["option_selected_zip"] = "Selected zip codes";
$lang["form"]["label"]["browser"] = "Browser";
$lang["form"]["label"]["option_any_browser"] = "Any browser";
$lang["form"]["label"]["option_selected_browser"] = "Selected browsers";
$lang["form"]["label"]["os"] = "Operating system";
$lang["form"]["label"]["option_any_os"] = "Any operating system";
$lang["form"]["label"]["option_any_selected_os"] = "Selected operating systems";
$lang["form"]["label"]["duration"] = "Event time";
$lang["form"]["label"]["option_none"] = "Not required";
$lang["form"]["label"]["criteria_option_has_opened_broadcast"] = "Has opened";
$lang["form"]["label"]["criteria_option_hasnt_opened_any_broadcast"] = "Hasn't opened";
$lang["form"]["label"]["criteria_option_has_unsubscribe"] = "Has unsubscribed";
$lang["form"]["label"]["criteria_option_has_complained"] = "Has complained";
$lang["form"]["label"]["criteria_option_sent"] = "Sent";
$lang["form"]["label"]["criteria_option_never_sent"] = "Never sent";
$lang["form"]["label"]["criteria_option_injected_into_mta"] = "Injected";
$lang["form"]["label"]["criteria_option_delivered"] = "Delivered";
$lang["form"]["label"]["criteria_option_delayed"] = "Delayed";
$lang["form"]["label"]["criteria_option_bounced"] = "Bounced";
$lang["form"]["label"]["and"] = "And";
$lang["form"]["label"]["option_clicked_on_link"] = "Clicked on a link";
$lang["form"]["label"]["option_hasnt_clicked_on_link"] = "Hasn't clicked on any link";
$lang["form"]["label"]["option_any_link"] = "Any link";
$lang["form"]["label"]["option_selected_links"] = "Selected links";
$lang["form"]["label"]["option_type"] = "Type";
$lang["form"]["label"]["option_bounce_reason"] = "Bounce reason";
$lang["form"]["label"]["option_bounce_code"] = "Bounce code";
$lang["form"]["label"]["option_bounce_details"] = "Bounce details";
$lang["form"]["dropdown_option_filter_is"] = "Is";
$lang["form"]["dropdown_option_filter_isnt"] = "Isn't";
$lang["form"]["filter_dropdown_option_is"] = "Is";
$lang["form"]["filter_dropdown_option_is_not"] = "Isn't";
$lang["form"]["filter_dropdown_option_contains"] = "Contains";
$lang["form"]["filter_dropdown_option_does_not_contain"] = "Doesn't contain";
$lang["form"]["filter_dropdown_option_starts_with"] = "Starts with";
$lang["form"]["filter_dropdown_option_ends_at"] = "Ends with";
$lang["form"]["filter_dropdown_option_first_alphabet_greater_equal"] = "First alphabet is greater than and equal to";
$lang["form"]["filter_dropdown_option_first_alphabet_lesser_equal"] = "First alphabet is lesser than and equal to";
$lang["form"]["filter_dropdown_option_greater_than"] = "Greater than";
$lang["form"]["filter_dropdown_option_lesser_than"] = "Lesser than";
$lang["form"]["filter_dropdown_option_domain_is"] = "Domain is";
$lang["form"]["filter_dropdown_option_domain_is_not"] = "Domain isn't";
$lang["form"]["label"]["filter_by_activity"] = "Filter by Engagement/Delivery";
$lang["form"]["filter_dropdown_option_after"] = "After";
$lang["form"]["filter_dropdown_option_before"] = "Before";
$lang["form"]["filter_dropdown_option_exactly"] = "Exactly on";
$lang["form"]["filter_dropdown_option_between"] = "Between";
$lang["form"]["filter_dropdown_option_occurring_before"] = "Occurred before";
$lang["form"]["filter_dropdown_option_occurred_after"] = "Occurring after";
$lang["form"]["filter_dropdown_option_for_the_past"] = "For the past";
$lang["form"]["filter_dropdown_option_older_than"] = "Older than";
$lang["form"]["filter_dropdown_option_is_today"] = "Is today";
$lang["form"]["filter_dropdown_option_day_of_month"] = "Day of month";
$lang["form"]["filter_dropdown_option_day_month_of_year"] = "Month of year";
$lang["form"]["filter_dropdown_option_january"] = "January";
$lang["form"]["filter_dropdown_option_february"] = "February";
$lang["form"]["filter_dropdown_option_march"] = "March";
$lang["form"]["filter_dropdown_option_april"] = "April";
$lang["form"]["filter_dropdown_option_may"] = "May";
$lang["form"]["filter_dropdown_option_june"] = "June";
$lang["form"]["filter_dropdown_option_july"] = "July";
$lang["form"]["filter_dropdown_option_august"] = "August";
$lang["form"]["filter_dropdown_option_september"] = "September";
$lang["form"]["filter_dropdown_option_october"] = "October";
$lang["form"]["filter_dropdown_option_november"] = "November";
$lang["form"]["filter_dropdown_option_december"] = "December";
$lang["form"]["filter_dropdown_option_todays_date"] = "Today's date";
$lang["form"]["filter_dropdown_option_this_month"] = "This month";
$lang["form"]["subscriber_dropdown_placeholder_select_option"] = "Select an option";
$lang["form"]["subscriber_dropdown_option_select_status"] = "Status";
$lang["form"]["subscriber_dropdown_option_subscriber_status"] = "Contact status";
$lang["form"]["subscriber_dropdown_option_suppression_status"] = "Suppression status";
$lang["form"]["subscriber_dropdown_option_subscription_status"] = "Subscription status";
$lang["form"]["custom_field_dropdown_option_confirmation_status"] = "Confirmation status";
$lang["form"]["custom_field_dropdown_option_complained_status"] = "Spam status";
$lang["form"]["custom_field_dropdown_option_fbl_status"] = "Feedback loop status";
$lang["form"]["custom_field_dropdown_option_spammed"] = "Spam";
$lang["form"]["custom_field_dropdown_option_content_format"] = "Content format";
$lang["form"]["custom_field_dropdown_option_creation_date"] = "Creation date";
$lang["form"]["custom_field_dropdown_option_bounce_status"] = "Bounce status";
$lang["form"]["custom_field_dropdown_option_by_field_value"] = "By Field Value";
$lang["form"]["custom_field_dropdown_option_email"] = "Active";
$lang["form"]["custom_field_dropdown_unsubscribed"] = "Unsubscribed";
$lang["form"]["subscriber_dropdown_option_contact_list"] = "Contact list";
$lang["form"]["subscriber_dropdown_option_sending_node_type"] = "Sending node type";
$lang["form"]["subscriber_dropdown_option_sending_node"] = "Sending node";
$lang["form"]["subscriber_dropdown_sending_domain"] = "Sending domain";
$lang["form"]["subscriber_dropdown_send_from_email"] = "Sender email";
$lang["form"]["subscriber_dropdown_send_bounce_email"] = "Bounce email";
$lang["form"]["subscriber_dropdown_send_reply_to_email"] = "Reply-to email";
$lang["form"]["subscriber_dropdown_send_recipient_email"] = "Recipient email";
$lang["form"]["subscriber_dropdown_send_schedule_email"] = "Campaign name";
$lang["form"]["subscriber_dropdown_send_schedule_message_id"] = "Message-ID";
$lang["view"]["title"] = "Segments";
$lang["view_segments"]["page_heading"] = "Filter by List";
$lang["view_segments"]["label"]["filter_by_statistics"] = "Filter by Statistics";
$lang["view_segments"]["label"]["select_list"] = "Select list";
$lang["view_segments"]["label"]["any_contact_list"] = "Any contact list";
$lang["view_segments"]["label"]["contact_list"] = "Contact list";
$lang["view_segments"]["label"]["groups"] = "Groups";
$lang["view_segments"]["label"]["custom_criteria"] = "Custom criteria";
$lang["view_segments"]["label"]["list_name"] = "List name";
$lang["view_segments"]["label"]["list_group"] = "Group name";
$lang["view_segments"]["label"]["apply_filters"] = "Apply Filters";
$lang["view_segments"]["label"]["status"] = "Status";
$lang["view_segments"]["label"]["bounce_status"] = "Bounce status";
$lang["view_segments"]["label"]["subscription_status"] = "Subscription status";
$lang["view_segments"]["label"]["confirmation_status"] = "Confirmation status";
$lang["view_segments"]["label"]["complained_status"] = "Complained status";
$lang["view_segments"]["label"]["content_format"] = "Content format";
$lang["view_segments"]["label"]["creation_date"] = "Creation date";
$lang["view_segments"]["label"]["broadcasts"] = "Broadcasts";
$lang["view_segments"]["label"]["selected_broadcasts"] = "Selected broadcasts";
$lang["view_segments"]["label"]["select_criteria"] = "Criteria";
$lang["view_segments"]["label"]["any"] = "Any";
$lang["view_segments"]["label"]["has_opened_broadcast"] = "Has opened the broadcast";
$lang["view_segments"]["label"]["hasnt_opened_broadcast"] = "Hasn't opened any broadcast";
$lang["view_segments"]["label"]["has_unsubscribed"] = "Has unsubscribed";
$lang["view_segments"]["label"]["has_complained"] = "Has complained";
$lang["view_segments"]["label"]["is_sent"] = "Sent";
$lang["view_segments"]["label"]["never_sent"] = "Never sent";
$lang["view_segments"]["label"]["injected"] = "Injected";
$lang["view_segments"]["label"]["delivered"] = "Delivered";
$lang["view_segments"]["label"]["delayed"] = "Delayed";
$lang["view_segments"]["label"]["bounced"] = "Bounced";
$lang["view_segments"]["label"]["clicked_on_a_link"] = "Clicked on a link";
$lang["view_segments"]["label"]["has_not_clicked_on_any_link"] = "Hasn't clicked on any link";
$lang["view_segments"]["label"]["and"] = "And";
$lang["view_segments"]["label"]["any_link"] = "Any Link";
$lang["view_segments"]["label"]["selected_link"] = "Selected links";
$lang["view_segments"]["label"]["any_country"] = "Any Country";
$lang["view_segments"]["label"]["selected_countries"] = "Selected countries";
$lang["view_segments"]["label"]["any_state"] = "Any state";
$lang["view_segments"]["label"]["selected_state"] = "Selected states";
$lang["view_segments"]["label"]["any_city"] = "Any city";
$lang["view_segments"]["label"]["selected_city"] = "Selected cities";
$lang["view_segments"]["label"]["any_zip"] = "Any zip code";
$lang["view_segments"]["label"]["selected_zip"] = "Selected zip codes";
$lang["view_segments"]["label"]["any_browser"] = "Any browser";
$lang["view_segments"]["label"]["selected_browser"] = "Selected browsers";
$lang["view_segments"]["label"]["any_os"] = "Any operating system";
$lang["view_segments"]["label"]["selected_os"] = "Selected operating systems";
$lang["view_segments"]["label"]["none"] = "Not required";
$lang["view_segments"]["label"]["duration"] = "Event time";
$lang["view_segments"]["label"]["by_date"] = "Define duration";
$lang["view_segments"]["label"]["after"] = "After";
$lang["view_segments"]["label"]["before"] = "Before";
$lang["view_segments"]["label"]["exactly_on"] = "Exactly on";
$lang["view_segments"]["label"]["between"] = "Between";
$lang["view_segments"]["label"]["to"] = "To";
$lang["view_segments"]["label"]["occurred_before"] = "Occurred Before";
$lang["view_segments"]["label"]["for_the_past"] = "For the past";
$lang["view_segments"]["label"]["older_than"] = "Older than";
$lang["view_segments"]["label"]["segment_copying"] = "Segmented contacts are being copied to the contact list.";
$lang["view_segments"]["label"]["segment_moving"] = "Segmented contacts are being moved to the contact list.";
$lang["view_segments"]["label"]["segment_exporting"] = "Segmented contacts are being exported to a CSV file.";
$lang["view_segments"]["label"]["no_proccess"] = "Not Bounced";
$lang["form"]["label"]["select_country"]["error_message"] = "Error: Select a country first.";
$lang["form"]["label"]["select_state"]["error_message"] = "Error: Select a state first.";
$lang["form"]["label"]["select_city"]["error_message"] = "Error: Select a city first.";
$lang["export_segments"]["title"] = "Export Segment";
$lang["export_segments"]["description"] = "Export the selected segment as a CSV file for further use. Once exported, you can download and analyze the segmented data or integrate it with other tools to enhance your marketing efforts.";
$lang["export_segments"]["form_heading"] = "Exporting segment <b>:title</b>";
$lang["export_segments"]["alert_information"]["waiting_to_export"] = "Waiting for the process to start.";
$lang["export_segments"]["label"]["choose_custom_fields"] = "Select Custom Fields to Include";
$lang["export_segments"]["error_message_select_one_field"] = "Select at least one field";
$lang["export_segments"]["label"]["geo_stats"] = "Statistics";
$lang["export_segments"]["form"]["option_geo_country"] = "Geo Country";
$lang["export_segments"]["form"]["option_geo_state"] = "Geo State";
$lang["export_segments"]["form"]["option_geo_city"] = "Geo City";
$lang["export_segments"]["form"]["option_geo_zip"] = "Geo Zip";
$lang["export_segments"]["form"]["option_browser"] = "Browser";
$lang["export_segments"]["form"]["option_operating_system"] = "Operating System";
$lang["export_segments"]["form"]["option_link_clicked"] = "Link Clicked";
$lang["export_segments"]["form"]["option_message_id"] = "Message-ID";
$lang["export_segments"]["form"]["option_stop_export_message"] = "Segment (%%segemnt_name%%) export has been stopped.";
$lang["export_segments"]["form"]["option_campaign_name"] = "Campaign Name";
$lang["export_segments"]["form"]["option_group_name"] = "Group Name";
$lang["export_segments"]["form"]["option_subject_line"] = "Subject Line";
$lang["export_segments"]["form"]["option_broadcast_creation_date"] = "Broadcast Creation Date";
$lang["export_segments"]["form"]["option_campaign_sent_date"] = "Campaign Sent Date";
$lang["export_segments"]["alert_message"]["file_not_exist"] = "The file doesn't exist.";
$lang["export_segments"]["form"]["alert_message_success"] = "The segment export has been initiated in the background.";
$lang["export_segments"]["form"]["alert_message_error"] = "Oops... something went wrong, try again later.";
$lang["export_segments"]["label"]["campaign"] = "Campaign";
$lang["segment_subscribers"]["title"] = "View Segmented Contacts: :name";
$lang["segment_subscribers"]["description"] = "View detailed information about all contacts within the selected segment. Gain insights into your segmented audience, allowing for analysis and further actions to optimize targeting and engagement.";
$lang["segment_subscribers"]["bulk_actions_dropdown"]["tools"] = "Tools";
$lang["segment_subscribers"]["modal"]["title"] = "Contact's Details";
$lang["segment_subscribers"]["table_heading"]["bounced"] = "Bounced";
$lang["segment_subscribers"]["table_heading"]["unsubscribed"] = "Unsubscribed";
$lang["segment_subscribers"]["table_heading"]["confirmed"] = "Confirmed";
$lang["segment_subscribers"]["table_heading"]["created_date"] = "Creation Date";
$lang["form"]["error_message"]["broadcast_type"] = "Select broadcast source.";
$lang["form"]["error_message"]["broadcast"] = "Select from the broadcasts.";
$lang["form"]["error_message"]["criteria"] = "Select a criteria.";
$lang["form"]["error_message"]["select_broadcast"] = "Select at least one broadcast.";
$lang["form"]["alert_message"]["note"] = "Note";
$lang["form"]["alert_message"]["log_notification"] = "Log retention is set to <code>%%keep_log_for%% days</code>. As a result, filters linked to logs may not retrieve data beyond this timeframe.";
$lang["view"]["model"]["copy_segment"]["title"] = "Copy segmented contacts to a contact list";
$lang["view"]["model"]["copy_segment"]["error_message_1"] = "<b>Error: </b> Your segment was created using global criteria and cannot be copied to another list.";
$lang["view"]["model"]["copy_segment"]["error_message_2"] = "<b>Reason: </b> The destination contact list must not be part of the source contact lists.";
$lang["view"]["model"]["move_segment"]["title"] = "Move segmented contacts to a contact list";
$lang["view"]["model"]["move_segment"]["error_message_1"] = "<b>Error: </b> Your segment was created using global criteria and cannot be moved to another list.";
$lang["view"]["model"]["move_segment"]["error_message_2"] = "<b>Reason: </b> The destination contact list must not be part of the source contact lists.";
$lang["view"]["model"]["delete_segment"]["error_message_alert"] = "<b>Error: </b> Unassign the segment \":segment\" from associated assets before deleting it.";
$lang["view"]["model"]["delete_segment"]["error_message_alert2"] = "<b>Error: </b> Unassign the segments \":segment\" from associated assets before deleting them.";
$lang["view"]["model"]["delete_segment"]["title"] = "Dependency Check";
$lang["view"]["model"]["label"]["campaign_schedule"] = "Schedule Campaigns";
$lang["view"]["action"]["copy_link"] = "Copying";
$lang["view"]["action"]["move_link"] = "Moving";
$lang["view"]["action"]["export_link"] = "Exporting";
$lang["form"]["limit_reached"]["error_message"] = "Oops... The limit has been reached.";
$lang["form"]["contact_admin"]["link_label"] = "Please contact the administrator.";
$lang["export_segments"]["error_message"]["export_supressed_list"] = "An error occurred exporting this segment.";
$lang["export_segments"]["error_message"]["export_list_stop"] = "Export Error:";
$lang["form"]["filter_by_list"]["criteria_option_list"] = "List";
$lang["form"]["filter_by_list"]["criteria_option_is_member_option"] = "Is member of";
$lang["form"]["filter_by_list"]["criteria_option_is_not_member_option"] = "Isn't member of";
$lang["admin_segment_create_blade"]["my_list_select_opt"] = "Admin lists";
$lang["form"]["segment_count"]["alert_fill_all_compulsary"] = "Please fill in all required fields.";
$lang["form"]["segment_count"]["option_select_suppressed"] = "Suppressed";
$lang["view"]["segment_limit"]["button_label"] = "Segments Limit:";
$lang["form"]["segment_count"]["error_message_timeout"] = "This process is taking longer than expected. Please save the segment and view the result later.";
$lang["form"]["segment_count"]["error_message_fill_compulsary"] = "Please fill in all required fields.";
$lang["form"]["users_dropdown"]["select_option_label"] = "Select an option";
$lang["form"]["link"]["predefine_template"] = "Select from the pre-defined templates";
$lang["form"]["table_heading"]["tag"] = "Tag";
$lang["form"]["table_heading"]["description"] = "Description";
$lang["form"]["table_heading"]["actions"] = "Actions";
$lang["form"]["widget_title"]["templates"] = "Templates";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["view"]["table_heading"]["segments"] = "Template Name";
$lang["view"]["table_heading"]["enable_users"] = "Enable for Users";
$lang["form"]["description"] = "Description";
$lang["form"]["description_description"] = "Provide a brief description of this segment template.";
$lang["templates"]["view"]["title"] = "Segment Templates";
$lang["templates"]["view"]["description"] = "Create and manage reusable templates for defining segments of your contact lists. These templates allow you and your users to quickly and easily target specific groups of subscribers based on their attributes, behavior, or other criteria, streamlining your email campaign targeting and personalization efforts.";
$lang["templates"]["add"]["title"] = "Add Segment Template";
$lang["templates"]["edit"]["title"] = "Edit Segment Template";
$lang["templates"]["add"]["description"] = "Create a new reusable template for defining segments of your contact lists, enabling targeted and personalized email campaigns.";
$lang["templates"]["add"]["enable_users"] = "Enable for Users";
$lang["templates"]["add"]["enable_users_desc"] = "Allow users to access and use this template.";
$lang["templates"]["add"]["enable_users_desc_only"] = "Description";
$lang["templates"]["edit"]["description"] = "Modify an existing segment template to refine its criteria and improve your audience targeting capabilities.";
$lang["templates"]["tag"]["updated"] = "Segment template status has been updated successfully.";
$lang["templates"]["tag"]["not_found"] = "No segment template found.";
$lang["templates"]["available_templates"] = "Templates";
$lang["templates"]["defined_templated"] = "Pre-defined templates";
$lang["templates"]["clone"] = "Clone";
$lang["templates"]["cloned"] = ":tag has been cloned successfully.";
$lang["templates"]["bulk_cloned"] = ":tag out of :count segments cloned successfully.";
$lang["add"]["box_title"] = "Templates";
$lang["add"]["alert_confirm_title"] = "Are you sure?";
$lang["add"]["alert_confirm_description"] = "It will override the current selection.";
$lang["templates"]["add_edit"]["save"] = "Save";
$lang["view"]["button"]["templates"] = "Templates";
$lang["add"]["exists"] = ":attribute with this name already exists.";
$lang["view"]["modal"]["heading"]["segment_templates"] = "Segment Templates";
$lang["view"]["modal"]["table_heading"]["tag"] = "Tag";
$lang["view"]["modal"]["table_heading"]["description"] = "Description";
$lang["view"]["modal"]["table_heading"]["actions"] = "Actions";
$lang["view"]["modal"]["button"]["clone_all"] = "Clone all";
$lang["form"]["error_message"]["select_filter"] = "Apply filters to refine your search.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
