<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["add"]["title"] = "Add Profile Field";
$lang["add"]["description"] = "Add a new custom field to capture additional information from your contacts beyond the standard fields. Tailor the field's type, options, and visibility to suit your specific data collection needs and enhance your audience segmentation capabilities.";
$lang["edit"]["title"] = "Edit Profile Field";
$lang["form"]["label"]["name"] = "Name";
$lang["form"]["label"]["name_description"] = "The name of this profile field.";
$lang["form"]["label"]["field_order"] = "Field order";
$lang["form"]["label"]["field_order_help"] = "The order in which this field appears on the \"Add Contact\" page.";
$lang["form"]["label"]["field_type"] = "Type";
$lang["form"]["label"]["field_type_help"] = "Select the type of data this field will store (e.g., Text, Multiline Text, Checkboxes, Dropdown, Radio Buttons, Date, JSON).";
$lang["form"]["label"]["required"] = "Required";
$lang["form"]["label"]["required_help"] = "If enabled, this field must be filled out when adding a contact to the associated list.";
$lang["form"]["label"]["list_of_values"] = "List of values";
$lang["form"]["label"]["list_of_values_help"] = "Enter the possible values for this field (applicable to Checkboxes, Dropdown, and Radio Button field types).";
$lang["form"]["label"]["contact_list"] = "Assign to contact lists";
$lang["form"]["label"]["contact_list_help"] = "Select the contact lists to which this profile field should be added. You can also assign this field to lists when adding or editing them.";
$lang["form"]["label"]["language"] = "Language text";
$lang["form"]["label"]["language_help"] = "E.g., custom_fields.contact_lists.firstname";
$lang["form_heading"] = "Field Details";
$lang["form"]["label"]["check_list"] = "Update this profile field of all existing contacts";
$lang["form"]["label"]["check_list_message"] = "This action will update the selected profile field for all existing contacts in the recently selected or un-selected lists. If the field is newly assigned to a list, it will be added with an empty value. For lists where this field has been recently removed, any associated data will be deleted.";
$lang["form"]["label"]["note"] = "Note";
$lang["form"]["label"]["name_error_message"] = "The name must contain only letters and numbers.";
$lang["view"]["pagetitle"] = "Profile Fields";
$lang["view"]["description"] = "Profile fields store additional information about your leads and contacts, such as name, company, location, and phone number.";
$lang["message"]["field_exists"] = "Profile field already exists.";
$lang["activity_log"]["title"] = "Profile Field";
$lang["view"]["title"]["table_headings"]["name"] = "Name";
$lang["view"]["title"]["table_headings"]["sorting_order"] = "Sort Order";
$lang["view"]["title"]["table_headings"]["type"] = "Type";
$lang["view"]["title"]["table_headings"]["status"] = "Status";
$lang["view"]["title"]["table_headings"]["required"] = "Required";
$lang["form"]["duplicate_field"]["message"] = "A profile field with this name already exists.";
$lang["view"]["model_delete"]["label"]["issue_1"] = "This profile field is assigned to one or more contact lists.";
$lang["view"]["model_delete"]["label"]["issue_2"] = "This profile field is not assigned to any lists, but it contains data.";
$lang["view"]["model_delete"]["alert_warning"]["message_1"] = "<b>Error:</b> This profile field is assigned to contact lists. Unassign it from all lists before deleting.";
$lang["view"]["model_delete"]["alert_warning"]["message_2"] = "<b>Warning:</b> This profile field is not assigned to any lists but contains data. Deleting it will also delete the data. ";
$lang["view"]["model_delete"]["action_description"] = "To delete this profile field forcibly, following actions are available:";
$lang["view"]["model_delete"]["action_description_check"] = "Unassign this profile field from all associated contact lists and delete it.";
$lang["view"]["model_delete"]["action_alert_message"] = "<b>Note:</b> Deleting this profile field will also delete its data.";
$lang["view"]["model_delete"]["data_flush_check"] = "I understand that deleting this profile field will also delete its data.";
$lang["view"]["model_delete"]["button_delete"] = "Delete field";
$lang["form"]["label"]["name_alphabetic_error"] = "The first character must be a letter.";
$lang["form"]["label"]["name_space_error"] = "Only letters, numbers, underscores, and spaces are allowed.";
$lang["form"]["alert"]["forbidden_error"] = "Commas (,) are not allowed in the list of values.";
$lang["view"]["delete_field"]["alert_title"] = "Are you sure you want to delete this profile field?";
$lang["view"]["delete_field"]["alert_message"] = "Profile field has been deleted successfully!";
$lang["contact_lists"]["firstname"] = "First Name";
$lang["contact_lists"]["lastname"] = "Last Name";
$lang["contact_lists"]["dob"] = "Birth Date";
$lang["contact_lists"]["city"] = "City";
$lang["contact_lists"]["state"] = "State";
$lang["contact_lists"]["country"] = "Country";
$lang["contact_lists"]["zip_code"] = "Zip Code";
$lang["contact_lists"]["mobile"] = "Mobile";
$lang["contact_lists"]["fax"] = "Fax";
$lang["contact_lists"]["company"] = "Company";
$lang["contact_lists"]["title"] = "Title";
$lang["add_new"]["field"]["type"]["values"]["text"] = "Text field";
$lang["add_new"]["field"]["type"]["values"]["number"] = "Numeric";
$lang["add_new"]["field"]["type"]["values"]["textarea"] = "Multiline text field";
$lang["add_new"]["field"]["type"]["values"]["checkbox"] = "Checkboxes";
$lang["add_new"]["field"]["type"]["values"]["select"] = "Dropdown";
$lang["add_new"]["field"]["type"]["values"]["radio"] = "Radio options";
$lang["add_new"]["field"]["type"]["values"]["date"] = "Date field";
$lang["add_new"]["field"]["type"]["values"]["json"] = "JSON field";
$lang["view"]["success_message"]["change_status"] = "Profile field status has updated successfully.";
$lang["added"] = "Profile field has been successfully added!";
$lang["updated"] = "Profile field has been successfully updated!";
$lang["deleted"] = "Profile field has been successfully deleted!";
$lang["not_found"] = "Profile field not found!";
$lang["req"] = "Error: At least one parameter is required.";
$lang["dependency_check"] = "Dependency Check(:field)";
$lang["users"] = "Users";
$lang["fname"]["address_line_1"] = "Address Line 1";
$lang["fname"]["address_line_2"] = "Address Line 2";
$lang["fname"]["city"] = "City";
$lang["fname"]["state"] = "State";
$lang["fname"]["post_code"] = "Post Code";
$lang["fname"]["phone"] = "Phone";
$lang["delete"]["issue_1"] = "The profile field is currently assigned to one or more user profiles.";
$lang["delete"]["issue"]["warning"] = "⚠️ Error: This profile field is currently assigned to one or more user profiles. Please remove it from all assigned users before attempting to delete it.";
$lang["delete"]["action"]["warning"] = "If you want to proceed with deletion, the following action is available:";
$lang["delete"]["action"]["direction"] = "Unassign this profile field from all linked users and delete it.";
$lang["delete"]["alert"] = "🔷 Note: Deleting this profile field will also remove all associated data. If this field is used in any broadcasts, you will need to remove it manually from those broadcasts.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
