<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["edit"]["title"] = "Primary Domain";
$lang["edit"]["description"] = "The primary domain allows you to use a different domain from your " . $lang["variables"]["site_title"] . " installation domain for publicly visible actions, such as tracking links and CNAME redirection for tracking domains. This helps keep your installation domain private while using an alternative domain for system features that are publicly accessible. However, you can still choose to use the installation domain as the primary domain if needed.";
$lang["edit"]["widget_title"] = "Primary Domain";
$lang["edit"]["widget_heading"] = "Configure Primary Domain";
$lang["edit"]["button"]["recheck"] = "Recheck DNS Record";
$lang["edit"]["label"]["add_a_record"] = "Add an \"A Record\"";
$lang["edit"]["table_data"]["a_record"] = "A";
$lang["edit"]["label"]["add_a_record_description"] = "Login to the DNS zone of your domain <b>:domain</b> and add the following record.";
$lang["success_message"]["primary_domain_confirmed"] = "Primary domain has been validated successfully.";
$lang["error_message"]["primary_domain_failed"] = "Primary domain validation has failed.";
$lang["success_message"]["primary_domain_added"] = "Primary domain has been added successfully.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
