<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["edit"]["title"] = "Cron Settings";
$lang["edit"]["description"] = "Configure and manage automated tasks by setting the frequency or running them manually. Ensure efficient handling of scheduled operations and tailor each cron job to meet specific needs for optimal system performance.";
$lang["form_heading"] = "Cron Jobs";
$lang["form"]["label"]["email_sending"] = "Email Campaigns";
$lang["form"]["label"]["email_sending_description"] = "Define how often the system should start sending newly scheduled broadcasts.";
$lang["form"]["label"]["trigger_scheduling"] = "Trigger Processing";
$lang["form"]["label"]["trigger_scheduling_description"] = "Set how frequently triggers should be evaluated and executed in descending order of their priority.";
$lang["form"]["label"]["bounce_processing"] = "Bounce Processing";
$lang["form"]["label"]["bounce_processing_description"] = "Specify the wait time before processing the next batch of bounce reports.";
$lang["form"]["label"]["fbl_processing"] = "Feedback Loop Processing";
$lang["form"]["label"]["fbl_processing_description"] = "Determine the interval for processing spam complaint feedback loops (FBLs).";
$lang["form"]["label"]["maintenance_cron"] = "Maintenance Work";
$lang["form"]["label"]["maintenance_cron_description"] = "Schedule regular system maintenance tasks to run at set intervals.";
$lang["form"]["label"]["segments_recount"] = "Segments Recount";
$lang["form"]["label"]["segments_recount_description"] = "Set how often segment data should be recalculated.";
$lang["form"]["label"]["pending_stats"] = "Pending Stats";
$lang["form"]["label"]["delete_exported_files"] = "Delete exported files";
$lang["form"]["label"]["evergreen_campaign"] = "Evergreen Campaigns";
$lang["form"]["label"]["evergreen_campaign_description"] = "Defines how often the system checks for qualified evergreen campaigns and schedules them automatically based on the set frequency and predefined conditions.";
$lang["form"]["label"]["suppress_subscriber"] = "Suppression Processing";
$lang["form"]["label"]["suppress_subscriber_description"] = "Specify how frequently the system should process and suppress subscribers.";
$lang["form"]["label"]["trigger_checkup"] = "Triggers Checkup";
$lang["form"]["label"]["trigger_checkup_description"] = "Retry failed trigger tasks automatically to ensure proper execution.";
$lang["form"]["label"]["queue_work"] = "Queue Work";
$lang["form"]["label"]["queue_work_description"] = "Set the time interval for processing tasks in the queue.";
$lang["form"]["label"]["stucked_campaigns"] = "Stuck Campaigns";
$lang["form"]["label"]["stucked_campaigns_description"] = "Schedule a routine check to detect and resolve campaigns that have become stuck.";
$lang["form"]["label"]["reset_users_limit"] = "This is a daily cron to reset the user limits e.g. daily email limit, monthly email limit, etc.";
$lang["form"]["button"]["force_run"] = "Run Forcefully";
$lang["form"]["label"]["click_tracking"] = "Click Tracking";
$lang["form"]["label"]["open_tracking"] = "Open Tracking";
$lang["form"]["label"]["process_tracking"] = "Engagement Processing";
$lang["form"]["label"]["process_tracking_description"] = "Specifies how often the system processes open and click data, ensuring that these interactions are recorded and updated at regular intervals.";
$lang["form"]["label"]["limits_reset"] = "Limit Reset";
$lang["success_message"]["running_in_background"] = "The cron job has been started in the background.";
$lang["success_message"]["cron_settings_updated"] = "Cron settings have been updated successfully.";
$lang["form"]["label"]["click_tracking_description"] = "This scheduled task periodically processes click tracking data, allowing you to analyze how recipients interact with links in your emails.";
$lang["form"]["label"]["open_tracking_description"] = "This scheduled task regularly processes open tracking data, providing insights into how many recipients are opening your emails.";
$lang["form"]["label"]["delete_exported_files_desc"] = "Specifies how often the system checks for exported files to delete. Only files older than the retention period set in the Application Settings will be removed.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
