<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["title"] = "Broadcasts";
$lang["view"]["description"] = "A broadcast is an email template sent to recipients, featuring TEXT/HTML body content. Create unlimited broadcasts easily.";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["view"]["table_heading"]["group"] = "Group";
$lang["view"]["table_heading"]["subject"] = "Subject";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["add"]["title"] = "Add Broadcast";
$lang["add"]["description"] = "Create a new email broadcast using our HTML Editor or Drag & Drop Builder (if available). Employ custom variables, spintax, and dynamic content tags for personalized and engaging email content.";
$lang["widget_heading"] = "Select your favorite editor/builder to create a broadcast.";
$lang["form_heading"] = "Broadcast Details";
$lang["form_heading_help"] = "This is where you provide a specific and recognizable name for this broadcast. The name should be unique to allow for easy identification among other broadcasts.";
$lang["form"]["label"]["email_subject"] = "Email Subject";
$lang["form"]["label"]["email_subject_help"] = "This represents the subject line of your email. This will be the first line your recipients see when they receive your email. It plays a crucial role in determining whether the recipient will open the email.";
$lang["form"]["label"]["html_body"] = "HTML Body";
$lang["form"]["label"]["html_body_help"] = "This is the HTML content of your email. It refers to the main body of your sent email that could include various HTML tags such as paragraphs, links, tables, images, etc. This content will be displayed to the recipient in the body of the email.";
$lang["form"]["label"]["text_body"] = "Text Body";
$lang["form"]["label"]["text_body_help"] = "This refers to the text version of your email. It's a plain text copy of the email content without any HTML formatting. This will be used when the recipient's email client can't display HTML emails or the recipient chooses to view emails in plain text format.";
$lang["form"]["label"]["check_spam_score"] = "Check Spam Score";
$lang["form"]["label"]["attach_file"] = "Attachments";
$lang["form"]["label"]["attach_file_help"] = "Attach files to this broadcast. Include documents, images, PDFs, or other file types as needed.";
$lang["form"]["label"]["drop_or_browse_file_here"] = "Drop files here or click to browse";
$lang["form"]["label"]["previous_attachment"] = "Previous Attachments(s)";
$lang["form"]["label"]["get_content_from_url"] = "https://www.mytemplate.com/template.html";
$lang["form"]["label"]["campaign_url"] = "Insert the URL to import content from.";
$lang["form"]["button"]["get"] = "Import";
$lang["form"]["label"]["campaign_builder"] = "Email Design Builder";
$lang["add"]["form"]["button"]["load_campaign_builder"] = "Load Email Design Builder";
$lang["form"]["button"]["edit_content_area"] = "Edit Email Design";
$lang["form"]["label"]["download_image"] = "Download Images";
$lang["form"]["link"]["fetch_url"] = "Import Email Content from a URL";
$lang["form"]["link"]["fetch_url_help"] = "Enter the URL to fetch and insert the content into the editor.";
$lang["form"]["link"]["fetch_images_help"] = "Download images locally from the remote content and update the image paths to local references.";
$lang["form"]["alert_message"]["leave_page"] = "You have unsaved changes. Are you sure you want to leave this page?";
$lang["form"]["label"]["enable_preheader"] = "Add Email Pre-header";
$lang["form"]["label"]["enable_preheader_help"] = "Include a pre-header with your email to provide a preview next to or below the subject line in the recipient's inbox.";
$lang["form"]["file_upload"]["info-message"]["status_initialized"] = "Previous attachments(s)";
$lang["form"]["file_upload"]["success_message"]["transfers_finished"] = "All pending transfers completed";
$lang["form"]["file_upload"]["info_message"]["file_added"] = "New file added";
$lang["form"]["file_upload"]["info_message"]["uploading_start"] = "Starting upload for";
$lang["form"]["file_upload"]["info_message"]["cancelled_by_user"] = "Canceled by user";
$lang["form"]["file_upload"]["info_message"]["uploading"] = "Uploading";
$lang["form"]["file_upload"]["info_message"]["file_size_error"] = "The file";
$lang["form"]["file_upload"]["error_message"]["server_response_for_file"] = "Upload failed";
$lang["form"]["file_upload"]["success_message"]["file_uploaded"] = "Upload completed";
$lang["form"]["file_upload"]["success_message"]["upload_completed"] = "Successfully uploaded";
$lang["form"]["file_upload"]["error_message"]["fallback_error"] = "Plugin cannot be used here. Running fallback callback.";
$lang["form"]["file_upload"]["error_message"]["file_size_error_message"] = "cannot be uploaded";
$lang["form"]["label"]["select_serder_info"] = "Sender Details";
$lang["form"]["label"]["select_serder_info_help"] = "Choose the module option for obtaining sender details. This will determine the email address, name, and other details appearing as the 'From', 'Return-Path', 'Reply-To' in the email headers.";
$lang["form"]["label"]["option_select_domain"] = "Specific Sending Domain";
$lang["form"]["label"]["option_select_sending_node"] = "Obtain from Sending Node";
$lang["edit"]["title"] = "Edit Broadcast";
$lang["form"]["html_editor"]["description"] = "Use the HTML Editor to customize your broadcast with ease. Create and edit your content using a variety of formatting options to ensure your broadcast meets your unique requirements.";
$lang["form"]["builder"]["description"] = "Use the Drag & Drop Builder for a no-code experience and select from the beautiful and responsive widgets, modules, and tags to enhance your content.";
$lang["form"]["send_preview"]["form_heading"] = "Send a Preview";
$lang["form"]["send_preview"]["button"]["send"] = "Send Preview";
$lang["form"]["send_preview"]["label"]["smtp_for_preview"] = "Sending Node";
$lang["form"]["send_preview"]["label"]["smtp_for_preview_help"] = "The preview email will be relayed using the selected sending node.";
$lang["form"]["send_preview"]["label"]["domain_for_preview"] = "Sending Domain";
$lang["form"]["send_preview"]["label"]["domain_for_preview_help"] = "Choose the sending domain for the preview email. This domain will appear in the email headers and to recipients as the originator, maintaining a consistent brand image.";
$lang["form"]["send_preview"]["label"]["send_preview_to_email"] = "Email Address where the preview will be sent";
$lang["form"]["send_preview"]["label"]["send_preview_to_email_help"] = "Specify the email address to which you want to send the preview. This allows you to review the email before sending actual campaigns to the final recipients.";
$lang["form"]["send_preview"]["button"]["send_preview"] = "Send Test Preview";
$lang["send_preview"]["button"]["send_preview_help"] = "Enter the email address where you want to send the preview. This lets you review the email before sending the final version to your recipients.";
$lang["form"]["send_preview"]["label"]["contact_email_id"] = "Associate a Contact id";
$lang["form"]["send_preview"]["label"]["contact_email_id_help"] = "Convert the email variables with actual values for the specified contact id. This allows you to preview how these custom fields will look in the actual email. If you leave this field blank, the variables in the preview email will not be converted.";
$lang["form"]["send_preview"]["help_note"] = "<small><strong>Note</strong>: Save the broadcast before sending a preview to ensure the latest content is included.</small>";
$lang["form"]["send_preview"]["new_help_note"] = "<small><strong>Note</strong>: Ensure the broadcast is saved before sending a preview.</small>";
$lang["modal"]["check_spam_score"]["form_heading"] = "Check Spam Score";
$lang["modal"]["check_spam_score"]["alert_message"]["message_1"] = "A higher positive score increases the likelihood of being classified as spam. Aim for a score of 5.0 or lower.";
$lang["modal"]["check_spam_score"]["alert_message"]["message_2"] = "Ideally, your email should have a score lower than 5.0 to be considered acceptable.";
$lang["modal"]["check_spam_score"]["label"]["status"] = "Status";
$lang["modal"]["check_spam_score"]["label"]["score"] = "Score";
$lang["modal"]["check_spam_score"]["alert_message"]["empty_contents"] = "The HTML Content is empty.";
$lang["modal"]["check_spam_score"]["alert_message"]["empty_subject"] = "Subject line is empty.";
$lang["modal"]["check_spam_score"]["alert_message"]["alert_error"] = "Error: Unable to check spam score.";
$lang["fetch_url"]["alert_message"]["alert_request"] = "Please enter a valid URL.";
$lang["form"]["fetch_url"]["alert_message"]["alert_warning"] = "The given URL is invalid.";
$lang["form"]["file_upload"]["info_message"]["successfully_removed"] = "Successfully removed.";
$lang["templates"]["message"]["template_activated"] = "Template has been activated successfully.";
$lang["templates"]["message"]["template_deactivated"] = "Template has been deactivated successfully.";
$lang["templates"]["alert_confirm"]["remove_warning_description"] = "Warning: This template will be permanently removed from  the templates section.";
$lang["templates"]["success_message"]["template_removed"] = "The template has been successfully removed.";
$lang["templates"]["alert_message"]["template_updated"] = "The template has been updated successfully.";
$lang["templates"]["upload_form"]["success_message"]["template_uploaded"] = "The template has been successfully uploaded.";
$lang["view"]["delete"]["notification"]["activity_title"] = "Broadcast";
$lang["form"]["email_preview"]["form_heading"] = "Email Preview";
$lang["form"]["builder"]["button"]["dynamic_fields"] = "Dynamic Content Tags";
$lang["form"]["builder"]["button"]["dynamic_fields_title"] = "Insert Dynamic Content";
$lang["form"]["builder"]["button"]["insert"] = "Insert";
$lang["form"]["label"]["group_tooltip_title_add_new_group"] = "Add New Group";
$lang["form"]["label"]["group"] = "Group";
$lang["form"]["label"]["placeholder_choose_group"] = "Select Group";
$lang["edit"]["form"]["editor"]["unsubscribe"] = "Unsubscribe";
$lang["edit"]["form"]["editor"]["confirm"] = "Confirm";
$lang["edit"]["form"]["editor"]["web_version"] = "Web Version";
$lang["add"]["form"]["file_upload"]["waiting"] = "Waiting";
$lang["templates"]["view"]["title"] = "Select a Template";
$lang["templates"]["view"]["description"] = "Browse, edit, and utilize templates for your broadcasts. Use the HTML Editor or Drag & Drop Builder (if available) for easy customization. Filter templates by category or use the search function to find exactly what you need.";
$lang["templates"]["page"]["title"] = "Templates";
$lang["templates"]["page"]["description"] = "Discover a variety of pre-designed templates, meticulously crafted to enhance the visual appeal and effectiveness of your broadcasts. Easily edit each template using the HTML Editor or Drag & Drop Builder (if available). Our collection caters to all needs, whether your broadcast is informational, promotional, or otherwise.";
$lang["templates"]["marketplace"]["title"] = "Templates Gallery";
$lang["templates"]["marketplace"]["description"] = "Explore our collection of pre-designed templates ready for installation. The installed templates will become available in the templates section when creating broadcasts.";
$lang["templates"]["marketplace"]["label"]["hide_installed"] = "Hide Installed Templates";
$lang["templates"]["marketplace"]["label"]["hide_installed_description"] = "Select this option to hide already installed templates from your gallery overview.";
$lang["templates"]["table"]["name"] = "Name";
$lang["templates"]["view"]["table_heading"]["template"] = "Template Name";
$lang["templates"]["view"]["table_heading"]["client_enabled"] = "Enable for Users";
$lang["templates"]["view"]["table_heading"]["category"] = "Category";
$lang["templates"]["view"]["table_heading"]["reiews"] = "Reviews";
$lang["templates"]["view"]["table_heading"]["status"] = "Status";
$lang["templates"]["view"]["button"]["upload_template"] = "Upload Template";
$lang["templates"]["button_marketplace"] = "Template Marketplace";
$lang["templates"]["view"]["button"]["marketplace"] = "Templates Gallery";
$lang["choose_template"]["label"]["blank_template"] = "Blank Template";
$lang["choose_template"]["category"]["blank_template"] = "Blank";
$lang["choose_template"]["label"]["no_template_added"] = "No template added";
$lang["choose_template"]["filter"]["label"]["select_category"] = "Select Category";
$lang["choose_template"]["filter"]["option"]["all_categories"] = "All Categories";
$lang["choose_template"]["label"]["search_template"] = "Search Template";
$lang["templates"]["Editor"] = "Editor";
$lang["add_blank"]["label"]["html_editor"] = "HTML Editor";
$lang["add_blank"]["button"]["use_editor"] = "Use HTML Editor";
$lang["templates"]["Builder"] = "Builder";
$lang["add_blank"]["label"]["drag_drop_builder"] = "Drag & Drop Builder";
$lang["add_blank"]["button"]["use_builder"] = "Use Builder";
$lang["add_blade"]["editor_heading"] = "Editor Options";
$lang["add_new"]["label"]["html_editor"] = "HTML Editor";
$lang["add_new"]["button"]["use_editor"] = "Use HTML Editor";
$lang["add_blade"]["builder_heading"] = "Builder";
$lang["add_new"]["label"]["drag_drop_builder"] = "Drag & Drop Builder";
$lang["custom_criteria"]["alert_confirm"]["confirm_delete"] = "Are you sure you want to delete this?";
$lang["custom_criteria"]["filter_placeholder"]["select_option"] = "Select Option";
$lang["custom_criteria"]["filter_option"]["suppressed_checkbox"] = "Suppressed";
$lang["templates_backup_blade"]["catalog_collection_action"] = "Catalog Collection";
$lang["templates_backup_blade"]["mumara_template_span"] = "Mumara Template";
$lang["templates_backup_blade"]["catalog_span"] = "Catalog";
$lang["templates_backup_blade"]["campaign_group_span"] = "Campaign Group";
$lang["templates_backup_blade"]["july_month"] = "July";
$lang["templates_backup_blade"]["invoice_template_action"] = "Invoice Template";
$lang["templates_backup_blade"]["invoice_txt_span"] = "Invoice";
$lang["templates_backup_blade"]["main_one_span"] = "Main-01";
$lang["templates_backup_blade"]["main_one_template_span"] = "Main-01 Template";
$lang["templates_backup_blade"]["main_text_span"] = "Main";
$lang["templates_backup_blade"]["template_text_span"] = "Template";
$lang["add_new"]["success_message"]["builder_selection"] = "Your selection has been saved successfully.";
$lang["add_new"]["action"]["paused_campaign_popover"] = "Pause the campaign forcefully";
$lang["additional_header"]["title"] = "Additional Headers";
$lang["additional_header"]["description"] = "Add custom email headers which will be embedded to the email when this broadcast is sent. These can be set as per your requirement or other tracking purposes.";
$lang["additional_header"]["note"] = "<b>Note:</b> No special characters or spaces are supported except hyphens (-).";
$lang["additional_header"]["button"]["add"] = "Add New";
$lang["view"]["label"]['editor'] = "Editor";
$lang["view"]["label"]['builder'] = "Builder";
$lang['add_new']['form']['drag_drop_zone']['size_excess_limit'] = "File size exceeds the limit.";
$lang["templates"]["button"]["resyncTemplates"] = "Update Templates";
$lang["view"]["template_title"] = "Broadcasts Templates";
$lang["not_found"] = "Broadcast doesn't exits";
$lang["add_new"]["form"]["drag_drop_zone"]["size_excess_limit"] = "size excess limit";
$lang["templates"]["tag"]["updated"]["success_message"] = "Broadcast template status has been successfully updated.";
$lang["templates"]["tag"]["not_found"]["error_message"] = "Broadcast template doesn't exist.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
