<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $groups_parent = addParentPermission('Groups','1','api','0','0','all','10000','0');
        if(!is_null($groups_parent))
            addChildPermission('Get Groups', '1', 'api', '0', '0', 'all', '1', 'getGroups', $groups_parent->id);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $groups_parent = \App\Models\Permission::where('default_title','Get Groups')->where('route_type','api')->first();
        if(!is_null($groups_parent)){
            \App\Models\Permission::where('parent_id',$groups_parent->id)->delete();
            $groups_parent->delete();
        }
    }
};
