<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('sections', 'tag'))
        {
            Schema::table('sections', function (Blueprint $table) {
                $table->string('tag')->nullable()->default(null);
            });
        }
        $exists=DB::table('sections')->where('id',5)->where('name','Custom Field')->exists();
        if(!$exists)
        DB::statement("INSERT INTO `sections` (`id`, `name`, `tag`) VALUES(5, 'Custom Field', 'customField')");
        DB::statement("UPDATE `sections` SET tag ='list'   WHERE  `id` = 1;");
        DB::statement("UPDATE `sections` SET tag ='sendingNode'   WHERE  `id` = 2;");
        DB::statement("UPDATE `sections` SET tag ='broadcast'   WHERE  `id` = 3;");
        DB::statement("UPDATE `sections` SET tag ='broadcastTemplate'   WHERE  `id` = 4;");
            
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('sections', 'tag'))
        {
            Schema::table('sections', function (Blueprint $table) {
                $table->dropColumn('tag');
            });
        }        
    }
};
