<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $permission = DB::table('permissions')
            ->where('route', 'client.package.view')
            ->first();

        if ($permission) {
            DB::table('permissions')
                ->where('id', $permission->id)
                ->update(['skip_in_acl' => 1]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('permissions')
            ->where('route', 'client.package.view')
            ->update(['skip_in_acl' => 0]);
    }
};
