<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasColumn('domain_maskings','bounce_domain_spf')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->text('bounce_domain_spf')->nullable();
            });
        }
        if(!Schema::hasColumn('domain_maskings','bounce_domain_mx')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->text('bounce_domain_mx')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasColumn('domain_maskings','bounce_domain_mx')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->drop('bounce_domain_mx');
            });
        }
        if(Schema::hasColumn('domain_maskings','bounce_domain_spf')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->drop('bounce_domain_spf');
            });
        }
    }
};
