<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
            if (Schema::hasColumn('user_settings', 'created_at')) {
                Schema::table('user_settings', function (Blueprint $table) {
                    $table->timestamp('created_at')->nullable()->useCurrent()->change();
                });
            }
            if (Schema::hasColumn('email_complaints', 'created_at')) {
                Schema::table('email_complaints', function (Blueprint $table) {
                    $table->timestamp('created_at')->nullable()->useCurrent()->change();
                });
            }
            if (Schema::hasColumn('email_complaints', 'updated_at')) {
                Schema::table('email_complaints', function (Blueprint $table) {
                    $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate()->change();
                });
            }
            if (Schema::hasColumn('email_track_processing', 'updated_at')) {
                Schema::table('email_track_processing', function (Blueprint $table) {
                    $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate()->change();
                });
            }
            if (Schema::hasColumn('profile_fields', 'updated_at')) {
                Schema::table('profile_fields', function (Blueprint $table) {
                    $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate()->change();
                });
            }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
    }
};
