<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (
            Schema::hasTable('send_email_template_packets') &&
            ! Schema::hasTable('dynamic_template_queue')
        ) {
            Schema::rename('send_email_template_packets', 'dynamic_template_queue');
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
    // Only rename back if the new table exists and the old table does *not* exist
        if (
            Schema::hasTable('dynamic_template_queue') &&
            ! Schema::hasTable('send_email_template_packets')
        ) {
            Schema::rename('dynamic_template_queue', 'send_email_template_packets');
        }
    }
};
