<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('packages', 'display_initial_setup')) {
            Schema::table('packages', function (Blueprint $table) {
                 $table->Integer('display_initial_setup')->default(1);
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('packages', 'display_initial_setup')) {
            Schema::table('packages', function (Blueprint $table) {
                $table->dropColumn('display_initial_setup');
            });
        }
    }
};
