<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('application_settings', function (Blueprint $table) {
            $secure_url_exists = DB::table('application_settings')
                ->where('setting_name', 'use_secure_url')
                ->exists();
            
            if (!$secure_url_exists) {
                DB::table('application_settings')->insert([
                    'setting_name' => 'use_secure_url',
                    'setting_value' => 'on'
                ]);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('application_settings', function (Blueprint $table) {
            DB::table('application_settings')
                ->where('setting_name', 'use_secure_url')
                ->delete();
        });
    }
};
