<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $triggerPermission = \App\Models\Permission::where('route','trigger.index')->first();
        if(!is_null($triggerPermission))
            addChildPermission('Copy Trigger Template','1','web','0','0','all','4','trigger.copy',$triggerPermission->id,'clone_trigger');
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'triggers||trigger/{id}/edit||trigger/add||trigger/templates||trigger/template/add||trigger/template/{id}/edit||trigger/clone/{id}' WHERE `mainmenu`.`link` = 'trigger.index';");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'schedule/new/{id?}||triggers||trigger/{id}/edit||trigger/add||campaign/schedule/{id?}||campaign/re-schedule/{id}||trigger/templates||trigger/template/add||trigger/template/{id}/edit||trigger/clone/{id}' WHERE `mainmenu`.`id` = 4;");
        $roles = \App\Models\Role::where('id', '!=', 1)->where('type','web')->pluck('id')->toArray();
        $triggerCopyPermission = \App\Models\Permission::where('permission','clone_trigger')->first();
        if(!is_null($triggerCopyPermission)) {
            foreach ($roles as $role) {
                $permission_role = \App\Models\RolePermission::where('role_id', $role)->first();
                if (!is_null($permission_role)) {
                    \App\Models\RolePermission::firstOrCreate(['role_id' => $role, 'permission_id' => $triggerCopyPermission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\Permission::where('route','trigger.copy')->delete();
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'triggers||trigger/{id}/edit||trigger/add' WHERE `mainmenu`.`link` = 'trigger.index';");
        \Illuminate\Support\Facades\DB::statement("UPDATE `mainmenu` SET `routes` = 'schedule/new/{id?}||triggers||trigger/{id}/edit||trigger/add||campaign/schedule/{id?}||campaign/re-schedule/{id}' WHERE `mainmenu`.`id` = 4;");
        $triggerCopyPermission = \App\Models\Permission::where('permission','clone_trigger')->first();
        if(!is_null($triggerCopyPermission))
            \App\Models\RolePermission::where('permission_id',$triggerCopyPermission->id)->delete();

    }
};
