<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $roles = \App\Models\Role::where('id', '!=', 1)->where('type','web')->pluck('id')->toArray();
        $dynTagCopyPermission = \App\Models\Permission::where('permission','clone_dynamic_tag')->first();
        if(!is_null($dynTagCopyPermission)) {
            foreach ($roles as $role) {
                $permission_role = \App\Models\RolePermission::where('role_id', $role)->first();
                if (!is_null($permission_role)) {
                    \App\Models\RolePermission::firstOrCreate(['role_id' => $role, 'permission_id' => $dynTagCopyPermission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $dynTagCopyPermission = \App\Models\Permission::where('permission','clone_dynamic_tag')->first();
        if(!is_null($dynTagCopyPermission))
            \App\Models\RolePermission::where('permission_id',$dynTagCopyPermission->id)->delete();
    }
};
