<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $index_list_id=false;
        $index_user_id=false;
        $indexes = Schema::getIndexes("suppression_emails");
        foreach ($indexes as $index) {
            if (in_array("list_id", $index['columns']) && $index['type']=="btree") {
                $index_list_id=true;
            }
            if (in_array("user_id", $index['columns'])  && $index['type']=="btree") {
                $index_user_id=true;
            }
        }

        if (! $index_list_id) {
            DB::statement("INSERT INTO `alter_tables` ( `name`, `query`, `status`, `fields` ) VALUES (NULL, 'CREATE INDEX list_id ON suppression_emails (list_id);', '0', NULL);");
        }
        if (! $index_user_id) {
            DB::statement("INSERT INTO `alter_tables` ( `name`, `query`, `status`, `fields` ) VALUES (NULL, 'CREATE INDEX user_id ON suppression_emails (user_id);', '0', NULL);");
        }
        Artisan::call('alter:tables');
   }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
