<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $table_name = "email_track_processing";
        if (!Schema::hasColumn($table_name , 'list_id')) {
            Schema::table($table_name, function (Blueprint $table) {
                $table->Integer('list_id')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $table_name = "email_track_processing";
        if (Schema::hasColumn($table_name , 'list_id')) {
            Schema::table($table_name, function (Blueprint $table) {
                $table->dropColumn('list_id');
            });
        }
    }
};
