@extends(decide_template())
@section('title', trans('common.label.contact_lists'))
@php
    $authUser = getAuthUser();
@endphp
@section('page_styles')
<link href="/resources/assets/css/list-view.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<style type="text/css">
table#lists tr td .dropdown {
    display: inline-block;
    float: none;
}
.btn-added {
    display: inline-block;
    float: left;
    position: relative;
    margin-left: 5px;
}
a.btn-icon-md {
    min-width: 31px !important;
}
#import-result table tr td:first-child {
    width: 220px;
    max-width: 200px;
    text-align: left;
}
#groups-table tr th, #groups-table tr td {
    text-align: center;
    padding: 10px !important;
}
#groups-table tr th:first-child, #groups-table tr td:first-child {
    min-width: 200px !important;
    width: 30% !important;
    text-align: left;
}
#modal-edit-group .dataTables_filter input[type="search"] {
    max-width: 140px;
}
#groups-table tr th:last-child, #groups-table tr td:last-child {
    text-align: center;
    max-width: 100px;
}
.main-actions {
    display: flex;
    vertical-align: middle;
    align-items: center;
    justify-content: center;
}
.main-actions a i {
    font-size: 16px;
    width: 18px;
    margin: 0 4px;
    text-align: center;
}
.fa-save:before {
    content: "\f0c7";
}
.dataTables_wrapper .dataTable tbody tr td:last-child .main-actions>a.save-group, .dataTables_wrapper .dataTable tbody tr td:last-child .main-actions>a.cancel-group {
    display: none;
}
#groups-table tr td .labels input.group-input, #groups-table tr td .labels label {
    border: 0;
    border-radius: 0;
    padding: 8px 5px 8px 5px !important;
    height: 31px !important;
    width: 100%;
    border-bottom: 2px solid #ddd;
    line-height: 1 !important;
}
#groups-table tr td .labels label {
    border-color: transparent !important;
}
#groups-table tr td .labels input.group-input {
    display:none;
}
.main-actions a.disabled {
    opacity: 0.5;
    pointer-events: none;
}
.main-actions.disabled {
    cursor: no-drop;
}
button.close {
    margin-top: 0px !important;
}
.popover-body {
    text-align: center;
}
.popover-body b {
    font-weight: 500;
}
#groups-table tr th:nth-child(2), #groups-table tr td:nth-child(2) {
    max-width: 120px;
}
</style>
@endsection

@section('page_scripts')
    <script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
    <script src="/themes/default/js/select2.js" type="text/javascript"></script>
    <script src="/themes/default/js/common.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
    <script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/fnReloadAjax.js" type="text/javascript"></script>
    <script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>

@if ($list_view == 'tree')
<style>
    .dragrows{ cursor:move }
    #example-datatable .kt-checkbox > span {top: -9px !important; }
    table.treetable tbody tr td.kt-checkbox-inline {
        white-space: nowrap !important;
    }
    .kt-checkbox-inline .kt-checkbox {
        display: inline-block;
        margin-right: 0 !important;
        margin-bottom: 5px !important;
    }
    table#example-datatable {
        margin-top: 30px;
    }
</style>

<script type="text/javascript" src="/themes/default/js/gridtree/jquery.ui.core.js"></script>
<script type="text/javascript" src="/themes/default/js/gridtree/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/themes/default/js/gridtree/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="/themes/default/js/gridtree/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="/themes/default/js/gridtree/jquery.ui.droppable.js"></script>
<script type="text/javascript" src="/themes/default/js/gridtree/jquery.treetable.js" ></script>
<script>
    
    function treeTable(){
      $(".tree").treetable({ expandable: true },true);
      // Highlight selected row
      $(".tree tbody").on("mousedown", "tr", function() {
            $(".selected").not(this).removeClass("selected");
            $(this).toggleClass("selected");
            $(this).toggleClass("selected");
            saveTreeState(1);
    });

      // Drag & Drop Example Code
    $(".tree .file, .tree .folder").draggable({
        helper: "clone",
        opacity: .75,
        refreshPositions: true, // Performance?
        revert: "invalid",
        revertDuration: 300,
        scroll: true
    });

      $(".tree .folder").each(function() {
        $(this).parents(".tree tr").droppable({
          accept: ".file",
          drop: function(e, ui) {

            var droppedEl = ui.draggable.parents("tr");

            drag_id =  droppedEl.attr('data-tt-id');
            drop_id =  $(this).attr('data-tt-id');

            drag_movable =  droppedEl.attr('data-tt-movable');
            drop_movable =  $(this).attr('data-tt-movable');

            directory_level =  $(this).attr('data-tt-root');

            var data_ttID = $(this).data("ttId");

            // .. directory not move and not accept file to drop
            if (drag_movable == 0 || (drop_movable == 0 && directory_level == 'root' && drag_id.indexOf("list") != -1) || (drag_id.indexOf("group") >= 0 && drop_id == 'group2')) {
              //  alert(drag_movable);
               // return;
            }
            $.ajax({
            type: "POST",
            url: "{{ url('/') }}"+"/list/tree/move",
            data: { action: "Move_List", drag_id: drag_id, drop_id : drop_id  },
                success: function(result) {
                    if (result.response == 'error'){
                        alert('' + result.list + '{{trans('contact_list.view.list_exist.message')}}'+ result.group +' ');
                        return false;
                    } else {
                        //$(".tree").treetable("move", droppedEl.data("ttId"), data_ttID);
                        window.location.href = "{{ route('list.index') }}";
                        //$('#example-datatable').Datatable().ajax().reload();
                    }
                }
            })
          },
          hoverClass: "accept",
          over: function(e, ui) {
            var droppedEl = ui.draggable.parents("tr");
            if(this != droppedEl[0] && !$(this).is(".expanded")) {
             $(".tree").treetable("expandNode", $(this).data("ttId"));
            }
          }
        });
      }); 
      <?php
    if(isset($list_tree_state) && count($list_tree_state) > 0 ) {
        foreach($list_tree_state as $group) { ?>
            if($(document).find('#<?php echo $group;?>').length>0){
             $('.tree').treetable("expandNode", '<?php echo $group;?>');;
            }
<?php }} ?> 
    }
setTimeout(function(){
 treeTable();   
},1000);
    

    function saveTreeState(val) {
        var expanded_list = new Array();
        $(".expanded[id^='group']").each(function(){
            expanded_list.push($(this).attr('id'));
        }) 
        $.ajax({
          type: "POST",
          url: "{{ url('/') }}"+"/list/tree/move",
          data: { action: "SAVE_TREE_STATE", expanded_list: expanded_list, val: val },
          success: function(result) {
            // need to execute 2 times because save the opened states
            if (result == '1') {
                saveTreeState(2);
            }
          }
        })
     }
     // edit group in tree view
     function editGroup(group_id) {
        $("#groupedit-"+group_id).css("display", "inline")
        $(".grouplabel-"+group_id).hide()
    }
    // cancel edit in tree view
    function cancelEdit(group_id) {
        $("#groupedit-"+group_id).hide()
        $(".grouplabel-"+group_id).show()
    }
    // update group in tree view
    function saveGroup(group_id) {
        new_group_label = $('#new_list_group_name_'+group_id).val();
        $.ajax({
          type: "POST",
          url: "{{ url('/') }}"+'/list/tree/move',
          data: {action: "SAVE_GROUP_LIST" , group_id : group_id, new_group_label : new_group_label}
        }).done(function( msg ) {
            Command: toastr["success"] ("{{trans('contact_list.view.save_group.success_message')}}");
            $("#groupname-"+group_id).html("<strong>"+new_group_label+"<strong>")
            $("#groupedit-"+group_id).hide()
            $(".grouplabel-"+group_id).show()
        })
    }

    function deleteGroupList(group_id) {
        if(confirm('{{trans('contact_list.view.delete_group.confirm_message')}}'))
        {
            $.ajax({
              type: "POST",
              url: "{{ url('/') }}"+'/list/tree/move',
              data: {action: "DELETE_GROUP_LIST" , group_id : group_id}
            }).done(function( msg ) {
                // console.log(msg);
                Command: toastr["success"] ("{{trans('contact_list.view.delete_group_list.success_message')}}"); 
                bulkActions();
            })
        }
    }
    // delete group in tree view
    function deleteGroup(group_id) {
        if(confirm('{{trans('common.message.alert_delete')}}'))
        {
            $.ajax({
              type: "POST",
              url: "{{ url('/') }}"+'/list/tree/move',
              data: {action: "DELETE_GROUP" , group_id : group_id}
            }).done(function( msg ) {
               // console.log(msg);
                window.location.href = "{{ route('list.index') }}";
                Command: toastr["success"] ("{{trans('contact_list.view.save_group.delete_message')}}");
             
            })
        }
    }

    $('.group-selector-subscriber').click(function () {
        var group = this.id;
        if($(this).is(':checked')) {
            $('.group-subscriber-'+group).prop('checked', true);
        } else {
            $('.group-subscriber-'+group).prop('checked', false);
        }
    });
    
    // check/uncheck all checkbox
    $('[data-tt-parent-id="group0"] .checkbox-all-index-root:first').click(function () {
        if($(this).is(':checked')) {
            $('.checkbox-index').prop('checked', true);
        } else {
            $('.checkbox-index').prop('checked', false);
        }
    });
</script>
@endif
    <script>
        var objTable;
        var request;
        var record_type = 'our_records';
        let list_id_to_delete = null;


        function groupTable() {
            var page_limit=show_per_page('','groups_pageLength',5);  // Params (table,page,default_limit=10)
            var table=$('#groups-table').DataTable({
                "aoColumnDefs": [{"bSortable": false, "aTargets": [1]}],
                "aaSorting": [[2, "desc"]],
                "sPaginationType": "full_numbers",
                "sAjaxSource": "{{ url('/lists/getGroups') }}",
                "pageLength" : page_limit,
                "aLengthMenu": [[5, 10,50, 100, 500], [5, 10,50, 100, 500]]
            });
  
        }
        $(document).ready(function() {
            groupTable();
            // $("#groups-table").dataTable({
            //     "aoColumnDefs": [{"bSortable": false, "aTargets": [1]}],
            //     "aaSorting": [[0, "desc"]],
            //     "sPaginationType": "full_numbers",
            //     "pageLength" : page_limit,
            //     "aLengthMenu": [[5, 10,50, 100, 500], [5, 10,50, 100, 500]]
            // });


            $("a#help-article").css("display", "block");
            $("a#help-article").attr("href", "https://support.mumara.com/hc/articles/1/6/4/contact-lists");

            var g_text = "";
            $("body").on("click", ".group-input", function(){
                $(this).keypress(function() {
                    var gt = $(this).next().text();
                    var val = $(this).val();
                    $(this).next().text(val);
                });
                
            });
            
            $("body").on("click", "a.delete-group",function() {
              
              // {!! trans('contact_list.model.dependency_check.error_note', ["group_name" => "General"]) !!}
               var label = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("label");
                var inputId = label.attr('id');
                var g_text = $(label).text();
                var row = $(this).parent().parent().parent();
                document.getElementById("get_users_list2").innerHTML="";
                document.getElementById("get_users_list_segment").innerHTML="";
                document.getElementById("new_id").innerHTML="";
                document.getElementById("new_id").value = "";
                var return_select="";
                var return_list = "";
                var return_list_segment="";
                $.get('/lists/groups/check/' + inputId, function (data) {
                    if (data == 'not_exists') {
                        Swal.fire({
                            title: "{{trans('dynamic_tags.alert_confirm.title_sure')}}",
                            text: "{!! trans('dynamic_tags.alert_confirm.description_not_revert') !!}",
                            icon: 'warning',
                            showCancelButton: true,
                            confirmButtonColor: '#3085d6',
                            cancelButtonColor: '#d33',
                            confirmButtonText: "{{trans('dynamic_tags.alert_confirm.button.delete')}}"
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: "{{  url('lists/deleteListGroups') }}",
                                    type: "POST",
                                    data:{
                                        group_id:inputId,
                                    },
                                    success: function(result) {
                                        Swal.fire({
                                            title: "{{trans('dynamic_tags.alert_confirm.message_deleted')}}",
                                            text: "{{ trans('contact_list.view.modal.delete.success_message') }}",
                                            icon:'success',
                                            showConfirmButton: false
                                        });
                                        $("#modal-edit-group").css("opacity", "1");
                                        $("#groups-table").dataTable().fnReloadAjax();
                                        $(row).remove();
                                       
                                    }
                                });   
                            }
                        });
                    }
                    else {
                        var baseUrl = "{{ url('/') }}";
                        $("#error-msg-upload").html('{!!trans('contact_list.model.dependency_check.error_note')!!}'.replace(':group_name',g_text));
                        document.getElementById("old_id").value = inputId;
                        $("#modal-edit-group").css("opacity", "0.6");
                        $.get('/lists/groups/get_groups/' + inputId, function (response) {
                            return_select += "<option value=''>Select Group</option>"; 
                            for (var x = 0; x < response[0].length; x++) {
                                return_select += "<option value="+ response[0][x]['id'] +">"+ response[0][x]['name'] + "</option> " + response[0][x]['name'] + " </a></li>";
                                }
                                var selectContainer=document.getElementById("new_id");
                                selectContainer.innerHTML=return_select;
                         });
                        $("#modal-delete").modal("show");
                        for (var x = 0; x < data[0].length; x++) {
                            return_list += "<li><a target=\"_blank\" href=\"" + baseUrl + "/list/" + data[0][x]['id'] + "/edit\"><i class=\"fa fa-angle-double-right\"></i> " + data[0][x]['name'] + " </a></li>";

                        }
                        var listContainer = document.getElementById("get_users_list2");
                        listContainer.innerHTML = "<label class='col-form-label'>{{ trans('contact_list.model.dependency_check.groups_label') }}</label><ul class='no-list'>" + return_list + "</ul>";
                    }

                });

                $.get('/lists/groups/check/segments/' + inputId, function (data) {
                        if(data=='not_exists'){

                        }
                        else {
                            console.log(data);
                            var baseUrl = "{{ url('/') }}";
                            for (var x = 0; x < data[0].length; x++) {
                            return_list_segment += "<li><a target=\"_blank\" href=\"" + baseUrl + "/segment/edit/" + data[0][x]['id']+"\" ><i class=\"fa fa-angle-double-right\"></i> " + data[0][x]['name'] + " </a></li>";
                             }
                             var listSegmentContainer = document.getElementById("get_users_list_segment");
                             listSegmentContainer.innerHTML = "<label class='col-form-label'>Segmentation</label><ul class='no-list'>" + return_list_segment + "</ul>";
                        }
                        
                });
            });






            $("#close-dc").click(function() {
                $("#modal-edit-group").css("opacity", "1");
                $("#modal-delete").modal("hide");
            });

            $("#new_id").on("change", function() {
                var val = $(this).val();
                if(val != "") {
                    $("#deleteItem2").show();
                } else {
                    $("#deleteItem2").hide();
                }
            });

            $("#deleteItem2").click(function() {
                new_id = $('#new_id').val();
                old_id = $('#old_id').val();
                $('#new_id-error').html('').hide();
                $(".blockUI").show();
                $.ajax({
                    url: "{{ url('/') }}"+'/lists/groups/existing/delete/'+new_id+'/'+old_id,
                    type: "GET",
                    success: function(result) {
                        if(result == 'deleted') {
                            $(".blockUI").hide();
                            $("#modal-delete").modal("hide");
                            Command: toastr["success"] ("{{trans('user_management.view.success_confirmation.success_description')}}");
                            $("#modal-edit-group").css("opacity", "1");
                            setTimeout(() => {
                                location.reload();
                            }, 1000);
                        }
                    }
                });
            });

            $("body").on("click", "a.edit-group", function() {
                var label = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("label");
                var input = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("input");
                g_text = $(label).text();
                $(label).hide();
                $(input).show();
                $(this).hide();
                $(this).siblings("a.delete-group").hide();
                $(this).siblings("a.save-group").show();
                $(this).siblings("a.cancel-group").show();
            });

            $("body").on("click", "a.save-group", function() {
                var label = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("label");
                var input = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("input"); 
                var inputId = input.attr('id');
                var inputValue=input.val();
                var Updatelabel = $("label[id="+inputId+"]");
               
                $(".blockUI").show();
                $.ajax({
                    url: "{{  url('lists/updateListGroups') }}",
                    type: "POST",
                    data:{
                        group_id:inputId,
                        group_name:inputValue
                    },
                    success: function(result) {
                          Command: toastr["success"] ("{{ trans('contact_list.view.modal.saved.success_message') }}");
                        $(".blockUI").hide(); 
                        $(label).show();
                        $(input).hide();    
                    }
                });
                        $(this).siblings("a.cancel-group").hide();
                        $(this).siblings("a.edit-group").show();
                        $(this).siblings("a.delete-group").show();   
                        $(this).hide();
                       
                if (Updatelabel.length) {
                    Updatelabel.text(inputValue);
                }
              
            });
            $("body").on("click", "a.cancel-group", function() {
                var label = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("label");
                var input = $(this).parent().parent().parent("tr").children("td").children("div.labels").children("input");
                $(label).text(g_text);
                $(input).val(g_text);
                $(label).show();
                $(input).hide();
                $(this).hide();
                $(this).siblings("a.delete-group").show();
                $(this).siblings("a.save-group").hide();
                $(this).siblings("a.edit-group").show();
            });

            $("#btn-groups").click(function() {
                $("#modal-edit-group").modal("show");
            });

           

            $('.m-select2').select2({
                templateResult: function (data, container) {
                    if (data.element) {
                      $(container).addClass($(data.element).attr("class"));
                    }
                    return data.text;
                  }
            });

            $("#all_lists").click(function() {
                //$(".blockUI").show();
                setTimeout(function(){
                    $(".bullData").hide();
                    $(".treeView").show();
                    //$(".blockUI").hide();
                }, 1000);
            });

            // $(".optbulls").click(function(){
             
            // });

            $(".blockUI").hide();
             var rows=[];
             var requests=[];
            // function in master2 layout
            var page_limit=show_per_page('','list_pageLength',10);  // Params (table,page,default_limit=10)
            objTable = $('#lists').dataTable({
                "aoColumnDefs": [{"bSortable": false, "aTargets": [0,{{$client?6:7}}]}],
                "bProcessing": true,
                "bServerSide": true,
                "aaSorting": [[{{$client?5:6}}, "desc"]],
                "sPaginationType": "full_numbers",
                "sAjaxSource": "{{ url('/getLists') }}",
                 createdRow: function( row, data, dataIndex ) {
                    if(parseInt(data.DT_impr)==1){
                     var params=$('#lists').DataTable().ajax.params();
                     rows.push({rowIndex:dataIndex,params:params,list_id:data.DT_RowId.replace('row','')});
                    }
                },
                  "drawCallback": function( settings, json ) {

                    if(rows.length > 0 && requests.length<=0){
                       var list_ids=[];
                       $.each(rows,function(i,val){
                        list_ids.push(val.list_id);
                       });
                       var data=rows[0].params;
                           data.list_ids=list_ids;
                        request=$.ajax({
                            url: "{{ url('getLists') }}",
                            type: "GET",
                            data:data,
                            success: function(result) {
                                var data=JSON.parse(result);
                                var retry=0;
                               $.each(data.aaData,function(i,val){
                                for (var key in val) {
                                    if (val.hasOwnProperty(key) && key !="DT_RowId" && key !="DT_impr") {
                                         $('#'+val.DT_RowId).find('td').eq(key).html(val[key]);
                                    }
                                } 
                                    if(parseInt(val.DT_impr)==1 ){
                                        retry++;
                                    }

                                }); 
                               if(retry >0 ){
                                var $this=this;
                                setTimeout(function(){
                                  $.ajax($this);
                                },3000);
                               }
                            }
                        });
                        requests.push(request);
                    }
                  rows=[];
                },
                "fnServerParams": function (aoData) {
                aoData.push({"name": "record_type", "value": record_type});
                aoData.push({"name": "clients", "value": $("#clients").val()});
                aoData.push({"name": "admins", "value": $("#admins").val()});
                },
                "pageLength" : page_limit,
                "aLengthMenu": [[10,50, 100, 500], [10,50, 100, 500]]
            });

            page_limit=show_per_page(objTable,'list_pageLength');

             
           
            @if ($list_view == 'tree')
                $("#clients").change(function () {
                var clients=$("#clients :selected").map(function(i, el) {
                        return $(el).val();
                    }).get();
                var list=$('input.optbulls:checked').attr('id');
                $.ajax({
                    url: "{{  url('lists') }}/?list_view={{ $list_view }}&user_id="+clients+"&list="+list,
                    type: "GET",
                    data:{tree:1},
                    success: function(result) {
                        $("#list_tree").html(result);
                           treeTable();
                         
                    }
                });
            });
               
                @endif
            // split the contact list
            $("#frm-split-list").submit(function(){
                var form_data =  $("#frm-split-list").serialize();
                $.ajax({
                    url: "{{ URL::route('list.split') }}",
                    type: "POST",
                    data: form_data+'&confirm=0',
                    success: function(result) {
                        var obj = JSON.parse(result);
                        if (confirm(obj.msg) ) {
                            $("#split-processing").removeAttr("style", "display:none");
                            $.ajax({
                                url: "{{ URL::route('list.split') }}",
                                type: "POST",
                                data: 'confirm=1&list_id='+obj.list_id+'&contacts_per_list='+obj.contacts_per_list+'&no_of_lists='+obj.no_of_lists,
                                success: function(result) {
                                    $("#split-processing").attr("style", "display:none");
                                     window.location.href = "{{ route('list.index') }}";
                                }
                            });
                        }
                    }
                });
                return false;
            });
            // change the label on selecting split by option
            $('#split-by').on('change', function() {
                if (this.value == 'contacts') {
                    $('#label-input-split').html('{{trans('contact_list.table.actions.no_of_contacts_per_list')}}');
                } else {
                    $('#label-input-split').html('{{trans('contact_list.table.actions.no_of_contact_lists')}}');
                }
            });
        });
        // show deleting contact list modal
        function showDeleteModal(list_id,id) {
            if(id=="single"){
              $('#single').show();
              $('#double').hide();  
            }else{
               $('#single').hide();
               $('#double').show();  
            }
            
            list_id_to_delete = list_id;
            $('#soft_hard_delete_confirmation').modal('show');
        }


          // show deleting contact list modal
          function showDuplicateModal(list_id) {
             $("#duplicateListId").val(list_id);
            $('#duplicate_list_remove_modal').modal('show');
          }


          function hideDuplicateModal() {
              var delete_action = $("#duplicateSelection").val();
              var list_id_to_delete = $("#duplicateListId").val();
            $('#duplicate_list_remove_modal').modal('hide');
            duplicateList(list_id_to_delete, delete_action);
         }

          // delete list function
        function duplicateList(list_id, type=2) {
            $.post("{{ URL::route('list.duplicatelList') }}", {list_id, type},
                function(response){
                    if(response == 'success') {
                        Command: toastr["success"] ('{{trans('contact_list.view.task_background.message_background')}}');
                        
                    } else {
                        Command: toastr['error'] (response);
                    }
                }
            );
           
        }

        // delete list function
        $('#confirmDelete').live('click',function (){
            deleteList(list_id_to_delete, 3,'forcefully');
        });
        function deleteList(list_id, type=2,action=null) {
            $.ajax({
                type    : "post",
                url     : "{{ route('list.delList') }}",
                data    : {list_id, type,'action':action},
                beforeSend: function ()
                {
                    $(".blockUI").show();
                },
                success: function(response) {
                    $(".blockUI").hide();
                    $('#soft_hard_delete_confirmation').modal('hide');
                    if(response == 'success') {
                        Command: toastr["success"] ('{{trans('contact_list.view.delete_group_list.success_message')}}');
                        location.reload();
                    }
                    else
                    {
                        $("#modal-delete").modal('show');
                        $('#assignedAssets').html(response.content);
                        $("#itemToDelete").html('{!!trans('contact_list.view.delete_list.error_message')!!}');
                        $('#mdlTitle').html(response.mdl_title);
                    }
                }
            });
           
        }

        function hideDeleteModal(delete_action=2) {
           // $('#soft_hard_delete_confirmation').modal('hide');
            deleteList(list_id_to_delete, delete_action);
        }
        // expot contact lsit
        function stopExportList (list_id) {
            if(confirm('{{trans('contact_list.view.export.stop_confirmation_message')}}')) {             
                $.ajax({
                    url: "{{ url('/') }}"+'/list/cancelExport/'+list_id,
                    type: "GET",
                    dataType:'json',                
                    success: function(result) {
                        if(result.status == 'success') {
                            Command: toastr["success"] (result.message);    
                        } else {
                            Command: toastr['error'] (result.message);
                       }
                       location.reload();
                        
                    }
                });
            }
        }
        var retryExport = 0;
        function retryExportList (list_id) {
            if(retryExport==0){
                retryExport = 1;
                $.ajax({
                        url: "{{ url('/') }}"+'/list/retryExport/'+list_id,
                        type: "GET",
                        dataType:'json',                
                        success: function(result) {
                            if(result.status == 'success') {
                                Command: toastr["success"] (result.message);    
                            } else {
                                Command: toastr['error'] (result.message);
                           }
                           retryExport = 0;
                           location.reload();
                        }
                    });
            }    
        }
        function exportList (list_id,parent='no') {
        //   $("#modal-export-list").modal('show');
            Command: toastr["success"] ("{{trans('contact_list.table.actions.export_process_started')}}");
            $("#export-processing").removeAttr("style", "display:none");
            $.ajax({
                url: "{{ url('/') }}"+'/list/export/csv/'+list_id+"?parent="+parent,
                type: "GET",
                success: function(result) {
                    if(result=='permission_error'){
                         Command: toastr["error"] ("{{trans('common.message.temp_permission')}}");
                    }else{
                        location.reload();
                    }
                    
                }
            });
            ///location.reload();
        }
        // delete the the selected record
        function deleteAll () {
            if(!$('input:checkbox:checked').length){
            alert('{{trans('common.message.alert_no_record')}}');
            return false;
            }
            if(confirm('{{trans('common.message.alert_delete')}}')) {
                var lists = $('input:checkbox:checked').map(function() {
                    return this.value;
                }).get();
                $.ajax({
                    type    : "Delete",
                    url     : "{{ url('/') }}"+'/list/'+lists,
                    data    : {ids: lists},
                    success: function(result) {
                                if(result == 'delete') {
                                    Command: toastr["error"] ("{{trans('contact_list.view.delete_group_list.success_message')}}");
                                    window.location.href = "{{ url('/') }}"+"/list";
                                }
                            }
                });
            }
        }
// recount the subscriber 
$(document).on('click','#reCountListSubscribers',function(){
    var list_ids = [$(this).data('id')];
    reCountListSubscribers(list_ids);
});
// function for recount subscriber 
function reCountListSubscribers(list_ids){
      if(!list_ids.length){
            alert('{{trans('common.message.alert_no_record')}}');
            return false;
            }
                $.ajax({
                    type    : "POST",
                    url     : "{{ url('list/reCountListSubscribers') }}",
                    data    : {list_ids: list_ids},
                    beforeSend: function() {
                        $(".blockUI").show();
                    },
                    success: function(result) {
                                if(result.success) {
                                    Command: toastr["success"] ('{{trans('common.message.success_operation')}}');
                                    location.reload();
                                }else{
                                   Command: toastr["error"] (result.msg);  
                                }
                                $(".blockUI").hide();
                            },
                    error: function(error) {
                           Command: toastr["error"] ('{{trans('common.message.went_wrong')}}'); 
                           $(".blockUI").hide(); 
                    }
                });
}
  
        function verifylist(list_id) {
            $('#verify-status_'+list_id).html('{{trans('common.message.verifying')}}...');
            $.ajax({
                type    : "post",
                url     : "{{ url('/') }}"+'/list/validate',
                data    : {list_id: list_id},
                success: function(result) {
                }
            });
        }
        // show move list modal
        function moveList(id)
        {
            $('#list_id').val(id);
            $.ajax({
                url: "{{ url('/') }}"+'/list/move/'+id,
                type: "GET",
                success: function (data) {
                    $('#group-name').html(data);
                    $("#modal-move-list").modal('show');
                }
            });
        }
        // submit move list form
        $("#frm-move-list").submit(function() {
            var form_data =  $("#frm-move-list").serialize();
            $.ajax({
                url: "{{ url('/') }}"+'/list/group/update',
                type: "POST",
                data: form_data,
                success: function(result) {
                    window.parent.scrollTo(0,0);
                    if(result == 'success'){
                        $("#modal-move-list").modal('hide');
                        $('#error-msg').hide();
                        $('#msg').css("display", "flex");
                        $('#msg-text').html('{{trans('contact_list.view.move_list.success_message')}}');
                        $('#msg').removeClass('display-hide').addClass('alert alert-success ');
                        setTimeout(function(){
                            window.location.href = "{{ route('list.index') }}";
                            }, 1000);
                    } else if(result == 'error'){
                        $('#msg').hide();
                        $('#error-msg').css("display", "flex");
                        $('#error-msg').delay(3000).hide(1);
                        $('#error-text').html('{{trans('contact_list.view.move_list.exist_message')}}');
                        $('#error-msg').removeClass('display-hide').addClass('alert alert-danger  ');
                    }
                }
            });
            return false;
        });
        // show modal for merge list
        function mergeList(id)
        {
            $('#list-id').val(id);
            $.ajax({
                url: "{{ url('/') }}"+'/list/merge/'+id,
                type: "GET",
            //   data    : {type: 'get'},
                success: function (data) {
                    $('#list-name').html(data.list);
                    $("#modal-merge-list #list-id-select").html(data.all_lists);
                    $("#list-id-select").select2("destroy");
                    $("#list-id-select").select2({
                templateResult: function (data, container) {
                    if (data.element) {
                      $(container).addClass($(data.element).attr("class"));
                    }
                    return data.text;
                  }
            });
                    $("#modal-merge-list").modal('show');
                }
            });
        }
        // form submit for merge list
        $("#frm-merge-list").submit(function(){
            var form_data =  $("#frm-merge-list").serialize();
            
                if (confirm('{{trans('contact_list.view.merge_list.confirm_message')}}')) {
                    $("#merge-processing").removeAttr("style", "display:none");
                    $.ajax({
                        url: "{{ url('/') }}"+'/list/merge',
                        type: "POST",
                        data: form_data,
                        success: function(result) {
                            $("#merge-processing").attr("style", "display:none");
                            window.location.href = "{{ route('list.index') }}";
                        }
                    });
                }
            return false;
        });
        // function for copy list
        function copyList(id){

            $('#copy-listname').empty();
            $('#copy-list-id').val(id);
                $.ajax({
                    url: "{{ url('/') }}"+'/list/copy/'+id,
                    type: "GET",
                    data    : {type: 'get'},
                    success: function (result) {
                        if(result.status)
                        $('#copy-listname').html(result.response);
                        if(result.is_client) {
                            var html = '<span class="alert-text">{{trans('page_title.admin.on.client')}}: (<a href="javascript:;" target="_blank"><b>'+result.owner.name+'</b></a>, '+result.owner.id+')</span>';
                            $('#adminOnClient').empty();
                            $('#adminOnClient').html(html);
                            $('#adminOnClient').show();
                        }
                        else{
                            $('#adminOnClient').empty();
                            $('#adminOnClient').hide();
                        }
                    }
                });
        }
        // show and hide message on copy contact list modal
        $(".copy_contacts").click(function() {
            if($(this).val() == "Yes") { 
                $(".copyContacts").show();
            } else { 
                $(".copyContacts").hide();
            }
        });
        $("#btn-close").click(function(){
            window.location.href = "{{ route('list.index') }}";
        });
        // top bulk action function
        function bulkActions(){

            <?php  if ($list_view == 'list') { ?>

                if(!$('#lists tbody input:checkbox:checked').length){
                alert('{{trans('common.message.alert_no_record')}}');
                return false;
            }if($('#bulk_action option:selected').val() == ''){
                alert('{{trans('common.message.alert_no_action')}}');
                return false;
            }
            var type = $('#bulk_action option:selected').val();
            var lists = $('#lists tbody input:checkbox:checked').map(function() {
                    return this.value;
               }).get(); 
            <?php } else {  ?>
                if(!$('#example-datatable tbody input:checkbox:checked').length){
                    alert('{{trans('common.message.alert_no_record')}}');
                    return false;
                }if($('#bulk_action option:selected').val() == ''){
                    alert('{{trans('common.message.alert_no_action')}}');
                    return false;
                }
                var type = $('#bulk_action option:selected').val();
                var lists = $('#example-datatable tbody input:checkbox:checked').map(function() {
                        return this.value;
                }).get(); 
            <?php } ?>
        if(type=='export_list')
        {
            exportList(lists.join(','),'yes');
            return false;
        }
               
             if(type=='delete_list')
                {
                    showDeleteModal(lists,'double');
                }else {
                        if(confirm('{{trans("contact_list.view.delete_list.confirm_message")}} '+ $('#bulk_action option:selected').text() +' for {{trans('contact_list.view.delete_list.selected_lists')}}')) {

                            if(type=="reCountListSubscribers"){
                              reCountListSubscribers(lists);
                                return false;
                            }
                    
                            $.ajax({
                                type    : "GET",
                                url     : "{{ url('/') }}"+'/list/bulk/actions/'+lists,
                                data    : {ids: lists , action_type : type},
                                success: function(result) {
                                    if(result.status==false)
                                        Command: toastr["error"](result.message);
                                    else
                                        window.location.href = "{{ route('list.index') }}";
                                }
                            });
                    }

          }
           
        }
        // bottom bulk action function
        function bulkActions2()
        { 

             <?php  if ($list_view == 'list') { ?>

                if(!$('#lists tbody input:checkbox:checked').length){
                    alert('{{trans('common.message.alert_no_record')}}');
                    return false;
                }if($('#bulk_action2 option:selected').val() == ''){
                    alert('{{trans('common.message.alert_no_action')}}');
                    return false;
                }
                var lists = $('#lists tbody input:checkbox:checked').map(function() {return this.value;}).get();
                var type = $('#bulk_action2 option:selected').val();
            <?php } else {  ?>

                if(!$('#example-datatable tbody input:checkbox:checked').length){
                    alert('{{trans('common.message.alert_no_record')}}');
                    return false;
                }if($('#bulk_action2 option:selected').val() == ''){
                    alert('{{trans('common.message.alert_no_action')}}');
                    return false;
                }
                var lists = $('#example-datatable tbody input:checkbox:checked').map(function() {return this.value;}).get();
                var type = $('#bulk_action2 option:selected').val();
            <?php } ?>
             if(type=='export_list')
            {
                exportList(lists.join(','),'yes');
                return false;
            }

              if(type=='delete_list')
                {
                    showDeleteModal(lists,'double');
                   
                }
                else {
                    if(confirm('{{trans('contact_list.view.delete_list.confirm_message')}} '+ $('#bulk_action2 option:selected').text() +' for {{trans('contact_list.view.delete_list.selected_lists')}}')) {
                            $.ajax({
                                type    : "GET",
                                url     : "{{ url('/') }}"+'/list/bulk/actions/'+lists,
                                data    : {ids: lists , action_type : type},
                                success: function(result) {
                                    window.location.href = "{{ route('list.index') }}";
                                }
                            });
                        }
            }
        }

        function importSubscriberSummery(import_id, list_id, list_name) {

            $("#modal-import").modal("show");
            $("#progress-import").show();
            $("#list_name").html(list_name);
           

            $.ajax({
                type    : "GET",
                url     : "{{ url('/') }}"+'/list/import/summary',
                data    : {id: import_id},
                success: function(result) {
                    var obj = JSON.parse(result);
                    line_no = obj.line_no;
                    total_insert = parseInt(obj.total_insert);
                    duplicate_found = parseInt(obj.duplicate_found);
                    var overwritten = parseInt(obj.overwritten);
                    invalid_email = parseInt(obj.invalid_email);
                    total_records = obj.total_records;
                    user_id = obj.user_id;

                    if(line_no < total_records){
                         var imported = total_insert + duplicate_found + invalid_email+ overwritten;
                         var total_import = imported - duplicate_found - invalid_email - overwritten;
                         progress = Math.round((total_insert / total_records) * 100);
                        $(".progress-bar").width(progress + '%').html( progress + '%');
                        importSubscriberSummery(import_id, list_id);
                        $(".import-progress").html("{{trans('contacts.import.form.label.record_processed')}}: "+line_no);
                        $("#import-result").show();

                        $("#import-result").html("<table class='table table-striped table-hover table-checkable responsive mb0'>"+
                            "<tr><td>{{trans('common.import.normal.total_contacts')}}:</td><td>"+total_records+"</td></tr>"+
                            "<tr><td>{{trans('common.import.normal.imported_successfuly')}}:</td><td>"+total_insert+"</td></tr>"+
                            "<tr><td>{{trans('common.import.normal.duplicates')}}:</td><td>"+duplicate_found+"</td></tr>"+
                            "<tr><td>{{trans('common.import.normal.invalids')}}:</td><td>"+invalid_email+"</td></tr>"+
                            "<tr><td>{{trans('common.form.button.cancel')}}:</td><td>&nbsp;&nbsp; &nbsp;&nbsp;<a href='javascript:void(0)' onclick='cancelImport("+ import_id +",1,1)' class='btn btn-danger btn-xs'>{{trans('common.form.button.cancel')}}</a></td></tr>"+
                        "</table>");
                    }
                    else{
                        var style_duplicate_found=duplicate_found==0? "style='pointer-events:none;'":"";
                        var style_invalid_email= invalid_email==0 ? "style='pointer-events:none;'":"";
                        $(".progress-bar").width(100 + '%').html( 100 + '%');
                        $("#progress-import").hide();
                        $("#import-result").html("<table class='table table-striped table-hover table-checkable responsive mb0'>"+
                            "<tr><td>{{trans('common.import.normal.total_contacts')}}:</td><td>"+total_records+"</td></tr>"+
                            "<tr><td>{{trans('common.import.normal.imported_successfuly')}}:</td><td>"+total_insert+"</td></tr>"+
                            "<tr><td>{{trans('common.import.normal.duplicates')}}:</td><td>"+duplicate_found+"&nbsp;&nbsp;<a "+style_duplicate_found+" href='/downloadCSV?p=storage/users/" + user_id + "/files/imports/subscribers/" + import_id + "/"+import_id + "_duplicates_emails.csv' class='btn btn-info btn-xs pull-right'>{{trans('common.label.download')}}</a></td></tr>"+
                            "<tr><td>{{trans('common.import.normal.invalids')}}:</td><td>"+invalid_email+"&nbsp;&nbsp;<a "+style_invalid_email+" href='/downloadCSV?p=storage/users/" + user_id + "/files/imports/subscribers/" + import_id + "/"+import_id + "_invalid.csv' class='btn btn-info btn-xs pull-right'>{{trans('common.label.download')}}</a></td></tr>"+
                        "</table>");
                    } 
                }
            });
        }

            $("input[name='number_of_copies']").click(function () {
                if ($("#single-copy").is(":checked")) {
                    $("#copy-div").hide();
                } else {
                    $("#copy-div").show();
                }
            });
        // submit copy list form
        $("#frm-copy-list").submit(function(){
            var form_data =  $(this).serialize();
            $("#copy-processing").removeAttr("style", "display:none");
            $('#btn-copy').prop('disabled', true);

            $.ajax({
                url: "{{ url('/') }}"+'/list/copied',
                type: "POST",
                data: form_data,
                dataType: 'json',
                success: function(data) {
                    $('#copy_tbody').html('');
                    // if( parseInt(data.total_contacts) > 0)
                    if( false)
                    {
                        $('#mdl_header').show();
                        $('#frm-copy-list').hide();
                        $('#copy_table_div').slideDown('slow');
                        lists = data.lists;
                        contacts = data.total_contacts;
                        tr = '';
                        arr =[];
                        lists.forEach(function(obj) {
                            arr.push(obj.id);
                            progress = '<div class="progress progress-striped active" >\n' +
                                '<div id="progress_'+obj.id+'" class="progress-bar bg-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0%">0%</div>\n' +
                                '</div>';
                            tr += '<tr>';
                            tr += '<td>'+obj.name+'</td>';
                            tr += '<td id="contacts_'+obj.id+'">0/'+data.total_contacts+'</td>';
                            tr += '<td>'+progress+'</td>';
                            tr += '</tr>';
                        });
                        $('#copy_tbody').append(tr);
                        updateProgressBars(arr,contacts);
                    }
                    else {
                        if(data.status==false){
                            $('#btn-copy').prop('disabled', false);
                            $("#copy-processing").attr("style", "display:none");
                            Command: toastr["error"](data.message);
                        }
                        else {
                        $("#copy-processing").attr("style", "display:none");
                        Command: toastr["success"]("{{trans('contact_list.view.copy_list.success_message')}}");
                        setTimeout(function () {
                            window.location.href = "{{ route('list.index') }}";
                        }, 3000);
                        }
                    }

                },
                 error: function(data) {
                     $("#copy-processing").html('Error').show();
                     $('#btn-copy').prop('disabled', false);
                 }
            });
            return false;
        });

        function updateProgressBars(arr,contacts) {
            var new_arr = [];
            $.ajax({
                url: "{{ route('countContacts') }}",
                type: "POST",
                data: {'list_ids':arr,'contacts':contacts},
                dataType: 'json',
                success: function(data) {
                    if(data.result!==undefined)
                    {
                        data.result.forEach(function(obj) {
                        percent = obj.percent;
                        copied = obj.copied;
                        total = obj.total;
                        $('#progress_'+obj.id).css('width',percent+'%');
                        $('#progress_'+obj.id).text(percent+'%');
                        $('#contacts_'+obj.id).text(copied+'/'+total);
                        if(percent<100)
                            new_arr.push(obj.id);
                        else{

                        }
                        });
                        if(new_arr.length>0)
                            setTimeout(updateProgressBars(new_arr,contacts),1500)

                    }
                    else {
                    }

                }
            });
        }


        $(".m-select2").select2({
                templateResult: function (data, container) {
                    if (data.element) {
                      $(container).addClass($(data.element).attr("class"));
                    }
                    return data.text;
                  }
            });
        $("#user_records").click(function() {
            //$(".blockUI").show();
            $('#admin_lists').val('');
            setTimeout(function(){
                $(".bullData").show();
                $(".treeView").hide();
                $('#admin-list-filter').hide();
            }, 250);
            record_type = 'user_records';
            getTreeView(record_type,[]);

        });
        $("#our_records").click(function() {
            //$(".blockUI").show();
            $('#client_list').val('');
            setTimeout(function(){
                $(".bullData").hide();
                $(".treeView").show();
                $('#admin-list-filter').show();
            }, 250);
            record_type = 'our_records';
            getTreeView(record_type,[]);

        });


        $("#client_list").change(function(){
           var val = $('#client_list').val();
            getTreeView(record_type,[val]);

        });
        $("#admin_lists").change(function(){
            var val = $('#admin_lists').val();
            getTreeView(record_type,val);

        });

        function getTreeView(record_type,ids) {
            $.ajax({
                url: "{{route('getListTree')}}",
                type: "get",
                data: {'record_type':record_type,'ids':ids},
                dataType: 'json',
                beforeSend:function ()
                {
                    $(".blockUI").show();
                },
                success: function(data) {
                    $(".blockUI").hide();
                    if(data.status)
                    {
                        $('#list_tree').html(data.html);
                        setTimeout(function(){
                            treeTable();
                            },800)
                    }
                },error: function (jqXHR, exception) {
                    $(".blockUI").hide();
                   var msg = 'Uncaught Error.\n' + jqXHR.responseText;
                    Command: toastr["error"] (msg);
                }
            });
        }

    </script>
    @if ($list_view == 'list')
        @include('includes.view-pages-filter-script')
    @endif
@endsection

@section(decide_content())

<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="DNwqMndk">
    {{ Session::get('msg') }}
</div>
@endif
@if (Session::has('error-msg'))
    <div class="alert alert-danger" data-name="AVajLFdZ">
        {{ Session::get('error-msg') }}
    </div>
@endif
<div id="msg" class="display-hide" data-name="GSuZiCys">
    <button class="close" data-close="alert"></button>
    <span id='msg-text' class="alert-text"><span>
</div>
<div id="msg-del" class="display-hide" data-name="GfrNQjdQ">
    <button class="close" data-close="alert"></button>
    <span id='del-msg-text'><span>
</div>
@php
    $canDeleteList = routeAccess('list.delList');
    $canDeleteContact = routeAccess('contact.destroy');
    $canUpdateContact = routeAccess('contact.edit');
    $export_contacts = routeAccess('list.export');

@endphp
<div class="col-md-12" data-name="jAMaZmXZ">
    <div class="row" data-name="PagbBGMH">
        <div class="kt-portlet kt-portlet--height-fluid" data-name="SmTVHjeR">
            <div class="kt-portlet__body" data-name="WGoPpGbM">
                <div class="table-toolbar" data-name="MoSsbLPm">
                    <button type="submit" onclick="bulkActions();" class="btn btn-success flmrmb"> {{ trans('contact_list.table.actions.go') }} </button>
                    <div class="row flmrmb minw260" data-name="yLGDZhNn">
                        <select name="bulk_action" id="bulk_action" class="form-control m-select2" data-placeholder="{{trans('contact_list.table.actions.select')}}">
                            <option value="">{{trans('contact_list.table.actions.select')}}</option>
                             @if($canDeleteList)
                            <option value="delete_list">{{trans('contact_list.table.actions.delete_lists')}}</option>
                            @endif
                            <option value="reCountListSubscribers">{{trans('contact_list.table.actions.reCountListSubscribers')}}</option>
                            @if($export_contacts)
                            <option value="export_list">{{trans('contact_list.table.actions.export_to_csv')}}</option>
                            @endif
                            @if($canUpdateContact)
                            <option value="update_confirmed">{{trans('contact_list.table.actions.mark_confirm')}}</option>
                            <option value="update_unconfirmed">{{trans('contact_list.table.actions.mark_unconfirm')}}</option>
                            <option value="update_html">{{trans('contact_list.table.actions.receive_html')}}</option>
                            <option value="update_text">{{trans('contact_list.table.actions.receive_text')}}</option>
                            <option value="convert_soft_active">{{trans('contact_list.table.actions.mark_soft_bounce_active')}}</option>
                            <option value="convert_hard_active">{{trans('contact_list.table.actions.mark_hard_bounce_active')}}</option>
                            <option value="convert_unsubscribe_active">{{trans('contact_list.table.actions.mark_unsubscribed_active')}}</option>
                            <option value="update_status_active">{{trans('contact_list.table.actions.contacts_status_to_ctive')}}</option>
                            <option value="update_status_inactive">{{trans('contact_list.table.actions.contacts_status_to_inctive')}}</option>
                            @endif
                            @if($canDeleteContact)
                            <option value="delete_contacts">{{trans('contact_list.table.actions.delete_lists_contacts')}}</option>
                            <option value="delete_soft_bounce">{{trans('contact_list.table.actions.delete_soft_bounced_contacts')}}</option>
                            <option value="delete_hard_bounce">{{trans('contact_list.table.actions.delete_hard_bounced_contacts')}}</option>
                            <option value="delete_suppressed">{{trans('contact_list.table.actions.delete_suppressed_contacts')}}</option>
                            <option value="delete_unsubscribed">{{trans('contact_list.table.actions.delete_unsubscribed_contacts')}}</option>
                            @endif
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="row" data-name="sFTsPOnl">
    <div class="col-md-12" data-name="bOjPwjDU">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid" data-name="BFGKvGsN">
            <div class="kt-portlet__body" data-name="YdPwTWVn">
                <div class="table-toolbar" data-name="fUzYDAeg">
                    <div class="form-group row" data-name="DetMetjQ">
                        <div class="col-md-12" data-name="qVBrmdZX">
                            @if (routeAccess('list.create'))
                            <a href="{{route('list.create')}}">
                                <button id="sample_editable_1_new" class="btn btn-label-success">
                                    <i class="la la-plus"></i> {{trans('common.form.button.add_new')}}
                                </button>
                            </a>
                            @endif
                            <button id="btn-groups" class="btn btn-label-info">
                                {{trans('contact_list.view.button.groups')}}
                            </button>
                            <div class="pull-right" data-name="AjWCnWGd">
                               
                                <a href="{{route('list.index')}}?list_view=list" title="{{trans('contact_list.view.action.list_view')}}" class="btn btn-label-success btn-xs"> <li class="fa fa-list"></li>
                                </a>
                                &nbsp&nbsp
                                <a href="{{route('list.index')}}?list_view=tree" title="{{trans('contact_list.view.action.tree_view')}}" style="" class="btn btn-label-info btn-xs">
                                    <li class="fa fa-sitemap" style=""></li>
                                </a>
                             
                                &nbsp&nbsp
                            </div>
                        </div>

                    </div>

                    @if ($list_view == 'list')
                        @include('includes.view-pages-filter')
                    @endif
                </div>
                @if ($list_view == 'list')
                <table class="table table-striped table-hover table-checkable responsive" id="lists" role="grid" >
                    <thead>
                        <tr role="row">
                            <th style="width: 25px;">
                                <label class="kt-checkbox kt-checkbox--single kt-checkbox--all kt-checkbox--solid">
                                    <input type="checkbox" autocomplete="off" class="checkboxes checkbox-all-index" autocomplete="off">
                                    <span></span>
                                </label>
                            </th>
                            <th>{{trans('contact_list.view.table_heading.contact_list_name')}}</th>
                            <th>{{trans('contact_list.view.table_heading.group')}}</th>
                            <th>{{trans('contact_list.view.table_heading.subscribers')}}</th>
                            @if(!isClient(Auth::user()))
                                <th>{{trans('contact_list.view.table_heading.created_by')}}</th>
                            @endif
                            <th>{{trans('common.table_heading.last_activity')}}</th>
                            <!-- <th>Verify</th> -->
                            <th>{{trans('common.table_heading.created_on')}}</th>
                            <th>{{trans('common.table_heading.actions')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
                @else

                    @include('includes.list-tree-filter')
                    <table  id="example-datatable"  class="table table-striped table-hover table-checkable responsive tree">
                        <thead>
                            <tr>
                                <th width="20%">{{trans('contact_list.view.table_heading.contact_list_name')}}</th>
                                <th>{{trans('contact_list.view.table_heading.subscribers')}}</th>
                                @if(!isClient(Auth::user()))
                                    <th>{{trans('contact_list.view.table_heading.created_by')}}</th>
                                @endif
                                <th>{{trans('common.table_heading.created_on')}}</th>
                                <th>{{trans('common.table_heading.updated_on')}}</th>
                                <th class="text-left">{{trans('common.table_heading.actions')}}</th>
                            </tr>
                        </thead>
                        <tbody id="list_tree">
                        {!! $list_tree !!}
                        </tbody>
                    </table>
                @endif
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
 
<div class="col-md-12" data-name="WuWLUrPN">
    <div class="row" data-name="fQRcEDyQ">
        <div class="kt-portlet kt-portlet--height-fluid" data-name="aaNpJBiK">
            <div class="kt-portlet__body" data-name="yrninPME">
                <div class="row filter_bottom" data-name="FhVHsnmd">
                    <div class="col-md-4" data-name="xhbMOlIm">
                        <select name="bulk_action2" id="bulk_action2" class="form-control m-select2" data-placeholder="{{trans('contact_list.table.actions.select')}}">
                            <option value="">{{trans('contact_list.table.actions.select')}}</option>
                             @if($canDeleteList)
                            <option value="delete_list">{{trans('contact_list.table.actions.delete_lists')}}</option>
                            @endif
                            <option value="reCountListSubscribers">{{trans('contact_list.table.actions.reCountListSubscribers')}}</option>
                            @if($export_contacts)
                            <option value="export_list">{{trans('contact_list.table.actions.export_to_csv')}}</option>
                            @endif
                            @if($canUpdateContact)
                            <option value="update_confirmed">{{trans('contact_list.table.actions.mark_confirm')}}</option>
                            <option value="update_unconfirmed">{{trans('contact_list.table.actions.mark_unconfirm')}}</option>
                            <option value="update_html">{{trans('contact_list.table.actions.receive_html')}}</option>
                            <option value="update_text">{{trans('contact_list.table.actions.receive_text')}}</option>
                            <option value="convert_soft_active">{{trans('contact_list.table.actions.mark_soft_bounce_active')}}</option>
                            <option value="convert_hard_active">{{trans('contact_list.table.actions.mark_hard_bounce_active')}}</option>
                            <option value="convert_unsubscribe_active">{{trans('contact_list.table.actions.mark_unsubscribed_active')}}</option>
                            <option value="update_status_active">{{trans('contact_list.table.actions.contacts_status_to_ctive')}}</option>
                            <option value="update_status_inactive">{{trans('contact_list.table.actions.contacts_status_to_inctive')}}</option>
                            @endif
                            @if($canDeleteContact)
                            <option value="delete_contacts">{{trans('contact_list.table.actions.delete_lists_contacts')}}</option>
                            <option value="delete_soft_bounce">{{trans('contact_list.table.actions.delete_soft_bounced_contacts')}}</option>
                            <option value="delete_hard_bounce">{{trans('contact_list.table.actions.delete_hard_bounced_contacts')}}</option>
                            <option value="delete_suppressed">{{trans('contact_list.table.actions.delete_suppressed_contacts')}}</option>
                            <option value="delete_unsubscribed">{{trans('contact_list.table.actions.delete_unsubscribed_contacts')}}</option>
                            @endif
                        </select>
                    </div>
                    <button type="submit" onclick="bulkActions2();"  class="btn btn-success flmrmb"> {{ trans('contact_list.table.actions.go') }} </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- split list modal -->
<div id="modal-edit-group" class="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="FZmAJhxs">
    <div class="modal-dialog modal-dialog-centered modal-lg" data-name="txROtNUd">
        <div class="modal-content" data-name="Ilhgirfe">
            <div class="modal-header" data-name="mVcKlhTd">
                <h5 class="modal-title">{{ trans('contact_list.view.modal_heading.view-edit-group') }} <small>({{ trans('contact_list.view.modal_heading.edit-group-lists') }})</small></h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div class="modal-body" data-name="MMfNJLAx">
                <table class="table table-striped table-hover table-checkable responsive" id="groups-table">
                    <thead>
                        <tr>
                            <th width="30%">{{ trans('contact_list.view.modal.table_heading.group_name') }}</th>
                            <th width="20%">{{ trans('contact_list.view.modal.table_heading.added_by') }}</th>
                            <th width="20%">{{ trans('common.table_heading.created_on') }}</th>
                            <th width="20%">{{ trans('contact_list.view.modal.table_heading.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                       
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- split list modal -->


<!-- split list modal -->
<div id="modal-split-list" class="modal" tabindex="-1" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="FZmAJhxs">
    <div class="modal-dialog" data-name="txROtNUd">
        <div class="modal-content" data-name="Ilhgirfe">
            <div class="modal-header" data-name="mVcKlhTd">
                <h5 class="modal-title">{{trans('contact_list.view.modal_heading.split_list')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div class="modal-body" data-name="MMfNJLAx">
            <form action="" id="frm-split-list" method="post" class="kt-form kt-form--label-right" autocomplete="off">
                <input type="hidden" name="split_list_id" id="split_list_id" value="" >
                <div id='split-processing' style='display:none;' data-name="veMQCLNk">
                    <h4 class="process-block text-info"><i class='la la-gear fa-spin'></i> {{trans('contact_list.view.modal.split_list.label_processing')}}...</h4>
                    <div class="alert alert-info" data-name="HeWtYbSL">{{trans('contact_list.view.modal.split_list.alert_processing_message')}}</div>
                </div>
                <div class="form-group row" data-name="fSPTFNEd">
                    <label class="col-md-3 col-form-label" >
                        {{trans('contact_list.view.modal.split_list.label_split_by')}}
                    </label>
                    </label>
                    <div class="col-md-7" data-name="IJRbuaLO">
                        <select class="form-control select" name="split_by" id="split-by">
                            <option value="contacts">
                                {{trans('contact_list.table.actions.no_of_contacts_per_list')}}
                            </option>
                            <option value="lists">
                                {{trans('contact_list.table.actions.no_of_contact_lists')}}
                            </option>
                        </select>
                    </div>
                </div>
                <div class="form-group row" data-name="UJcJFpRk">
                    <label class="col-md-3 col-form-label" id="label-input-split" >
                        {{trans('contact_list.table.actions.no_of_contacts_per_list')}}
                    </label>
                    <div class="col-md-7" data-name="USsZxQXJ">
                        <input type="text"  name="no_of_contacts" class="form-control" required>
                    </div>
                </div>
                <div class="form-actions" data-name="GQOcMJSe">
                    <div class="row" data-name="nRTdOsCM">
                        <div class="offset-md-3 col-md-7" data-name="VdNxexOo">
                            <button type="submit" class="btn btn-success">{{trans('common.form.button.submit')}}</button>
                            <button type="reset" class="btn btn-default">
                                {{trans('common.form.button.reset')}}
                            </button>
                        </div>
                    </div>
                </div>
            </form>
            </div>
        </div>
    </div>
</div>
<!-- split list modal -->

<!-- move list modal -->
<div id="modal-move-list" class="modal" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="FBZgnFKT">
    <div class="modal-dialog" data-name="fHFGPouW">
        <div class="modal-content" data-name="boaONCzu">
            <div class="modal-header" data-name="pBZcnjYd">
                <h5 class="modal-title">{{trans('contact_list.view.modal_heading.move-list')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div id="error-msg" class="display-hide" data-name="oWonXFVZ">
                <span id='error-text' class="alert-text"><span>
            </div>
            <div class="modal-body" data-name="SrNRegLA">
                <form action="" id="frm-move-list" method="post" class="kt-form kt-form--label-right" autocomplete="off">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <input type="hidden" name="list_id" id="list_id" value="" >
                    <div class="group-name" id="group-name" data-name="njxLhyGX"></div>
                    <div class="form-group row" data-name="SRaZgeQw">
                        <label class="col-form-label col-md-3">{{trans('contact_list.view.modal.move-list.label_choose_group')}}
                        </label>
                        <div class="col-md-7" data-name="EGNIcWUf">
                            <select class="form-control m-select2" name="group_id" id="group-id" required="">
                                <option value="">{{trans('contact_list.view.modal.move-list.label_choose_group')}}</option>
                                @foreach($groups as $group)
                                    <option value="{{ $group->id }}">
                                    {{ $group->name  }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-actions" data-name="RaJvakaL">
                        <div class="row" data-name="EpyjvPvr">
                            <div class="offset-md-3 col-md-7" data-name="ZEGmokSG">
                                <button type="submit" class="btn btn-success">{{trans('common.form.button.submit')}}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- move list modal -->

<!-- merge list modal -->
<div id="modal-merge-list" class="modal" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="ArDlLbut">
    <div class="modal-dialog" data-name="byPhNGNN">
        <div class="modal-content" data-name="EvonaPNT">
            <div class="modal-header" data-name="mWIOevMu">
                <h5 class="modal-title">{{trans('contact_list.view.modal_heading.merge_list')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div class="modal-body" data-name="cnTqQsqz">
            <form action="" id="frm-merge-list" method="post" class="kt-form kt-form--label-right" autocomplete="off">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <input type="hidden" name="list_id" id="list-id" value="" >
                <div id='merge-processing' style='display:none;' data-name="TgFWhhtZ">
                    <h4 class="text-center text-info"><i class='la la-gear fa-spin'></i> {{trans('contact_list.view.modal.split_list.label_processing')}}...</h4>
                    <div class="alert alert-info" data-name="rxFvsPki">{{trans('contact_list.view.modal.split_list.alert_processing_message')}}</div>
                </div>
                <div class="list-name" id="list-name" data-name="hhsGqkYl"></div>
                <div class="form-group row" data-name="fUteYuNo">
                    <label class="col-form-label col-md-3">{{trans('contact_list.view.modal.merge_list.label_merge_into')}}
                    </label>
                    <div class="col-md-7" data-name="BxOxjGbj">
                        <select class="form-control m-select2" name="merge_to_list" id="list-id-select" required="">
                           
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                       
                        <label class="col-form-label col-md-3">{{trans('contact_list.view.modal.merge_list.label_duplicate_found')}}</label>
                        <div class="col-md-7" data-name="BxOxjGbj">
                        <select id="links-clicked" class="form-control" name="copy_duplication" aria-invalid="false">
                                <option value="1">{{trans('contact_list.model.merge_list.option_skip_duplicate')}}</option>
                                <option value="2">{{trans('contact_list.model.merge_list.option_keep_existing')}}</option>
                            </select>
                        </div>
                       
                    </div>
                <div class="form-actions" data-name="kNQAGnIa">
                    <div class="row" data-name="dGiEtuTa">
                        <div class="offset-md-3 col-md-7" data-name="txvMUihB">
                            <button type="submit" class="btn btn-success">{{trans('common.form.button.submit')}}</button>
                        </div>
                    </div>
                </div>
            </form>
            </div>
        </div>
    </div>
</div>
<!-- merge list modal -->

<!-- copy list modal -->
<div id="modal-copy-list" class="modal" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="srQDBgDP">
    <div class="modal-dialog" data-name="pXpaTeiZ">
        <div class="modal-content" data-name="kJAuErbW">
            <div id="mdl_header" class="modal-header" style="display: none;" data-name="ylwQenuh">
                <h5 class="modal-title">{{trans('contact_list.view.modal.copy-list.progress')}}</h5>
            </div>
            <div class="modal-body" data-name="JrAzWCpD">
                <div id="adminOnClient" class="alert alert-warning" style="display: none;" data-name="kveOWAxe">

                </div>
                <form action="" id="frm-copy-list" method="post" class="kt-form kt-form--label-right" autocomplete="off">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <input type="hidden" name="list_id" id="copy-list-id" value="" >

                    <h4 id='copy-processing' class="kt-font-info text-center" style='display:none;'>
                        <i class='la la-gear fa-spin'></i> {{trans('contact_list.view.modal.copy-list.label_copying')}}...
                        {{--<div class="text-danger offset-md-4" data-name="FeWszXEA">{{trans('contact_list.view.modal.copy-list.stop_copying')}}</div>--}}
                    </h4>

                    <div class="row" data-name="zkIVZUCl">
                        <div class="col-md-12" data-name="lNpTqTDY">
                            <div class="copy-listname" id="copy-listname" data-name="tIUQpOSW"></div>
                            <div class="alert alert-warning copyContacts" style="display:none" data-name="uuyInzJW">
                                {{trans('contact_list.view.modal.copy-list.alert_copy_contacts')}}
                            </div>
                            <div class="form-group row mb1" id="copy-div" data-name="njUzuXpw">
                                <label class="col-form-label col-md-4">{{trans('contact_list.view.modal.copy-list.label_no_of_copies')}}</label>
                                <div class="col-md-7" data-name="liwfkKtK">
                                    <select class="form-control" name="copies_number">
                                        @for ($i = 1; $i <=30; $i++)
                                            <option value="{{$i}}">{{$i}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row mb1" id="copy-div" data-name="hwCIdqyS">
                                <label class="col-form-label col-md-4">{{trans('contact_list.view.modal.copy-list.label_copy_contacts')}}</label>
                                <div class="col-md-7" data-name="FcSjlYLu">
                                    <div class="kt-radio-inline" data-name="kSVgPyho">
                                        <label class="kt-radio">
                                            <input class="copy_contacts" type="radio" autocomplete="off" name="copy_contacts" value="Yes"> {{trans('common.form.button.yes')}}
                                            <span></span>
                                        </label>
                                        <label class="kt-radio">
                                            <input class="copy_contacts" type="radio" autocomplete="off" name="copy_contacts" checked value="No"> {{trans('common.form.button.no')}}
                                            <span></span>
                                        </label>

                                    </div>
                                </div>
                            </div>

                            <div class="row" data-name="aUtEPuFf">
                                <div class="offset-md-4 col-md-8" data-name="ISKopzhu">
                                    <button type="submit" class="btn btn-success" id="btn-copy">{{trans('common.form.button.copy')}}</button>
                                    <button type="button" id="btn-close" class="btn btn-default" data-dismiss="modal">{{trans('common.form.button.close')}}</button>
                                </div>
                            </div>

                            <div id="copy_table_div" style="display: none;" data-name="JMxlHZCr">
                                <span style="display: none;"  class="spinner spinner_2"><i class="fa fa-spinner fa-spin"></i></span>
                                <div style="display: none;"   class="alert_msg alert alert-danger" data-name="RwmfFGCH"></div>
                                <div id="consResult"  class="form-group scroll scroll-300" data-name="aMVSpFhR">
                                    <table class="table table-striped table-bordered" id="copy_table">
                                        <thead>
                                        <tr>
                                            <th>List Name</th>
                                            <th>Contacts</th>
                                            <th>Progress</th>
                                        </tr>
                                        </thead>
                                        <tbody id="copy_tbody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- copy list modal -->

<div id="modal-import" class="modal" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="SJIRZqJP">
    <div class="modal-dialog" data-name="QxnievMS">
        <div class="modal-content" data-name="msNRJTxw">
            <div class="modal-header" data-name="GnfxAXKe">
                <h5 class="modal-title">{{trans('contact_list.view.modal_heading.import_history')}}</h5>
                <button type="button" class="close"  onclick="location.reload()" aria-hidden="true"></button>
            </div>
            <div class="modal-body" data-name="szNygNcN">
                <div id="progress-import" data-name="CpsLmXVL">
                    <div class="la la-asterisk fa-spin fa-2x kt-font-success" id="ajax-spinner" data-name="XUmpNqQW"></div>
                    <div id="ajax-spinner-text" data-name="kZWHUHJc">                                         {{trans('contact_list.view.modal.import_history.label_importing')}}... 
                        <strong><span id="list_name"></span></strong>
                    </div>
                    <div class="progress progress-striped" data-name="xZLkqCDm" >
                        <div class="progress-bar bg-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0%" data-name="ZEtbSqBc">0%</div>
                    </div>
                    <div class="import-progress" data-name="ynqTsjVx"></div>
                </div>
                <div id="import-result" data-name="qTjJavdH">

                </div>
            </div>
        </div>
    </div>
</div>

<!-- delete confirmation modal -->
<div id="soft_hard_delete_confirmation" class="modal" tabindex="-1" role="dialog" data-name="uAJPTpuN">
  <div class="modal-dialog" role="document" data-name="aKxgkNIr">
    <div class="modal-content" data-name="omRMNNUz">
      <div class="modal-header" data-name="HjfXTwol">
        <h5 class="modal-title"> {{trans('common.form.button.delete')}}</h5>
        <!-- <h5 class="modal-title"> {{trans('user_management.view.modal_heading.delete_confirmation')}}</h5> -->
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        </button>
      </div>
      <div class="modal-body" data-name="XTsosyvH">
        <!-- <p> {{trans('user_management.view.modal_heading.delete_confirmation')}}?.</p> -->
        <div style="display: none;" id="single" class="alert alert-danger" data-name="HKtChiuO"><span class="alert-text">{{trans('contact_list.view.modal.alert_message.delete_list')}}</span></div>
        <div style="display: none;" id="double" class="alert alert-danger" data-name="ptMRygnz"><span class="alert-text">{{trans('contact_list.view.modal.alert_message.delete_selected_list')}}</span></div>
        <!-- <div id="double" class="alert alert-danger"><span class="alert-text">@lang('contact_list.contact_lists.message.soft_or_hard_delete')</span></div> -->
      </div>
      <div class="modal-footer" data-name="hRFgLVDG">
        <!-- <button type="button" onclick="hideDeleteModal(2)" class="btn btn-info">{{trans('user_management.modal.button.soft_delete')}}</button> -->
        <button type="button" onclick="hideDeleteModal(3)" class="btn btn-danger">{{trans('common.form.button.delete')}}</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('common.form.button.cancel')}}</button>
      </div>
    </div>
  </div>
</div>
<!-- delete confirmation modal -->


<!-- delete confirmation modal -->
<div id="duplicate_list_remove_modal" class="modal" tabindex="-1" role="dialog" data-name="EgczDZGa">
  <div class="modal-dialog" role="document" data-name="Jbjeyqya">
    <div class="modal-content" data-name="YoEMKaOl">
      <div class="modal-header" data-name="zXhKvfvT">
        <h5 class="modal-title"> {{trans('contact_list.view.modal_heading.dedupe_contact')}}</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        </button>
      </div>
      <div class="modal-body" data-name="EVTuTJpC">
        <p> {{trans('contact_list.view.modal.label.contact_list')}}</p>
        <select id="duplicateSelection" class="form-control">
        
            <option value="2">{{trans('contact_list.view.modal.duplicate_list.option_all_contacts')}}</option>
            <option value="1">{{trans('contact_list.view.modal.duplicate_list.option_selected_contacts')}}</option>
        </select> 
      </div>
      <input type="hidden" value="" id="duplicateListId">
      <div class="modal-footer" data-name="RYsAweko">
        <button type="button" onclick="hideDuplicateModal()" class="btn btn-info">{{trans('contact_list.view.modal.button.lists_dedupe')}}</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{trans('common.form.button.cancel')}}</button>
      </div>
    </div>
  </div>
</div>
<!-- delete confirmation modal -->

<div id="modal-export-list" class="modal" role="dialog" aria-hidden="true" data-backdrop="static" data-keyboard="false" data-name="LmgXhnJJ">
    <i class="la la-spinner fa-spin fa-5x"></i> 
</div>

<div id="modal-list" class="modal" role="dialog" aria-hidden="true" style="display: none" data-name="MRzVuMhm">
    <div class="modal-dialog" style="width: 600px;" data-name="EIjPkZrR">
        <div class="modal-content" data-name="HsihRfTe">
            <div class="modal-header" data-name="rqnchfSj">
                <h5 class="modal-title">{{trans('contact_list.view.modal_heading.all_lists')}} 
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            </div>
            <div class="modal-body" data-name="KdANTqlh">
                <div class="row" data-name="tBJRSehz">
                    <div class="col-md-12" data-name="JWgWeezR">
                        <span class="alert alert-danger" id="listToDel"></span>
                    </div>
                </div>
                <div class="row" data-name="SDfogEZY">
                    <div class="col-md-12" data-name="ggfMthjy">
                        <div id="listData" data-name="yqslGUQd"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="modal-delete" class="modal fade " tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" data-keyboard="false" data-backdrop="static" aria-modal="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">{{trans('contact_list.view.modal_heading.dependency_check')}}</h5>
      </div>
      <form id="form-import" action="#" method="POST" autocomplete="off">
        <div class="modal-body">
          <!-- <div class="alert alert-warning" id="error-msg">
            <span class="alert-text" id="error-msg-upload">
                
            </span>
          </div> -->
          <div class="row" data-name="igUKVYRO">
            <div class="col-md-12" data-name="jFQSGZuo">
              <div id="domain-data" data-name="oyaHdXQR">
                <div class="list-block" data-name="bDplkoVS">
                  <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">
                    <div class="col-md-12" data-name="ZKtDemZp">
                      
                      <div id="get_users_list2">
                        Groups
                      </div>
                      <div id="get_users_list_segment">
                      
                      </div>
                    </div>
                  </div>
                  <div id="unassignedAssets" style="display: none;" class="row" data-name="dhlPjruh">
                    <div class="col-md-12" data-name="jyMxdqfv">
                      <label class="col-form-label" id="moveToLabel"></label>
                      <div class="form-group mb0" data-name="hnTUjGZs">
                        <small id="new_id-error" class="error invalid-feedback"></small>
                        <input type="text" id="old_id" name="old_id" hidden>
                        <select name="new_id" class="form-control m-select2" data-placeholder="Select Package" id="new_id">
                        
                        </select>
                      </div>
                      <small id="sm">{{ trans('contact_list.model.dependency_check.group_select_help')}}</small>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer" data-name="lCYRZcBU">
          <button type="button" class="btn btn-secondary btn-sm pull-left" id="close-dc">{{ trans('common.form.button.close') }}</button>
          <button type="button" style="display:none" class="btn btn-primary btn-sm pull-right" id="deleteItem2">{{ trans('common.delete_assets_modal_blade.button_assign_delete') }}</button>
        </div>
      </form>
    </div>
  </div>
</div>

    @include('common.deleteAssetsModal')
@endsection