@extends('layouts.master2')

@section('title', $page_data['title'])

@section('page_styles')
<link href="/resources/assets/css/dynamic-content-tags-create.css?v={{time()}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<link href="/themes/default/css/bootstrap-timepicker.css" rel="stylesheet" type="text/css" />
<link href="/resources/assets/css/profile.css?v={{time()}}" rel="stylesheet" type="text/css">
<style>.kt-portlet__foot a.btn {margin-right: 1px;}.kt-portlet .kt-portlet__foot {padding: 25px!important;margin-top: 0;} .form-group.row .kt-switch.mt--5{margin-top: 7px !important; height: 33px;} span.plimit {position: absolute; width: calc(100% - 80px);margin-left: 5px;display: none;} #evergreen-campaign {display:none;margin-bottom: 25px;}.filter-block {  padding: 10px 30px 20px; background: #ecf3ff; border: 1px solid #e1ecff; border-bottom: 0;}</style>
@endsection

@section('content')
    <script src="/js/libs/ckeditor/ckeditor.js"></script>
    <script src="/js/libs/ckeditor/plugins/font/plugin.js"></script>
    <script src="/js/libs/ckeditor/plugins/colorbutton/plugin.js"></script>
    <script src="/js/libs/ckeditor/plugins/zsuploader/plugin.js"></script>
    <script src="/js/libs/ckeditor/plugins/smiley/plugin.js"></script>
    <script src="/js/libs/ckfinder/ckfinder.js"></script>

    @if($errors->any())
        <!-- For PHP validations errors-->
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        </div>
    @endif
    <!-- will be used to show any messages -->
    @if (Session::has('msg'))
        <div class="alert alert-success">
            {{ Session::get('msg') }}
        </div>
    @endif
    <div id="content_js" style="display: none"></div>
    <!-- will be used to show any messages about form -->
    <div id="msg" class="display-hide">
    <span id='msg-text'><span>
    </div>
    <!-- BEGIN FORM-->
    <div class="col-md-6 create-form">
        <form method="POST" id="dynamic-content-frm" class="kt-form kt-form--label-right" novalidate="novalidate" autocomplete="off">
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <input type="hidden" id="dynamic_tag_id" value="{{isset($dynamic_content) && !isset($action) ? $dynamic_content->id:'0'}}">
            <div class="row">
                <div class="kt-portlet kt-portlet--height-fluid">
                    <div class="kt-portlet__head">
                        <div class="kt-portlet__head-label">
                            <h3 class="kt-portlet__head-title">{{isset($dynamic_content) ? trans('dynamic_tags.form_heading.edit_rule') :trans('dynamic_tags.form_heading.add_rule')}}</h3>
                        </div>
                    </div>
                    <div class="kt-portlet__body">
                        <div class="form-body">
                            <!-- Name -->
                            @if(isset($getTemps) &&  $getTemps && routeAccess('dynamictag.clone'))
                                <a href="javascript:;" class="btn-template"  id="btn-templates">
                                    {{trans('spintag.add.button.pre_define_template')}} <i class="la la-angle-right"></i>
                                </a>
                                <div class="form-group row mb0" id="templates-blk" data-name="oRssRNWB">
                                    <div class="col-md-12" data-name="zPiJOnvC">
                                        <div class="kt-portlet kt-portlet--bordered" data-name="pJODGrH5" id="run-migrate-block" style="display: block;">
                                            <div class="kt-portlet__head" data-name="qTHZIBmc">
                                                <div class="kt-portlet__head-label" data-name="ATccxBNh">
                                                    <h3 class="kt-portlet__head-title" style="">{{ trans("spintag.add.box_title") }}</h3>
                                                </div>
                                                <div class="kt-portlet__head-label">
                                                    <div class="search-pblock">
                                                        <input type="text" class="form-control" name="searchp" id="searchp">
                                                        <button type="button" class="btn btn-secondary btn-sm" id="btn-searchp">
                                                            <i class="fa fa-search"></i>
                                                        </button>
                                                        <button type="button" class="btn btn-secondary btn-sm" id="btn-searchp2">
                                                            <i class="fa fa-times"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="kt-portlet__body" data-name="vztGIoPd">
                                                <div class="temp-head">
                                                    <div class="tags">{{trans('spintag.form.name')}}</div>
                                                    <div class="desc">{{trans('spintag.form.description')}}</div>
                                                    <div class="acts">{{trans('common.table_heading.actions')}}</div>
                                                </div>
                                                <div class="temp-blk scroll">
                                                    @foreach($templates as $template)
                                                    <div class="temp-row">
                                                        <div class="tags">{{$template->label}}</div>
                                                        <div class="desc">{{$template->description==null?'---':$template->description}}</div>
                                                        <div class="acts">
                                                            <a href="{{route('dynamictag.clone',['id'=>$template->id])}}" class="btn btn-info btn-sm btn-clone" type="button">Use This</a>
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="col-form-label">{{trans('dynamic_tags.form.label.name')}}
                                        {!! popover( 'dynamic_tags.form.label.name_description','common.description' ) !!}
                                    </label>
                                    <div class="input-icon right mt0">
                                        <input type="text" id="tag_name"  name="content_name" {{isset($dynamic_content->name) && !isset($action) ? "disabled" : '' }} value="{{isset($dynamic_content) ? $dynamic_content->name : '' }}" class="form-control"/>
                                        <small>{{trans('dynamic_tags.form.label.name_help_bottom')}}</small>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <div class="kt-radio-inline">
                                        <label  class="kt-radio">
                                            <input  @if($return_content=='return_single_content') checked @endif type="radio" autocomplete="off" name="return_content" value="return_single_content" >
                                            {{trans('dynamic_tags.form.model.radio_option.return_content_single')}}
                                            <span></span>
                                        </label>
                                        <label class="kt-radio">
                                            <input @if($return_content=='return_all_content') checked @endif  type="radio" autocomplete="off" name="return_content" value="return_all_content" >
                                            {{trans('dynamic_tags.form.model.radio_option.return_content_all')}}
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <!-- Name -->

                            <!-- Unit Rules -->
                            {{--row 1--}}

                            <!-- Unit Rules -->
                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="col-form-label">
                                        {{trans('dynamic_tags.form.model.label.if_criteria_met')}}
                                        {!! popover( 'dynamic_tags.form.model.label.if_criteria_met_description','common.description' ) !!}
                                    </label>
                                    <label class="col-form-label text-right pull-right" >
                                        <a href="javascript:;" onclick="displayModal()">[+] {{trans('dynamic_tags.form.link.add_unit')}} </a>
                                    </label>
                                    <div class="input-icon right">
                                        <div class="form-control scroll scroll-365" style="height:370px" name="content_rules"
                                             id="content_rules">
                                            <ul class="" id="sortable">
                                                {!! isset($str) ? $str : '' !!}
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-md-12">
                                    <label class="col-form-label">
                                        {{trans('dynamic_tags.add.descriptions')}}
                                        <span class="required">  </span>
                                    </label>
                                    <div class="input-icon right mt0">
                                        <input type="text" id="description"  name="description"  value="{{isset($dynamic_content) ? $dynamic_content->description : '' }}" class="form-control"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="kt-portlet__foot">
                       <!-- submit -->
                       <a href="javascript:;" onclick="testing()" class="btn btn-success">{{trans('common.form.button.save')}}</a>
                        <!-- reset -->
                        <a href="/dynamictags" class="btn btn-default">{{trans('common.form.button.cancel')}}</a>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <div class="modal fade" id="kt_modal_4" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{trans('dynamic_tags.add.form_heading')}}</h5>
                </div>
                <div class="modal-body scroll scroll-600">
                    <form id="add_rule_form" autocomplete="off">
                        <div class="form-group first-row">
                            <label for="rule_name" class="col-form-label">{{trans('dynamic_tags.modal.widget_heading')}}</label>
                            <input type="text" class="form-control" id="rule_name" name="rule_name">
                        </div>
                        <span class="repeater-popup-block" >
                            <div class="form-group row mb0" id="row_1">
                                <div class="col-md-12">
                                    <label class="col-form-label">{{trans('dynamic_tags.form.model.label.unit_rules')}}
                                        {!! popover( 'dynamic_tags.form.model.label.unit_rules_description','common.description' ) !!}
                                    </label>
                                    <div data-repeater-list="unit_rules">
                                        <div class="mt-repeater">
                                            <div data-repeater-item>
                                                <div data-repeater-item="" class="mt-repeater-item">
                                                    <div class="row mt-repeater-item" id="rep">
                                                        <div class="col-md-3">
                                                            <select id="select_field_1"
                                                                    class="form-control m-select2 select" name="field[]"
                                                                    data-placeholder="{{ trans('dynamic_tags.form.model.filter_placeholder.select_an_option') }}">
                                                                <optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_recipient')}}">
                                                                    <option value="custom_fields">{{ trans('dynamic_tags.form.model.filter_option.opt_profile') }}</option>
                                                                    <option value="email">{{ trans('common.label.email_address') }}</option>
                                                                    <option value="member_of">{{ trans('dynamic_tags.form.model.filter_option.opt_member_of') }}</option>
                                                                    <option value="confirmation">{{ trans('dynamic_tags.form.model.filter_option.opt_confirmation') }}</option>
                                                                    <option value="created_at">{{ trans('dynamic_tags.form.model.filter_option.opt_created_at') }}</option>
                                                                    <option value="list_name">{{ trans('dynamic_tags.form.model.filter_option.opt_list_name') }}</option>
                                                                </optgroup>
                                                                  <optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_time_date')}}">
                                                                      <option value="now">{{ trans('dynamic_tags.form.model.filter_option.opt_now') }}</option>
                                                                      <option value="today">{{ trans('dynamic_tags.form.model.filter_option.opt_today') }}</option>
                                                                      <option value="day">{{ trans('dynamic_tags.form.model.filter_option.opt_day_of_month') }}</option>
                                                                      <option value="day_of_week">{{ trans('dynamic_tags.form.model.filter_option.opt_week') }}</option>
                                                                      <option value="this_month">{{ trans('dynamic_tags.form.model.filter_option.opt_month') }}</option>
                                                                  </optgroup>
                                                                <optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_broadcast')}}">
                                                                    <option value="broadcast_name">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_name')}}</option>
                                                                    <option value="broadcast_creation">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_creation')}}</option>
                                                                    <option value="broadcast_group">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_group')}}</option>
                                                                    <option value="broadcast_subject">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_subject')}}</option>
                                                                    <option value="broadcast_attachment">{{trans('dynamic_tags.form.model.filter_option.opt_attachment')}}</option>
                                                                </optgroup>
                                                                <optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_schedule_details')}}">
                                                                    <option value="sch_label">{{trans('dynamic_tags.form.model.filter_option.opt_schedule')}}</option>
                                                                    <option value="camp_type">{{trans('dynamic_tags.form.model.filter_option.opt_campaign_type')}}</option>
                                                                    <option value="aud_type">{{trans('dynamic_tags.form.model.filter_option.opt_audience_type')}}</option>
                                                                </optgroup>
                                                            </select>

                                                        </div>
                                                        <div class="col-md-3">

                                                            <select id="select_field_name_1"
                                                                    class="form-control m-select2 select_2"
                                                                    name="field_name[]">
                                                                {!! $custom_fields_opt !!}
                                                            </select>

                                                        </div>
                                                        <div class="col-md-2">
                                                            <select id="select_condition_1" name="condition[]" class="form-control m-select2 select_3" data-placeholder="{{ trans('dynamic_tags.form.model.filter_placeholder.select_an_option') }}">
                                                                <option value="{{ trans('dynamic_tags.form.model.filter_option.is') }}">{{ trans('segments.form.filter_dropdown_option_is') }}</option>
                                                                <option value="is_not">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>
                                                                <option value="{{ trans('dynamic_tags.form.model.filter_option.contains') }}">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>
                                                                <option value="does_not_contain">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>
                                                            </select>

                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="col_4 value_1">
                                                                <input type="text" class="form-control textsystem"
                                                                    placeholder="Text Field" name="values[]">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-1">
                                                            <a href="javascript:;"
                                                            class="btn btn-danger btn-icon btn-sm btn-cancle">
                                                                <i class="la la-close"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div data-repeater-create="" class="btn btn-info btn-icon btn-sm btn-add"
                                    onclick="showRow(1)">
                                    <i class="la la-plus"></i>
                                </div>
                            </div>
                        </span>
                        <!-- -->
                        <br/>
                        <!-- -->
                        <div class="if-portion">
                            <h3><i class="fa fa-check-square"></i> {{trans('dynamic_tags.form.model.label.if_qualify')}}</h3>
                            
                        <?php 
                            $RssAddon = addon_license_status('RSS Feed');
                            $rssFeed=routeAccess('rssfeed');
                        ?>
                            @if($RssAddon=='Active')
                                @if(!empty($rssFeed))
                                <div class="form-group row mb1 mt1" data-name="XoBCUTdF">
                                    <label class="col-form-label col-md-2">
                                    {{trans('dynamic_tags.form.model.label.include_rss_feed')}} <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('dynamic_tags.form.model.label.include_rss_feed_description')}}" data-original-title="{{trans('common.description')}}"></i>
                                    </label>
                                    <div class=" kt-radio-inline pl12" id="session-check" data-name="BDSrYLUBrg">
                                        <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success mt-0">
                                            <label for="_format_rss">
                                                <input autocomplete="off" type="checkbox" name="_format_rss" id="_format_rss">
                                                <span></span>
                                            </label>
                                        </span>
                                        <!-- <label class="kt-radio kt-radio--default" for="_format_basic">
                                            <input id="_format_basic" checked type="radio" autocomplete="off" name="type" value="basic">
                                            <span></span>
                                        Basic
                                        </label>
                                        <label class="kt-radio kt-radio--default" for="_format_rss">
                                            <input id="_format_rss"  type="radio" autocomplete="off" name="type" value="rss">
                                            <span></span>
                                        RSS
                                        </label> -->
                                    </div>
                                </div>
                                <div class="form-group row  rssUrl mt2" data-name="XofBCUTdF" style="display:none">
                                    <label class="col-form-label col-md-2">
                                        {{trans('dynamic_tags.form.model.label.url')}} <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('dynamic_tags.form.model.label.url_description')}}" data-original-title="{{trans('common.description')}}"></i>
                                    </label>
                                    <div class="pt10 col-md-6"  data-name="BDSrYLUBrg">
                                        <input id="rss_url" class="form-control" type="text" name="rss_url" value="">
                                        <span class="text-help">{{trans('dynamic_tags.form.model.label.url_description')}}</span>
                                    </div>
                                    <div class="col-md-2">
                                        <button id="fetchHeaders" class="btn btn-info" type="button" name="rss_url">{{trans('dynamic_tags.form.model.button.fetch_tags')}}</button>
                                        <i class="rss-result proccess fa fa-spinner fa-spin"></i>
                                        <i class="rss-result ok fa fa-check-circle text-info"></i>
                                        <i class="rss-result notok fa fa-times-circle text-danger"></i>
                                    </div>
                                </div>
                                <div id="map-blk">
                                    <div class="form-group rssUrl row"  >
                                        <label class="col-form-label col-md-2"></label>
                                        <div class="pt10 col-md-9"  data-name="BDSrYLUBrg">
                                            <div class="row">
                                                <label class="col-form-label col-md-12">
                                                    {{trans('dynamic_tags.form.model.label.rss_tags')}}
                                                </label>
                                                <div id="MapFields" class="scroll col-md-12">
                                                    <table class="table table-striped table-hover responsive" id="rss-data">
                                                        <thead>
                                                            <tr>
                                                                <th>{{trans('dynamic_tags.form.model.table_heading.tag')}}</th>
                                                                <th>{{trans('dynamic_tags.form.model.table_heading.variable')}}</th>
                                                                <th>{{trans('dynamic_tags.form.model.table_heading.sample_content')}}</th>
                                                                <th>{{trans('dynamic_tags.form.model.table_heading.view')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="fetchRssMapping">
                                                            
                                                        </tbody>
                                                    </table>
                                                </div>
                                                    
                                                <div id="MappingFields" class="scroll" style="display:none"> </div>    
                                            </div>                  
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row rssUrl" data-name="XofBCUTdF" style="display:none">
                                    <label class="col-form-label col-md-2">
                                        {{trans('dynamic_tags.form.model.label.feed_limit')}} <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('dynamic_tags.form.model.label.feed_limit_description')}}" data-original-title="{{trans('common.description')}}"></i>
                                    </label>
                                    <div class="pt10 col-md-6"  data-name="BDSrYLUBrg">
                                        <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success mt--5">
                                            <label for="p_limit">
                                                <input autocomplete="off" type="checkbox" name="p_limit" id="p_limit">
                                                <span></span>
                                            </label>
                                        </span>
                                        <span class="plimit"><input id="post_limits" class="form-control" type="number" name="post_limits" value=""></span>
                                    </div>
                                </div>
                                <div class="form-group row rssUrl" data-name="XofBCUTdF" style="display:none">
                                    <label class="col-form-label col-md-2">
                                        {{trans('dynamic_tags.form.model.label.data_fetch_interval')}} <i class="fa fa-question-circle popovers" data-html="true" data-toggle="kt-popover" data-container="body" data-trigger="hover" data-placement="right" data-content="{{trans('dynamic_tags.form.model.label.data_fetch_interval_description')}}" data-original-title="{{trans('common.description')}}"></i>
                                    </label>
                                    <div class="pt10 col-md-6"  data-name="BDSrYLUBrg">
                                        <span class="kt-switch kt-switch--outline kt-switch--icon kt-switch--success mt--5">
                                            <label for="p_frequency">
                                                <input autocomplete="off" type="checkbox" name="p_frequency" id="p_frequency">
                                                <span></span>
                                            </label>
                                        </span>
                                    </div>
                                </div>
                                <div id="evergreen-campaign" class="rssUrl2" data-name="KUeJrJOW">
                                    <div class="row">
                                        <div class="col-md-6 offset-md-2 filter-block">
                                            <div class="form-group row" data-name="XunmEwRJ">
                                                <div class="col-md-12">
                                                    <label class="col-form-label">{{trans('dynamic_tags.form.model.label.frequency')}}</label>
                                                </div>
                                                <div class="col-md-12" data-name="JtjaUlPX">
                                                    <div class="kt-radio-inline" data-name="jXpDbThH">
                                                        <label for="yearly" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="yearly" checked="checked" name="rss_update_time"  value="yearly" onclick="loadEvergreenScheduleData('yearly')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'yearly') ? 'checked' : '' }}> {{trans('evergreen.edit.form.label.yearly')}}
                                                            <span></span>
                                                        </label> 
                                                        <label for="mnth" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="mnth" checked="checked" name="rss_update_time"  value="monthly" onclick="loadEvergreenScheduleData('monthly')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'monthly') ? 'checked' : '' }}> {{trans('common.monthly')}}
                                                            <span></span>
                                                        </label> 
                                                        <label for="wkly" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="wkly" name="rss_update_time" value="weekly" onclick="loadEvergreenScheduleData('weekly')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'weekly') ? 'checked' : '' }}> {{trans('common.weekly')}}
                                                            <span></span>
                                                        </label>
                                                        <label for="dly" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="dly" name="rss_update_time" value="daily" onclick="loadEvergreenScheduleData('daily')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'daily') ? 'checked' : '' }}> {{trans('common.daily')}}
                                                            <span></span>
                                                        </label>
                                                        <label for="hrly" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="hrly" name="rss_update_time" value="hourly" onclick="loadEvergreenScheduleData('hour')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'hour') ? 'checked' : '' }}> {{trans('common.hourly')}}
                                                            <span></span>
                                                        </label>
                                                        <!-- <label for="mnts" class="kt-radio kt-radio--default">
                                                            <input type="radio" autocomplete="off" id="mnts" name="evergreen_schedule" value="minutes" onclick="loadEvergreenScheduleData('minute')" {{ (isset($evergreen_campaign->evergreen_schedule) && $evergreen_campaign->evergreen_schedule == 'minute') ? 'checked' : '' }}> {{trans('common.minutes')}}
                                                            <span></span>
                                                        </label> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row" id="evergreen_schedule_year" data-name="wNhdZOmO">
                                                <div class="col-md-12" data-name="WSDZwuIP">
                                                    <label class="col-form-label">{{trans('common.month')}}</label>
                                                    <select class="form-control m-select2" name="month_of_year" id="month_of_year">
                                                        @for ($i=1; $i < 13; $i++)
                                                            <option value="{{$i}}" {{ (isset($evergreen_campaign->month_of_year) && $evergreen_campaign->month_of_year == $i) ? 'selected' : '' }}>{{$i}}</option>
                                                        @endfor
                                                    </select>
                                                </div>

                                            </div>
                                            <div class="form-group row" id="evergreen_schedule_month" data-name="wNhdZOmO">
                                                <div class="col-md-12" data-name="WSDZwuIP">
                                                    <label class="col-form-label">{{trans('common.day_of_month')}}</label>
                                                    <select class="form-control m-select2" name="day_of_month" id="day_of_month">
                                                        @for ($i=1; $i <= 31; $i++)
                                                            <option value="{{$i}}" {{ (isset($evergreen_campaign->day_of_month) && $evergreen_campaign->day_of_month == $i) ? 'selected' : '' }}>{{$i}}</option>
                                                        @endfor
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row" id="evergreen_schedule_week" data-name="jsUFFHVf">
                                                <div class="col-md-12" data-name="LTCHMDru">
                                                    <label class="col-form-label12">{{trans('common.day_of_week')}}</label>
                                                    <select class="form-control m-select2" name="day_of_week" id="day_of_week">
                                                        <option value="{{trans('common.sunday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'Sunday') ? 'selected' : '' }}>{{trans('common.sunday')}}</option>
                                                        <option value="{{trans('common.monday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'selected') ? 'checked' : '' }}>{{trans('common.monday')}}</option>
                                                        <option value="{{trans('common.tuesday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'tuesday') ? 'selected' : '' }}>{{trans('common.tuesday')}}</option>
                                                        <option value="{{trans('common.wednesday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'wednesday') ? 'selected' : '' }}>{{trans('common.wednesday')}}</option>
                                                        <option value="{{trans('common.thursday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'thursday') ? 'selected' : '' }}>{{trans('common.thursday')}}</option>
                                                        <option value="{{trans('common.friday')}}" {{ (isset($evergreen_campaign->day_of_week) && $evergreen_campaign->day_of_week == 'friday') ? 'selected' : '' }}>{{trans('common.friday')}}</option>
                                                        <option value="{{trans('common.saturday')}}">{{trans('common.saturday')}}</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row" id="evergreen_schedule_hour" data-name="EhRSdcnE"> 
                                                <div class="col-md-12" data-name="hjFWUdKv">
                                                    <label class="col-form-label">{{trans('common.after_every')}}</label>
                                                    <select class="form-control m-select2" name="every_hour" id="every_hour">
                                                            @for($i = 0; $i < 60; $i = $i + 5)
                                                            <option value="{{$i}}" {{ (isset($evergreen_campaign->every_hour) && $evergreen_campaign->every_hour == $i) ? 'selected' : '' }}>{{$i}} minute</option>
                                                            @endfor
                                                    </select> 
                                                </div>
                                            </div>
                                            <div class="form-group row" id="evergreen_schedule_minute" data-name="QWcgqnIQ">
                                                <div class="col-md-12" data-name="LddVrwSi">
                                                    <label class="col-form-label">{{trans('common.after_every')}}</label>
                                                    <select class="form-control m-select2" name="every_minute" id="every_mintue">
                                                        <option value="5" {{ (isset($evergreen_campaign->every_mintue) && $evergreen_campaign->every_mintue == 5) ? 'selected' : '' }}>5</option>
                                                        <option value="15" {{ (isset($evergreen_campaign->every_mintue) && $evergreen_campaign->every_mintue == 15) ? 'selected' : '' }}>15</option>
                                                        <option value="30" {{ (isset($evergreen_campaign->every_mintue) && $evergreen_campaign->every_mintue == 30) ? 'selected' : '' }}>30</option>
                                                    </select> 
                                                </div>
                                                <label class="col-form-label col-md-6 offset-md-2 text-left pt-5"> {{trans('common.minutes')}}</label>
                                            </div>
                                            <div class="form-group row sending_timeInput" data-name="yohcpAfd">
                                                <div class="col-md-12" data-name="HCrWgXWq">
                                                    <label class="col-form-label">{{trans('dynamic_tags.form.model.label.set_time')}}</label>
                                                    <div class="input-group date" data-date-format="dd-mm-yyyy" data-name="MSRGAqTf">
                                                        <input type="text" class="form-control timepicker timepicker-default"  name="sending_time" id="sending_time">
                                                        <div class="input-group-append" data-name="pXgVGVXu">
                                                            <span class="input-group-text">
                                                                <i class="la la-calendar-check-o"></i>
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            @endif

                            <div class="form-group row mb0" data-name="XoBCUTdF">
                                <label class="col-form-label col-md-2">
                                    @lang('dynamic_tags.form.model.label.content_type_select')
                                </label>
                                <div class="pt5 kt-radio-inline pl12" id="session-check" data-name="BDSrYLUBrg">
                                    <label class="kt-radio kt-radio--default" for="_format_html">
                                        <input id="_format_html" checked type="radio" autocomplete="off" name="_format" value="html">
                                        <span></span>
                                    @lang('dynamic_tags.form.model.radio_option.content_type_html')
                                    </label>
                                    <label class="kt-radio kt-radio--default" for="_format_text">
                                        <input id="_format_text" type="radio" autocomplete="off" name="_format" value="text">
                                        <span></span>
                                        @lang('dynamic_tags.form.model.radio_option.content_type_text')
                                    </label>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="content_html" class="content_title col-form-label">{{trans('dynamic_tags.form.model.label.html_body')}}</label>
                                <textarea class="form-control" rows="10" name="content_html" id="content_html"></textarea>
                            </div>
                            @php
                                $ckeditor_id = 'content_html';
                            @endphp
                            @if($adminOnClient)
                                {{ dynamicTags(0, 0, $ckeditor_id,$dynamic_content->user_id,false) }}
                            @else
                                {{ dynamicTags(0, 0, $ckeditor_id,null,false) }}
                            @endif
                     {{--       <div class="form-group">
                                <label for="content_text" class="col-form-label">{{trans('dynamic_tags.form.model.label.text_body')}}</label>
                                <textarea id="content_text" name="content_text" class="form-control" rows="5"></textarea>
                            </div>--}}
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button onclick="hideMdl()" type="button" class="btn btn-secondary" >{{trans('common.form.button.cancel')}}</button>
                    <button id="mkR" onclick="makeRule()" type="button" class="btn btn-success">{{trans('dynamic_tags.form.model.button.add_rule')}}</button>
                </div>
            </div>
        </div>
    </div>


<div class="modal fade" id="modal-text" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('dynamic_tags.form.model.widget_heading.sample_content')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <div class="modal-body">
                <div class="content-block scroll">
                    <xmp id="text-content"></xmp>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-html" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('dynamic_tags.form.model.widget_heading.content_preview')}}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                </button>
            </div>
            <div class="modal-body">
                <div class="content-block scroll">
                    <div id="html-content"></div>
                    <br><br>
                </div>
            </div>
        </div>
    </div>
</div>




    <script>
      var  editor = CKEDITOR.replace('content_html', {
            fullPage: true,
            allowedContent: true,
            height: 400
        });
        CKEDITOR.config.enterMode = CKEDITOR.ENTER_BR;
        CKFinder.setupCKEditor( editor );

        CKEDITOR.config.extraPlugins = 'preview,font,colorbutton,justify,bidi,language,emojione';
        CKEDITOR.config.language_list = ['en:English', 'ar:Arabic:rtl', 'fr:French', 'he:Hebrew:rtl', 'es:Spanish'];
        CKEDITOR.config.defaultLanguage = 'en';
        CKEDITOR.on('dialogDefinition', function (e) {
            $('#kt_modal_4').removeAttr('tabindex');
        });
    </script>
@endsection

@section('page_scripts')
    <script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
    <script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
    <script src="/themes/default/js/init.js" type="text/javascript"></script>
    <script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
    <script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/datepicker-init.js" type="text/javascript"></script>
    <script src="/themes/default/js/lib.js" type="text/javascript"></script>
    <script src="/themes/default/js/jquery.input.js" type="text/javascript"></script>
    <script src="/themes/default/js/repeater.js" type="text/javascript"></script>
    <script src="/themes/default/js/jquery-ui.js" type="text/javascript"></script>
    <script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-timepicker.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-timepicker.init.js" type="text/javascript"></script>
    <script src="/themes/default/js/includes/intlTelInput.js" type="text/javascript"></script>
    <script>

$(document).ready(function() {
        $(document).on('keyup keypress', 'form input[name="searchp"]', function(e) {
            if(e.which == 13) {
                e.preventDefault();
                return false;
            }
        });

        $("#btn-searchp").click(function() {
            $("#btn-searchp").hide();
            $("#btn-searchp2").show();
            var value = $("#searchp").val().toLowerCase();
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        $("#btn-searchp2").click(function() {
            $("#btn-searchp").show();
            $("#btn-searchp2").hide();
            $("#searchp").val("");
            var value = "";
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        $('#searchp').keyup(function(e){
            if(e.keyCode == 13) {
                $(this).trigger("enterKey");
            }
        });
        $('#searchp').bind("enterKey",function(e){
            var value = $("#searchp").val().toLowerCase();
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });

function loadEvergreenScheduleData (val) {
        $('.sending_timeInput').show();
        $('#evergreen_schedule_year').hide();
        if (val == 'yearly') {
            $('#evergreen_schedule_year').show();
            $('#evergreen_schedule_month').show();
            $('#evergreen_schedule_week').hide();
            $('#evergreen_schedule_hour').hide();
            $('#evergreen_schedule_minute').hide();
        } else if (val == 'monthly') {
            $('#evergreen_schedule_month').show();
            $('#evergreen_schedule_week').hide();
            $('#evergreen_schedule_hour').hide();
            $('#evergreen_schedule_minute').hide();
        } else if (val == 'weekly') {
            $('#evergreen_schedule_week').show();
            $('#evergreen_schedule_month').hide();
            $('#evergreen_schedule_hour').hide();
            $('#evergreen_schedule_minute').hide();
        } else if (val == 'daily') {
            $('#evergreen_schedule_week').hide();
            $('#evergreen_schedule_month').hide();
            $('#evergreen_schedule_hour').hide();
            $('#evergreen_schedule_minute').hide();
        } else if (val == 'hour') {
            $('.sending_timeInput').hide();
            $('#evergreen_schedule_hour').show();
            $('#evergreen_schedule_week').hide();
            $('#evergreen_schedule_month').hide();
            $('#evergreen_schedule_minute').hide();
        } else if (val == 'minute') {
            $('#evergreen_schedule_minute').show();
            $('#evergreen_schedule_hour').hide();
            $('#evergreen_schedule_week').hide();
            $('#evergreen_schedule_month').hide();
        }
    }
        
var htmlcontent = `<p class=\"has-vlog-bg-color has-vlog-bg-background-color has-text-color has-background\"></p>\n\n\n\n<h2 class=\"wp-block-heading\">Introduction</h2>\n\n\n\n<p>MySQL, a popular open-source relational database management system, allows you to store and manipulate vast amounts of data efficiently. When working with global applications or systems that require accurate time-related operations, ensuring that the database&#8217;s time zone is properly configured becomes essential.&nbsp;</p>\n\n\n\n<p>In this step-by-step guide, we will explore changing the time zone in a MySQL database, enabling you to maintain consistent and accurate time representation.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">Method: 1</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Step 1: Verify Current Time Zone Configuration</h3>\n\n\n\n<p>Before making any changes, it&#8217;s crucial to identify the current time zone configuration in your MySQL database. To accomplish this, connect to your MySQL server using a MySQL client, such as the command-line interface (CLI) or a graphical user interface (GUI) tool like phpMyAdmin. Execute the following SQL query to retrieve the current time zone:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>SELECT @@global.time_zone;</strong></code></pre>\n\n\n\n<p>This query will provide you with the current time zone setting.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 2: Modify Global Time Zone</h3>\n\n\n\n<p>To change the time zone in your MySQL database, you need to modify the global time zone setting. The global time zone affects the entire MySQL server and any databases or connections within it. Execute the following SQL statement to change the global time zone:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>SET GLOBAL time_zone = 'timezone';</strong></code></pre>\n\n\n\n<p>Replace &#8216;timezone&#8217; with the desired time zone. For example, if you want to set the time zone to UTC, use the following command:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>SET GLOBAL time_zone = '+00:00';</strong></code></pre>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 3: Modify the Session Time Zone</h3>\n\n\n\n<p>While changing the global time zone affects the MySQL server as a whole, individual client sessions may still have their time zone settings. To ensure consistent time representation across all sessions, it&#8217;s essential to modify the session time zone. Execute the following SQL statement to change the session time zone:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>SET time_zone = 'timezone';</strong></code></pre>\n\n\n\n<p>Again, replace &#8216;timezone&#8217; with the desired time zone.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 4: Verify Time Zone Changes</h3>\n\n\n\n<p>To verify that the time zone changes have been applied successfully, execute the following SQL queries:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>SELECT @@global.time_zone;\nSELECT @@session.time_zone;</strong>\n</code></pre>\n\n\n\n<p>These queries will display the global and session time zone settings, respectively. Confirm that the output matches the desired time zone.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 5: Restart MySQL Server (If Necessary)</h3>\n\n\n\n<p>In some cases, changes to the global time zone setting may require a server restart for the modifications to take effect. If you have made the necessary changes but still notice inconsistencies, consider restarting the MySQL server to ensure proper synchronization.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">Method: 2</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Step 1.  Locate my.cnf File</h3>\n\n\n\n<p>The my.cnf file is typically located in the MySQL installation directory. The exact location can vary depending on your operating system and MySQL installation method. Common paths include <strong><code>\\etc\\my.cnf</code></strong>, <strong><code>\\etc\\mysql\\my.cnf</code></strong>, or <strong><code>C:\\Program Files\\MySQL\\MySQL Server X.X\\my.ini</code></strong>  on Windows.</p>\n\n\n\n<p>Use the appropriate file explorer or command line tool to navigate to the directory containing the my.cnf file. If you are unable to find it, refer to the MySQL documentation or consult your system administrator for assistance.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 2: Backup my.cnf File (Optional, but Recommended)</h3>\n\n\n\n<p>Before making any modifications to my.cnf file, it&#8217;s advisable to create a backup in case any issues arise. This ensures that you can revert to the original configuration if necessary. Simply make a copy of the my.cnf file and store it in a safe location.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 3: Open my.cnf File for Editing</h3>\n\n\n\n<p>Using a text editor, open the my.cnf file for editing. Ensure that you have the necessary permissions to modify the file. On Linux-based systems, you may need to use sudo or a privileged user account to access and modify the file.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 4: Locate the [mysqld] Section</h3>\n\n\n\n<p>Within my.cnf file, locate the [mysqld] section. This section contains configuration options specific to the MySQL server. If the [mysqld] section doesn&#8217;t exist, create it at the end of the file on a new line.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 5: Update the Time Zone Setting</h3>\n\n\n\n<p>Add or modify the time zone setting within the [mysqld] section. Use the following syntax:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>default_time_zone = 'timezone';</strong></code></pre>\n\n\n\n<p>Replace &#8216;timezone&#8217; with the desired time zone. For example, if you want to set the time zone to UTC, the line would be:</p>\n\n\n\n<pre class=\"wp-block-code\"><code><strong>default_time_zone = '+00:00';</strong></code></pre>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 6: Save and Close my.cnf File</h3>\n\n\n\n<p>After updating the time zone setting, save the changes to my.cnf file and close the text editor.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">Step 7: Restart the MySQL Server</h3>\n\n\n\n<p><strong>Conclusion</strong></p>\n\n\n\n<p>Configuring the time zone in your MySQL database is crucial for accurate time-related operations, especially in global applications. By following this guide, you can easily modify the time zone settings in your MySQL database. Remember to verify the current time zone, change the global and session time zones, and confirm the changes to ensure that the desired time zone is accurately reflected.</p>\n\n\n\n<p>Maintaining the correct time zone setting in your MySQL database enhances the reliability and consistency of your data, allowing for seamless integration with applications and systems that rely on accurate time representation.</p>`;

var content2 = htmlcontent.replace(/(\r\n|\n|\r)/gm, "");

        function copy_user(containerid) {
            console.log(containerid);
            var range = document.createRange();
            range.selectNode(containerid); //changed here
            window.getSelection().removeAllRanges(); 
            window.getSelection().addRange(range); 
            document.execCommand("copy");
            window.getSelection().removeAllRanges();
            Command: toastr["success"] ("Value copied successfully!");
        }

        var tag1 = `<li id="list_1" class="ui-state-default ui-sortable-handle"><i class="fa fa-bars"></i> <span class="li-text">Dynamic Tag 01</span> <span class="li-action"> <a onclick="deleteRule(1)" href="#" title="Delete" class="deleteme pull-right"><i class="la la-trash"></i></a> <a href="javascript:;" class="pull-right" title="Edit"><i class="la la-edit"></i></a>  </span> </li>`;

        function useTemp(tag,desc,values)
        {
            var tags = $("#tag_name").val();
            var taglist = $("#sortable").html();
            var tagdesc = $("#description").val();
            if(tags != "" || tagdesc != "") {
                Swal.fire({
                    title: "Are you sure?",
                    text: "It will override the current selections.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: "Confirm"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $(".blockUI").show();
                        setTimeout(() => {
                            $("#tag_name").val(tag);
                            $("#sortable").html(tag1)
                            $("#description").val(desc);
                            $(".blockUI").hide();
                            $("#templates-blk").slideUp();
                            $("#btn-templates").removeClass("section-close");
                            Command: toastr["success"] ("Dynamic template successfully added!");
                        }, 1500);
                    } else {
                        $("#templates-blk").slideDown();
                        $("#btn-templates").addClass("section-close");
                    }
                });
            } else {
                $(".blockUI").show();
                setTimeout(() => {
                    $("#tag_name").val(tag);
                    $("#sortable").html(tag1)
                    $("#description").val(desc);
                    $(".blockUI").hide();
                    $("#templates-blk").slideUp();
                    $("#btn-templates").removeClass("section-close");
                    Command: toastr["success"] ("Dynamic template successfully added!");
                }, 1500);
            }
        }


        $(document).ready(function() {
            $("#btn-templates").click(function() {
                $("#templates-blk").slideToggle();
                $(this).toggleClass("section-close");
            });
            $("#rss_url").css("border-color", "#bec4d0");
            $("#p_frequency").on("change", function() {
                var check = $(this).is(":checked");
                if(check){
                    $("#evergreen-campaign").slideDown();
                } else{
                    $("#evergreen-campaign").slideUp();
                }
            });
            $('#sending_time').timepicker({
                minuteStep: 5,
                showSeconds: false,
                showMeridian: false,
                snapToStep: true
            });
            $("body").on("click" , ".eye-view" , function() {
                $('.blockUI').show();
                var rss_url = $("#rss_url").val();
                var field = $(this).attr("data-id");
                $.ajax({
                    url: "{{ route('fetch_rss_mapping_single') }}",
                    type: "POST",
                    data: {rss_url: rss_url, field:field},
                    success: function(result) {
                        $('.blockUI').hide();
                        // console.log(JSON.parse(result))
                        // //result = atob(result);
                        $("#html-content").html(result);
                        $("#modal-html").modal("show");
                    }
                });

               
            });
            $(".show-content").click(function() {
                $("#text-content").html(htmlcontent);
                $("#modal-text").modal("show");
            });
            $('#copyAsText').remove();
            $("#p_limit").on("change", function() {
                var checked = $(this).is(":checked");
                if(checked == true) {
                    $(".plimit").css("display", "inline-block");
                } else {
                    $(".plimit").hide();
                }
            });
        });

        $('#copyAsText2').click(function() {
            var content_html_2 = CKEDITOR.instances['content_html_then'].getData(); // For CK editor editor
            jQuery('#content_js').html(content_html_2).find('a').each(function(){
                var href=jQuery(this).attr('href');
                var label=jQuery(this).text();
                if( href && href !="#"){
                    var link= (label && label !="") ? label +":"+ href:href;
                }else{
                    var link=label;
                }
                jQuery(this).replaceWith(link);
            });
            // Removing extra spaces e.g newline, tabs etc with single one
            // content_html=$.trim(jQuery('#content_js').text()).replace(/\s\s+/g, ' ');
            content_html_2=jQuery('#content_js').html();
            $(".blockUI").show();
            $.ajax({
                url: "{{ route('converHtmlToText') }}",
                type: "POST",
                data: {html: content_html_2},
                success: function(result) {
                    $(".blockUI").hide();
                    $('#content_then_text').val(result);
                },
                error: function(err) {
                    $(".blockUI").hide();
                }
            });

        });

        $("body").on("click" , "#fetchHeaders" , function() { 
            $("i.rss-result.proccess").css("display", "inline-block");
            $("i.rss-result.notok").hide();
            $("i.rss-result.ok").hide();
            $(".blockUI").show();
            $("#rss_url").css("border-color", "#bec4d0");
            var rss_url = $("#rss_url").val();
            if(rss_url == "") {
                $("i.rss-result.proccess").hide();
                $("#rss_url").css("border-color", "red");
                $(".blockUI").hide();
                Command: toastr["error"] ("Enter rss url to fetch the content.");
                return false;
            } else {
                $("#rss_url").css("border-color", "#bec4d0");
                $.ajax({
                    url: "{{ route('fetch_rss_mapping') }}",
                    type: "POST",
                    data: {rss_url: rss_url},
                    success: function(result) {
                        $("i.rss-result.proccess").hide();
                        $("i.rss-result.notok").hide();
                        $("i.rss-result.ok").css("display", "inline-block");
                        $(".blockUI").hide();
                        $("#map-blk").show();
                        
                        $('#fetchRssMapping').html(result);
                        $(".rss-field").css("display", "inline-block");
                        setTimeout(() => {
                            $("i.rss-result").fadeOut(1500);
                        }, 3000);
                    },
                    error: function(err) {
                        $("i.rss-result.proccess").hide();
                        $("i.rss-result.ok").hide();
                        $("i.rss-result.notok").css("display", "inline-block");
                        Command: toastr["error"] ("Wrong URL or data not found in this URL.");
                        $(".blockUI").hide();
                        setTimeout(() => {
                            $("i.rss-result").fadeOut(1500);
                        }, 3000);
                    }
                });
            }
        })

        $('#copyAsText').click(function() {
            var content_html = CKEDITOR.instances['content_html'].getData(); // For CK editor editor
            jQuery('#content_js').html(content_html).find('a').each(function(){
                var href=jQuery(this).attr('href');
                var label=jQuery(this).text();
                if( href && href !="#"){
                    var link= (label && label !="") ? label +":"+ href:href;
                }else{
                    var link=label;
                }
                jQuery(this).replaceWith(link);
            });
            // Removing extra spaces e.g newline, tabs etc with single one
            // content_html=$.trim(jQuery('#content_js').text()).replace(/\s\s+/g, ' ');
            content_html=jQuery('#content_js').html();
            $(".blockUI").show();
            $.ajax({
                url: "{{ route('converHtmlToText') }}",
                type: "POST",
                data: {html: content_html},
                success: function(result) {
                    $(".blockUI").hide();
                    $('#content_text').val(result);
                },
                error: function(err) {
                    $(".blockUI").hide();
                }
            });

        });
        var countries = '{!! $cont_options !!}';
        var conditions = "<option value=\"{{ trans('dynamic_tags.form.model.filter_option.is') }}\">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n" +
            "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n" +
            "<option value=\"{{ trans('dynamic_tags.form.model.filter_option.contains') }}\">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n" +
            "<option value=\"does_not_contain\">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>";
        var custom_fields = '{!!$custom_fields_opt!!}';
        var lists = '{!!$listOptions!!}';
        var broadcasts = '{!!$broadcast_options!!}';
        var dates = '{!!$date_options!!}';

        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }

        function editRule(id)
        {
            $(".blockUI").show();
             rule = $(document).find('[data-id="'+id+'"]').val();
            $('#exampleModalLabel').html('{{trans('dynamic_tags.form_heading.add_unit')}}');
            rule = JSON.parse(rule);
            title = rule.rule_name;
            $('#rule_name').val(title);
            rule_type = rule.rule_type;
            rss_url = rule.rss_url;
            p_limit = rule.p_limit;
            p_frequency = rule.p_frequency;
           
            if(p_frequency == "on") {
                $("#p_frequency").prop("checked", false);
                $("#p_frequency").trigger("click");
            } 
            if(p_limit == "on") {
                $("#p_limit").trigger("click");
            } 
            
            if(rule_type == "rss" && rss_url != "") { 
                $("#_format_rss").prop("checked" , false);
                $("#_format_rss").trigger("click");
                
            } 
            $('#rss_url').val(rss_url);
            if(rss_url != "") { 
                setTimeout(() => {
                    $("#fetchHeaders").trigger("click");
                }, 200);
            }
            
            
            post_limits = rule.post_limits;
            cron_after = rule.cron_after;
            cron_after_time = rule.cron_after_time;

            if(rule.rss_update_time == "yearly") $("#yearly").trigger("click");  
            if(rule.rss_update_time == "monthly") $("#mnth").trigger("click");
            if(rule.rss_update_time == "weekly") $("#wkly").trigger("click");
            if(rule.rss_update_time == "daily") $("#dly").trigger("click");
            if(rule.rss_update_time == "hourly") $("#hrly").trigger("click");

            
            $('#rss_update_time').val(rule.rss_update_time);
            $('#month_of_year').val(rule.month_of_year);
            $('#day_of_month').val(rule.day_of_month);
            $('#day_of_week').val(rule.day_of_week);
            $('#every_hour').val(rule.every_hour);
            $('#every_mintue').val(rule.every_mintue);
            $('#sending_time').val(rule.sending_time);


            $('#post_limits').val(post_limits);
            $('#cron_after').val(cron_after);
            $('#cron_after_time').val(cron_after_time);
            rule_fields = rule.fields;
            rule_field_names = rule.field_names;
            rule_conditions = rule.conditions;
            rule_values = rule.values;
            rule_content = rule.content.replace(/\\"/g, '"');
            content_type = rule.content_type;
            optionsArr = {!! $optionsArr !!};

            for(i=0; i < rule_fields.length; i++)
            {
                col1_value = rule_fields[i];
                col2_value = rule_field_names[i].name;
                col3_value = rule_conditions[i].name;
                col4_value = rule_values[i];

                if(i>0)
                    $('.btn-add').trigger('click');
                if(i===0) {
                    $('#select_field_1').val(col1_value).trigger('change');
                if(col2_value!=null)
                    $('#select_field_name_1').val(col2_value).trigger('change');
                    //$('#select_field_name_1').children().remove();
                   // if(col1_value!='broadcast_group')
                    $('#select_condition_1').val(col3_value).trigger('change');
                    if(optionsArr[col2_value]!==undefined || ['country','lists','groups'].includes(col2_value) || ['broadcast_group','day','day_of_week','this_month'].includes(col1_value))
                    {
                        if(optionsArr[col2_value]!==undefined) {
                            if(optionsArr[col2_value].includes('<optgroup')) {
                                contList = col4_value.value;
                                result = Object.values(contList);
                                $('.value_1' + ' select').multiselect('select', result);
                            }
                            else{
                                $('.value_1' + ' :input').val(col4_value.value);
                            }
                        }
                        else{
                            contList = col4_value.value;
                            result = Object.values(contList);
                            $('.value_1' + ' select').multiselect('select', result);
                        }
                    }
                    else{
                        oneC = ['exactly','after','before']
                        if(oneC.includes(col3_value))
                            $('.value_1'+' :input').val(col4_value.value);
                        else if(col3_value=='between') {
                            $('#from_1').val(col4_value.key);
                            $('#to_1').val(col4_value.value);
                        }
                        else if(['occurred_before','occurred_after','for_the_past','older_than'].includes(col3_value))
                        {
                            keyS = col4_value.key;
                            $('.value_1'+' :input').val(col4_value.value);
                            $('#filter_1').val(keyS);
                        }
                        else {
                            if($('.value_1').find('input.mobile').length>0)
                                $('.value_1').find('input.mobile').intlTelInput("setNumber", "+" + col4_value.key+col4_value.value);
                            else
                            $('.value_1' + ' :input').val(col4_value.value);

                        }
                    }
                }
            }
            var b  = parseInt(localStorage.getItem("id"))-rule_fields.length+1;
            for(i=0; i < rule_fields.length; i++)
            {
                col1_value = rule_fields[i];
                col2_value = rule_field_names[i].name;
                col3_value = rule_conditions[i].name;
                col4_value = rule_values[i];
                col1_id = '#select_field_'+b+'';
                col2_id = '#select_field_name_'+b+'';
                col3_id = '#select_condition_'+b+'';
                col4_div_class = '.value_'+b+'';
                $(col1_id).val(col1_value).trigger('change');
                if(col2_value!=null)
                    $(col2_id).val(col2_value).trigger('change');
                $(col3_id).val(col3_value).trigger('change');
                if(optionsArr[col2_value]!==undefined  || ['country','lists','groups'].includes(col2_value) || ['broadcast_group','day','day_of_week','this_month'].includes(col1_value))
                {
                    if(optionsArr[col2_value]!==undefined) {
                        if(optionsArr[col2_value].includes('<optgroup')) {
                            contList = col4_value.value;
                            result = Object.values(contList);
                            $(col4_div_class+ ' select').multiselect('select', result);
                        }
                        else{
                            $(col4_div_class+' :input').val(col4_value.value);
                        }
                    }
                    else{

                        contList = col4_value.value;
                        result = Object.values(contList);
                        $(col4_div_class+ ' select').multiselect('select', result);
                    }
                }
                else{
                    oneC = ['exactly','after','before']
                    if(oneC.includes(col3_value))
                        $(col4_div_class+' :input').val(col4_value.value);
                    else if(col3_value=='between') {
                        $('#from_'+b).val(col4_value.key);
                        $('#to_'+b).val(col4_value.value);
                    }
                    else if(['occurred_before','occurred_after','for_the_past','older_than'].includes(col3_value))
                    {
                        keyS = col4_value.key;
                        $(col4_div_class+' :input').val(col4_value.value);
                        $('#filter_'+b).val(keyS);
                    }
                    else {
                        if ($(col4_div_class).find('input.mobile').length > 0)
                            $(col4_div_class).find('input.mobile').intlTelInput("setNumber", "+" + col4_value.key + col4_value.value);
                        else
                            $(col4_div_class+' :input').val(col4_value.value);
                    }
                }
                b++;
            }
            $('#kt_modal_4').modal('show');
            $('.m-select2').select2();
            if(content_type=='html' || content_type===undefined)
            {
                $('#content_html').val('');
                $('#_format_html').trigger('click');
                CKEDITOR.instances['content_html'].setData(rule_content);
            }
           else
           {
               try {
                   CKEDITOR.instances['content_html'].setData('');
               }
               catch (e) {
                   
               }
                $('#_format_text').trigger('click');
                $('#content_html').val(rule_content);
           }
            $('#mkR').attr('onclick','makeRule('+id+')').html('{{trans('dynamic_tags.form.button.edit')}}');
            $(".blockUI").hide();
        }
        function deleteRule(id)
        {
            $(".swal2-confirm").css("background-color", "#dd3333");
            $(".swal2-cancel").css("background-color", "#95a0a8");
            Swal.fire({
                title: "{{trans('dynamic_tags.alert_confirm.title_sure')}}",
                text: "{!! trans('dynamic_tags.alert_confirm.description_not_revert') !!}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{trans('dynamic_tags.alert_confirm.button.delete')}}"
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        "{{trans('dynamic_tags.alert_confirm.message_deleted')}}" ,
                        "{{trans('dynamic_tags.alert_confirm.description_tag_deleted')}}",
                        'success',
                        $('#list_'+id).remove()
                    )
                }
            });
        }function array_combine( keys, values ) {
            var new_array = {}, keycount=keys.length, i;

            if( !keys || !values || keys.constructor !== Array || values.constructor !== Array ){
                return false;
            }
            if(keycount != values.length){
                return false;
            }
            for ( i=0; i < keycount; i++ ){
                new_array[keys[i]] = values[i];
            }
            return new_array;
        }

        localStorage.setItem('i', '0');
        function escapeHtml(unsafe)
        {
            return unsafe
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;")
                .replace(/'/g, "&#039;");
        }
        function createIdForRow(id)
        {
           var new_id = '#list_'+id;
            if($(new_id).length == 0)
                return id;
            for(var i = id; i >= 0; i++)
            {
                new_id = '#list_'+i;
                if($(new_id).length == 0)
                {
                    id = i;
                    localStorage.setItem('i', '' + i + '');
                    break;
                }
            }
            return id;
        }
        function filterString(variable)
        {
            if (typeof variable === 'string')
          return   variable.replace(/'/g, '&#39;')
            return variable
        }
        function makeRule(id=null)
        {
            $("#content_text").css("border-color", "");
            $("#rule_name").css("border-color", "#bec4d0");
            $(".textsystem").css("border-color", "#bec4d0");
            $("#rule_name").css("border-color", "#bec4d0");
            $(".textsystem").css("border-color", "#bec4d0");
            $('.error').remove();
            var rule_name = filterString($('#rule_name').val());
            var rule_type = $('#_format_rss').is(':checked') ? 'rss' :'basic';
            var p_limit = $('#p_limit').is(':checked') ? 'on' :'off';
            var p_frequency = $('#p_frequency').is(':checked') ? 'on' :'off';
            if(p_limit == "off") { 
                var post_limits = 0;
            } else { 
                var post_limits = filterString($('#post_limits').val());
            }
            var rss_url = filterString($('#rss_url').val());
            // var mapping = $("#mapping_value").val();
            var mapping = [];
            $(".mapping_id").each(function() {
                if($(this).attr("data-id") != "") { 
                    mapping.push($(this).attr("data-id"));
                }
            });

            var rss_time = "monthly";
            if($('#yearly').is(":checked")) rss_time = "yearly";
            if($('#wkly').is(":checked")) rss_time = "weekly";
            if($('#dly').is(":checked")) rss_time = "daily";
            if($('#hrly').is(":checked")) rss_time = "hourly";

            var cron_after = filterString($('#cron_after').val());
            var cron_after_time = filterString($('#cron_after_time').val());
            var rss_update_time = filterString(rss_time);
            var month_of_year = filterString($('#month_of_year').val());
            var day_of_month = filterString($('#day_of_month').val());
            var day_of_week = filterString($('#day_of_week').val());
            var every_hour = filterString($('#every_hour').val());
            var every_mintue = filterString($('#every_mintue').val());
            var sending_time = filterString($('#sending_time').val());



            if (rule_name.length==0)
            {
                $("#rule_name").css("border-color", "red");
                Command: toastr["error"] ("{{trans('dynamic_tags.form.error_message.unit_required')}}");
                return false;
            }

            var fields = $("select[name='field[]']")
                .map(function(){return $(this).val();}).get();
            var field_names = $("select[name='field_name[]']")
                .map(function(){return {'name':$(this).val()};}).get();
            var conditions = $("select[name='condition[]']")
                .map(function(){return {'name':$(this).val()};}).get();
            var values = $("[name='values[]']")
                .map(function(){
                    if($(this).hasClass('mobile'))
                        return {'key':$(this).intlTelInput("getSelectedCountryData").dialCode,'value':filterString($(this).val().replace(/ /g,''))};
                    return {'key':filterString($(this).val())};
                }).get();
            try {
                var content = CKEDITOR.instances['content_html'].getData().replace(/&quot;/g, '\\"');
            }
            catch (e) {
                var content = $('#content_html').val();
            }
            content = escapeHtml(content);
            var content_text = null;
            if(content_text==''){
                $("#content_text").css("border-color", "red");
                Command: toastr["error"] ("{{trans('dynamic_tags.form.error_message.text_required')}}");
                return false;
            }
            var values_=[];
            var  val_key = 0;
            var between;
            for (var i=0; i < conditions.length; i++) {
                    if (conditions[i].name == 'between') {
                        val = values[val_key].key;
                        val2 = values[val_key + 1].key;
                        values_.push({'key': val, 'value': val2});
                        val_key++;
                    } else {
                        if (['occurred_before', 'occurred_after', 'for_the_past', 'older_than'].includes(conditions[i].name)) {
                            val = values[val_key].key == undefined ? null : values[val_key].key;
                            key = values[val_key+1].key == undefined ? null : values[val_key+1].key;
                            values_.push({'key': key, 'value': val});
                            val_key++;
                        }
                        else {
                            key = values[val_key].value!==undefined ? values[val_key].key: null;
                            val = values[val_key].value!==undefined ? values[val_key].value : values[val_key].key;
                            values_.push({'key': key, 'value': val});
                            between = false;
                        }
                    }
                val_key++;
            }
            values = values_;
            var content_type = $('#_format_html').is(':checked') ? 'html' :'text';
            var json = JSON.stringify({rule_name, rule_type,p_limit, p_frequency, rss_url,post_limits,rss_update_time, month_of_year, day_of_month, day_of_week, every_hour, every_mintue, sending_time, cron_after, cron_after_time, mapping, fields,field_names,conditions,values,content,content_type});
            // console.log(json);
            $.ajax({
                url:'{{route('validateDynamicTagRule')}}',
                method:'post',
                data:{'data':json},
                beforeSend:function ()
                {
                    $(".blockUI").show();
                },
                success:function (response)
                {
                    $(".blockUI").hide();
                    if(response.status=='success') {
                        console.log(values);
                        console.log(json);
                        if(id!==null) {
                            i = id;
                            v2 = i+1
                            localStorage.setItem('i', '' + v2 + '');
                        }
                        else {
                            @if(isset($dynamic_content))
                            localStorage.setItem("i", '{{$storage_var}}');
                            @endif
                                i = parseInt(localStorage.getItem('i'));
                            i++;
                            localStorage.setItem('i', '' + i + '');
                            i = createIdForRow(i);
                        }

                        edit_func = 'editRule(' + i + ')';
                        delete_func = 'deleteRule(' + i + ')';
                        lid = 'id="list_' + i + '"';
                        html = '<li ' + lid + ' class="ui-state-default ui-sortable-handle"><i class="fa fa-bars"></i> <span class="li-text">' + rule_name + '</span> <span class="li-action"> <a onclick="' + delete_func + '" href="javascript:;" title="Delete" class="deleteme pull-right"><i class="la la-trash"></i></a> <a href="javascript:;" onclick="' + edit_func + '" class="pull-right" title="Edit"><i class="la la-edit"></i></a> <!--<a href="javascript:;" class="pull-right" title="Copy"><i class="la la-copy"></i></a>--> <input type="hidden" name="rule[]" class="rule" value=' + "'" + json + "'" + ' data-id="' + i + '"></span> </li>';
                       $('.hr').trigger('click');
                        setTimeout(() => {
                            if(id!==null)
                                $('#list_'+i+'').replaceWith(html);
                            else
                            $('#sortable').append(html);
                            $("#kt_modal_4").modal('hide');
                            $("#add_rule_form")[0].reset();
                            $(".blockUI").hide();
                        }, 500);
                    }
                    else{
                        $(".blockUI").hide();
                    }
                },complete: function () {
                    $('.blockUI').hide();
                }
            });


        }
        $( function() {
            $( "#sortable" ).sortable();
            $( "#sortable" ).disableSelection();
            
            $('#_format_rss').on("click" , function() { 
                $("#rss_url").css("border-color", "#bec4d0");
                var checked  = $(this).is(":checked");
                if(checked){
                    $(".rssUrl").show();
                    // $(".rssUrl2").show();
                } else {
                    $(".rssUrl").hide();
                    $(".rssUrl2").hide();
                    $("#p_frequency").prop("checked", false);
                }
                
            });
            // $('#_format_basic').on("click" , function() { 
            //     $(".rssUrl").hide();
            // });
        } );
        function displayModal() {
            $('#content_html').val('');
            $('#_format_html').trigger('click');
            $('#_format_rss').prop("checked" , false);
            $(".rssUrl").hide();
            $(".rssUrl2").hide()
            $("#rss_url").val("");
            $("#map-blk").hide();
            $('#select_field_1').val('custom_fields').change();
            $('#select_field_name_1').change();
            $('#exampleModalLabel').html('{{trans('dynamic_tags.add.form_heading')}}');
            $('#mkR').attr('onclick','makeRule()').html('{{trans('dynamic_tags.form.button.add')}}');
            $('#rule_name').val('');
            $('.hr').trigger('click');
            CKEDITOR.instances['content_html'].setData('');
            $('#kt_modal_4').modal('show');
        }

        
        function hideMdl()
        {
            $('#kt_modal_4').modal('hide');
            $('#select_field_1').val('custom_fields').trigger('change');
            $('.hr').trigger('click');
            $('#_format_text').trigger('click');
            $('#content_html').val('');
            $('#_format_html').trigger('click');
            CKEDITOR.instances['content_html'].setData('');

        }
        var form_error = "{{trans('common.message.form_error')}}";
        localStorage.removeItem("id");
        @if(isset($storage_var) && $storage_var>1)
        localStorage.setItem("i", '{{$storage_var}}');
        @endif
    </script>
    <script>
        $(document).on('change', '.select_3', function () {
            select_con_id = this.id;
            string_id = select_con_id.substring(17);
            div_class = 'value_' + string_id;
            select_field_name_id = '#select_field_name_' + string_id;
            select_field_id = '#select_field_' + string_id;
            val = this.value;
            hd = 'hd_' + string_id;
            dates_arr = {!!$dates!!};
            select_field_name = $(select_field_name_id).val();
            $('.' + div_class).addClass(hd);
            if (dates_arr.includes(select_field_name) || ['created_at','broadcast_creation'].includes($(select_field_id).val()) || val === 'exactly') {
                if ((val === 'after' || val === 'before' || val === 'exactly')) {
                    div = '<div class="col_4 ' + div_class + '" >\n' +
                        '<input  type="text" class="form-control datesystem" placeholder="{{ trans('dynamic_tags.form.model.filter_option.date_field') }}" id="" name="values[]">\n' +
                        '</div>';
                    $('.' + div_class).after(div);
                    $('.' + hd).remove();
                    $(".datesystem").datepicker({
                        dateFormat: 'yy-mm-dd',
                        autoclose: true
                    });
                } else if (val === 'occurred_before' || val === 'for_the_past' || val === 'older_than' || val === 'occurred_after') {
                    date_filter = 'filter_'+string_id;
                    div = '<div class="col_4 ' + div_class + '" >\n' +
                        '<div class="datetype22">\n' +
                        '<input type="number"  class="form-control" id="" name="values[]" placeholder="Text Field">\n' +
                        '</div>\n' +
                        '<div class="datetype33">\n' +
                        '<select id="'+date_filter+'"  class="form-control m-select2" name="values[]" data-placeholder="{{ trans('dynamic_tags.form.model.filter_placeholder.select_an_option') }}">\n' +
                        '<option value="minutes" >{{ trans("common.minutes")}}</option>\n' +
                        '<option value="hours" >{{ trans("common.hours")}}</option>\n' +
                        '<option value="days" >{{ trans("common.days")}}</option>\n' +
                        '<option value="weeks" >{{ trans("common.weeks")}}</option>\n' +
                        '<option value="months" >{{ trans("common.months")}}</option>\n' +
                        '<option value="years" >{{ trans("common.years")}}</option>\n' +
                        '</select>' +
                        '</div>\n' +
                        '</div>';
                    $('.' + div_class).after(div);
                    $('.' + hd).remove();
                    $('.m-select2').select2({
                        templateResult: function (data, container) {
                            if (data.element) {
                                $(container).addClass($(data.element).attr("class"));
                            }
                            return data.text;
                        }
                    });
                } else if (val === 'between') {
                    from_id = 'from_'+string_id;
                    to_id = 'to_'+string_id;
                    div = '<div class="' + div_class + '" >\n' +
                        '<div class="input-group date form_datetime bs-datetime" id="datetimepicker-geo" data-date="" data-date-format="yyyy-mm-dd">\n' +
                        '<div class="input-daterange input-group dategroupmap">\n' +
                        '<input id="'+from_id+'"  type="text" class="form-control cfrom" name="values[]" readonly="" data-date-format="yyyy-mm-dd">\n' +
                        '<div class="input-group-append"><span class="input-group-text"><i class="la la-ellipsis-h"></i></span></div>\n' +
                        '<input id="'+to_id+'" type="text" class="form-control cto" readonly="" name="values[]"  data-date-format="yyyy-mm-dd">\n' +
                        '</div>\n' +
                        '</div>\n' +
                        '</div>';
                    $('.' + div_class).after(div);
                    $(".cfrom, .cto").datepicker({ dateFormat: 'yy-mm-dd' ,autoclose: true});
                    $('.' + hd).remove();
                }
            }
        });

        // select second dropdown in unit rules
        $(document).on('change', '.select_2', function () {
            var id_c = null;
            countries = '{!! $cont_options !!}';
            optionsArr = {!! $optionsArr !!};
            numbersArr = {!! $numbersArr !!};
            lists = '{!!$listOptions!!}';
            broadcasts = '{!!$broadcast_options!!}';
            listGroups = '{!!$listGroups!!}';
            dates_arr = {!!$dates!!};
            select_id = this.id;
            string_id = select_id.substring(18);
            hd = 'hd_' + string_id;
            div_class = 'value_' + string_id;
            select_condition = '#select_condition_' + string_id;
            $('.' + div_class).addClass(hd);
             if (this.value === 'mobile') {
                div = '<div class="' + div_class + '" >\n' +
                    '<input  type="tel" name="values[]"  class="form-control mobile">\n' +
                    '</div>';
                $('.' + div_class).after(div);
                $('.' + hd).remove();
                 conditions = '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n' +
                     "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n" +
                     '<option value="contains">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n' +
                     '<option value="does_not_contain">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>';
                 $(select_condition).children().remove();
                 $(select_condition).append(conditions);
                var elm = $(".mobile").intlTelInput({
                    placeholderNumberType: "MOBILE",
                    separateDialCode: true,
                    utilsScript: '{{ URL("/themes/default/js/includes/utils.js") }}'
                });
            }
             else if (this.value === 'country')
             {
                conditions = '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n' +
                    "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n";
                $(select_condition).children().remove();
                $(select_condition).append(conditions);
                div = '<div class="' + div_class + '" >\n' +
                    countries +
                    '</div>';
                $('.' + div_class).after(div);
                $('.' + div_class+' select').multiselect({'rebuild':true, includeSelectAllOption: true});
                $('.' + hd).remove();
            }
            else if (this.value=='lists')
            {
                    options = lists;
                mselectId = 'm_select_'+string_id;
                listSelect = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false" data-placeholder="Select Lists">';
                div = '<div class="' + div_class + '" >\n' +
                    listSelect+ options +'</select>';
                    '</div>';
                $('.' + div_class).replaceWith(div);
                $('#'+mselectId).multiselect({'rebuild':true, includeSelectAllOption: true});
                $('.' + hd).remove();
            }
            else if (this.value=='groups')
            {
                options = listGroups;
                mselectId = 'm_select_'+string_id;
                listSelect = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false" data-placeholder="Select {{trans('Groups')}}">';
                div = '<div class="' + div_class + '" >\n' +
                    listSelect+ options +'</select></div>';
                $('.' + div_class).replaceWith(div);
                $('#'+mselectId).multiselect({'rebuild':true, includeSelectAllOption: true});
                $('.' + hd).remove();
            }
            else
            {
                if(dates_arr.includes(this.value))
                {
                    conditions = '<option value="">{{ trans('dynamic_tags.form.model.filter_placeholder.select_an_option') }}</option>\n' +
                        '<option value="after">{{ trans('segments.form.filter_dropdown_option_after') }}</option>\n' +
                        '<option value="before">{{ trans('segments.form.filter_dropdown_option_before') }}</option>\n' +
                        '<option value="exactly">{{ trans('segments.form.filter_dropdown_option_exactly') }}</option>\n' +
                        '<option value="between">{{ trans('segments.form.filter_dropdown_option_between') }}</option>\n' +
                        '<option value="occurred_before">{{ trans('segments.form.filter_dropdown_option_occurring_before') }}</option>\n' +
                        '<option value="occurred_after">{{ trans('dynamic_tags.form.model.filter_option.opt_occurred_after') }}</option>\n' +
                        '<option value="for_the_past">{{ trans('segments.form.filter_dropdown_option_for_the_past') }}</option>\n' +
                        '<option value="older_than">{{ trans('segments.form.filter_dropdown_option_older_than') }}</option>';
                    $(select_condition).children().remove();
                    $(select_condition).append(conditions);
                }
                else {
                    fv  = this.value;
                    if(optionsArr[fv]!==undefined)
                    {
                        conditions = '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>';
                        $(select_condition).children().remove();
                        $(select_condition).append(conditions);
                        options_ = optionsArr[fv];
                        if(options_.includes('<optgroup'))
                        {
                            mselectId = 'm_select_'+string_id;
                            listSelect = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false">';
                            div = '<div class="' + div_class + '" >\n' +
                                listSelect+ options_ +'</select></div>';
                            $('.' + div_class).after(div);
                            $('.' + div_class+' select').multiselect({'rebuild':true, includeSelectAllOption: true});
                            $('.' + hd).remove();
                        }
                        else{
                            val_options = '<select class="select_23 m-select2 form-control"  name="values[]">';
                            val_options +=options_;
                            div = '<div class="' + div_class + '" >\n'+val_options +'</select>\n'+
                                '</div>';
                            $('.' + div_class).replaceWith(div);
                            $('.select_23').select2();
                        }
                    }
                    else {
                        if (numbersArr.includes(this.value)) {
                            conditions = '<option value="equal">{{ trans('dynamic_tags.form.model.filter_option.equal') }}</option>\n' +
                                "<option value=\"not_equal\">{!! trans('dynamic_tags.form.model.filter_option.not_equal') !!}</option>\n" +
                                '<option value="greater_than">{{ trans('dynamic_tags.form.model.filter_option.greater_than') }}</option>\n' +
                                '<option value="greater_and_equal">{{ trans('dynamic_tags.form.model.filter_option.greater_and_equal') }}</option>'+
                                '<option value="lesser_than">{{ trans('dynamic_tags.form.model.filter_option.lesser_than') }}</option>'+
                                '<option value="lesser_and_equal">{{ trans('dynamic_tags.form.model.filter_option.lesser_and_equal') }}</option>'+
                                '<option value="first_char">{{ trans('dynamic_tags.form.model.filter_option.first_char') }}</option>\n'+
                                '<option value="contains">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n' +
                                '<option value="does_not_contain">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>';
                            $(select_condition).children().remove();
                            $(select_condition).append(conditions);
                            div = '<div class=" ' + div_class + '" >\n' +
                                '<input  type="number" class="form-control textsystem" placeholder="Number Field" name="values[]">\n' +
                                '</div>';
                            $('.' + div_class).after(div);
                            $('.' + hd).remove();
                        } else {
                            conditions = '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n' +
                                "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n" +
                                '<option value="contains">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n' +
                                '<option value="does_not_contain">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>';
                            $(select_condition).children().remove();
                            $(select_condition).append(conditions);
                            div = '<div class=" ' + div_class + '" >\n' +
                                '<input  type="text" class="form-control textsystem" placeholder="Text Field" name="values[]">\n' +
                                '</div>';
                            $('.' + div_class).after(div);
                            $('.' + hd).remove();
                        }
                    }
                }
            }
        });

        // add Unit Rules
        function showRow(id) {
            var id_c = null;
            vall = $('.select_2').val();
            local_id = localStorage.getItem("id");
            if (local_id !== null)
                id = parseInt(local_id);
            id_ = id + 1;
            localStorage.setItem("id", id_);
            current_div_id = '#row_' + id;
            next_div_id = '#row_' + id_;
            row_id = 'row_' + id_;
            select_field_id = 'select_field_' + id_;
            select_field_name_id = 'select_field_name_' + id_;
            select_condition_id = 'select_condition_' + id_;
            value_class = 'value_' + id_;
            showR = "showRow(" + id_ + ")";
            hideR = "hideRow('" + next_div_id + "')";
            div = '<div class="form-group row mb0" id="' + row_id + '">\n' +
                '<div class="col-md-12">\n' +
                '<label class="col-form-label">{{trans('dynamic_tags.form.model.label.unit_rules')}}</label>\n' +
                '<div data-repeater-list="unit_rules">\n' +
                '<div class="mt-repeater">\n' +
                '<div data-repeater-item="">\n' +
                '<div data-repeater-item="" class="mt-repeater-item">\n' +
                '<div class="row mt-repeater-item">\n' +
                '<div class="col-md-3">\n' +
                '<select  id="' + select_field_id + '" class="form-control m-select2 select" name="field[]" data-placeholder="Select an option">\n' +
                '<optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_recipient')}}">\n'+
                '<option value="custom_fields">{{ trans('dynamic_tags.form.model.filter_option.opt_profile') }}</option>\n' +
                '<option value="email">{{ trans('common.label.email_address') }}</option>\n' +
                '<option value="member_of">{{ trans('dynamic_tags.form.model.filter_option.opt_member_of') }}</option>\n' +
                '<option value="confirmation">{{ trans('dynamic_tags.form.model.filter_option.opt_confirmation') }}</option>\n' +
                '<option value="created_at">{{ trans('dynamic_tags.form.model.filter_option.opt_created_at') }}</option>\n' +
                '<option value="list_name">{{ trans('dynamic_tags.form.model.filter_option.opt_list_name') }}</option>\n'+
                '</optgroup>\n' +
                '<optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_time_date')}}">\n'+
                '<option value="now">{{ trans('dynamic_tags.form.model.filter_option.opt_now') }}</option>\n' +
                '<option value="today">{{ trans('dynamic_tags.form.model.filter_option.opt_today') }}</option>\n'+
                '<option value="day">{{ trans('dynamic_tags.form.model.filter_option.opt_day_of_month') }}</option>\n'+
                '<option value="day_of_week">{{ trans('dynamic_tags.form.model.filter_option.opt_week') }}</option>\n'+
                '<option value="this_month">{{ trans('dynamic_tags.form.model.filter_option.opt_month') }}</option>\n'+
                '</optgroup>\n'+
                '<optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_broadcast')}}">\n'+
                '<option value="broadcast_name">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_name')}}</option>\n'+
                '<option value="broadcast_creation">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_creation')}}</option>\n'+
                '<option value="broadcast_group">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_group')}}</option>\n'+
                '<option value="broadcast_subject">{{trans('dynamic_tags.form.model.filter_option.opt_broadcast_subject')}}</option>\n'+
                '<option value="broadcast_attachment">{{trans('dynamic_tags.form.model.filter_option.opt_attachment')}}</option>\n'+
                '</optgroup>\n'+
                '<optgroup label="{{trans('dynamic_tags.form.model.filter_option.opt_group_schedule_details')}}">\n'+
                '<option value="sch_label">{{trans('dynamic_tags.form.model.filter_option.opt_schedule')}}</option>\n'+
                '<option value="camp_type">{{trans('dynamic_tags.form.model.filter_option.opt_campaign_type')}}</option>\n'+
                '<option value="aud_type">{{trans('dynamic_tags.form.model.filter_option.opt_audience_type')}}</option>\n'+
                '</optgroup>\n'+
                '</select>\n' +
                '</div>\n' +
                '<div class="col-md-3">\n' +
                '<select  id="' + select_field_name_id + '" class="form-control m-select2 select_2" name="field_name[]">\n' +
                '{!! $custom_fields_opt !!}' +
                '</select>\n' +
                '</div>\n' +
                '<div class="col-md-2">\n' +
                '<select  id="' + select_condition_id + '" name="condition[]" class="form-control m-select2 select_3" data-placeholder="{{ trans('dynamic_tags.form.model.filter_placeholder.select_an_option') }}">\n' +
                '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n' +
                "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n" +
                '<option value="contains">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n' +
                '<option value="does_not_contain">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>\n' +
                '</select>\n' +
                '</div>\n' +
                '<div class="col-md-3">\n' +
                '<div class="col_4 ' + value_class + '" >\n' +
                '<input  type="text" class="form-control textsystem" placeholder="Text Field" name="values[]">\n' +
                '</div>\n' +
                '</div>\n' +
                '<div class="col-md-1">\n' +
                '<a href="javascript:;" onclick="' + hideR + '" class="btn hr btn-danger btn-icon btn-sm">\n' +
                '<i class="la la-close"></i>\n' +
                '</a>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>\n' +
                '</div>';
            $(current_div_id).after(div);
            $(next_div_id).hide();
            $(next_div_id).slideDown('slow');
            $('#'+select_field_name_id).change();
            $('.m-select2').select2({
                templateResult: function (data, container) {
                    if (data.element) {
                        $(container).addClass($(data.element).attr("class"));
                    }
                    return data.text;
                }
            });
            $('.selected').each(function (i, obj) {
                selected = obj.selected;
                if (selected)
                    id_c = obj.getAttribute('cf');
                if (i !== 0) {
                }
            });
        }

        // hide Unit Rules
        function hideRow(id) {
            $(id).slideUp('slow');
            setTimeout(function () {
                $(id).empty();
            }, 1000);
        }

        // select first dropdown in unit rules
        $(document).on('change', '.select', function () {
            conditions = "<option value=\"{{ trans('dynamic_tags.form.model.filter_option.is') }}\">{{ trans('segments.form.filter_dropdown_option_is') }}</option>\n" +
                "<option value=\"is_not\">{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}</option>\n" +
                "<option value=\"{{ trans('dynamic_tags.form.model.filter_option.contains') }}\">{{ trans('segments.form.filter_dropdown_option_contains') }}</option>\n" +
                "<option value=\"does_not_contain\">{{ trans('dynamic_tags.form.model.filter_option.does_not_contain') }}</option>";
            var id_c = null;
            select_value = this.value;
            select_id = this.id;
            custom_fields = '{!!$custom_fields_opt!!}';
            broadcasts = '{!!$broadcast_options!!}';
            date = '{!!$date_options!!}';
            string_id = select_id.substring(13);
            select_field_name = '#select_field_name_' + string_id;
            select_condition = '#select_condition_' + string_id;
            div_class = 'value_' + string_id;
            hd = 'hd_' + string_id
            $('.' + div_class).addClass(hd);
            div = '<div class=" ' + div_class + '" >\n' +
                '<input  type="text" class="form-control textsystem" placeholder="Text Field" name="values[]">\n' +
                '</div>';
            $('.' + div_class).after(div);
            $('.' + hd).remove();
            $(select_field_name).removeClass('dt');
            if (select_value == 'custom_fields')
                options = custom_fields;
            else if (select_value == 'member_of') {
                options = '<option selected value="lists">{{ trans('common.label.contact_lists') }}</option>\n' +
                    '<option value="groups">{{ trans('dynamic_tags.form.model.filter_option.opt_group') }}</option>' ;
                conditions = '';
            }
            else if (['email','confirmation'].includes(select_value)) {
                if(select_value=='confirmation') {
                    val_options = '<select class="select_2_1 m-select2 form-control"  name="values[]">';
                    conditions = '<option value="is">' + '{{ trans('segments.form.filter_dropdown_option_is') }}' + '</option>';
                    val_options += '<option selected value="1">Confirmed</option>\n'+
                        '<option value="0">Unconfirmed</option>';

                    div = '<div class="' + div_class + '" >\n'+val_options +'</select>\n'+
                        '</div>';
                    $('.' + div_class).replaceWith(div);
                    $('.select_2_1').select2();
                }
                options ='';
            }
            else if(['now','today','day','day_of_week','this_month'].includes(select_value)) {
                options ='';
                if(select_value=='now') {
                    conditions = '<option value="between">{{ trans('segments.form.filter_dropdown_option_between') }}</option>';
                    from_id = 'from_' + string_id;
                    to_id = 'to_' + string_id;
                    div = '<div class="' + div_class + '" >\n' +
                        '<div class="input-group date form_datetime bs-datetime" id="datetimepicker-geo" data-date="" data-date-format="yyyy-mm-dd">\n' +
                        '<div class="input-daterange input-group dategroupmap">\n' +
                        '<input id="' + from_id + '"  type="text" class="form-control" readonly name="values[]" placeholder="From">\n' +
                        '<div class="input-group-append"><span class="input-group-text"><i class="la la-ellipsis-h"></i></span></div>\n' +
                        '<input id="' + to_id + '" type="text" class="form-control" readonly name="values[]" placeholder="To">\n' +
                        '</div>\n' +
                        '</div>\n' +
                        '</div>';
                    $('.' + div_class).replaceWith(div);
                    $('#' + from_id + ', #' + to_id).timepicker({
                        defaultTime: '',
                        showMeridian: false,
                        snapToStep: true
                    });
                    $('.' + div_class).addClass(hd);
                }
                else if(select_value=='today')
                    conditions = '<option value="exactly">{{ trans('segments.form.filter_dropdown_option_is') }}</option>';
                else{
                    conditions = '<option value="is">{{ trans('segments.form.filter_dropdown_option_is') }}</option>';
                    mselectId = 'm_this_select_'+string_id;
                    val_options = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false"><optgroup label="Select all">';
                    if(select_value=='day') {
                        val_options = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false"><optgroup label="Date of month">';
                        val_options += '<option value="01">01</option><option value="02">02</option><option value="03">03</option> <option value="04">04</option> <option value="05">05</option><option value="06">06</option><option value="07">07</option><option value="08">08</option><option value="09">09</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option><option value="21">21</option><option value="22">22</option><option value="23">23</option><option value="24">24</option><option value="25">25</option><option value="26">26</option><option value="27">27</option><option value="28">28</option><option value="29">29</option><option value="30">30</option><option value="31">31</option>';
                    } else if(select_value=='day_of_week') {
                        val_options = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false"><optgroup label="Days of week">';
                        val_options += '<option value="7">Sunday</option><option value="1">Monday</option><option value="2">Tuesday</option><option value="3">Wednesday</option><option value="4">Thursday</option><option value="5">Friday</option><option value="6">Saturday</option>';
                    }
                    else{
                        val_options = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false"><optgroup label="Months">';
                    val_options += '<option value="1">January</option>\n'+
                    '<option value="2">February</option>\n'+
                    '<option value="3">March</option>\n'+
                    '<option value="4">April</option>\n'+
                    '<option value="5">May</option>\n'+
                    '<option value="6">June</option>\n'+
                    '<option value="7">July</option>\n'+
                    '<option value="8">August</option>\n'+
                    '<option value="9">September</option>\n'+
                    '<option value="10">October</option>\n'+
                    '<option value="11">November</option>\n'+
                    '<option value="12">December</option>';
                    }
                    div = '<div class="' + div_class + '" >\n'+val_options +'</optgroup> </select>\n'+
                    '</div>';
                    $('.' + div_class).replaceWith(div);
                    $('#'+mselectId).multiselect({'rebuild':true, includeSelectAllOption: true});
                    $('.' + hd).remove();
                }


            }
            else if(['broadcast_name','broadcast_subject','sch_label','list_name'].includes(select_value))
            {
                options = '';
                conditions = '<option value="is">' + '{{ trans('segments.form.filter_dropdown_option_is') }}' + '</option>\n'+
                    "<option value=\"is_not\">" + "{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}" + "</option>\n"+
                    '<option value="contains">' + '{{trans('segments.form.filter_dropdown_option_contains')}}' + '</option>\n'+
                    '<option value="does_not_contain">' + '{{trans('dynamic_tags.form.model.filter_option.does_not_contain') }}' + '</option>';
            }
            else if(['camp_type','aud_type'].includes(select_value))
            {
                val_options = '<select class="select_2222 m-select2 form-control"  name="values[]">';
                if(select_value=='camp_type')
                    val_options += '<option value="campaigns">' + '{{ trans('dynamic_tags.form.model.filter_option.opt_broadcast') }}' + '</option>\n' +
                        '<option value="split_list">' + '{!! trans('dynamic_tags.form.model.filter_option.opt_split_list') !!}' + '</option>';
                else
                    val_options += '<option value="segment">' + '{{ trans('dynamic_tags.form.model.filter_option.opt_segment') }}' + '</option>\n' + '<option value="subscriber">' + '{{trans('common.label.contact_lists')}}' + '</option>';
                conditions = '<option value="is">' + '{{ trans('segments.form.filter_dropdown_option_is') }}' + '</option>\n' +
                    "<option value=\"is_not\">" + "{!!trans('dynamic_tags.form.model.filter_option.is_not')!!}" + "</option>";
                div = '<div class="' + div_class + '" >\n'+val_options +'</select>\n'+
                    '</div>';
                $('.' + div_class).replaceWith(div);
                $('.select_2222').select2();
                options = '';

            }
            else if(select_value=='broadcast_attachment')
            {
                options = '';
                val_options = '<select class="select_222 m-select2 form-control"  name="values[]">';
                val_options += '<option selected value="1">Yes</option>\n'+
                    '<option value="0">No</option>\n';
                conditions = '<option value="has">{{ trans('dynamic_tags.form.model.filter_option.has_attachment') }}</option>\n';
                div = '<div class="' + div_class + '" >\n'+val_options +'</select>\n'+
                    '</div>';
                $('.' + div_class).replaceWith(div);
                $('.select_222').select2();
            }
            else if(select_value=='broadcast_group')
            {
                conditions = '<option value="is">'+'{{ trans('segments.form.filter_dropdown_option_is') }}'+'</option>\n' +
                    "<option value=\"is_not\">"+"{!! trans('dynamic_tags.form.model.filter_option.is_not') !!}"+"</option>";
                options = ''
                mselectId = 'm_select_'+string_id;
                slect = '<select id="'+mselectId+'" class="mt-multiselect btn btn-default form-control" multiple="multiple" data-label="left" name="values[]" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="false" data-placeholder="Select Groups"><optgroup label="Groups">'
                div = '<div class="' + div_class + '" >\n' +slect+broadcasts+'</select>';
                '</div>';
                $('.' + div_class).replaceWith(div);
                $('#'+mselectId).multiselect({'rebuild':true, includeSelectAllOption: true});
                $('.' + hd).remove();
            }
            else {
                options = date;
                $(select_field_name).addClass('dt');
                conditions =
                    '<option selected value="after">{{ trans('segments.form.filter_dropdown_option_after') }}</option>\n' +
                    '<option value="before">{{ trans('segments.form.filter_dropdown_option_before') }}</option>\n' +
                    '<option value="exactly">{{ trans('segments.form.filter_dropdown_option_exactly') }}</option>\n' +
                    '<option value="between">{{ trans('segments.form.filter_dropdown_option_between') }}</option>\n' +
                    '<option value="occurred_before">{{ trans('segments.form.filter_dropdown_option_occurring_before') }}</option>\n' +
                    '<option value="occurred_after">{{ trans('dynamic_tags.form.model.filter_option.opt_occurred_after') }}</option>\n' +
                    '<option value="for_the_past">{{ trans('segments.form.filter_dropdown_option_for_the_past') }}</option>\n' +
                    '<option value="older_than">{{ trans('segments.form.filter_dropdown_option_older_than') }}</option>';
            }
            $(select_condition).parent().show();
            $(select_field_name).parent().show();
            if (options !== undefined) {
                $(select_field_name).children().remove();
                $(select_condition).children().remove();
                $(select_condition).append(conditions);
                if(select_value !== 'list')
                $(select_field_name).append(options);
                if(['member_of'].includes(select_value)) {
                    $(select_condition).parent().hide();
                    $(select_field_name).trigger('change');
                }
                else if(['confirmation','email','created_at','now','today','day','day_of_week','this_month','broadcast_group','broadcast_creation','broadcast_name','broadcast_subject','broadcast_attachment','sch_label','camp_type','aud_type','list_name'].includes(select_value))
                {
                    $(select_field_name).parent().hide();
                    $(select_condition).trigger('change');
                }
            }
            $('.selected').each(function (i, obj) {
                selected = obj.selected;
                if (selected)
                    id_c = obj.getAttribute('cf');
                if (i !== 0) {
                }
            });

        });


        function validate(evt) {
            var theEvent = evt || window.event;
            if (theEvent.type === 'paste') {
                key = event.clipboardData.getData('text/plain');
            } else {
                var key = theEvent.keyCode || theEvent.which;
                key = String.fromCharCode(key);
            }
            if(key.length>0)
                $("#tag_name").css("border-color", "");
            var regex = /[a-z0-9--]|\./;
            if( !regex.test(key) ) {
                theEvent.returnValue = false;
                if(theEvent.preventDefault) theEvent.preventDefault();
            }
        }
            $("#else-switch").click(function () {
                var checkBoxes = $("#else-switch").is(':checked');
                console.log(checkBoxes);
                if(checkBoxes === true) {
                    $("#else-switch").val("1");
                    $(".else-portion").slideDown();
                } else{
                    $("#else-switch").val("0");
                    $(".else-portion").slideUp();
                }
            });

            (function($) {
                $.fn.inputFilter = function(inputFilter) {
                    return this.on("{{trans('dynamic_tags.form.alert_message.keydown_keyup')}} ", function() {
                    if (inputFilter(this.value)) {
                        this.oldValue = this.value;
                        this.oldSelectionStart = this.selectionStart;
                        this.oldSelectionEnd = this.selectionEnd;
                    } else if (this.hasOwnProperty("oldValue")) {
                        this.value = this.oldValue;
                        this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                    } else {
                        this.value = "";
                    }
                    });
                };
            }(jQuery));
            $("#tag_name2").inputFilter(function(value) { return /^[a-z0-9--]*$/i.test(value); });

            $(".m-select2").select2({
                placeholder: "Select an option",
                class: "select",
                allowClear: true,
                templateResult: function (data, container) {
                    if (data.element) {
                        $(container).addClass($(data.element).attr("class"));
                    }
                    return data.text;
                }
            });
            $("#datesystem").datepicker({
                format: 'yyyy-mm-dd',
                //endDate: '+0d',
                autoclose: true
            }).datepicker();
            $("input.from").datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true
            }).datepicker();
            $("input.to").datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true
            }).datepicker();
            $('#content_name').keypress(function (e) {
                if (e.which === 32)
                    return false;
            });
            $('#content_name').keyup(function () {
                var yourInput = $(this).val();
                re = /[`~!@#$%^&*()_|+\-=?;:'",.<>\{\}\[\]\\/]/gi;
                var isSplChar = re.test(yourInput);
                if (isSplChar) {
                    var no_spl_char = yourInput.replace(/[`~!@#$%^&*()|+\_=?;:' ",.<>\{\}\[\]\\/]/gi, '');
                    $(this).val(no_spl_char);
                }
            });


        var dynamic_id = 0;

        function changeselect2() {

            dynamic_id++;
            window.setTimeout(function () {
                $(".select-change").last().attr('id', 'main_opt_' + dynamic_id);
                $("#main_opt_" + dynamic_id).select2({
                    placeholder: "Select Option",
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });
                $(".select-change2").last().attr('id', 'main_opt2_' + dynamic_id);
                $("#main_opt2_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });

                $(".select-change3").last().attr('id', 'main_opt3_' + dynamic_id);
                $("#main_opt3_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });

                $(".select-change4").last().attr('id', 'main_opt4_' + dynamic_id);
                $("#main_opt4_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });

                $(".select-change5").last().attr('id', 'main_opt5_' + dynamic_id);
                $("#main_opt5_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });

                $(".select-change6").last().attr('id', 'main_opt6_' + dynamic_id);
                $("#main_opt6_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });

                $(".select-change7").last().attr('id', 'main_opt7_' + dynamic_id);
                $("#main_opt7_" + dynamic_id).select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });
            }, 100);
        }

        // select system variable & additional variable
        function selectProfileField(field, ckeditor_id) {
            field = '%%pf_'+field+'%%';
            if($('#_format_html').is(':checked'))
                CKEDITOR.instances[ckeditor_id].insertHtml(field);
            else {
                c_text = $('#content_html').val();
                $('#content_html').val(c_text+field);
            }
        }
        function selectTag(field, ckeditor_id) {
            if (field == 'Unsubscribe Link')
                field = '<a href="%%unsubscribelink%%">{{trans('common.label.unsubscribe')}}</a>';
            else if (field == 'Confirm Link')
                field = '<a href="%%confirmurl%%">{{trans('common.label.confirm')}}</a>';
            else if(field == 'web_version')
                field = '<a href="%%web_version%%">{{trans('broadcasts.edit.form.editor.web_version')}}</a>';
            else if(field == 'rss_link')
                field = '<a href="%%rss_link%%">Read More</a>';
            else
                field = '%%' + field + '%%';
            if($('#_format_html').is(':checked'))
                CKEDITOR.instances[ckeditor_id].insertHtml(field);
            else {
                c_text = $('#content_html').val();
                $('#content_html').val(c_text+field);
            }
        }
        function replaceVariable(ckeditor_id,selectID){
            var field = $("#"+selectID).val();
            if(field!=""){
                if(selectID=='spintags_variables'){
                    selectSpintag(field, ckeditor_id)
                }
                else if(selectID=='dynamic_content_variables'){
                    field = "[["+field+"]]";
                    selectDynamicContent(field, ckeditor_id)
                }
                else if(selectID=='profile_fields')
                {
                    selectProfileField(field, ckeditor_id);
                }
                else{
                    selectTag(field, ckeditor_id);
                }
                setTimeout(function() {
                     $("#"+selectID).val(null).trigger('change.select2');
                }, 300);
            }

        }

        // select spintag
        function selectSpintag(spintag, ckeditor_id) {
            spintag = '{' + '{' + spintag + '}' + '}';
            if($('#_format_html').is(':checked'))
                CKEDITOR.instances[ckeditor_id].insertText(spintag);
            else {
                c_text = $('#content_html').val();
                $('#content_html').val(c_text+spintag);
            }
        }

        // select dynamic content tag
        function selectDynamicContent(dynamic_content, ckeditor_id) {
            dynamic_content = dynamic_content;
            CKEDITOR.instances[ckeditor_id].insertText(dynamic_content);
        }

        $('#copy-email').click(function () {
            var content_html = CKEDITOR.instances['content_html'].getSnapshot();
            var regex = /(<([^>]+)>)/ig
            var content = $.trim(content.replace(regex, ""));
            $('#content_text').html(content);
        });
    </script>
    <script>
        $('#content-unit-frm').submit(function () {
            CKEDITOR.instances.content_html.updateElement();
            var form_data = $("#content-unit-frm").serialize();
            $.ajax({
                url: "{{ URL::route('dynamictag.content.unit') }}",
                type: 'POST',
                data: form_data,
                success: function (result) {
                    $('#unit-of-content').modal('hide'),
                        $("#appendata").html(result);
                }
            });
            return false;
        });
        function GetAllProperties() {
            $.ajax({
                url: "{{ URL::route('dynamictag.content.unit') }}",
                type: 'Delete',
                data: {delete_action: 'delete_all'},
                success: function (result) {
                }
            });
        }

        function EditBlock(id, action_type) {
            $.ajax({
                url: "{{ URL::route('dynamictag.content.unit') }}",
                type: 'GET',
                data: {type: 'edit_form_data', content_id: id, action: action_type},
                dataType: "JSON",
                success: function (response) {
                    var unit_content = JSON.parse(response.data);
                    if (unit_content.is_default == 1) {
                        $('.default-checkbox').prop('checked', true);
                    }
                    $('#label').val(unit_content.label);
                    $('#id').val(unit_content.id);
                    CKEDITOR.instances.content_html.setData(unit_content.content_html);
                    $("#append-rules").html(response.html);
                    $("#unit-of-content").modal('show');
                }
            });
        }

        function DeleteBlock(id, action_type, dynamic_content_id) {
            $.ajax({
                url: "{{ URL::route('dynamictag.content.unit') }}",
                type: 'Delete',
                data: {content_id: id, action_type: action_type, dynamic_content_value: dynamic_content_id},
                success: function (result) {
                    $("#appendata").html(result);
                }
            });
        }

        // cleae modal values on close
        $('#unit-of-content').on('hidden.bs.modal', function () {
            $('.modal-body').find('#label,#id,#unit-rule-condition').val('');
            $(".modal-body").find('input:checkbox').prop('checked', false);
            $(".modal-body").find("option:selected").removeAttr("selected");
            CKEDITOR.instances.content_html.setData('');
        });
    </script>
    <script type="text/javascript">
        var txt,html;
        var KTFormRepeater = function () {
            var demo1 = function () {
                $('#kt_repeater_3').repeater({
                    initEmpty: false,

                    defaultValues: {
                        'text-input': 'foo'
                    },

                    show: function () {
                        $(this).slideDown();
                    },

                    hide: function (deleteElement) {
                        if (confirm('{{ trans('common.message.delete_warning')}}')) {
                            $(this).slideUp(deleteElement);
                        }
                    }
                });
            }
            return {
                init: function () {
                    demo1();
                }
            };
        }();

        jQuery(document).ready(function () {
            KTFormRepeater.init();
            window.setTimeout(function () {
                $("#main_opt, #main_opt2, #main_opt3,#main_opt4, #main_opt5, #main_opt6, #main_opt7").select2({
                    templateResult: function (data, container) {
                        if (data.element) {
                            $(container).addClass($(data.element).attr("class"));
                        }
                        return data.text;
                    }
                });
            }, 100);
        });

        function CKupdate() {
            for (instance in CKEDITOR.instances) {
                CKEDITOR.instances[instance].updateElement();
                CKEDITOR.instances[instance].setData('');
            }
        }

        function createOrUpdate(method, route, formId, rules, messages) {
            $('.listo').attr('disabled', false);
                    var rules_ = document.getElementsByClassName("rules");
                    for (var i = 0; i < rules_.length; i++) {

                    }
                    return;
                    data = $(formId).serialize()+'rules='+rules;
                    $.ajax({
                        type: method,
                        url: route,
                        data: data,
                        cache: false,
                        dataType: 'json',
                        beforeSend: function () {
                            //$("#preloader").show();
                        },
                        success: function (data) {

                            if (data.status) {
                                $('#modal-group-label').hide();
                                toastr.success(data.message);
                                $("#select_field_1").val(null).trigger('change');
                                $("#select_field_name_1").val(null).trigger('change');
                                $("#select_condition_1").val(null).trigger('change');
                                CKupdate();
                                // if(method=='POST') {
                                // $(formId).trigger("reset");
                                setTimeout(function () {
                                    window.location = "{{route('dynamictag.index')}}";
                                }, 1500);
                                // }
                            } else
                                toastr.error(data.message);
                            return false;
                        }
                    });
                    $('.listo').attr('disabled', false);
                    $('.selected').each(function (i, obj) {
                        selected = obj.selected;
                        if (selected)
                            id_c = obj.getAttribute('cf');
                        if (i !== 0) {

                        }
                    });


        }
        function testing() {
            tag_name = $('#tag_name').val();
            description = $('#description').val();
            $('#description').css("border-color", "#bec4d0");
            var regexp = /^[a-zA-Z0-9-_]+$/;
            if (tag_name.search(regexp) === -1)
            {
                $("#tag_name").css("border-color", "red");
                Command: toastr["error"] ("{{trans('dynamic_tags.form.error_message.tag_alphanumeric')}}");
                return false;
            }

            $(".blockUI").show();
            var rules_ = document.getElementsByClassName("rule");
            var arr = [];
            for (var i = 0; i < rules_.length; i++) {
                arr[i] = rules_.item(i).value;
            }
            var dyn_id = $('#dynamic_tag_id').val();
            $.ajax({
                type: 'POST',
                url: '{{route('dynamictag.store')}}',
                data: {arr,'name':tag_name,'id':$('#dynamic_tag_id').val(),'return_content':$("input[name=return_content]:checked").val(),'description':$('#description').val()},
                cache: false,
                dataType: 'json',
                beforeSend: function () {
                    //$("#preloader").show();
                },
                success: function (data) {
                    $(".blockUI").hide();
                    if (data.status) {
                        $('#modal-group-label').hide();
                        toastr.success(data.message);
                        $("#select_field_1").val(null).trigger('change');
                        $("#select_field_name_1").val(null).trigger('change');
                        $("#select_condition_1").val(null).trigger('change');
                        CKupdate();
                        if(dyn_id==0 || dyn_id>0)
                        setTimeout(function () {
                            window.location = "{{route('dynamictag.index')}}";
                        }, 1500);
                    } else
                        toastr.error(data.message);
                    return false;
                }, error: function () {
                    $('.blockUI').hide();
                }
            });
        }

        $('#tag_name').on('keyup keyup change', function(e) {
            tag  = $(this).val();
            var regexp = /^[a-zA-Z0-9-_]+$/;
            if (tag.search(regexp) === -1)
                $("#tag_name").css("border-color", "red");
            else
                $("#tag_name").css("border-color", "");
        });
        $('#rule_name').on('keyup keyup change', function(e) {
            ruleName  = $(this).val();
            if (ruleName.length == 0)
                $(this).css("border-color", "red");
            else
                $(this).css("border-color", "");
        });
        $('input[type=radio][name=_format]').change(function() {
            if (this.value == 'html') {
                $('.content_title').html('{{trans('dynamic_tags.form.model.label.html_body')}}');
               txt = $('#content_html').val();
                try {
                    editor.destroy();
                    data = $('#content_html').val();
                    editor = CKEDITOR.replace('content_html', {
                        fullPage: true,
                        allowedContent: true,
                        height: 150
                    });
                    CKEDITOR.instances['content_html'].setData(html);
                }
                catch (e) {

                }
            }
            else {
                $('.content_title').html('{{trans('dynamic_tags.form.model.label.text_body')}}');
                try {
                    html = CKEDITOR.instances['content_html'].getData();
                }
                catch (e) {

                }
                editor.setData('');
                editor.destroy();
                $('#content_html').val(txt);

            }
        });
    </script>

@endsection
