@extends(decide_template())

@section('title',  $pageTitle)

@section('page_styles')
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<style>
    #package tr th:first-child, #package tr td:first-child {
        padding: 10px 12px;
        text-align: center;
        max-width: 40px;
        width: 5%;
    } 
    #package tr th:last-child, #package tr td:last-child {
        padding: 10px 12px;
        text-align: center;
        max-width: 200px;
        width: 10%;
    } 
    .table>thead>tr>th:first-child, .table>tbody>tr>td:first-child {
        max-width: 40px;
        text-align: center;
        width: 4% !important;
    }
    #package tr th, #package tr td {
        text-align: center !important;
        padding: 12px 6px !important;
        min-width: 150px;
        max-width: 250px;
    }
    #package tr th:nth-child(2), #package tr td:nth-child(2) {
        text-align: left !important;
        max-width: 350px;
        min-width: 250px;
        white-space: normal !important;
        word-break: break-all !important;
    }
    ul.no-list {
        list-style-type: none;
        padding-left: 20px !important;
    }
    #assignedAssets ul {
        padding-left: 30px;
    }
    #assignedAssets, #assignedAssets>.row {
        width: 100%;
        margin: 0 !important;
    }
    #package tr th:first-child, #package tr td:first-child, #package tr th:last-child, #package tr td:last-child {
        min-width: 60px;
        max-width: 100px;
    }
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
<script>
    $(document).ready(function() {

        $('#new_id').live('change',function (){
            val =  $('#new_id').val();
            if(val=="")
                $('#deleteItem').hide();
            else
                $('#deleteItem').show();
        });

        $('#deleteItem').live('click',function (){
            
            new_id = $('#new_id').val();
            old_id = $('#old_id').val();
         //   alert(old_id);
          //  alert(new_id);
            $('#new_id-error').html('').hide();
            $(".blockUI").show();
            $.ajax({
                url: "{{ url('/') }}"+'/client/package/existing/delete/'+new_id+'/'+old_id,
                type: "GET",
                success: function(result) {
                    if(result == 'deleted') {
                        $(".blockUI").hide();
                        $("#modal-delete").modal("hide");
                        Command: toastr["success"] ("{{trans('user_management.view.success_confirmation.success_description')}}");
                        setTimeout(() => {
                            location.reload();
                        }, 1000);
                    }
                }
            });
        });
            
        $("a#help-article").css("display", "block");
        $("a#help-article").attr("href", "https://support.mumara.com/hc/articles/1/11/33/packages");

         // function in master2 layout
        var page_limit=show_per_page('','packages_pageLength',10);  // Params (table,page,default_limit=10)
        var table=$('#package').DataTable({
            "columnDefs": [
                { "orderable": false, "targets": [0,4] }
            ],
            "aaSorting": [[3, "desc"]],
            "pageLength" : page_limit,
            "aLengthMenu": [[10,50, 100, 500], [10,50, 100, 500]]
        });
         page_limit=show_per_page(table,'packages_pageLength');
    });

    function packageDelete(id,named) {

        $("#error-msg-upload").html('{!!trans('user_management.packages.modal.alert_message')!!}'.replace(':package',named));
        document.getElementById("get_users_list").innerHTML="";
        document.getElementById("new_id").innerHTML="";
        document.getElementById("new_id").value = "";
        $('#deleteItem').hide();
        
        var return_select="";
        var return_list = "";
    $.get('/client/package/check/users/' + id, function (data) {
        if (data == 'not_exists') {
            Swal.fire({
                title: "{{trans('user_management.view.alert_confirmation.delete_title')}}",
                text: "{{trans('user_management.view.alert_confirmation.delete_description')}}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{trans('dynamic_tags.alert_confirm.button.delete')}}"
            }).then((result) => {
                if (result.isConfirmed) {

                    $("#row_" + id).attr("style", "display:none");

                    $.ajax({
                        url: "{{ url('/') }}" + '/client/package/delete/' + id,
                        type: "DELETE",
                        success: function (result) {
                            if (result == 'delete') {
                                $('#msg').css("display", "flex");
                                $('#msg-text').html('{{trans('common.message.delete')}}');
                                $('#msg').removeClass('display-hide').addClass('alert alert-success');
                                Swal.fire({
                                    title: "{{trans('user_management.view.success_confirmation.success_title')}}",
                                    text: "{{trans('user_management.view.success_confirmation.success_description')}}",
                                    icon: 'success',
                                    showCancelButton: false,
                                    showConfirmButton: false,
                                    buttons: false
                                });
                                setTimeout(function () {
                                    Swal.close()
                                    location.reload();
                                }, 2500);
                            }
                        }
                    });
                }
            });
        }
        else {
            document.getElementById("old_id").value = id;
            $.get('/client/package/get_packages/' + id, function (response) {
               return_select += "<option value=''>Select Package</option>"; 
               for (var x = 0; x < response[0].length; x++) {
                return_select += "<option value="+ response[0][x]['id'] +">"+ response[0][x]['package_name'] + "</option> " + response[0][x]['package_name'] + " </a></li>";
                }
                var selectContainer=document.getElementById("new_id");
                selectContainer.innerHTML=return_select;
            });
           
            $("#modal-delete").modal("show");
             for (var x = 0; x < data[0].length; x++) {
                return_list += "<li><a href=\"#\"><i class=\"fa fa-angle-double-right\"></i> " + data[0][x]['name'] + " </a></li>";
            }
            var listContainer = document.getElementById("get_users_list");
            listContainer.innerHTML = "<ul class='no-list'>" + return_list + "</ul>";
        }
    });
}
</script>
@endsection

@section(decide_content())

<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="aXllqoHx">
    {{ Session::get('msg') }}
</div>
@endif
<div id="msg" class="display-hide" data-name="vVmeccnR">
    <button class="close" data-close="alert"></button>
    <span id='msg-text' class="alert-text"><span>
</div>

@if(!$roles)
<div class="col-md-12" data-name="upleLjiu">
    <div class="note prDomain" data-name="jjEvNAVx">
        <p>
            {{trans('user_management.role.alert_warning.role_not_found')}}
            <a href="{{ route('package.role.create') }}" type="button" class="btn btn-warning btn-sm">{{trans('user_management.role.button.add_new')}} </a>
        </p>
    </div>
</div>
@else
<div class="row" data-name="uhFYxSPT">
    <div class="col-md-12" data-name="BIxOVdSV">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="kt-portlet kt-portlet--height-fluid" data-name="FMsEvEwu">
            <div class="kt-portlet__body" data-name="uJEXGYQl">
                <div class="table-toolbar" data-name="TzHVNfNG">
                    <div class="form-group row" data-name="mCSYtBtb">
                        <div class="col-md-6" data-name="MhKSQPeG">
                           @if(routeAccess('create.package.page'))
                            <div class="btn-group" data-name="GYSSAOoz">
                            <a href="{{ route('client.package.create') }}">
                                <button id="sample_editable_1_new" class="btn btn-label-success">
                                    {{trans('common.form.button.add_new')}} <i class="la la-plus"></i>
                                </button></a>
                            </div>
                           @endif
                        </div>
                    </div>
                </div>
                <div class="table-scrollable">
                    <table class="table table-striped table-hover table-checkable" id="package" role="grid" >
                        <thead>
                            <tr role="row">
                                <th>{{trans('common.label.id')}}</th>
                                <th>{{trans('user_management.packages.view.table_heading.package_name')}}</th>
                                <th>{{trans('user_management.packages.table_headings.user_role')}}</th>
                                <th>{{trans('common.table_heading.created_on')}}</th>
                                <th>{{trans('common.table_heading.actions')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($packages as $index => $package)
                            <tr class="gradeX odd" role="row" id="row_{{ $package->id }}">
                                <td>{{($package->id)}}</td>
                                <td>{{ ($package->package_name)}} </td>
                                <td><?php $roles=DB::table('roles')->where('id',$package->role_id)->select('name')->first();
                                    echo isset($roles->name) ? $roles->name : '---';
                                ?> </td>
                                <td>
                                    <span style="visibility: hidden;">{{ strtotime( $package->created_at)}} </span>
                                    {{ showDateTime(Auth::user()->id, $package->created_at , 1)}} 
                                </td>
                                <td>
                                    <div class="dropdown" data-name="MecCYHSC">
                                        <a class="btn btn-label-success btn-icon btn-sm btn-icon-md" data-toggle="dropdown" aria-expanded="false"><i class="flaticon-more-1"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                                        @if(routeAccess('client.package.edit'))
                                            <li>
                                                <a href="{{ route('client.package.edit', $package->id) }}"> <i class="fa fa-edit icon-size"></i>{{trans('common.form.button.edit')}}</a>
                                            </li>
                                        @endif
                                        @if(routeAccess(246))
                                            <li>
                                                <a href="javascript:;" onclick="packageDelete( {{ $package->id }},'{{ $package->package_name}}' )" id='role-delete'> <i class="fa fa-remove icon-size"></i>{{trans('common.form.button.delete')}} </a>
                                            </li>
                                        @endif
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
@endif


<div class="modal fade" id="modal-delete" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"data-keyboard="false" data-backdrop="static" >
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">{{trans('user_management.packages.modal_heading.dependency_check')}}</h5>
            </div>
            <form id="form-import" action="#" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="alert alert-warning" id="error-msg">
                        <span class="alert-text" id="error-msg-upload">{!!trans('user_management.packages.modal.alert_message')!!}<span>
                    </div>
                    <div class="row" data-name="igUKVYRO">
                        <div class="col-md-12" data-name="jFQSGZuo">
                            <div id="domain-data" data-name="oyaHdXQR">
                                <div class="list-block" data-name="bDplkoVS">
                                    <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">
                                        <div class="col-md-12" data-name="ZKtDemZp">
                                            <label class="col-form-label">{{trans('user_management.packages.modal.label.users')}}</label>
                                            <div id="get_users_list"></div>
                                        </div>
                                    </div>
                                    <div id="unassignedAssets" style="/* display: none; */" class="row" data-name="dhlPjruh">
                                        <div class="col-md-12" data-name="jyMxdqfv">
                                            <label class="col-form-label" id="moveToLabel"></label>
                                            <div class="form-group mb0" data-name="hnTUjGZs">
                                                <small id="new_id-error" class="error invalid-feedback"></small>
                                                <input type="text" id="old_id" name="old_id" hidden>
                                                <select name="new_id" class="form-control m-select2" required data-placeholder="{{trans('user_management.packages.modal.label_placeholder.select_package')}}" id="new_id">
                                                    
                                                 </select>
                                            </div>
                                            <small id="sm">{{trans('user_management.packages.modal.label_placeholder.select_package_description')}} </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer" data-name="lCYRZcBU">
                    <button type="button" class="btn btn-secondary btn-sm pull-left" data-dismiss="modal">{{trans('common.form.button.close')}}</button>
                    <button style="display:none;" type="button" class="btn btn-primary btn-sm pull-right" id="deleteItem">Re-assign and Delete</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection