@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
    <link href="/resources/assets/css/campaign-view.css?v={{$local_version}}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
    <script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/select2.js" type="text/javascript"></script>
    <script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
    <script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/includes/common.js" type="text/javascript"></script>
    <script>
        var objTable;
        var record_type = 'our_records';
        $(document).ready(function() {

            /*         $("a#help-article").css("display", "block");
                     $("a#help-article").attr("href", "https://support.mumara.com/hc/articles/1/8/12/broadcasts");*/

            // function in master2 layout
            var page_limit=show_per_page('','campaign_pageLength',10);  // Params (table,page,default_limit=10)
            var table=$('#campaigns').DataTable({
                "aoColumnDefs": [{"bSortable": false, "aTargets": [0,5]}],
                "bProcessing": true,
                "bServerSide": true,
                "aaSorting": [[4, "desc"]],
                "sPaginationType": "full_numbers",
                "sAjaxSource": "{{ route('getBroadcastTemplates') }}",
                "pageLength" : page_limit,
                "aLengthMenu": [[10, 50, 100, 500], [10, 50, 100, 500]]
            });
            objTable = table;
            page_limit=show_per_page(table,'campaign_pageLength');
        });
        // delete Campaign
        function deleteCampaign(id) {
            if(confirm('{{trans('common.message.alert_delete')}}')) {
                $("#row_"+id).attr("style", "display:none");
                $.ajax({
                    url: "{{ url('/') }}"+'/broadcasts/'+id,
                    type: "DELETE",
                    success: function(result) {
                        if(result == 'delete') {
                            $('#msg').css("display", "flex");
                            $('#msg-text').html('{{trans('common.message.delete')}}');
                            $('#msg').removeClass('display-hide').addClass('alert alert-success ');
                        }
                    }
                });
            }
        }
        // delete selected Campaign
        function deleteAll () {
            if(!$('input:checkbox:checked').length){
                alert('{{trans('common.message.alert_no_record')}}');
                return false;
            }
            if(confirm('{{trans('common.message.alert_delete')}}')) {
                var campaigns = $('input:checkbox:checked').map(function() {
                    return this.value;
                }).get();
                $.ajax({
                    type  : "Delete",
                    url   : "{{ url('/') }}"+'/broadcasts/'+campaigns,
                    data    : {ids: campaigns},
                    success: function(result) {
                        if(result == 'delete') {
                            location.reload();
                        }
                    }
                });

            }
        }
        function changeStatus(id,class_) {
            var enabled_for_users;
            var enabled = $('.'+class_).is(':checked');
            if(enabled)
                enabled_for_users = 1;
            else
                enabled_for_users = 0;
            $.ajax({
                type   : "PUT",
                url    : "{{ route('broadcasts.update','') }}/"+id,
                data: {'change_status': 1,'enabled_for_users':enabled_for_users},
                success: function(result) {
                    $('.blockUI').hide();
                    if(result.status == "success") {
                        Command: toastr["success"](result.message);
                        objTable.draw();
                    }
                    else
                        Command: toastr["error"] (result.message);
                }
            });
        }
        function chooseBuilder(type){
            var template_id =localStorage.getItem('template_id') ? localStorage.getItem('template_id'): 'blank';
            jQuery.ajax({
                type: "POST",
                data:{type:type,template_id:template_id,"is_template":"1"},
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo route("broadcasts.useTemplate"); ?>",
                success: function(data) {
                    if(data.success==1)
                        window.location.href=data.url;
                    else
                        toastr.error(data.message);
                }
            });
        }
    </script>
    @include('includes.view-pages-filter-script')
@endsection

@section(decide_content())
    <!-- will be used to show any messages -->
    @if (Session::has('error'))
        <div class="alert alert-danger" data-name="vjiqgzWI">
            {{ Session::get('error') }}
        </div>
    @endif
    @if (Session::has('msg'))
        <div class="alert alert-success" data-name="vjiqgzWI">
            {{ Session::get('msg') }}
        </div>
    @endif
    <div id="msg" class="display-hide" data-name="xwBJqrix">
        <button class="close" data-close="alert"></button>
        <span id='msg-text' class="alert-text"><span>
    </div>
    <div class="row" data-name="cYpvQbCz">
        <div class="col-md-12" data-name="uHArZwwr">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="kt-portlet kt-portlet--height-fluid" data-name="bVWOwzlA">
                <div class="kt-portlet__body" data-name="lSejTQCY">
                    <div class="table-toolbar" data-name="ZUtVHfao">
                        <div class="form-group row" data-name="mLiXhZhM">
                            <div class="col-md-12" data-name="xlRhMNKf">
                                @if ($admin)
                                    <div class="btn-group" data-name="hgQfEpVj">
                                        <button onclick="chooseBuilder(1);" id="sample_editable_1_new" class="btn btn-label-success">
                                            <i class="la la-plus"></i> {{trans('common.form.button.add_new')}}
                                        </button>
                                    </div>
                                @endif

                                @if ($admin)
                                    <div class="btn-group pull-right" data-name="hXNwBlhD">
                                        <button class="btn btn-label-info dropdown-toggle" data-toggle="dropdown">
                                            {{ trans('common.button.bulk_actions') }}
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-right">

                                            <li>
                                                <a href="javascript:;" onclick="deleteAll();" class=""> <i class="fa fa-remove"></i> {{trans('common.form.button.delete')}}  </a>
                                            </li>

                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <table class="table table-striped table-hover table-checkable responsive" id="campaigns" role="grid" >
                        <thead>
                        <tr role="row">
                            <th style="width: 25px;">
                                <label class="kt-checkbox kt-checkbox--single kt-checkbox--all kt-checkbox--solid">
                                    <input type="checkbox" autocomplete="off" class="checkboxes checkbox-all-index" autocomplete="off">
                                    <span></span>
                                </label>
                            </th>
                            <th>{{trans('broadcasts.view.table_heading.name')}}</th>
                            <th>{{trans('broadcasts.view.table_heading.group')}}</th>
                            <th>{{trans('broadcasts.view.table_heading.subject')}}</th>
                            <th>{{trans('broadcasts.templates.view.table_heading.client_enabled')}}</th>
                            <th>{{trans('broadcasts.view.table_heading.added_on')}}</th>
                            <th>{{trans('common.table_heading.actions')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection