<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Spintax";
$lang["view"]["description"] = "Use Spintax to create dynamic content variations in your emails by automatically rotating words, phrases, or sentences. This feature helps increase personalization and uniqueness in messages, improving engagement and deliverability by preventing content repetition.";
$lang["view"]["table_heading"]["tag"] = "Tag";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["add"]["title"] = "Add Spintax";
$lang["add"]["description"] = "Create dynamic variations within your content by inserting spintax, allowing different words, phrases, or sentences to rotate in your emails. This feature helps generate unique content for each recipient, improving personalization and reducing redundancy.";
$lang["form_heading"] = "Spintax Settings";
$lang["form"]["name"] = "Tag";
$lang["form"]["name_description"] = "Represents the variable name used in broadcast content to dynamically insert one of the values below.";
$lang["form"]["words"] = "List of values";
$lang["form"]["words_description"] = "Line separated list of words or phrases that will be randomly selected while sending emails.";
$lang["edit"]["title"] = "Edit Spintax";
$lang["edit"]["description"] = "Modify and optimize your spintax to generate dynamic and unique content variations. Customize the syntax for multiple alternatives to enhance engagement and avoid duplication across your email campaigns.";
$lang["update"]["notification"]["activity_title"] = "Spintax";
$lang["controller"]["arry_txt_field"] = "Text Field";
$lang["controller"]["multiline_txt_field"] = "Multiline Text Field";
$lang["controller"]["checkbox_arry_txt_field"] = "Checkboxes";
$lang["controller"]["drop_down_arry_txt_field"] = "Dropdown";
$lang["controller"]["radio_button_arry_txt_field"] = "Radio Options";
$lang["controller"]["date_arry_txt_field"] = "Date Field";
$lang["view"]["table_heading"]["description"] = "Description";
$lang["view"]["table_heading"]["enable_users"] = "Enable for Users";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["form"]["description"] = "Description";
$lang["form"]["description_description"] = "Provide a brief description of this spintax.";
$lang["templates"]["view"]["title"] = "Spintax Templates";
$lang["templates"]["view"]["description"] = "Create and manage reusable Spintax templates to add variety and uniqueness to your email content, subject lines, or other text elements. These templates can be used by both admins and users to avoid duplicate content penalties and improve engagement by generating multiple variations of your text.";
$lang["templates"]["add"]["title"] = "Add Spintax Template";
$lang["templates"]["edit"]["title"] = "Edit Spintax Template";
$lang["templates"]["add"]["description"] = "Create a new Spintax template to generate multiple variations of your text, adding variety and uniqueness to your email content, subject lines, or other text elements.";
$lang["templates"]["edit"]["description"] = "Modify an existing Spintax template to refine the variations of your text, ensuring optimal engagement and avoiding duplicate content penalties in your email campaigns and other text-based communications.";
$lang["templates"]["tag"]["updated"]["success_message"] = "Spintax template status has been successfully updated.";
$lang["templates"]["tag"]["not_found"]["error_message"] = "Spintax template doesn't exist.";
$lang["templates"]["available_templates"] = "Spintax Templates";
$lang["templates"]["button"]["defined_templated"] = "Pre-defined templates";
$lang["add"]["button"]["close_templates"] = "Collapse templates";
$lang["add"]["button"]["use_this"] = "Use this template";
$lang["add"]["select_template"]["success_message"] = "Select a template";
$lang["add"]["button"]["pre_define_template"] = "Select from the pre-defined templates";
$lang["add"]["box_title"] = "Templates";
$lang["add"]["alert_confirm_title"] = "Are you sure?";
$lang["add"]["alert_confirm_description"] = "It will override the current selection.";
$lang["templates"]["cloned"]["success_message"] = ":tag has been cloned successfully.";
$lang["templates"]["bulk_cloned"]["success_message"] = ":tag out of :count spintax cloned successfully.";
$lang["templates"]["add"]["enable_users"] = "Enable for Users";
$lang["templates"]["add"]["enable_users_desc"] = "Allow users to access and utilize this spintax.";
$lang["templates"]["add"]["enable_users_desc_only"] = "Description";
$lang["view"]["button"]["templates"] = "Templates";
$lang["templates"]["clone"] = "Clone";
$lang["templates"]["cloned"] = ":tag has been cloned successfully.";
$lang["templates"]["add_edit"]["save"] = "Save";
$lang["add"]["exists"] = ":attribute with this name already exists.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
