<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Dynamic Content Tags";
$lang["view"]["description"] = "Dynamic Content Tags allow you to personalize email campaigns by displaying specific content based on predefined criteria. You can create content units that are triggered when contact details, such as location, profession, or age, match your set conditions. Multiple content units can be assigned to a single tag, allowing for highly targeted and relevant messaging within your emails.";
$lang["view"]["table_heading"]["dynamic_tag"] = "Tag";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["add"]["title"] = "Add new dynamic content tag";
$lang["add"]["description"] = "Create dynamic content tags to personalize your email campaigns based on specific criteria. Use the available fields to define rules that determine when specific content units are displayed.";
$lang["add"]["form_heading"] = "Dynamic Content Tag Settings";
$lang["form"]["model"]["filter_placeholder"]["select_an_option"] = "Select an Option";
$lang["form"]["label"]["name"] = "Tag";
$lang["form"]["label"]["name_description"] = "Create a simple, friendly tag name to be used as a placeholder in your email content.";
$lang["form"]["label"]["name_help_bottom"] = "Only lowercase alphanumeric characters and hyphens (-) are supported.";
$lang["form"]["model"]["label"]["unit_rules"] = "and";
$lang["form"]["model"]["label"]["unit_rules_description"] = "Set the conditions that need to be met.";
$lang["form"]["model"]["filter_option"]["custom_field"] = "Custom Field";
$lang["form"]["model"]["filter_option"]["date_field"] = "Date Field";
$lang["form"]["model"]["filter_option"]["contacts_list"] = "Contact List";
$lang["form"]["model"]["filter_option"]["email_campaign"] = "Broadcast";
$lang["form"]["model"]["label"]["if_criteria_met"] = "Content Units";
$lang["form"]["model"]["label"]["if_criteria_met_description"] = "A content unit specifies the email content that will be inserted when the defined rules are met.";
$lang["form"]["model"]["label"]["else"] = "Else";
$lang["form"]["model"]["label"]["else_description"] = "Email content when criteria isn't met";
$lang["form_heading"]["add_rule"] = "Add Rule";
$lang["form_heading"]["edit_rule"] = "Edit Rule";
$lang["form_heading"]["add_unit"] = "Edit Unit";
$lang["modal"]["widget_heading"] = "Unit Name";
$lang["form"]["model"]["label"]["if_qualify"] = "If the rule qualifies";
$lang["form"]["model"]["label"]["html_body"] = "HTML Content";
$lang["form"]["model"]["label"]["text_body"] = "Text Content";
$lang["form"]["model"]["button"]["add_rule"] = "Add Rule";
$lang["form"]["model"]["label"]["include_rss_feed"] = "Include RSS Feed";
$lang["form"]["model"]["label"]["include_rss_feed_description"] = "Enabling this option will automatically embed RSS feeds into your email content, allowing you to keep your audience updated with the latest information from your chosen RSS sources.";
$lang["form"]["model"]["label"]["url"] = "Feed URL";
$lang["form"]["model"]["button"]["fetch_tags"] = "Fetch Tags";
$lang["form"]["model"]["label"]["rss_tags"] = "RSS Tags";
$lang["form"]["model"]["label"]["url_description"] = "Provide the URL to crawl the RSS feed from. Supported types are XML and JSON.";
$lang["form"]["model"]["table_heading"]["tag"] = "Tag";
$lang["form"]["model"]["table_heading"]["variable"] = "Variable";
$lang["form"]["model"]["table_heading"]["sample_content"] = "Sample Content";
$lang["form"]["model"]["table_heading"]["view"] = "View";
$lang["form"]["model"]["label"]["feed_limit"] = "Feed Items Iteration";
$lang["form"]["model"]["label"]["feed_limit_description"] = "The 'Feed Items Iteration' feature allows you to display multiple content blocks by cycling through feed items up to a set number. This ensures that your audience sees a continuous stream of content in each email.";
$lang["form"]["model"]["label"]["data_fetch_interval"] = "Update Feed Automatically";
$lang["form"]["model"]["label"]["data_fetch_interval_description"] = "Enable this option to fetch and update the feed content at defined intervals automatically.";
$lang["form"]["model"]["label"]["frequency"] = "Frequency";
$lang["form"]["model"]["label"]["set_time"] = "Time of Day";
$lang["form"]["model"]["widget_heading"]["content_preview"] = "Content Preview";
$lang["form"]["model"]["widget_heading"]["sample_content"] = "Sample Content";
$lang["edit"]["title"] = "Edit Dynamic Content Tag:";
$lang["edit"]["description"] = "Edit your dynamic content tag by adjusting the conditions and content units used to personalize your emails. While the tag name cannot be changed, you can modify the rules, add or remove content units, and update how the content is displayed based on specific criteria to ensure targeted and relevant messaging.";
$lang["alert_message"]["tag_exist"] = "Dynamic content tag already exists.";
$lang["success_message"]["dynamic_tag_created"] = "Dynamic content tag has been created";
$lang["success_message"]["dynamic_tag_updated"] = "Dynamic content tag has been updated";
$lang["notification"]["activity_title"] = "Dynamic Content Tag";
$lang["alert_confirm"]["title_sure"] = "Delete this content unit?";
$lang["alert_confirm"]["description_not_revert"] = "This action is irreversible";
$lang["alert_confirm"]["button"]["delete"] = "Yes, delete it!";
$lang["alert_confirm"]["message_deleted"] = "Deleted!";
$lang["alert_confirm"]["description_tag_deleted"] = "The content unit has been deleted successfully.";
$lang["model"]["delete"]["widget_heading"] = "Un-assign Dynamic Content Tags";
$lang["model"]["delete"]["alert_message"] = "This dynamic tag is currently in use and cannot be deleted. Please unlink the dynamic tag from the assets listed below before attempting to delete it.";
$lang["form"]["model"]["filter_option"]["opt_recipient"] = "Recipient Details";
$lang["form"]["model"]["filter_option"]["opt_profile"] = "Profile Field";
$lang["form"]["model"]["filter_option"]["opt_member_of"] = "Is Member of";
$lang["form"]["model"]["filter_option"]["opt_group"] = "Groups";
$lang["form"]["model"]["filter_option"]["opt_confirmation"] = "Confirmation Status";
$lang["form"]["model"]["filter_option"]["opt_created_at"] = "Creation Date";
$lang["form"]["model"]["filter_option"]["opt_now"] = "Time Right Now";
$lang["form"]["model"]["filter_option"]["opt_today"] = "Date Today";
$lang["form"]["model"]["filter_option"]["opt_day_of_month"] = "Date Of Month";
$lang["form"]["model"]["filter_option"]["opt_week"] = "Day Of Week";
$lang["form"]["model"]["filter_option"]["opt_month"] = "This Month";
$lang["form"]["model"]["filter_option"]["opt_broadcast_name"] = "Broadcast Name";
$lang["form"]["model"]["filter_option"]["opt_broadcast_creation"] = "Broadcast Creation Date";
$lang["form"]["model"]["filter_option"]["opt_broadcast_group"] = "Broadcast Group";
$lang["form"]["model"]["filter_option"]["opt_broadcast_subject"] = "Broadcast Subject";
$lang["form"]["model"]["filter_option"]["opt_attachment"] = "Attachments";
$lang["form"]["model"]["filter_option"]["opt_schedule"] = "Schedule Label";
$lang["form"]["model"]["filter_option"]["opt_campaign_type"] = "Campaign Type";
$lang["form"]["model"]["filter_option"]["opt_audience_type"] = "Audience Type";
$lang["form"]["model"]["filter_option"]["opt_segment"] = "Segment";
$lang["form"]["model"]["filter_option"]["opt_broadcast"] = "Broadcast";
$lang["form"]["model"]["filter_option"]["opt_split_list"] = "Split Test";
$lang["form"]["model"]["filter_option"]["opt_list"] = "List";
$lang["form"]["model"]["filter_option"]["opt_list_name"] = "List Name";
$lang["form"]["model"]["filter_option"]["opt_occurred_after"] = "Occurring after";
$lang["form"]["model"]["filter_option"]["opt_group_time_date"] = "Time and Date";
$lang["form"]["model"]["filter_option"]["opt_group_broadcast"] = "Broadcast Details";
$lang["form"]["model"]["filter_option"]["opt_group_schedule_details"] = "Schedule Details";
$lang["form"]["model"]["filter_option"]["has_attachment"] = "Has an attachment";
$lang["form"]["button"]["add"] = "Add Content Unit";
$lang["form"]["button"]["edit"] = "Update Content Unit";
$lang["form"]["model"]["filter_option"]["is_not"] = "Isn't";
$lang["form"]["model"]["filter_option"]["equal"] = "Equal to";
$lang["form"]["model"]["filter_option"]["not_equal"] = "Not Equal to";
$lang["form"]["model"]["filter_option"]["does_not_contain"] = "Doesn't contain";
$lang["form"]["model"]["filter_option"]["greater_than"] = "Greater than";
$lang["form"]["model"]["filter_option"]["lesser_than"] = "Lesser than";
$lang["form"]["model"]["filter_option"]["lesser_and_equal"] = "Lesser than or equal to";
$lang["form"]["model"]["filter_option"]["greater_and_equal"] = "Greater than or equal to";
$lang["form"]["model"]["filter_option"]["first_char"] = "First character is";
$lang["form"]["model"]["radio_option"]["return_content_all"] = "Return combined content of all qualified units.";
$lang["form"]["model"]["radio_option"]["return_content_single"] = "Return the content when the first unit qualifies";
$lang["form"]["model"]["radio_option"]["content_type_text"] = "Text";
$lang["form"]["model"]["radio_option"]["content_type_html"] = "HTML";
$lang["form"]["model"]["label"]["content_type_select"] = "Select the content type";
$lang["form"]["link"]["add_unit"] = "Add Content Unit";
$lang["form"]["error_message"]["tag_alphanumeric"] = "Tag must be alphanumeric.";
$lang["form"]["alert_message"]["keydown_keyup"] = "input keydown keyup mousedown mouseup select contextmenu drop";
$lang["form"]["error_message"]["text_required"] = "Text content is required.";
$lang["form"]["error_message"]["unit_required"] = "Unit name is required";
$lang["form"]["alert_message"]["unit_rule_required"] = "Unit rule required.";
$lang["form"]["alert_message"]["date_required"] = "Date is required.";
$lang["form"]["alert_message"]["error_occurred"] = "An error has occurred";
$lang["form"]["alert_message"]["add_one_rule"] = "Add at least one unit rule.";
$lang["form"]["model"]["filter_option"]["is"] = "is";
$lang["form"]["model"]["filter_option"]["isnt"] = "isn't";
$lang["form"]["model"]["filter_option"]["contains"] = "contains";
$lang["form"]["model"]["filter_option"]["doesnt_contains"] = "doesn't contain";
$lang["form"]["error_message"]["error_occurred"] = "opps! Please complete the form.";
$lang["templates"]["view"]["title"] = "Dynamic Content Tag Templates";
$lang["templates"]["view"]["description"] = "Create and manage reusable templates for dynamic content tags, allowing you to personalize your email campaigns and other communications based on subscriber data, behavior, or other criteria. These templates streamline the process of inserting dynamic content into your messages, making it easier to tailor your content for maximum impact.";
$lang["templates"]["add"]["title"] = "Add Dynamic Content Tag Template";
$lang["templates"]["edit"]["title"] = "Edit Dynamic Content Tag Template";
$lang["templates"]["add"]["description"] = "Create a new template for dynamic content tags that both you and your users can utilize to personalize email campaigns and other communications.";
$lang["templates"]["edit"]["description"] = "Modify an existing dynamic content tag template to refine its personalization options, ensuring tailored and relevant content for your audience.";
$lang["templates"]["tag"]["updated"]["success_message"] = "Dynamic content tag template status has been updated successfully.";
$lang["templates"]["tag"]["not_found"]["error_message"] = "template not found.";
$lang["templates"]["tag"]["not_found"] = "Spintax template not found.";
$lang["templates"]["available_templates"] = "Templates";
$lang["templates"]["defined_templated"] = "Pre-defined templates";
$lang["templates"]["clone"] = "Clone";
$lang["add"]["box_title"] = "Templates";
$lang["add"]["alert_confirm_title"] = "Are you sure?";
$lang["add"]["alert_confirm_description"] = "It will override the current selections.";
$lang["add"]["descriptions"] = "Description";
$lang["add_temp"]["title"] = "Add Dynamic Content Tag Template";
$lang["add_temp"]["description"] = "Create a new template for dynamic content tags that both you and your users can utilize to personalize email campaigns and other communications.";
$lang["edit_temp"]["title"] = "Edit Dynamic Content Tag Template";
$lang["edit_temp"]["description"] = "Modify an existing dynamic content tag template to refine its personalization options, ensuring tailored and relevant content for your audience.";
$lang["view"]["temp_status"] = "Status";
$lang["form"]["label"]["description"] = "Description";
$lang["form"]["error_message"]["description"] = "Description is requied!";
$lang["templates"]["cloned"] = ":tag cloned successfully.";
$lang["templates"]["bulk_cloned"] = ":tag out of :count dynamic content tags cloned successfully.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
