<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Bounce Rules Management";
$lang["view"]["description"] = "Bounces are categorized as Soft (temporary delivery errors) or Hard (permanent delivery issues). Each Internet Service Provider (ISP) reports bounces uniquely. " . $lang["variables"]["site_title"] . " also allows you to create custom rules for classifying bounces based on their codes and errors.";
$lang["view"]["button"]["reset"] = "Re-sync Default Bounce Rules";
$lang["view"]["table_heading"]["label"] = "Bounce Rule Name";
$lang["view"]["table_heading"]["reason"] = "Bounce Reason";
$lang["view"]["table_heading"]["details"] = "Bounce Description";
$lang["view"]["table_heading"]["code"] = "Bounce Code";
$lang["view"]["table_heading"]["type"] = "Bounce Classification";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["add"]["title"] = "Add Bounce Rule";
$lang["add"]["description"] = "Define criteria for classifying emails as either a soft bounce or a hard bounce.";
$lang["form_heading"] = "Rule Criteria";
$lang["form"]["label"]["label"] = "Rule Name";
$lang["form"]["label"]["conditions"] = "Conditions";
$lang["form"]["conditions_option"]["bounce_code"] = "Bounce Code";
$lang["form"]["conditions_option"]["bounce_reason"] = "Bounce Reason";
$lang["form"]["conditions_option"]["bounce_details"] = "Bounce Description";
$lang["form"]["button"]["add_condition"] = "Add Condition";
$lang["form"]["label"]["process_as"] = "Classify as";
$lang["form"]["process_as_placeholder"]["set_bounce_type"] = "Select bounce classification";
$lang["form"]["process_as_option"]["soft_bounce"] = "Soft Bounce";
$lang["form"]["process_as_option"]["hard_bounce"] = "Hard Bounce";
$lang["form"]["process_as_option"]["dont_process"] = "Do not process";
$lang["edit"]["title"] = "Edit Bounce Rule";
$lang["edit"]["description"] = "Bounce Reason";
$lang["view"]["table_data"]["bounce_any"] = "Any";
$lang["form"]["label"]["and"] = "and";
$lang["form"]["condition_placeholder"]["select_condition"] = "Select a Condition";
$lang["view"]["table_data"]["no_process"] = "Exclude from Processing";
$lang["view"]["alert_confirmation"]["sync_rule_alert"] = "Are you sure you want to resync the bounce rules?";
$lang["view"]["success_message"]["sync_rule_success"] = "Bounce rules have been successfully synchronized.";
$lang["view"]["alert_message"]["deleted"] = "The first row cannot be deleted.";
$lang["view"]["alert_message"]["one_criteria_required"] = "Error: Select at least one rule.";
$lang["form"]["alert_message"]["created"] = "The bounce rule has been added successfully.";
$lang["form"]["alert_message"]["updated"] = "The bounce rule has been updated successfully.";
$lang["view"]["alert_message"]["sorting_saved"] = "The bounce processing order has been successfully updated.";
$lang["form"]["alert_message"]["already_exits"] = "This bounce rule already exists.";
$lang["view"]["alert_warning"]["module_message"] = "New updates are found for the bounce rules. Resync will apply the updates.";
$lang["view"]["button"]["module_switch"] = "Synchronize Bounce Rules";
$lang["add"]["log"]["bounce_reason_add_error"] = "Error adding bounce rule";
$lang["update"]["log"]["bounce_reason_edit_error"] = "Error editing bounce rule";
$lang["delete"]["log"]["bounce_reason_txt_error"] = "Error deleting bounce rule";
$lang["view"]["alert_warning"]["notice_txt_bold"] = "Important Notice";
$lang["view"]["button"]["reset_default"] = "Reset to Default Bounce Rules";
$lang["view"]["alert_confirmation"]["reset_default"] = "Are you sure you want to reset the bounce rules to default?";
$lang["view"]["success_message"]["reset_default"] = "Bounce rules have been successfully reset to default.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
