<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "Bounce Addresses";
$lang["view"]["description"] = "A bounce address is essential for receiving delivery reports of failed messages and plays a key role in authenticating emails via SPF (Sender Policy Framework). It ensures your emails are fully qualified and recognized.";
$lang["view"]["table_headings"]["bounce_address"] = "Bounce Email Address";
$lang["view"]["table_headings"]["host"] = "Server Host";
$lang["view"]["table_headings"]["username"] = "Username";
$lang["view"]["table_headings"]["method"] = "Connection Method";
$lang["view"]["table_headings"]["port"] = "Server Port";
$lang["view"]["table_headings"]["verify_status"] = "Verification Status";
$lang["view"]["bulk_actions_dropdown"]["test_connect"] = "Test Connection";
$lang["view"]["bulk_actions_dropdown"]["set_active"] = "Set as Activate";
$lang["view"]["bulk_actions_dropdown"]["set_inactive"] = "Set as Inactive";
$lang["view"]["bulk_actions_dropdown"]["export_to_csv"] = "Export to CSV File";
$lang["add"]["title"] = "Add Bounce Address";
$lang["add"]["description"] = "Configure a new bounce address to process bounced emails. Efficient processing keeps your email list clean and reduces the risk of blacklisting.";
$lang["form_heading"] = "Setup Bounce Address";
$lang["form"]["port_placeholder"]["common_port_143"] = "Common Port: 143 (IMAP)";
$lang["form"]["port_placeholder"]["common_port_110"] = "Common Port: 110 (POP)";
$lang["form"]["label"]["bounce_email"] = "Bounce Email Address";
$lang["form"]["label"]["bounce_email_description"] = "The email address designated for receiving bounces. This address will receive notifications about emails that could not be delivered to recipients.";
$lang["form"]["label"]["process_bounce"] = "Process bounces from the mailbox";
$lang["form"]["label"]["process_bounce_description"] = "Allow " . $lang["variables"]["site_title"] . " to access and process delivery reports from this mailbox using IMAP/POP connection. This enables the system to automatically handle bounce notifications, categorize them, and take appropriate actions.";
$lang["form"]["label"]["active_description"] = "Enable this option to start processing the failed deliveries. Activating this feature ensures that bounced emails are tracked and managed effectively.";
$lang["form"]["label"]["method"] = "Connection Method";
$lang["form"]["label"]["method_description"] = "<b>POP</b>: Downloads emails from the mailbox and processes them, removing them from the server. <br><b>IMAP</b>: Accesses and processes emails directly on the mailbox server without deleting them, allowing for synchronization across multiple devices.";
$lang["form"]["label"]["host"] = "Server Hostname";
$lang["form"]["label"]["host_description"] = "The hostname of the bounce email server. This is typically provided by your email service provider and is required to connect to the email server to process bounce reports.";
$lang["form"]["label"]["username"] = "Username";
$lang["form"]["label"]["username_description"] = "Username for the bounce email mailbox. It is typically the email address itself.";
$lang["form"]["label"]["password"] = "Password";
$lang["form"]["label"]["password_description"] = "Password for the bounce email mailbox.";
$lang["form"]["label"]["port"] = "Port Number";
$lang["form"]["label"]["port_description"] = "Port number for the email server.";
$lang["form"]["label"]["folder"] = "Mailbox Folder";
$lang["form"]["label"]["folder_description"] = "The specific folder to check for the bounce reports. Default: INBOX.";
$lang["form"]["label"]["validate_certificate"] = "Validate Certificate";
$lang["form"]["label"]["validate_certificate_description"] = "Verify the SSL certificate of the email server.";
$lang["form"]["label"]["mail_encryption"] = "Use Secure Connection";
$lang["form"]["label"]["mail_encryption_description"] = "The type of secure connection used, such as SSL or TLS. This ensures that your data is encrypted and protected during transmission.";
$lang["form"]["label"]["delete_emails_after_bounce_processing"] = "Post-Processing Email Deletion";
$lang["form"]["label"]["delete_emails_after_bounce_processing_description"] = "Remove emails from the mailbox after processing by " . $lang["variables"]["site_title"] . ".";
$lang["form"]["label"]["delete_emails_option"]["only_processed"] = "Delete only processed/matched emails";
$lang["form"]["label"]["delete_emails_option"]["all_emails"] = "Flush the mailbox after processing";
$lang["form"]["button"]["verify_connection"] = "Verify Connection";
$lang["form"]["button"]["verify_connection_description"] = "Validate the connection with bounced email address.";
$lang["edit"]["title"] = "Edit Bounce Address";
$lang["error_message"]["verify_connection_error"] = "Connection Error:";
$lang["success_message"]["verify_connection_success"] = "Connecton Successful:";
$lang["update"]["notification"]["activity_title"] = "Bounce Handling";
$lang["form"]["error_message"]["pmta_control"] = "Managed by PowerMTA";
$lang["form"]["mail_encryption_option"]["none"] = "None";
$lang["form"]["mail_encryption_option"]["tls"] = "TLS";
$lang["form"]["mail_encryption_option"]["ssl"] = "SSL";
$lang["modal"]["table_headings"]["test_connection"]["bounce_name"] = "Bounce Address Name";
$lang["modal"]["table_headings"]["test_connection"]["test_status"] = "Testing Status";
$lang["modal"]["table_headings"]["test_connection"]["status"] = "Status";
$lang["modal"]["widget_heading"]["attach_to_list"] = "The bounce email address is in use";
$lang["modal"]["alert_message"]["delete_linked_assets"] = "This bounce email address can not be deleted as it is linked to the following assets.";
$lang["modal"]["alert_message"]["detach_replace_another_address"] = "To delete this bounce email address, unlink it from the associated assets, or re-assign another bounce email address to the associated assets.";
$lang["view"]["alert_message"]["bounce_addresses_deleted"] = "The bounce email address has been successfully deleted.";
$lang["view"]["alert_message"]["error_message"] = "Oops, something went wrong.";
$lang["view"]["modal"]["button"]["attach_and_delete"] = "Re-assign and Delete";
$lang["view"]["bounce_list_placeholder"]["select"] = "Re-assign another bounce address";
$lang["delete"]["log"]["bounce_address_error"] = "Error deleting bounce email address";
$lang["delete"]["log"]["bounce_delete_error"] = "Error deleting bounce email address";
$lang["add"]["log"]["bounce_add_error"] = "Error adding bounce email address";
$lang["update"]["log"]["bounce_edit_error"] = "Error adding bounce email address";
$lang["modal"]["list"]["sending_node"] = "Sending Node 1, Sending Node 2, Sending Node 3";
$lang["modal"]["list"]["contact_list"] = "Contact List 1, Contact List 2, Contact List 3";
$lang["modal"]["error_message"]["filed_required_div"] = "This field is required.";
$lang["view"]["conntection_test"]["error_message"] = "The request timed out. Please verify the server connection, and then try again. Usually it could be unresolvable hostname, firewall blockage, port closed or similar issues.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
