<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 04/23/2025
 */

$lang["view"]["title"] = "API Keys";
$lang["view"]["description"] = "Manage and generate API keys to enable external applications to securely interact with the system. These keys provide controlled access to specific functionalities, ensuring secure integration with third-party tools or services.";
$lang["view"]["table_heading"]["api_token"] = "API Key";
$lang["view"]["table_heading"]["token_name"] = "API Name";
$lang["view"]["table_heading"]["user"] = "Owner";
$lang["view"]["table_heading"]["ip_address"] = "Allowed IPs";
$lang["view"]["table_heading"]["last_access"] = "Last Accessed";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["view"]["table_heading"]["action"] = "Actions";
$lang["view"]["tab_title"]["api_credentials"] = "API Keys";
$lang["view"]["modal"]["heading"]["generate_api_credentials"] = "Create an API Key";
$lang["view"]["modal"]["heading"]["update_api_credentials"] = "API Key Settings";
$lang["view"]["modal"]["label"]["description"] = "Description";
$lang["view"]["modal"]["label"]["rate_limit"] = "Rate limit";
$lang["view"]["modal"]["label"]["rate_limit_help_text"]["hour"] = "Allowed number of requests per minute.";
$lang["view"]["modal"]["api_role_palceholder"]["select_api_role"] = "Select an API Role";
$lang["view"]["modal"]["label"]["allowed_ip_address"] = "Allowed IPs";
$lang["view"]["modal"]["label"]["allowed_ip_address_description"] = "Add the IP addresses or subnets (separated by new lines) that are allowed to use this API Key.";
$lang["view"]["modal"]["button"]["generate"] = "Create Key";
$lang["view"]["tab_title"]["api_roles"] = "API Roles";
$lang["view"]["table_heading"]["role_name"] = "Role Name";
$lang["view"]["modal"]["label"]["allowes_api_actions"] = "API Permissions";
$lang["form"]["button"]["create_api_role"] = "Add API Role";
$lang["view"]["table"]["link"]["add_client"] = "Add Client";
$lang["view"]["modal"]["heading"]["create_api_roles"] = "Add API Role";
$lang["view"]["modal"]["heading"]["update_api_roles"] = "API Role Settings";
$lang["view"]["modal"]["label"]["token_name"] = "API Name";
$lang["view"]["modal"]["heading"]["modules"] = "Modules";
$lang["view"]["modal"]["button"]["check_all"] = "Check All";
$lang["view"]["modal"]["label"]["allowed_ip_address_help_text"]["current_ip_address"] = "Current IP Address";
$lang["success_message"]["credentials_successfully_created"] = "API key has been created successfully.";
$lang["success_message"]["role_successfully_created"] = "API role has been added successully.";
$lang["success_message"]["role_deleted"] = "API role has been deleted successully.";
$lang["error_message"]["role_not_found"] = "API role not found.";
$lang["alert_message"]["role_in_use"] = "This API role is assigned to API Keys. Unassign this API role from the associated API Keys before it can be deleted.";
$lang["success_message"]["token_successfully_created"] = "API key has been created successfully.";
$lang["success_message"]["token_deleted"] = "API key has been deleted successfully.";
$lang["error_message"]["token_not_found"] = "API Key not found.";
$lang["error_message"]["param_missing"] = "Required param is missing.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
