<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('domain_maskings', 'domain_hash')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                 $table->text('domain_hash')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('domain_maskings', 'domain_hash')) {
            Schema::table('domain_maskings', function (Blueprint $table) {
                $table->dropColumn('domain_hash');
            });
        }
    }
};
