<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $userCreatePermission = \App\Models\Permission::where('route','user.create')->first();
        if(!is_null($userCreatePermission))
            addChildPermission('Packages','1','web','0','0','all','10000','client.package.view',$userCreatePermission->parent_id);
        $authLogsPermission = \App\Models\Permission::where('route','authentication-log')->first();
        if(!is_null($authLogsPermission))
            addChildPermission('Failed Jobs Logs','0','web','1','0','super_admin','10000','activity.failedJobs',$authLogsPermission->parent_id);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\Permission::where('route','client.package.view')->delete();
        \App\Models\Permission::where('route','activity.failedJobs')->delete();
    }
};
