<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dynamicParent = \App\Models\Permission::where('route','dynamictag.index')->where('route_type','web')->first();
        if(!is_null($dynamicParent))
        {       
            addChildPermission('RSS Feed','1','web','0','0','all',4,'rssfeed',$dynamicParent->id,'RSSFeed');  
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\Permission::where('permission','RSSFeed')->delete();
    }
};
