<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $defaultFields = [
            [
                'tag' => 'picture',
                'name' => 'Profile picture',
                'field_order' => '12'
            ],
            [
                'tag' => 'picture_url',
                'name' => 'Profile picture url',
                'field_order' => '13'
            ]
        ];

        foreach ($defaultFields as $perm)
        {
            if(!\App\Models\ProfileField::where('tag',$perm['tag'])->exists())
             \App\Models\ProfileField::firstOrCreate(
                [
                    'tag' => $perm['tag'],
                    'name' =>  $perm['name'],
                    'field_order' =>  $perm['field_order'],
                ],
                [
                    'type' => 'text','is_default'=> '1','is_required' => '1','status'=>'1','options'=>null,'user_id' => '2','is_deleted' => '0',now(),now()
                ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\ProfileField::whereIn('tag',['picture','picture_url'])->delete();
    }
};
