<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $roles= DB::table('roles')->where('is_staff',1)->where('type','web')->where('id','!=',1)->get();
        $api_permission_id=DB::table('permissions')->where('route','api_management')->value('id');
        foreach($roles as $role){
            $check_permission_role_exists=DB::table('role_permissions')->where('role_id',$role->id)->where('permission_id',$api_permission_id)->exists();
            if($check_permission_role_exists){
                DB::table('role_permissions')->where('role_id',$role->id)->where('permission_id',$api_permission_id)->delete();   
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
       
    }
};
