<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $nodeAdd = \App\Models\Permission::where('route','node.create-new')->where('route_type','web')->first();
        if(!is_null($nodeAdd))
        {
            $max= \App\Models\Permission::where('parent_id',$nodeAdd->id)->max('sequence');
            $max++;
            addChildPermission('ManDrill','1','web','0','0','all',$max,null,$nodeAdd->id,'ManDrill');
            $max++;
            addChildPermission('SendInBlue','1','web','0','0','all',$max,null,$nodeAdd->id,'SendInBlue');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        \App\Models\Permission::where('permission','SendInBlue')->delete();
        \App\Models\Permission::where('permission','ManDrill')->delete();
    }
};
