<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        \App\Models\MainMenu::where('id',9)->update(['routes'=>'setting/update||cron/status||bugs/list||tools/logs/debug||tools/logs/access||tools/logs/callbacks||phpinfo||dbcheck||tools/logs/debug/list||tools/logs/debug/{date}/{level}||tools/logs/authentication||tools/logs/failedJobs||tools/exported/files||languages||languages/{id}/update']);
        $parent = \App\Models\Permission::where('default_title','Tools')->where('route_type','web')->first();
        if(!empty($parent)) {
            $langauge_exists = \App\Models\Permission::where('default_title','Languages')->where('route_type','web')->exists();
            if(!$langauge_exists){
                $permission = addChildPermission('Languages','1','web','1','1','super_admin',10000,'languages.index',$parent->id);
                if(!empty($permission)) 
                    \App\Models\MainMenu::create(['parent_id' => 9,'routes' => 'languages||languages/{id}/update','link'=>'languages.index','sequence'=>7,'type'=>1,'is_view'=>1,'icons'=>'kt-menu__link-bullet kt-menu__link-bullet--dot','module_name'=>'lang.menu.item.langs','new_flag'=>0,'permission'=>$permission->id]);
                }
            }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
