<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {
        if (!Schema::hasTable('web_form_designs')) {
            Schema::create('web_form_designs', function (Blueprint $table) {
                $table->integer('id', true);
                $table->text('styles')->nullable();
                $table->string('design_name', 255)->nullable();
                $table->integer('user_id')->nullable();
                $table->longText('design')->nullable();
                $table->string('preview_picture', 255)->nullable();
                $table->integer('category_id')->nullable();
                $table->tinyInteger('is_default')->default(0);
                $table->tinyInteger('user_default')->default(1);
                $table->timestamps();
            });
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(1, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    *, *::before, *::after {\r\n      box-sizing: border-box;\r\n      }\r\n      body{\r\n      margin: 0;\r\n      font-family: \"Roboto\", sans-serif;\r\n      font-weight: 300;\r\n      letter-spacing: .05em;\r\n      background-color: #fff;\r\n      }\r\n     .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n  }\r\n    .bg-gray-darken {\r\n      background-color: #384662;\r\n  }\r\n  \r\n  .section-sm, .section-md, .section-lg, .section-xl {\r\n      padding: 60px 0;\r\n  }\r\n  .context-dark, .bg-gray-darken, .bg-default-primary, .bg-gray-dark, .bg-secondary-3, .bg-gradient-primary, .one-screen-page, .animated-box-front.bg-image, .animated-box-back.bg-image {\r\n      color: #fff;\r\n  }\r\n  .section {\r\n      position: relative;\r\n  }\r\n  .text-left {\r\n      text-align: left !important;\r\n  }\r\n  .spacing-40 {\r\n      transform: translate3d(0, -40px, 0);\r\n      margin-bottom: -40px;\r\n      pointer-events: none;\r\n  }\r\n  .spacing-40 > * {\r\n      margin-top: 40px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-40 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  .text-regular {\r\n      font-weight: 400;\r\n  }\r\n  h4{\r\n    display: inline-block;\r\n    margin-top: 0;\r\n    margin-bottom: 0;\r\n    font-family: inherit;\r\n    font-weight: 100;\r\n    letter-spacing: -.025em;\r\n  }\r\n  .page .form-inline {\r\n      text-align: center;\r\n      justify-content: center;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  .form-inline {\r\n      display: flex;\r\n      flex-flow: row wrap;\r\n      align-items: center;\r\n  }\r\n  form {\r\n      margin-bottom: 0;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .page .form-inline .form-group {\r\n      width: 100%;\r\n  }\r\n  .page .form-inline .form-group input {\r\n      width: 100%;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-control {\r\n      background: #3f4f6e;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-label{\r\n      color: #fff;\r\n  }\r\n  .bg-gray-darken h4{\r\n    color: #fff;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-control{\r\n    color: #fff;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-validation{\r\n    color: #fff;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-validation {\r\n      position: absolute;\r\n      right: 6px;\r\n      top: 4px;\r\n      font-size: 10px;\r\n      line-height: 12px;\r\n      letter-spacing: 0;\r\n      font-weight: 400;\r\n      color: rgba(227, 84, 117, 0.9);\r\n      transition: .3s;\r\n  }\r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: white;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label.focus{\r\n    opacity: 0!important;\r\n  }\r\n  html .bg-image form[data-form-type=\'subscribe\'] .btn-primary, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:active, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:focus {\r\n      color: #242731;\r\n      background: #fff;\r\n      border-color: #fff;\r\n  }\r\n  .form-group + .btn {\r\n      margin-top: 35px;\r\n  }\r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  * + .btn {\r\n      margin-top: 22px;\r\n  }\r\n  .rd-mailform > * + * {\r\n      margin-top: 30px;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .page .form-inline > * + * {\r\n      margin-top: 0;\r\n      margin-left: 30px;\r\n  }\r\n  html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary:hover, .btn.btn-effect-ujarak.btn-primary-outline:hover {\r\n      border-color: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak:hover {\r\n      background-color: transparent;\r\n      border-color: #5798ef;\r\n  }\r\n  .page .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  .page {\r\n      overflow: hidden;\r\n  }\r\n  .page {\r\n      position: relative;\r\n      overflow: hidden;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  .radio-group>label.form-label, .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  .spacing-20 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  * + .row {\r\n      margin-top: 30px;\r\n  }\r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /*********** End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  @media (min-width: 480px){\r\n  .page .form-inline .form-group {\r\n      width: auto;\r\n      flex-shrink: 0;\r\n      flex-grow: 1;\r\n      }\r\n    * + .btn {\r\n      margin-top: 30px;\r\n    }\r\n  }\r\n  @media (min-width: 768px){\r\n    .page .form-inline {\r\n      display: -ms-flexbox;\r\n      display: -webkit-flex;\r\n      display: flex;\r\n      -webkit-flex-direction: row;\r\n      -ms-flex-direction: row;\r\n      flex-direction: row;\r\n      -webkit-flex-wrap: nowrap;\r\n      -ms-flex-wrap: nowrap;\r\n      flex-wrap: nowrap;\r\n      -webkit-align-items: stretch;\r\n      -ms-flex-align: stretch;\r\n      align-items: stretch;\r\n      -webkit-justify-content: center;\r\n      -ms-flex-pack: center;\r\n      justify-content: center;\r\n      width: 100%;\r\n    }\r\n    .section-md {\r\n        padding: 70px 0;\r\n      }\r\n    h4, .h4 {\r\n      font-size: 30px;\r\n      line-height: 1.33333;\r\n    }\r\n    .page .form-inline .form-group {\r\n      -webkit-flex-grow: 1;\r\n      -ms-flex-positive: 1;\r\n      flex-grow: 1;\r\n    }\r\n    .page .form-inline button {\r\n      display: inline-block;\r\n      -webkit-flex-shrink: 0;\r\n      -ms-flex-negative: 0;\r\n      flex-shrink: 0;\r\n    }\r\n    * + .btn {\r\n      margin-top: 50px;\r\n    }\r\n  }\r\n  @media (min-width: 992px){\r\n    .section-md {\r\n        padding: 95px 0;\r\n    }\r\n  }\r\n  \r\n  \r\n  ', 'Simple Subscriber form', 2, '<section class=\"section section-md bg-gray-darken novi-background text-left section-1\">\r\n  <div class=\"container\">\r\n    <div class=\"row spacing-40 align-items-center\">\r\n      <div class=\"col-sm-10 col-lg-8 col-xl-6\">\r\n        <h4>We Make the <span class=\"text-regular\">Best</span> Web Design Solutions </h4>\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-8 col-xl-6\">\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 1, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(2, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    *, *::before, *::after {\r\n      box-sizing: border-box;\r\n      }\r\n      body{\r\n      -webkit-text-size-adjust: none;\r\n      -webkit-font-smoothing: subpixel-antialiased;\r\n      font-family: \"Roboto\", sans-serif;\r\n      font-weight: 300;\r\n      letter-spacing: .05em;\r\n      }\r\n      html .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n      }\r\n      .btn-primary.focus, .btn-primary:focus {\r\n          box-shadow: none!important;\r\n      }\r\n      html .bg-gray-dark {\r\n          background-color: #363d41;\r\n      }\r\n      .bg-gray-dark h3{\r\n        color: white;\r\n      }\r\n      .section-sm, .section-md, .section-lg, .section-xl {\r\n          padding: 60px 0;\r\n      }\r\n      .context-dark, .bg-gray-darken, .bg-default-primary, .bg-gray-dark, .bg-secondary-3, .bg-gradient-primary, .one-screen-page, .animated-box-front.bg-image, .animated-box-back.bg-image {\r\n          color: #fff;\r\n      }\r\n      .section {\r\n          position: relative;\r\n      }\r\n      h3{\r\n        margin-top: 0;\r\n        margin-bottom: 0;\r\n        font-family: inherit;\r\n        font-weight: 100;\r\n        letter-spacing: -.025em;\r\n      }\r\n      .text-center [class*=\'text-width\'] {\r\n          margin-left: auto;\r\n          margin-right: auto;\r\n      }\r\n      * + .big {\r\n          margin-top: 12px;\r\n      }\r\n      * + .big {\r\n          margin-top: 8px;\r\n      }\r\n      .text-width-smaller {\r\n          max-width: 470px;\r\n      }\r\n      [class*=\'text-width\'] {\r\n          width: 100%;\r\n      }\r\n  \r\n      * + p, * + .p {\r\n          margin-top: 20px;\r\n      }\r\n      .page .form-inline {\r\n          text-align: center;\r\n          justify-content: center;\r\n      }\r\n      p + .rd-mailform {\r\n          margin-top: 18px;\r\n      }\r\n      .form-group {\r\n        position: relative;\r\n        margin-bottom: 0;\r\n      }\r\n      .page .form-inline .form-group {\r\n        width: 100%;\r\n      }\r\n      .page .form-inline .form-group input {\r\n        width: 100%;\r\n      }\r\n       .bg-gray-dark .rd-mailform .form-control{\r\n        color: white;\r\n        background: rgba(255, 255, 255, 0.47);\r\n       }\r\n      .form-control {\r\n        min-height: 50px;\r\n        height: auto;\r\n        padding: 15.2px 19px;\r\n        border-radius: 6px;\r\n        -webkit-appearance: none;\r\n        line-height: 19.6px;\r\n        background: #f5f5f5;\r\n        border: 0;\r\n      }\r\n      .form-control:focus{\r\n        box-shadow: none!important;\r\n      }\r\n      .form-validation {\r\n        position: absolute;\r\n        right: 6px;\r\n        top: 4px;\r\n        font-size: 10px;\r\n        line-height: 12px;\r\n        letter-spacing: 0;\r\n        font-weight: 400;\r\n        color: rgba(227, 84, 117, 0.9);\r\n        transition: .3s;\r\n      }\r\n      .form-label {\r\n        position: absolute;\r\n        top: 25px;\r\n        left: 19px;\r\n        font-size: 14px;\r\n        color: #999;\r\n        line-height: 1.2;\r\n        pointer-events: none;\r\n        letter-spacing: .05em;\r\n        z-index: 9;\r\n        transition: .3s;\r\n        transform: translateY(-50%);\r\n        will-change: transform;\r\n        opacity: .6;\r\n      }\r\n      .form-label.focus{\r\n        opacity: 1;\r\n      }\r\n      .bg-gray-dark .rd-mailform .form-label{\r\n        color: white;\r\n      }\r\n      html .bg-image form[data-form-type=\'subscribe\'] .btn-primary, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:active, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:focus {\r\n          color: #242731;\r\n          background: #fff;\r\n          border-color: #fff;\r\n      }\r\n      * + .btn {\r\n          margin-top: 22px;\r\n      }\r\n      .rd-mailform > * + * {\r\n          margin-top: 30px;\r\n      }\r\n      .btn {\r\n          font-family: \"Montserrat\", sans-serif;\r\n          font-size: 12px;\r\n          font-weight: 400;\r\n          line-height: 2;\r\n          transition: 0.33s all ease-in;\r\n          border-radius: 6px;\r\n          border: 1px solid;\r\n          text-transform: uppercase;\r\n          letter-spacing: 0;\r\n          white-space: normal;\r\n          max-width: 100%;\r\n          cursor: pointer;\r\n      }\r\n      .page .form-inline > * + * {\r\n          margin-top: 20px;\r\n      }\r\n      .form-group + .btn {\r\n          margin-top: 35px;\r\n      }\r\n      .rd-mailform .btn {\r\n          padding-left: 20px;\r\n          padding-right: 20px;\r\n          min-height: 50px;\r\n      }\r\n      .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n          transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n      }\r\n      .btn.btn-effect-ujarak {\r\n          position: relative;\r\n          z-index: 0;\r\n          transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n      }\r\n      .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n          color: #fff;\r\n          background: #5798ef;\r\n          border-color: #5798ef;\r\n      }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary:hover, .btn.btn-effect-ujarak.btn-primary-outline:hover {\r\n      border-color: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak:hover {\r\n      background-color: transparent;\r\n      border-color: #5798ef;\r\n  }\r\n  .page .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  .radio-group>label.form-label, .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  .spacing-20 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  * + .row {\r\n      margin-top: 30px;\r\n  }\r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  \r\n  \r\n  \r\n      @media (min-width: 480px){\r\n      .big {\r\n        font-size: 18px;\r\n        line-height: 28px;\r\n        }\r\n        .page .form-inline .form-group {\r\n          width: auto;\r\n          flex-shrink: 0;\r\n          flex-grow: 1;\r\n        }\r\n        * + .btn {\r\n          margin-top: 30px;\r\n        }\r\n        .page .form-inline > * + * {\r\n          margin-top: 0;\r\n          margin-left: 30px;\r\n        }\r\n      }\r\n      @media (min-width: 576px){\r\n      .form-inline .form-group {\r\n        display: flex;\r\n        flex: 0 0 auto;\r\n        flex-flow: row wrap;\r\n        align-items: center;\r\n        margin-bottom: 0;\r\n        }\r\n        .form-inline .form-control {\r\n          display: inline-block;\r\n          width: auto;\r\n          vertical-align: middle;\r\n        }\r\n        .form-inline label {\r\n          display: flex;\r\n          align-items: center;\r\n          justify-content: center;\r\n          margin-bottom: 0;\r\n        }\r\n      }\r\n      @media (min-width: 768px){\r\n      .section-md {\r\n          padding: 70px 0;\r\n        }\r\n        h3, .h3 {\r\n          font-size: 34px;\r\n        }\r\n        .page .form-inline {\r\n          display: -ms-flexbox;\r\n          display: -webkit-flex;\r\n          display: flex;\r\n          -webkit-flex-direction: row;\r\n          -ms-flex-direction: row;\r\n          flex-direction: row;\r\n          -webkit-flex-wrap: nowrap;\r\n          -ms-flex-wrap: nowrap;\r\n          flex-wrap: nowrap;\r\n          -webkit-align-items: stretch;\r\n          -ms-flex-align: stretch;\r\n          align-items: stretch;\r\n          -webkit-justify-content: center;\r\n          -ms-flex-pack: center;\r\n          justify-content: center;\r\n          width: 100%;\r\n        }\r\n        .page .form-inline .form-group {\r\n          -webkit-flex-grow: 1;\r\n          -ms-flex-positive: 1;\r\n          flex-grow: 1;\r\n        }\r\n        .page .form-inline .form-control {\r\n          width: 100%;\r\n        }\r\n        * + .btn {\r\n          margin-top: 50px;\r\n        }\r\n        .page .form-inline button {\r\n          display: inline-block;\r\n          -webkit-flex-shrink: 0;\r\n          -ms-flex-negative: 0;\r\n          flex-shrink: 0;\r\n        }\r\n      }\r\n      @media (min-width: 992px){\r\n      .section-md {\r\n          padding: 95px 0;\r\n        }\r\n      }\r\n    @media (min-width: 1200px){\r\n      h3, .h3 {\r\n          font-size: 42px!important;\r\n          line-height: 1.19048;\r\n        }\r\n      * + .big {\r\n          margin-top: 24px;\r\n        }\r\n      }\r\n  \r\n      \r\n  ', 'Contact Form', 2, '<section class=\"section section-md bg-gray-dark novi-background bg-image text-center section-3\" style=\"background-image: url(images/bg-image-3.jpg);\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-sm-center\">\r\n      <div class=\"col-sm-10 col-lg-8 col-xl-7\">\r\n        <h3>Subscribe to Our Newsletter</h3>\r\n        <p class=\"big text-width-smaller\">Sign up to our newsletter and be the first to know about our latest news, special offers, and events.</p>\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 3, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(3, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    *, *::before, *::after {\r\n      box-sizing: border-box;\r\n      }\r\n      body{\r\n      margin: 0;\r\n      font-family: \"Roboto\", sans-serif;\r\n      font-weight: 300;\r\n      letter-spacing: .05em;\r\n      line-height: 1.5;\r\n      color: #212529;\r\n      background-color: #fff;\r\n      }\r\n     .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n  }\r\n    .bg-gray-darken {\r\n      background-color: #384662;\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .section-sm, .section-md, .section-lg, .section-xl {\r\n      padding: 60px 0;\r\n  }\r\n  .context-dark, .bg-gray-darken, .bg-default-primary, .bg-gray-dark, .bg-secondary-3, .bg-gradient-primary, .one-screen-page, .animated-box-front.bg-image, .animated-box-back.bg-image {\r\n      color: #fff;\r\n  }\r\n  .section {\r\n      position: relative;\r\n  }\r\n  .text-left {\r\n      text-align: left !important;\r\n  }\r\n  .spacing-40 {\r\n      transform: translate3d(0, -40px, 0);\r\n      margin-bottom: -40px;\r\n      pointer-events: none;\r\n  }\r\n  .spacing-40 > * {\r\n      margin-top: 40px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-40 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  .text-regular {\r\n      font-weight: 400;\r\n  }\r\n  h4{\r\n    display: inline-block;\r\n    margin-top: 0;\r\n    margin-bottom: 0;\r\n    font-family: inherit;\r\n    font-weight: 100;\r\n    letter-spacing: -.025em;\r\n  }\r\n  .page .form-inline {\r\n      text-align: center;\r\n      justify-content: center;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  .form-inline {\r\n      display: flex;\r\n      flex-flow: row wrap;\r\n      align-items: center;\r\n  }\r\n  form {\r\n      margin-bottom: 0;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .page .form-inline .form-group {\r\n      width: 100%;\r\n  }\r\n  .page .form-inline .form-group input {\r\n      width: 100%;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-control {\r\n      background: #3f4f6e;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-validation {\r\n      position: absolute;\r\n      right: 6px;\r\n      top: 4px;\r\n      font-size: 10px;\r\n      line-height: 12px;\r\n      letter-spacing: 0;\r\n      font-weight: 400;\r\n      color: rgba(227, 84, 117, 0.9);\r\n      transition: .3s;\r\n  }\r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label.focus{\r\n    opacity: 1;\r\n  }\r\n  html .bg-image form[data-form-type=\'subscribe\'] .btn-primary, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:active, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:focus {\r\n      color: #242731;\r\n      background: #fff;\r\n      border-color: #fff;\r\n  }\r\n  .form-group + .btn {\r\n      margin-top: 35px;\r\n  }\r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  * + .btn {\r\n      margin-top: 22px;\r\n  }\r\n  .rd-mailform > * + * {\r\n      margin-top: 30px;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .page .form-inline > * + * {\r\n      margin-top: 0;\r\n      margin-left: 30px;\r\n  }\r\n  html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary:hover, .btn.btn-effect-ujarak.btn-primary-outline:hover {\r\n      border-color: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak:hover {\r\n      background-color: transparent;\r\n      border-color: #5798ef;\r\n  }\r\n  .page .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  .bg-gray-darken .rd-mailform .form-validation{\r\n    color: #ddd;\r\n  }\r\n  .page {\r\n      overflow: hidden;\r\n  }\r\n  .page {\r\n      position: relative;\r\n      overflow: hidden;\r\n  }\r\n  \r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  .radio-group>label.form-label, .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  .spacing-20 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  * + .row {\r\n      margin-top: 30px;\r\n  }\r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  \r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  \r\n  \r\n  @media (min-width: 480px){\r\n  .page .form-inline .form-group {\r\n      width: auto;\r\n      flex-shrink: 0;\r\n      flex-grow: 1;\r\n      }\r\n    * + .btn {\r\n      margin-top: 30px;\r\n    }\r\n  }\r\n  \r\n  @media (min-width: 768px){\r\n    .page .form-inline {\r\n      display: -ms-flexbox;\r\n      display: -webkit-flex;\r\n      display: flex;\r\n      -webkit-flex-direction: row;\r\n      -ms-flex-direction: row;\r\n      flex-direction: row;\r\n      -webkit-flex-wrap: nowrap;\r\n      -ms-flex-wrap: nowrap;\r\n      flex-wrap: nowrap;\r\n      -webkit-align-items: stretch;\r\n      -ms-flex-align: stretch;\r\n      align-items: stretch;\r\n      -webkit-justify-content: center;\r\n      -ms-flex-pack: center;\r\n      justify-content: center;\r\n      width: 100%;\r\n    }\r\n    .section-md {\r\n        padding: 70px 0;\r\n      }\r\n    h4, .h4 {\r\n      font-size: 30px;\r\n      line-height: 1.33333;\r\n    }\r\n    .page .form-inline .form-group {\r\n      -webkit-flex-grow: 1;\r\n      -ms-flex-positive: 1;\r\n      flex-grow: 1;\r\n    }\r\n    .page .form-inline button {\r\n      display: inline-block;\r\n      -webkit-flex-shrink: 0;\r\n      -ms-flex-negative: 0;\r\n      flex-shrink: 0;\r\n    }\r\n    * + .btn {\r\n      margin-top: 50px;\r\n    }\r\n  }\r\n  @media (min-width: 992px){\r\n    .section-md {\r\n        padding: 95px 0;\r\n    }\r\n  }\r\n  \r\n  \r\n  ', 'contact form variant2', 2, '<section class=\"section section-md bg-gray-darken novi-background text-left section-4\">\r\n  <div class=\"container\">\r\n    <div class=\"row spacing-40 align-items-center\">\r\n      <div class=\"col-sm-10 col-lg-8 col-xl-6\">\r\n        <h4>We Make the <span class=\"text-regular\">Best</span> Web Design Solutions </h4>\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-8 col-xl-6\">\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 4, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(4, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    *, *::before, *::after {\r\n      box-sizing: border-box;\r\n      }\r\n      body{\r\n      -webkit-text-size-adjust: none;\r\n      -webkit-font-smoothing: subpixel-antialiased;\r\n      font-family: \"Roboto\", sans-serif;\r\n      font-weight: 300;\r\n      letter-spacing: .05em;\r\n      }\r\n      html .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n      }\r\n      html .bg-gray-light {\r\n          background-color: #f2f3f8;\r\n      }\r\n      .section-sm, .section-md, .section-lg, .section-xl {\r\n          padding: 60px 0;\r\n      }\r\n      .section {\r\n          position: relative;\r\n      }\r\n      article, aside, dialog, figcaption, figure, footer, header, hgroup, main, nav, section {\r\n          display: block;\r\n      }\r\n      .spacing-40 {\r\n          transform: translate3d(0, -40px, 0);\r\n          margin-bottom: -40px;\r\n          pointer-events: none;\r\n      }\r\n  .justify-content-center {\r\n      justify-content: center !important;\r\n      text-align: center;\r\n  }\r\n  .spacing-40 > * {\r\n      margin-top: 40px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-40 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  .heading-3 {\r\n      font-size: 26px;\r\n      line-height: 1.45;\r\n      font-weight: 400;\r\n      letter-spacing: -.025em;\r\n  }\r\n  h3{\r\n    display: inline-block;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  \r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  form {\r\n      margin-bottom: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  \r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  \r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-20 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .has-error .form-control:not(.form-control-impressed), .has-error .form-control:not(.form-control-impressed):focus {\r\n      border-color: rgba(227, 84, 117, 0.6);\r\n      box-shadow: none;\r\n  }\r\n  \r\n  .bg-gray-light .form-control {\r\n      background: #fff;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  .has-error .form-validation {\r\n      color: #e35475;\r\n  }\r\n  \r\n  .form-validation {\r\n      position: absolute;\r\n      right: 6px;\r\n      top: 4px;\r\n      font-size: 10px;\r\n      line-height: 12px;\r\n      letter-spacing: 0;\r\n      font-weight: 400;\r\n      color: rgba(227, 84, 117, 0.9);\r\n      transition: .3s;\r\n  }\r\n  .bg-gray-light .form-label {\r\n      color: #242731;\r\n  }\r\n  \r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label.focus{\r\n    opacity: 0;\r\n  }\r\n  \r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .bg-gray-light .form-control {\r\n      background: #fff;\r\n  }\r\n  \r\n  textarea.form-control {\r\n      height: 135px;\r\n      min-height: 50px;\r\n      max-height: 229.5px;\r\n      resize: vertical;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  \r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .page .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  \r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  @media (min-width: 768px){\r\n  .section-lg {\r\n      padding: 80px 0;\r\n    }\r\n    .heading-3 {\r\n      font-size: 34px;\r\n    }\r\n    .form-label, .form-label-outside, .form-control {\r\n        font-size: 14px;\r\n    }\r\n  \r\n  }\r\n  @media (min-width: 992px){\r\n  .section-lg {\r\n      padding: 100px 0;\r\n    }\r\n  }\r\n  @media (min-width: 1200px){\r\n  .heading-3 {\r\n      font-size: 42px;\r\n      line-height: 1.19048;\r\n    }\r\n  }\r\n  \r\n  \r\n  \r\n  \r\n    \r\n  ', 'Subscribe form minimal', 2, '<section class=\"section section-lg bg-gray-light novi-background section-5\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-center spacing-40\">\r\n      <div class=\"col-sm-10 col-lg-12\">\r\n        <h3>\r\n          <span class=\"heading-3\">Contact Form</span>\r\n        </h3>\r\n      </div>\r\n      <div class=\"col-sm-10 col-xl-6\">\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 5, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(5, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n  *, *::before, *::after {\r\n    box-sizing: border-box;\r\n    }\r\n    body{\r\n    -webkit-text-size-adjust: none;\r\n    -webkit-font-smoothing: subpixel-antialiased;\r\n    font-family: \"Roboto\", sans-serif;\r\n    font-weight: 300;\r\n    letter-spacing: .05em;\r\n    }\r\n    .page {\r\n    overflow: hidden;\r\n    }\r\n    .page {\r\n        position: relative;\r\n        overflow: hidden;\r\n        background-color: #fff;\r\n    }\r\n    html .bg-image {\r\n    background-size: cover;\r\n    background-position: center 55%;\r\n    background-repeat: no-repeat;\r\n}\r\n\r\nhtml .bg-gray-dark {\r\n    background-color: #363d41;\r\n}\r\n.section-sm, .section-md, .section-lg, .section-xl {\r\n    padding: 60px 0;\r\n}\r\n.pre-footer-default {\r\n    padding: 50px 0;\r\n    background: #fff;\r\n}\r\n.context-dark, .bg-gray-darken, .bg-default-primary, .bg-gray-dark, .bg-secondary-3, .bg-gradient-primary, .one-screen-page, .animated-box-front.bg-image, .animated-box-back.bg-image {\r\n    color: #fff;\r\n}\r\n.section {\r\n    position: relative;\r\n}\r\n.text-left {\r\n    text-align: left;\r\n}\r\n.spacing-55 {\r\n    transform: translate3d(0, -55px, 0);\r\n    margin-bottom: -55px;\r\n    pointer-events: none;\r\n}\r\n.spacing-55 > * {\r\n    margin-top: 55px;\r\n    pointer-events: auto;\r\n}\r\n.spacing-55 > *::before {\r\n    content: \'\';\r\n    display: table;\r\n    width: 0;\r\n}\r\na, a:active, a:focus {\r\n    color: #5798ef;\r\n}\r\n\r\na {\r\n    display: inline-block;\r\n    text-decoration: none;\r\n    transition: 0.33s all ease-in;\r\n}\r\n.brand-sm img {\r\n    width: 100%;\r\n    max-width: 153px;\r\n    height: auto;\r\n}\r\n* + p, * + .p {\r\n    margin-top: 20px;\r\n}\r\np {\r\n    margin: 0;\r\n}\r\nhtml .page .group-sm {\r\n    -webkit-transform: translateY(-10px);\r\n    transform: translateY(-10px);\r\n    margin-bottom: -10px;\r\n    margin-left: -16px;\r\n}\r\n\r\np + .group-sm {\r\n    margin-top: 15px;\r\n}\r\n* + .group-sm {\r\n    margin-top: 35px;\r\n}\r\nhtml .page .group-middle > *, html .page .group-middle > *:first-child {\r\n    vertical-align: middle;\r\n}\r\nhtml .page .group-sm > *, html .page .group-sm > *:first-child {\r\n    display: inline-block;\r\n    margin-top: 10px;\r\n    margin-left: 16px;\r\n}\r\nhtml .page .group-middle > *, html .page .group-middle > *:first-child {\r\n    vertical-align: middle;\r\n}\r\n\r\nhtml .page .group-sm > *, html .page .group-sm > *:first-child {\r\n    display: inline-block;\r\n    margin-top: 10px;\r\n    margin-left: 16px;\r\n}\r\n.inline-list-xxs {\r\n    position: relative;\r\n    transform: translateY(-8px);\r\n    margin-bottom: -8px;\r\n    margin-left: -3px;\r\n    margin-right: -3px;\r\n}\r\nul, ol {\r\n    list-style: none;\r\n    padding: 0;\r\n    margin: 0;\r\n}\r\n.inline-list-xxs > * {\r\n    display: inline-block;\r\n}\r\n\r\n.inline-list-xxs > * {\r\n    margin-top: 8px;\r\n    padding-left: 3px;\r\n    padding-right: 3px;\r\n}\r\nhtml .page [class*=\'group-\']:before, html .page [class*=\'group-\']:after {\r\n    content: \'\';\r\n    display: table;\r\n}\r\n.icon-xxs.icon-circle {\r\n    height: 27px;\r\n    width: 27px;\r\n    line-height: 27px;\r\n}\r\n\r\n.page .icon-effect-1 {\r\n    position: relative;\r\n    z-index: 1;\r\n}\r\n.page .icon-trout-outline {\r\n    color: white;\r\n    background-color: transparent;\r\n    border: 1px solid white;\r\n}\r\n.icon-circle {\r\n    border-radius: 100%;\r\n}\r\n.icon-xxs {\r\n    font-size: 12px;\r\n}\r\n.icon {\r\n    display: inline-block;\r\n    text-align: center;\r\n}\r\n.pre-footer-default h4 {\r\n    font-weight: 700;\r\n    color: white;\r\n}\r\n.pre-footer-default * + .row.gallery-sofia {\r\n    margin-top: 14px;\r\n}\r\n.pre-footer-default .row.gallery-sofia {\r\n    margin-left: -5px;\r\n    margin-right: -5px;\r\n    width: 100%;\r\n}\r\n.spacing-10 {\r\n    transform: translate3d(0, -10px, 0);\r\n    margin-bottom: -10px;\r\n    pointer-events: none;\r\n}\r\n.pre-footer-default .row.gallery-sofia [class*=\'col\'] {\r\n    padding-left: 5px;\r\n    padding-right: 5px;\r\n}\r\n\r\n.spacing-10 > * {\r\n    margin-top: 10px;\r\n    pointer-events: auto;\r\n}\r\n.thumbnail-sofia {\r\n    position: relative;\r\n    padding-bottom: 100%;\r\n}\r\n.thumbnail-sofia a {\r\n    position: absolute;\r\n    top: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n    right: 0;\r\n}\r\n\r\n[data-lightgallery=\'item\'] {\r\n    cursor: pointer;\r\n}\r\n.thumbnail-sofia img {\r\n    object-fit: cover;\r\n    object-position: center;\r\n    width: 100%;\r\n    height: 100%;\r\n}\r\n.thumbnail-sofia .caption {\r\n    position: absolute;\r\n    top: 0;\r\n    bottom: 0;\r\n    left: 0;\r\n    right: 0;\r\n    display: flex;\r\n    justify-content: center;\r\n    align-items: center;\r\n    color: #fff;\r\n    background-color: rgba(87, 152, 239, 0.35);\r\n    transition: .3s ease-out all;\r\n    pointer-events: none;\r\n    overflow: hidden;\r\n    will-change: transfrom;\r\n}\r\n\r\n.thumbnail-sofia .caption .list-inline {\r\n    margin-left: -10px;\r\n    margin-right: -10px;\r\n}\r\n.inline-list-xxs {\r\n    position: relative;\r\n    transform: translateY(-8px);\r\n    margin-bottom: -8px;\r\n    margin-left: -3px;\r\n    margin-right: -3px;\r\n}\r\n.pre-footer-default .caption .list-inline > li {\r\n    padding-left: 3px;\r\n    padding-right: 3px;\r\n}\r\n.thumbnail-sofia .caption .list-inline span {\r\n    display: inline-block;\r\n    vertical-align: middle;\r\n}\r\n\r\n.pre-footer-default .caption .icon {\r\n    font-size: 14px;\r\n}\r\n.thumbnail-sofia .caption .icon {\r\n    margin-right: 5px;\r\n    font-size: 28px;\r\n}\r\n.icon {\r\n    display: inline-block;\r\n    text-align: center;\r\n}\r\n.mdi {\r\n    display: inline-block;\r\n    font: normal normal normal 24px/1 \"Material Design Icons\";\r\n    font-size: inherit;\r\n    text-rendering: auto;\r\n    -webkit-font-smoothing: antialiased;\r\n    -moz-osx-font-smoothing: grayscale;\r\n    transform: translate(0, 0);\r\n}\r\n.pre-footer-default * + .rd-mailform {\r\n    margin-top: 20px;\r\n}\r\n.form-group {\r\n    position: relative;\r\n    margin-bottom: 0;\r\n}\r\n.form-bordered .form-label {\r\n    top: 24px;\r\n}\r\n.form-centered .form-label {\r\n    right: 19px;\r\n}\r\n.form-centered label, .form-centered .form-control {\r\n    text-align: center;\r\n}\r\n.form-label {\r\n    position: absolute;\r\n    top: 25px;\r\n    left: 19px;\r\n    font-size: 14px;\r\n    color: #999;\r\n    line-height: 1.2;\r\n    pointer-events: none;\r\n    letter-spacing: .05em;\r\n    z-index: 9;\r\n    transition: .3s;\r\n    transform: translateY(-50%);\r\n    will-change: transform;\r\n    opacity: .6;\r\n}\r\n.form-label.focus{\r\n  opacity: 1;\r\n}\r\n.label {\r\n    margin-bottom: 0;\r\n}\r\n.bg-gray-dark .rd-mailform .form-label,.bg-gray-dark .rd-mailform .form-validation{\r\n  color: white;\r\n}\r\n.bg-gray-dark .rd-mailform .form-control{\r\n  background: rgba(255, 255, 255, 0.47);  \r\n}\r\n.has-error .form-control:not(.form-control-impressed), .has-error .form-control:not(.form-control-impressed):focus {\r\n    border-color: rgba(255, 255, 255, 0.6);\r\n    box-shadow: none;\r\n}\r\n.form-bordered .form-control {\r\n    padding-top: 13.2px;\r\n    padding-bottom: 13.2px;\r\n    border: 2px solid #ededed;\r\n    background-color: transparent;\r\n}\r\n.has-error .form-validation {\r\n    color: #e35475;\r\n}\r\n.form-validation {\r\n    position: absolute;\r\n    right: 6px;\r\n    top: 4px;\r\n    font-size: 10px;\r\n    line-height: 12px;\r\n    letter-spacing: 0;\r\n    font-weight: 400;\r\n    color: rgba(227, 84, 117, 0.9);\r\n    transition: .3s;\r\n}\r\nhtml .bg-image form[data-form-type=\'subscribe\'] .btn-primary, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:active, html .bg-image form[data-form-type=\'subscribe\'] .btn-primary:focus {\r\n    color: #242731;\r\n    background: #fff;\r\n    border-color: #fff;\r\n}\r\n* + .btn.btn-offset-small {\r\n    margin-top: 14px;\r\n}\r\n.rd-mailform .btn {\r\n    padding-left: 20px;\r\n    padding-right: 20px;\r\n    min-height: 50px;\r\n}\r\n.btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n    transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n}\r\n.btn.btn-effect-ujarak {\r\n    position: relative;\r\n    z-index: 0;\r\n    transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n}\r\n.page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n    color: #fff;\r\n    background: #5798ef;\r\n    border-color: #5798ef;\r\n}\r\n.btn {\r\n    font-family: \"Montserrat\", sans-serif;\r\n    font-size: 12px;\r\n    font-weight: 400;\r\n    line-height: 2;\r\n    transition: 0.33s all ease-in;\r\n    border-radius: 6px;\r\n    border: 1px solid;\r\n    text-transform: uppercase;\r\n    letter-spacing: 0;\r\n    white-space: normal;\r\n    max-width: 100%;\r\n    cursor: pointer;\r\n}\r\n.btn-primary.focus, .btn-primary:focus {\r\n    box-shadow: none!important;\r\n}\r\nh3{\r\n   margin-top: 0;\r\n  margin-bottom: 0;\r\n  font-family: inherit;\r\n  font-weight: 100;\r\n  letter-spacing: -.025em;\r\n  line-height: 1.45;\r\n}\r\np{\r\n  margin-top: 20px;\r\n}\r\n.btn.btn-effect-ujarak.btn-primary:hover, .btn.btn-effect-ujarak.btn-primary-outline:hover {\r\n    color: #fff;\r\n    background: #5acea4;\r\n    border-color: #5acea4;\r\n}\r\n\r\n.form-label.focus{\r\n  opacity: 0!important;\r\n}\r\n.form-control {\r\n    min-height: 50px;\r\n    height: auto;\r\n    padding: 15.2px 19px;\r\n    border-radius: 6px;\r\n    -webkit-appearance: none;\r\n    line-height: 19.6px;\r\n    background: #f5f5f5;\r\n    border: 0;\r\n}\r\n.rd-mailform .row {\r\n    margin-left: -5px;\r\n    margin-right: -5px;\r\n}\r\n.rd-mailform .row > [class*=\'col-\'] {\r\n    padding-left: 5px;\r\n    padding-right: 5px;\r\n}\r\n.radio-group>label.form-label, .checkbox-group>label.form-label {\r\n    position: relative;\r\n    display: block;\r\n    top: auto;\r\n    left: auto;\r\n    font-size: 14px;\r\n}\r\n.spacing-20 > *::before {\r\n    content: \'\';\r\n    display: table;\r\n    width: 0;\r\n}\r\n* + .row {\r\n    margin-top: 30px;\r\n}\r\n.spacing-20 {\r\n    transform: translate3d(0, -20px, 0);\r\n    margin-bottom: -20px;\r\n    pointer-events: none;\r\n}\r\nlabel {\r\n    margin-bottom: 0;\r\n}\r\n\r\n\r\n\r\n/***********  Sam Custom Styling   *************/\r\n.rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n    min-width: 100% !important;\r\n    border-radius: 6px;\r\n}\r\n.dropdown .select2-selection {\r\n    background: #f5f5f5;\r\n}\r\n.bg-gray-light .dropdown .select2-selection {\r\n    background: #FFFFFF;\r\n}\r\n.bg-gray-darken .dropdown .select2-selection {\r\n    background: #3f4f6e !important;\r\n    border: 0;\r\n    border-radius: 6px !important;\r\n}\r\n.bg-gray-dark .dropdown .select2-selection {\r\n    background: rgba(255, 255, 255, 0.47) !important;\r\n    border-color: transparent;\r\n}\r\n.bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n    background: rgba(255, 255, 255, 0.47);\r\n    border-color: rgba(255,255,255,0.47);\r\n}\r\n.bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n    color: rgba(255,255,255, 0.6) !important;\r\n    font-weight: 500 !important;\r\n}\r\n.bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n    color: #acb3c0 !important;\r\n    font-weight: 500;\r\n    font-size: 14px;\r\n}\r\n.form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n    padding-top: 13.2px;\r\n    padding-bottom: 13.2px;\r\n    border: 2px solid #ededed;\r\n    background: rgba(255, 255, 255, 0.47);\r\n}\r\n.dropdown .select2-selection .select2-selection__rendered {\r\n    font-size: 14px;\r\n    text-transform: capitalize;\r\n}\r\n.spacing-20 > * {\r\n    margin-top: 20px;\r\n    pointer-events: auto;\r\n}\r\n.radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n    position: relative;\r\n    display: block;\r\n    top: auto;\r\n    left: auto;\r\n    font-size: 14px;\r\n}\r\nlabel.kt-radio, label.kt-checkbox {\r\n    margin-right: 20px;\r\n    font-size: 14px;\r\n    font-weight: 400;\r\n    text-transform: capitalize;\r\n    vertical-align: middle;\r\n    cursor: pointer;\r\n}\r\n.kt-radio>input, .kt-checkbox>input {\r\n    width: 1.5rem;\r\n    height: 1.5rem;\r\n    vertical-align: middle;\r\n    margin-right: 5px;\r\n    cursor: pointer;\r\n    -webkit-appearance: none;\r\n    -moz-appearance: none;\r\n    appearance: none;\r\n    background: #F5F5F5;\r\n    border: 2px solid #F5F5F5;\r\n}\r\n\r\n.bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n    background-color: #FFFFFF;\r\n    border: 2px solid #FFFFFF;\r\n}\r\n.bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n    background: #3f4f6e ;\r\n    border: 2px solid #3f4f6e;\r\n}\r\n.form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n    border: 2px solid #ededed;\r\n    background: rgba(255, 255, 255, 0.47);\r\n}\r\n.kt-radio>input:checked, .kt-checkbox>input:checked {\r\n    background: #5798ef !important;\r\n    border-color: #5798ef !important;\r\n}\r\n.kt-radio>input {border-radius: 50%;}\r\n\r\ninput.form-control:focus+label.form-label,\r\ntextarea.form-control:focus+label.form-label {\r\n    opacity: 0;\r\n    transition: 1s ease all;\r\n}\r\n.pl-10 {padding-left: 10px !important;}\r\n.pl-20 {padding-left: 20px !important;}\r\n.pl-30 {padding-left: 30px !important;}\r\n.pr-10 {padding-right: 10px !important;}\r\n.pr-20 {padding-right: 20px !important;}\r\n.pr-30 {padding-right: 30px !important;}\r\n.pt-10 {padding-top: 10px !important;}\r\n.pt-20 {padding-top: 20px !important;}\r\n.pt-30 {padding-top: 30px !important;}\r\n.pb-10 {padding-bottom: 10px !important;}\r\n.pb-20 {padding-bottom: 20px !important;}\r\n.pb-30 {padding-bottom: 30px !important;}\r\n.ml-10 {margin-left: 10px !important;}\r\n.ml-20 {margin-left: 20px !important;}\r\n.ml-30 {margin-left: 30px !important;}\r\n.mr-10 {margin-right: 10px !important;}\r\n.mr-20 {margin-right: 20px !important;}\r\n.mr-30 {margin-right: 30px !important;}\r\n.mt-10 {margin-top: 10px !important;}\r\n.mt-20 {margin-top: 20px !important;}\r\n.mt-30 {margin-top: 30px !important;}\r\n.mb-10 {margin-bottom: 10px !important;}\r\n.mb-20 {margin-bottom: 20px !important;}\r\n.mb-30 {margin-bottom: 30px !important;}\r\n\r\n/***********  End Sam Custom Styling   *************/\r\n/************** add css ****************/\r\n.radio-group, .checkbox-group {\r\n    position: relative;\r\n    margin-top: 30px;\r\n}\r\ntextarea.form-control {\r\n    height: 130px;\r\n}\r\n/************** add css ****************/\r\n@media (min-width: 576px){\r\n.justify-content-sm-center {\r\n    justify-content: center !important;\r\n  }\r\n}\r\n@media (min-width: 768px){\r\n.section-md {\r\n    padding: 70px 0;\r\n  }\r\n  .text-sm-center {\r\n    text-align: center;\r\n  }\r\n  * + .row {\r\n    margin-top: 50px;\r\n  }\r\n  h4, .h4 {\r\n      font-size: 30px;\r\n      line-height: 1.33333;\r\n  }\r\n}\r\n@media (min-width: 992px){\r\n.section-md {\r\n    padding: 95px 0;\r\n  }\r\n  html:not(.lt-ie10) .text-md-left {\r\n    text-align: left;\r\n  }\r\n}\r\n@media (min-width: 1200px){\r\n.thumbnail-sofia .caption .list-inline {\r\n    margin-left: -25px;\r\n    margin-right: -25px;\r\n  }\r\n  .thumbnail-sofia .caption .list-inline > li {\r\n    padding-left: 25px;\r\n    padding-right: 25px;\r\n  }\r\n  h3, .h3 {\r\n    font-size: 42px;\r\n    line-height: 1.19048;\r\n  }\r\n}\r\n', 'Contact form with address', 2, '<section class=\"section section-2 section-md bg-gray-dark novi-background bg-image pre-footer-default text-left\" style=\"background-image: url(images/bg-image-3.jpg);background-size: cover;\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-sm-center spacing-55\">\r\n      <div class=\"col-lg-4\">\r\n        <div class=\"brand-sm\">\r\n          <a href=\"index.html\">\r\n            <img src=\"images/logo-default-100x28.png\" alt=\"\" width=\"100\" height=\"28\">\r\n          </a>\r\n        </div>\r\n        <p>Mumara Website Builder is a perfect solution for everyone who wants to establish a stunningly looking website with lots of useful functions and without extra coding.</p>\r\n        <div class=\"group-sm group-middle\">\r\n          <span class=\"big text-primary\">Social media</span>\r\n          <ul class=\"inline-list-xxs\">\r\n            <li>\r\n              <a class=\"icon novi-icon icon-xxs icon-circle icon-trout-outline icon-effect-1 fa fa-instagram\" href=\"#\"></a>\r\n            </li>\r\n            <li>\r\n              <a class=\"icon novi-icon icon-xxs icon-circle icon-trout-outline icon-effect-1 fa fa-facebook\" href=\"#\"></a>\r\n            </li>\r\n            <li>\r\n              <a class=\"icon novi-icon icon-xxs icon-circle icon-trout-outline icon-effect-1 fa fa-twitter\" href=\"#\"></a>\r\n            </li>\r\n            <li>\r\n              <a class=\"icon novi-icon icon-xxs icon-circle icon-trout-outline icon-effect-1 fa fa-google-plus\" href=\"#\"></a>\r\n            </li>\r\n          </ul>\r\n        </div>\r\n      </div>\r\n      <div class=\"col-lg-4\">\r\n        <h4>Gallery</h4>\r\n        <div class=\"row spacing-10 gallery-sofia\" data-lightgallery=\"group\">\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-2-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-02-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-3-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-03-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-4-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-04-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-8-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-06-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-9-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-07-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"col-4\">\r\n            <div class=\"thumbnail-sofia\">\r\n              <a class=\"sofia-link\" data-lightgallery=\"item\" href=\"images/grid-gallery-5-1200x800_original.jpg\" data-images-standard_resolution-url=\"href\">\r\n                <img class=\"sofia-image\" src=\"images/gallery-justify-09-270x300.jpg\" alt=\"\" data-images-standard_resolution-url=\"src\">\r\n              </a>\r\n              <div class=\"caption\">\r\n                <ul class=\"list-inline inline-list-xxs\">\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-heart\"></span>\r\n                    <span data-likes-count=\"text\"></span>\r\n                  </li>\r\n                  <li>\r\n                    <span class=\"novi-icon icon mdi mdi-comment\"></span>\r\n                    <span data-comments-count=\"text\"></span>\r\n                  </li>\r\n                </ul>\r\n              </div>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <div class=\"col-lg-4 text-sm-center text-md-left\">\r\n        <h3>Newsletter</h3>\r\n        <p>Enter your e-mail to get the latest news of Mumara Website Builder.</p>\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 2, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(6, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    *, *::before, *::after {\r\n      box-sizing: border-box;\r\n      }\r\n      body{\r\n      -webkit-text-size-adjust: none;\r\n      -webkit-font-smoothing: subpixel-antialiased;\r\n      font-family: \"Roboto\", sans-serif;\r\n      font-weight: 300;\r\n      letter-spacing: .05em;\r\n      }\r\n      html .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n      }\r\n      html .bg-gray-light {\r\n          background-color: #fff;\r\n      }\r\n      .section-sm, .section-md, .section-lg, .section-xl {\r\n          padding: 60px 0;\r\n      }\r\n      .section {\r\n          position: relative;\r\n      }\r\n  .spacing-30 {\r\n      transform: translate3d(0, -30px, 0);\r\n      margin-bottom: -30px;\r\n      pointer-events: none;\r\n  }\r\n  .justify-content-center {\r\n      justify-content: center !important;\r\n  }\r\n  .spacing-30 > * {\r\n      margin-top: 30px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-30 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  h2, .h2 {\r\n      font-size: 28px;\r\n      line-height: 1.3;\r\n  }\r\n  h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {\r\n      margin-top: 0;\r\n      margin-bottom: 0;\r\n      font-family: inherit;\r\n      font-weight: 100;\r\n      letter-spacing: -.025em;\r\n      color: #242731;\r\n  }\r\n  * + p, * + .p {\r\n      margin-top: 20px;\r\n  }\r\n  p + p, p + img, p + .marked-list {\r\n      margin-top: 24px;\r\n  }\r\n  \r\n  * + .marked-list, * + .ordered-list {\r\n      margin-top: 12px;\r\n  }\r\n  ul, ol {\r\n      list-style: none;\r\n      padding: 0;\r\n      margin: 0;\r\n  }\r\n  .marked-list__marker-1 > li {\r\n      padding-left: 30px;\r\n  }\r\n  \r\n  .marked-list > li {\r\n      position: relative;\r\n      padding-left: 25px;\r\n      font: 400 14px/24px \"Roboto\", sans-serif;\r\n      color: #242731;\r\n      text-align: left;\r\n  }\r\n  ul li, ol li {\r\n      display: block;\r\n  }\r\n  .marked-list__marker-1 > li:before {\r\n      color: #5acea4;\r\n      content: \'\\e005\';\r\n      font: 400 13px/24px \"fl-flat-icons-set-2\";\r\n  }\r\n  \r\n  .marked-list > li:before {\r\n      position: absolute;\r\n      top: -1px;\r\n      left: 0;\r\n      content: \'\\f00c\';\r\n      font: 100 24px/24px \"FontAwesome\";\r\n      color: #5acea4;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  \r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  form {\r\n      margin-bottom: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  \r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  \r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .form-control:focus {\r\n      outline: 0;\r\n      background: #f5f5f5;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  .form-validation {\r\n      position: absolute;\r\n      right: 6px;\r\n      top: 4px;\r\n      font-size: 10px;\r\n      line-height: 12px;\r\n      letter-spacing: 0;\r\n      font-weight: 400;\r\n      color: rgba(227, 84, 117, 0.9);\r\n      transition: .3s;\r\n  }\r\n  \r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  label {\r\n      display: inline-block;\r\n      margin-bottom: 0.5rem;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  textarea.form-control {\r\n      height: 135px;\r\n      min-height: 50px;\r\n      max-height: 229.5px;\r\n      resize: vertical;\r\n  }\r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  \r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .btn-primary:hover{\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  \r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  \r\n  @media (min-width: 768px){\r\n    .form-label, .form-label-outside, .form-control {\r\n      font-size: 14px;\r\n  }\r\n  h2, .h2 {\r\n      font-size: 40px;\r\n      line-height: 1;\r\n    }\r\n    .list-collumn-2 {\r\n      columns: 2;\r\n      column-gap: 30px;\r\n    }\r\n    .section-lg {\r\n      padding: 80px 0;\r\n    }\r\n  }\r\n  @media (min-width: 992px){\r\n  .section-lg {\r\n      padding: 100px 0!important\r\n    }\r\n  }\r\n  @media (min-width: 1200px){\r\n  h2, .h2 {\r\n      font-size: 48px!important;\r\n    }\r\n  }\r\n  \r\n  \r\n  \r\n  \r\n  \r\n  \r\n  \r\n  ', 'Subscribe form with background', 2, '<section class=\"section section-lg bg-default novi-background text-left section-6\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-center spacing-30\">\r\n      <div class=\"col-sm-10 col-xl-6\">\r\n        <h2>eCommerce Ready</h2>\r\n        <p>We have included all you may need to build an Amazing eCommerce Website from a scratch. Create your successful business now!</p>\r\n        <ul class=\"marked-list marked-list__marker-1 list-collumn-2\">\r\n          <li>Grid View;</li>\r\n          <li>Shopping Cart Page;</li>\r\n          <li>Checkout Page;</li>\r\n          <li>Single Product Page.</li>\r\n        </ul>\r\n      </div>\r\n      <div class=\"col-sm-10 col-xl-6\">\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 6, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(7, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n    body {\r\n      color: #6f727d;\r\n    }\r\n    html .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n  }\r\n  \r\n  html .bg-gray-light {\r\n      background-color: #f2f3f8;\r\n  }\r\n  .section-sm, .section-md, .section-lg, .section-xl {\r\n      padding: 60px 0;\r\n  }\r\n  .section {\r\n      position: relative;\r\n  }\r\n  .spacing-55 {\r\n      transform: translate3d(0, -55px, 0);\r\n      margin-bottom: -55px;\r\n      pointer-events: none;\r\n  }\r\n  .spacing-55 > * {\r\n      margin-top: 55px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-55 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  h3, .h3 {\r\n      font-size: 26px;\r\n      line-height: 1.45;\r\n      text-align: center;\r\n  }\r\n  h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {\r\n      margin-top: 0;\r\n      margin-bottom: 0;\r\n      font-family: inherit;\r\n      font-weight: 100;\r\n      letter-spacing: -.025em;\r\n      color: #242731;\r\n  }\r\n  .heading-3 {\r\n      font-size: 26px;\r\n      line-height: 1.45;\r\n      font-weight: 400;\r\n      letter-spacing: -.025em;\r\n  }\r\n  .box-wrap-content-interactive {\r\n      pointer-events: auto;\r\n  }\r\n  .box-contacts {\r\n      display: inline-block;\r\n      padding: 30px 40px;\r\n      background: #fff;\r\n      text-align: left;\r\n  }\r\n  .box-contacts h4 {\r\n      font-size: 13px;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0.1em;\r\n  }\r\n  h4, .h4 {\r\n      font-size: 22px;\r\n      line-height: 1.35;\r\n  }\r\n  h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6 {\r\n      margin-top: 0;\r\n      margin-bottom: 0;\r\n      font-family: inherit;\r\n      font-weight: 100;\r\n      letter-spacing: -.025em;\r\n      color: #242731;\r\n  }\r\n  .box-contacts h4 + *, .box-contacts .h4 + * {\r\n      margin-top: 7px;\r\n  }\r\n  \r\n  .box-contacts address {\r\n      max-width: 145px;\r\n  }\r\n  address {\r\n      margin-top: 0;\r\n      margin-bottom: 0;\r\n  }\r\n  p {\r\n      margin: 0;\r\n  }\r\n  .box-contacts * + h4, .box-contacts * + .h4 {\r\n      margin-top: 30px;\r\n  }\r\n  .box-contacts h4 {\r\n      font-size: 13px;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0.1em;\r\n  }\r\n  .list-0 {\r\n      line-height: 1.25;\r\n  }\r\n  .box-contacts h4 {\r\n      font-size: 13px;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0.1em;\r\n  }\r\n  \r\n  ul, ol {\r\n      list-style: none;\r\n      padding: 0;\r\n      margin: 0;\r\n  }\r\n  ul li, ol li {\r\n      display: block;\r\n  }\r\n  a[href*=\'callto\'], a[href*=\'mailto\'] {\r\n      white-space: nowrap;\r\n  }\r\n  \r\n  .link-gray-darker, .link-gray-darker:active, .link-gray-darker:focus {\r\n      color: #242731;\r\n  }\r\n  .link-sm {\r\n      font-size: 16px;\r\n      line-height: 1.2;\r\n  }\r\n  .link {\r\n      display: inline-block;\r\n  }\r\n  a, a:active, a:focus {\r\n      color: #5798ef;\r\n  }\r\n  a {\r\n      display: inline-block;\r\n      text-decoration: none;\r\n      transition: 0.33s all ease-in;\r\n  }\r\n  .link-gray, .link-gray:active, .link-gray:focus {\r\n      color: #6f727d;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  \r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  .text-left {\r\n      text-align: left;\r\n  }\r\n  .text-left {\r\n      text-align: left !important;\r\n  }\r\n  form {\r\n      margin-bottom: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  \r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .bg-gray-light .form-label {\r\n      color: #242731;\r\n  }\r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .bg-gray-light .form-control {\r\n      background: #fff;\r\n  }\r\n  \r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  .form-validation {\r\n      position: absolute;\r\n      right: 6px;\r\n      top: 4px;\r\n      font-size: 10px;\r\n      line-height: 12px;\r\n      letter-spacing: 0;\r\n      font-weight: 400;\r\n      color: rgba(227, 84, 117, 0.9);\r\n      transition: .3s;\r\n  }\r\n  .bg-gray-light .form-label {\r\n      color: #242731;\r\n  }\r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  \r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .has-error .form-control:not(.form-control-impressed), .has-error .form-control:not(.form-control-impressed):focus {\r\n      border-color: rgba(227, 84, 117, 0.6);\r\n      box-shadow: none;\r\n  }\r\n  \r\n  .bg-gray-light .form-control {\r\n      background: #fff;\r\n  }\r\n  textarea.form-control {\r\n      height: 135px;\r\n      min-height: 50px;\r\n      max-height: 229.5px;\r\n      resize: vertical;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  \r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  \r\n  \r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  \r\n  \r\n  @media (min-width: 480px){\r\n  .box-wrap-content-interactive {\r\n      display: inline-block;\r\n    }\r\n  }\r\n  @media (min-width: 768px){\r\n  .section-md {\r\n      padding: 70px 0;\r\n    }\r\n    h3, .h3 {\r\n      font-size: 34px;\r\n    }\r\n    .heading-3 {\r\n      font-size: 34px;\r\n    }\r\n    .box-contacts {\r\n      padding: 50px 60px;\r\n    }\r\n    h4, .h4 {\r\n      font-size: 30px;\r\n      line-height: 1.33333;\r\n    }\r\n    .form-label, .form-label-outside, .form-control {\r\n      font-size: 14px;\r\n    }\r\n  }\r\n  @media (min-width: 992px){\r\n  .section-md {\r\n      padding: 95px 0;\r\n    }\r\n    .box-contacts {\r\n      padding: 50px 100px;\r\n    }\r\n  }\r\n  @media (min-width: 1200px){\r\n  h3, .h3 {\r\n      font-size: 42px;\r\n      line-height: 1.19048;\r\n      text-align: center;\r\n    }\r\n    .heading-3 {\r\n      font-size: 42px;\r\n      line-height: 1.19048;\r\n    }\r\n  }\r\n  \r\n  \r\n  ', 'Campaign Monitor Form �minimal', 2, '<section class=\"section section-md bg-gray-light novi-background section-7\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-sm-center justify-content-lg-between spacing-55\">\r\n      <div class=\"col-sm-10 col-xl-12\">\r\n        <h3>\r\n          <span class=\"heading-3\">Contact Form</span> with address\r\n        </h3>\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-10 col-xl-5\">\r\n        <div class=\"box-wrap-content-interactive\">\r\n          <div class=\"box-contacts\">\r\n            <h4>Address</h4>\r\n            <address>\r\n              <p>6036 Richmond hwy., Alexandria, VA, 2230</p>\r\n            </address>\r\n            <h4>Phone</h4>\r\n            <ul class=\"list-0\">\r\n              <li>\r\n                <a class=\"link link-sm link-gray-darker\" href=\"callto:#\">+1 (409) 987�5874</a>\r\n              </li>\r\n              <li>\r\n                <a class=\"link link-sm link-gray-darker\" href=\"callto:#\">+1 (409) 455�5454</a>\r\n              </li>\r\n            </ul>\r\n            <h4>E-mail</h4>\r\n            <a class=\"link-gray\" href=\"mailto:#\">info@demolink.org</a>\r\n          </div>\r\n        </div>\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-10 col-xl-6\">\r\n        %%web_form%%\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 7, 1, 1);");
            DB::statement("INSERT INTO `web_form_designs` (`id`, `styles`, `design_name`, `user_id`, `design`, `preview_picture`, `category_id`, `is_default`, `user_default`) VALUES(8, '\r\n    @import url(\'https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css\');\r\n    @import url(\'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css\');\r\n    @import url(\'https://fonts.googleapis.com/css2?family=Metal+Mania&family=Montserrat:wght@400;700&family=Roboto:wght@100;300;400;700;900&display=swap\');\r\n  \r\n    body {\r\n      color: #6f727d;\r\n      font-family: \"Roboto\", sans-serif;\r\n    }\r\n  html .bg-image {\r\n      background-size: cover;\r\n      background-position: center 55%;\r\n      background-repeat: no-repeat;\r\n  }\r\n  a:hover, a:focus {\r\n      color: #5acea4;\r\n      text-decoration: none;\r\n  }\r\n  html .bg-default {\r\n      background-color: #fff;\r\n  }\r\n  .section-sm, .section-md, .section-lg, .section-xl {\r\n      padding: 60px 0;\r\n  }\r\n  .section {\r\n      position: relative;\r\n  }\r\n  .spacing-40 {\r\n      transform: translate3d(0, -40px, 0);\r\n      margin-bottom: -40px;\r\n      pointer-events: none;\r\n  }\r\n  .spacing-40 > * {\r\n      margin-top: 40px;\r\n      pointer-events: auto;\r\n  }\r\n  .spacing-40 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  h3, .h3 {\r\n      font-size: 26px;\r\n      line-height: 1.45;\r\n  }\r\n  \r\n  h3{\r\n      margin-top: 0;\r\n      margin-bottom: 0;\r\n      font-family: Roboto;\r\n      font-weight: 100;\r\n      letter-spacing: -.025em;\r\n      color: #242731;\r\n      text-align: center;\r\n  }\r\n  .heading-3 {\r\n      font-size: 26px;\r\n      line-height: 1.45;\r\n      font-weight: 400;\r\n      letter-spacing: -.025em;\r\n  }\r\n  .rd-mailform {\r\n      position: relative;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .spacing-30 {\r\n      transform: translate3d(0, -30px, 0);\r\n      margin-bottom: -30px;\r\n      pointer-events: none;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  .spacing-30 > * {\r\n      margin-top: 30px;\r\n      pointer-events: auto;\r\n  }\r\n  .form-group {\r\n      position: relative;\r\n      margin-bottom: 0;\r\n  }\r\n  .form-label {\r\n      position: absolute;\r\n      top: 25px;\r\n      left: 19px;\r\n      font-size: 14px;\r\n      color: #999;\r\n      line-height: 1.2;\r\n      pointer-events: none;\r\n      letter-spacing: .05em;\r\n      z-index: 9;\r\n      transition: .3s;\r\n      transform: translateY(-50%);\r\n      will-change: transform;\r\n      opacity: .6;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  .form-label, .form-label-outside, .form-control {\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      letter-spacing: 0;\r\n  }\r\n  textarea.form-control {\r\n      height: 135px;\r\n      min-height: 50px;\r\n      max-height: 229.5px;\r\n      resize: vertical;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .input-sm, .input-sm:focus, .input-lg, .input-lg:focus, .form-control, .form-control:focus {\r\n      box-shadow: none;\r\n  }\r\n  \r\n  .rd-mailform .btn {\r\n      padding-left: 20px;\r\n      padding-right: 20px;\r\n      min-height: 50px;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak {\r\n      position: relative;\r\n      z-index: 0;\r\n      transition: background 0.4s, border-color 0.4s, color 0.4s;\r\n  }\r\n  .page .btn-primary, .page .btn-primary:active, .page .btn-primary:focus {\r\n      color: #fff;\r\n      background: #5798ef;\r\n      border-color: #5798ef;\r\n  }\r\n  .btn {\r\n      font-family: \"Montserrat\", sans-serif;\r\n      font-size: 12px;\r\n      font-weight: 400;\r\n      line-height: 2;\r\n      transition: 0.33s all ease-in;\r\n      border-radius: 6px;\r\n      border: 1px solid;\r\n      text-transform: uppercase;\r\n      letter-spacing: 0;\r\n      white-space: normal;\r\n      max-width: 100%;\r\n      cursor: pointer;\r\n  }\r\n  .btn.btn-effect-ujarak.btn-primary::before, .btn.btn-effect-ujarak.btn-primary-outline::before {\r\n      background: #5acea4;\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .btn.btn-effect-ujarak, .btn.btn-effect-ujarak:before {\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn.btn-effect-ujarak::before {\r\n      content: \'\';\r\n      position: absolute;\r\n      top: -1px;\r\n      left: -1px;\r\n      width: calc(100% + 2px);\r\n      height: calc(100% + 2px);\r\n      background: #5798ef;\r\n      z-index: -1;\r\n      opacity: 0;\r\n      border-radius: 6px;\r\n      transform: scale3d(0.7, 1, 1);\r\n      transition: transform 0.4s, opacity 0.4s;\r\n      transition-timing-function: cubic-bezier(0.2, 1, 0.3, 1);\r\n  }\r\n  .btn-primary.focus, .btn-primary:focus {\r\n      box-shadow: none!important;\r\n  }\r\n  .form-group:focus {\r\n      outline: none;\r\n  }\r\n  .form-control:focus {\r\n      outline: 0;\r\n      background: #f5f5f5;\r\n  }\r\n  .unit, .unit-vertical {\r\n      -webkit-flex-direction: column;\r\n      -ms-flex-direction: column;\r\n      flex-direction: column;\r\n  }\r\n  .unit {\r\n      display: -ms-flexbox;\r\n      display: -webkit-flex;\r\n      display: flex;\r\n      -ms-flex: 0 1 100%;\r\n      -webkit-flex: 0 1 100%;\r\n      flex: 0 1 100%;\r\n      -webkit-flex-direction: column;\r\n      -ms-flex-direction: column;\r\n      flex-direction: column;\r\n  }\r\n  .box-contact-item {\r\n      padding: 40px 0;\r\n      padding-left: 30px;\r\n  }\r\n  .unit > [class*=\'unit-\']:first-child, .unit-vertical > [class*=\'unit-\']:first-child {\r\n      padding-top: 0;\r\n  }\r\n  \r\n  .box-contact-item > *:first-of-type {\r\n      font-size: 13px;\r\n      font-weight: 900;\r\n      text-transform: uppercase;\r\n      color: #242731;\r\n  }\r\n  .unit-left, .unit-right {\r\n      -ms-flex: 0 0 auto;\r\n      -webkit-flex: 0 0 auto;\r\n      flex: 0 0 auto;\r\n      max-width: 100%;\r\n  }\r\n  p{\r\n    margin: 0;\r\n  }\r\n  .unit > .unit-left + .unit-right, .unit > .unit-left + .unit-body, .unit-vertical > .unit-left + .unit-right, .unit-vertical > .unit-left + .unit-body {\r\n      padding-left: 0;\r\n      padding-top: 20px;\r\n  }\r\n  .box-contact-item .unit-body {\r\n      padding-top: 7px;\r\n  }\r\n  .unit-body {\r\n      -ms-flex: 0 1 auto;\r\n      -webkit-flex: 0 1 auto;\r\n      flex: 0 1 auto;\r\n  }\r\n  .object-inline {\r\n      display: inline-block;\r\n      vertical-align: middle;\r\n      line-height: 0;\r\n  }\r\n  .page .icon-gray {\r\n      color: #6f727d;\r\n  }\r\n  \r\n  .object-inline .icon {\r\n      vertical-align: top;\r\n  }\r\n  .icon-sm {\r\n      font-size: 20px;\r\n  }\r\n  .icon {\r\n      display: inline-block;\r\n      text-align: center;\r\n  }\r\n  .icon:before {\r\n      display: inline-block;\r\n      font-weight: 400;\r\n      font-style: normal;\r\n      speak: none;\r\n      text-transform: none;\r\n      -webkit-font-smoothing: antialiased;\r\n      -moz-osx-font-smoothing: grayscale;\r\n  }\r\n  .material-icons-location_on:before {\r\n      content: \"\\e0c8\";\r\n  }\r\n  .material-icons-ico, [class*=\"material-icons-\"]:before {\r\n      font-family: \'Material Icons\';\r\n      font-weight: 400;\r\n      font-style: normal;\r\n      font-size: inherit;\r\n  }\r\n  .link-gray-darker, .link-gray-darker:active, .link-gray-darker:focus {\r\n      color: #242731;\r\n  }\r\n  \r\n  .link-sm {\r\n      font-size: 16px;\r\n      line-height: 1.2;\r\n  }\r\n  .link {\r\n      display: inline-block;\r\n  }\r\n  .object-inline > * + * {\r\n      margin-top: 0;\r\n      margin-left: 10px;\r\n  }\r\n  .object-inline > * {\r\n      display: inline-block;\r\n      line-height: 1.1;\r\n  }\r\n  a, a:active, a:focus {\r\n      color: #5798ef;\r\n  }\r\n  a {\r\n      display: inline-block;\r\n      text-decoration: none;\r\n      transition: 0.33s all ease-in;\r\n  }\r\n  .object-inline {\r\n      display: inline-block;\r\n      vertical-align: middle;\r\n      line-height: 0;\r\n  }\r\n  .page .icon-gray {\r\n      color: #6f727d;\r\n  }\r\n  .icon-sm {\r\n      font-size: 20px;\r\n  }\r\n  .icon {\r\n      display: inline-block;\r\n      text-align: center;\r\n  }\r\n  .object-inline > * {\r\n      display: inline-block;\r\n      line-height: 1.1;\r\n  }\r\n  .box-contact-item + .box-contact-item {\r\n      border-top: 1px solid #dddddd;\r\n  }\r\n  .inline-list-xs {\r\n      position: relative;\r\n      transform: translateY(-18px);\r\n      margin-bottom: -18px;\r\n      margin-left: -8px;\r\n      margin-right: -8px;\r\n  }\r\n  \r\n  ul, ol {\r\n      list-style: none;\r\n      padding: 0;\r\n      margin: 0;\r\n  }\r\n  .inline-list-xs > * {\r\n      display: inline-block;\r\n  }\r\n  \r\n  .inline-list-xs > * {\r\n      margin-top: 18px;\r\n      padding-left: 8px;\r\n      padding-right: 8px;\r\n  }\r\n  ul li, ol li {\r\n      display: block;\r\n  }\r\n  .page .icon-gray {\r\n      color: #6f727d;\r\n  }\r\n  .icon-sm {\r\n      font-size: 20px;\r\n  }\r\n  \r\n  .icon {\r\n      display: inline-block;\r\n      text-align: center;\r\n  }\r\n  .fa {\r\n      display: inline-block;\r\n      font: normal normal normal 14px/1 FontAwesome;\r\n      font-size: inherit;\r\n      text-rendering: auto;\r\n      -webkit-font-smoothing: antialiased;\r\n      -moz-osx-font-smoothing: grayscale;\r\n  }\r\n  a {\r\n      display: inline-block;\r\n      text-decoration: none;\r\n      transition: 0.33s all ease-in;\r\n  }\r\n  .icon:before {\r\n      display: inline-block;\r\n      font-weight: 400;\r\n      font-style: normal;\r\n      speak: none;\r\n      text-transform: none;\r\n      -webkit-font-smoothing: antialiased;\r\n      -moz-osx-font-smoothing: grayscale;\r\n  }\r\n  .page a.icon-white:hover, .page a.icon-gray:hover, .page a.icon-gray-darker:hover, .page a.icon-gray-6:hover, .page a.icon-mako:hover, .page a.icon-mine-shaft:hover {\r\n      color: #5acea4;\r\n  }\r\n  [class*=\'fa-\']:before {\r\n      font-weight: 400;\r\n      font-size: 20px;\r\n      color: #6f727d;\r\n      font-family: \'FontAwesome\';\r\n  } \r\n  .fa-facebook-f:before, .fa-facebook:before {\r\n      content: \"\\f09a\";\r\n  }\r\n  .box-contact-info {\r\n      background-color: #f5f5f5;\r\n      width: 100%;\r\n  }\r\n  .fa-twitter:before {\r\n      content: \"\\f099\";\r\n  }\r\n  .fa-google-plus:before {\r\n      content: \"\\f0d5\";\r\n  }\r\n  .fa-youtube:before {\r\n      content: \"\\f167\";\r\n  }\r\n  .page .icon-gray {\r\n      color: #6f727d;\r\n  }\r\n  .btn-primary:hover {\r\n      color: #fff;\r\n      background: #5acea4;\r\n      border-color: #5acea4;\r\n  }\r\n  .form-control {\r\n      min-height: 50px;\r\n      height: auto;\r\n      padding: 15.2px 19px;\r\n      border-radius: 6px;\r\n      -webkit-appearance: none;\r\n      line-height: 19.6px;\r\n      background: #f5f5f5;\r\n      border: 0;\r\n  }\r\n  .rd-mailform .row {\r\n      margin-left: -5px;\r\n      margin-right: -5px;\r\n  }\r\n  .rd-mailform .row > [class*=\'col-\'] {\r\n      padding-left: 5px;\r\n      padding-right: 5px;\r\n  }\r\n  .radio-group>label.form-label, .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  .spacing-20 > *::before {\r\n      content: \'\';\r\n      display: table;\r\n      width: 0;\r\n  }\r\n  * + .row {\r\n      margin-top: 30px;\r\n  }\r\n  .spacing-20 {\r\n      transform: translate3d(0, -20px, 0);\r\n      margin-bottom: -20px;\r\n      pointer-events: none;\r\n  }\r\n  label {\r\n      margin-bottom: 0;\r\n  }\r\n  .spacing-20 > * {\r\n      margin-top: 20px;\r\n      pointer-events: auto;\r\n  }\r\n  .rd-mailform {\r\n      text-align: left;\r\n  }\r\n  \r\n  \r\n  /***********  Sam Custom Styling   *************/\r\n  .rd-mailform [class*=\'group\'] .select2-container--bootstrap .select2-selection {\r\n      min-width: 100% !important;\r\n      border-radius: 6px;\r\n  }\r\n  .dropdown .select2-selection {\r\n      background: #f5f5f5;\r\n  }\r\n  .bg-gray-light .dropdown .select2-selection {\r\n      background: #FFFFFF;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection {\r\n      background: #3f4f6e !important;\r\n      border: 0;\r\n      border-radius: 6px !important;\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection {\r\n      background: rgba(255, 255, 255, 0.47) !important;\r\n      border-color: transparent;\r\n  }\r\n  .bg-gray-dark label.kt-radio>input, .bg-gray-dark label.kt-checkbox>input {\r\n      background: rgba(255, 255, 255, 0.47);\r\n      border-color: rgba(255,255,255,0.47);\r\n  }\r\n  .bg-gray-dark .dropdown .select2-selection .select2-selection__rendered {\r\n      color: rgba(255,255,255, 0.6) !important;\r\n      font-weight: 500 !important;\r\n  }\r\n  .bg-gray-darken .dropdown .select2-selection .select2-selection__rendered {\r\n      color: #acb3c0 !important;\r\n      font-weight: 500;\r\n      font-size: 14px;\r\n  }\r\n  .form-bordered .dropdown .select2-selection .select2-selection__rendered {\r\n      padding-top: 13.2px;\r\n      padding-bottom: 13.2px;\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .dropdown .select2-selection .select2-selection__rendered {\r\n      font-size: 14px;\r\n      text-transform: capitalize;\r\n  }\r\n  .radio-group, .checkbox-group {\r\n      position: relative;\r\n      margin-top: 30px;\r\n  }\r\n  .radio-group>label.form-label,  .checkbox-group>label.form-label {\r\n      position: relative;\r\n      display: block;\r\n      top: auto;\r\n      left: auto;\r\n      font-size: 14px;\r\n  }\r\n  label.kt-radio, label.kt-checkbox {\r\n      margin-right: 20px;\r\n      font-size: 14px;\r\n      font-weight: 400;\r\n      text-transform: capitalize;\r\n      vertical-align: middle;\r\n      cursor: pointer;\r\n  }\r\n  .kt-radio>input, .kt-checkbox>input {\r\n      width: 1.5rem;\r\n      height: 1.5rem;\r\n      vertical-align: middle;\r\n      margin-right: 5px;\r\n      cursor: pointer;\r\n      -webkit-appearance: none;\r\n      -moz-appearance: none;\r\n      appearance: none;\r\n      background: #F5F5F5;\r\n      border: 2px solid #F5F5F5;\r\n  }\r\n  \r\n  .bg-gray-light .kt-radio>input, .bg-gray-light .kt-checkbox>input {\r\n      background-color: #FFFFFF;\r\n      border: 2px solid #FFFFFF;\r\n  }\r\n  .bg-gray-darken .kt-radio>input, .bg-gray-darken .kt-checkbox>input {\r\n      background: #3f4f6e ;\r\n      border: 2px solid #3f4f6e;\r\n  }\r\n  .form-bordered .kt-radio>input, .form-bordered .kt-checkbox>input {\r\n      border: 2px solid #ededed;\r\n      background: rgba(255, 255, 255, 0.47);\r\n  }\r\n  .kt-radio>input:checked, .kt-checkbox>input:checked {\r\n      background: #5798ef !important;\r\n      border-color: #5798ef !important;\r\n  }\r\n  .kt-radio>input {border-radius: 50%;}\r\n  \r\n  input.form-control:focus+label.form-label,\r\n  textarea.form-control:focus+label.form-label {\r\n      opacity: 0;\r\n      transition: 1s ease all;\r\n  }\r\n  .pl-10 {padding-left: 10px !important;}\r\n  .pl-20 {padding-left: 20px !important;}\r\n  .pl-30 {padding-left: 30px !important;}\r\n  .pr-10 {padding-right: 10px !important;}\r\n  .pr-20 {padding-right: 20px !important;}\r\n  .pr-30 {padding-right: 30px !important;}\r\n  .pt-10 {padding-top: 10px !important;}\r\n  .pt-20 {padding-top: 20px !important;}\r\n  .pt-30 {padding-top: 30px !important;}\r\n  .pb-10 {padding-bottom: 10px !important;}\r\n  .pb-20 {padding-bottom: 20px !important;}\r\n  .pb-30 {padding-bottom: 30px !important;}\r\n  .ml-10 {margin-left: 10px !important;}\r\n  .ml-20 {margin-left: 20px !important;}\r\n  .ml-30 {margin-left: 30px !important;}\r\n  .mr-10 {margin-right: 10px !important;}\r\n  .mr-20 {margin-right: 20px !important;}\r\n  .mr-30 {margin-right: 30px !important;}\r\n  .mt-10 {margin-top: 10px !important;}\r\n  .mt-20 {margin-top: 20px !important;}\r\n  .mt-30 {margin-top: 30px !important;}\r\n  .mb-10 {margin-bottom: 10px !important;}\r\n  .mb-20 {margin-bottom: 20px !important;}\r\n  .mb-30 {margin-bottom: 30px !important;}\r\n  \r\n  /***********  End Sam Custom Styling   *************/\r\n  /************** add css ****************/\r\n  textarea.form-control {\r\n      height: 130px;\r\n  }\r\n  /************** add css ****************/\r\n  \r\n  \r\n  @media (min-width: 480px){\r\n  .unit-xs-horizontal {\r\n      -webkit-flex-direction: row;\r\n      -ms-flex-direction: row;\r\n      flex-direction: row;\r\n    }\r\n    .unit-xs-horizontal > .unit-left + .unit-right, .unit-xs-horizontal > .unit-left + .unit-body {\r\n      padding-top: 0;\r\n      padding-left: 30px;\r\n    }\r\n  }\r\n  @media (min-width: 768px){\r\n  .section-lg {\r\n      padding: 80px 0;\r\n    }\r\n    h3, .h3 {\r\n      font-size: 34px;\r\n    }\r\n    .heading-3 {\r\n      font-size: 34px;\r\n    }\r\n    .form-label, .form-label-outside, .form-control {\r\n      font-size: 14px;\r\n    }\r\n  }\r\n  @media (min-width: 992px){\r\n  .section-lg {\r\n      padding: 100px 0;\r\n    }\r\n  }\r\n  @media (min-width: 1200px){\r\n  h3, .h3 {\r\n      font-size: 42px;\r\n      line-height: 1.19048;\r\n    }\r\n    .heading-3 {\r\n      font-size: 42px;\r\n      line-height: 1.19048;\r\n    }\r\n  }\r\n  \r\n  \r\n  ', 'Campaign Monitor Form with background', 2, '<section class=\"section section-lg bg-default novi-background section-8\">\r\n  <div class=\"container\">\r\n    <div class=\"row justify-content-sm-center justify-content-lg-between spacing-40\">\r\n      <div class=\"col-sm-10 col-xl-12\">\r\n        <h3>\r\n          <span class=\"heading-3\">Contact Form</span> with address variant 2\r\n        </h3>\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-10 col-xl-6 text-left\">\r\n        %%web_form%%\r\n      </div>\r\n      <div class=\"col-sm-10 col-lg-10 col-xl-5 text-left\">\r\n        <div class=\"box-contact-info\">\r\n          <div class=\"unit unit-xs-horizontal box-contact-item\">\r\n            <div class=\"unit-left\">\r\n              <p>ADDRESS</p>\r\n            </div>\r\n            <div class=\"unit-body\">\r\n              <div class=\"object-inline object-inline-top\">\r\n                <span class=\"icon novi-icon icon-sm icon-gray fa-map-marker\"></span>\r\n                <a class=\"link link-sm link-gray-darker\" href=\"#\">6036 Richmond hwy., <br> Alexandria, VA, 2230 </a>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"unit unit-xs-horizontal box-contact-item\">\r\n            <div class=\"unit-left\">\r\n              <p>24/7 SUPPORT</p>\r\n            </div>\r\n            <div class=\"unit-body\">\r\n              <div class=\"object-inline\">\r\n                <span class=\"icon novi-icon icon-sm icon-gray fa-phone\"></span>\r\n                <a class=\"link link-sm link-gray-darker\" href=\"callto:#\">+1 (409) 987�5874</a>\r\n              </div>\r\n            </div>\r\n          </div>\r\n          <div class=\"unit unit-xs-horizontal box-contact-item\">\r\n            <div class=\"unit-left\">\r\n              <p>get social </p>\r\n            </div>\r\n            <div class=\"unit-body\">\r\n              <ul class=\"inline-list-xs\">\r\n                <li>\r\n                  <a class=\"icon novi-icon icon-sm icon-gray fa fa-facebook\" href=\"#\"></a>\r\n                </li>\r\n                <li>\r\n                  <a class=\"icon novi-icon icon-sm icon-gray fa fa-twitter\" href=\"#\"></a>\r\n                </li>\r\n                <li>\r\n                  <a class=\"icon novi-icon icon-sm icon-gray fa fa-google-plus\" href=\"#\"></a>\r\n                </li>\r\n                <li>\r\n                  <a class=\"icon novi-icon icon-sm icon-gray fa fa-youtube\" href=\"#\"></a>\r\n                </li>\r\n              </ul>\r\n            </div>\r\n          </div>\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</section>', '', 8, 1, 1);");
        }
        else {
            if (!Schema::hasColumn('web_form_designs', 'id')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->integer('id', true);
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'styles')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->text('styles')->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'design_name')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->string('design_name', 255)->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'user_id')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->integer('user_id')->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'design')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->longText('design')->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'preview_picture')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->string('preview_picture', 255)->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'category_id')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->integer('category_id')->nullable();
                });
            }
              if (!Schema::hasColumn('web_form_designs', 'is_default')) {
                Schema::table('web_form_designs', function (Blueprint $table) {
                    $table->tinyInteger('is_default')->default(0);
                });
            }
               if (!Schema::hasColumn('web_form_designs', 'created_at') &&             !Schema::hasColumn('web_form_designs', 'updated_at')) {
                 Schema::table('web_form_designs', function (Blueprint $table) {
                   $table->timestamps();
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down() {
        Schema::dropIfExists('web_form_designs');
    }

}
;
