@extends(decide_template())

@section('title', $page_data['title'])

@section('page_styles')
<link href="/resources/assets/css/profile.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<style>
    label.cancel-upload {
        display: inline-block;
        width: 26px;
        height: 26px;
        margin-bottom: 0;
        border-radius: 100%;
        background: #FFFFFF;
        border: 1px solid transparent;
        box-shadow: 0px 2px 4px 0px rgb(0 0 0 / 12%);
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        position: absolute;
        bottom: -10px;
        right: 4px;
    }
    label.cancel-upload i {
        color: #a5a5a5;
        position: absolute;
        top: 0;
        left: 0;
        margin: auto;
        text-align: center;
        width: 24px;
        line-height: 27px;
    }
    label.cancel-upload:hover i {
        color: #333;
    }
    label.cancel-upload:hover {
        background: #ffffff;
        border-color: #e9e6e6;
    }
    .kt-checkbox-list.pl12 {
        padding-top: 8px;
    }
    .kt-portlet .kt-portlet.kt-portlet--bordered .kt-portlet__foot {
        padding: 20px 20px!important;
        margin-top: 0;
    }
    .kt-portlet__body.p-0 {
        padding:0
    }
    .dmnTitle h2 {
        margin-top: 10px!important;
        margin-bottom: 10px!important;
        font-size: 16px!important;
        font-weight: 500!important;
    }
    button.btn-chk {
        height: 38px;
        min-width: 12px!important;
        width: 38px;
        font-size: 16px;
        margin-right: 10px;
        padding: 0;
        text-align: center;
    }
    button.btn-chk i {
        font-size: 1.3rem !important;
    }
    .btn:not(.btn-sm):not(.btn-lg) {
        vertical-align: bottom;
    }
    .contentBlk {
        margin-top: 25px;
        margin-bottom: 25px;
    }
    .contentBlk1 h2 {
        margin-top: 10px;
        margin-bottom: 10px;
        font-size: 16px;
        font-weight: 600;
    }
    .table {
        border: 1px solid #e7ecf1!important;
        border-top: 0!important;
    }
    .table td, .table th {
        padding: 10px;
        vertical-align: middle;
        border-top: 1px solid #ebedf2;
    }
    .fileinput {
        margin: 0 auto;
        max-width: 250px;
        position:relative;
    }
    .fileinput .thumbnail {
        display: inline-block;
        margin-bottom: 5px;
        overflow: hidden;
        text-align: center;
        vertical-align: middle;
    }
    .thumbnail {
        padding: 5px;
    }

    .fileinput .thumbnail>img {
        max-height: 40px;
        max-width: 100%;
    }
    .thumbnail img {
        border-radius: 0;
    }

    .fileinput-exists .fileinput-new, .fileinput-new .fileinput-exists {
        display: none;
    }

    .fileinput .thumbnail {
        width: 100%!important;
        height: 100px !important;
        margin-bottom: 0;
        border: 4px solid #eee !important;
        border-color: #eee;
        min-height: 100px;
        border-bottom: 0;
        background: #1b1e25;
        padding: 0;
        border-radius: 20px;
        line-height: 88px;
    }
    .bg-white {
        background: #FFF !important;
        color: #666;
    }
    .dimension {
        color: #979eaf;
        background: #1b1e25;
        display: block;
        position: relative;
        padding: 7px 0;
        text-align: center;
        font-size: 11px;
        font-weight: 500;
    }
    .files-btn {
        position: absolute;
        top: 0;
        right: 0;
        cursor: pointer;
        left: 0;
        bottom: 0;
    }
    .files-btn .btn.default:not(.btn-outline) {
        padding: 0;
        position: absolute;
        right: -10px;
        top: -5px;
    }
    .btn-file>input {
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        margin: 0;
        font-size: 23px;
        cursor: pointer;
        opacity: 0;
        direction: ltr;
    }
    .fileinput-preview.fileinput-exists img {
        max-height: 40px;
        margin-top: -10px;
    }
    .fileinput .thumbnail.bg-white+.thumbnail {
        background: #FFF !important;
    }
    input.uploadimage {
        position: absolute;
        width: calc(100% + 8px);
        height: 100px;
        z-index: 5;
        opacity: 0;
        cursor: pointer;
        left: 0;
        top: 0;
    }
    a.btn.red.fileinput-exists {
        position: absolute;
        z-index: 5;
    }
    span.fileinput-new {
        display: inline-block;
        width: 26px;
        height: 26px;
        margin-bottom: 0;
        border-radius: 100%;
        background: #ffffff;
        border-color: #e9e6e6;
        border: 1px solid transparent;
        box-shadow: 0px 2px 4px 0px rgb(0 0 0 / 12%);
        cursor: pointer;
        font-weight: normal;
        transition: all 0.2s ease-in-out;
        line-height: 24px;
    }
    span.fileinput-exists {
        display: inline-block;
        width: 26px;
        height: 26px;
        margin-bottom: 0;
        border-radius: 100%;
        background: #ffffff;
        border-color: #e9e6e6;
        border: 1px solid transparent;
        box-shadow: 0px 2px 4px 0px rgb(0 0 0 / 12%);
        cursor: pointer;
        font-weight: normal;
        transition: all 0.2s ease-in-out;
        line-height: 24px;
    }
    a.btn.red.fileinput-exists {
        position: absolute;
        z-index: 10;
        padding: 0;
        width: 26px;
        height: 26px;
        margin-bottom: 0;
        border-radius: 100%;
        background: #ffffff;
        border-color: #e9e6e6;
        border: 1px solid transparent;
        box-shadow: 0px 2px 4px 0px rgb(0 0 0 / 12%);
        cursor: pointer;
        font-weight: normal;
        transition: all 0.2s ease-in-out;
        line-height: 24px;
        bottom: 0;
        right: -9px;
        color: #a5a5a5 !important;
    }
    a.btn.red.fileinput-exists:hover {color: #333 !important;}
    .col-md-6.mb-5 {
        margin-bottom: 15px;
    }
    .default.btn-file i.fa {
        color: #a5a5a5 !important;
    }
    .fileinput:hover .default.btn-file i.fa {
        color: #333 !important;
    }
    .fileinput.banner .thumbnail {
        height: 200px !important;
        line-height: 191px;
    }
    .fileinput.banner .thumbnail>img {
        max-height: 180px;
        max-width: 100%;
    }
    h3.mini_heading {
        margin: 0;
        padding: 0;
        font-size: 17px;
        font-weight: 500;
        color: var(--kt-portlet__head-title-color);
        margin-top: 20px;
    }
    span.input-group-text i.fa-2x {
        font-size: 16px;
    }
</style>
@endsection

@section(decide_content())

<!-- END PAGE HEADER-->
@if($errors->any())
<!-- For PHP validations errors-->
<div class="alert alert-danger" data-name="aXaeRRAF">
    @foreach($errors->all() as $error)
    <p>{{ $error }}</p>
    @endforeach
</div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="fYbTqLqs">
    {{ Session::get('msg') }}
</div>

@endif
@if (Session::has('error'))
<div class="alert alert-danger" data-name="hmZHvQIt">
    <p>{{ Session::get('error') }}</p>
</div>
@endif
<!-- will be used to show any messages about form -->
<div id="msg" class="display-hide" data-name="vqhKEXdr">
    <span id='msg-text'><span>
</div>
<?php
$setting = new \stdClass();
?>

<!-- BEGIN FORM-->
<div class="col-md-12 p-0 profile-setup" data-name="XsoOeiyX">
    <div class="row" data-name="BapuoDZD">
        <div class="col-md-2">
            <div class="kt-portlet card card-flush submenu">
                <div class="card-header pt-7" id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <b class="mb0">{{ trans('user_management.setting.sidebat.widget_heading') }}</b>
                    </div>
                    <!--end::Card title-->
                </div>
                <div class="card-body pt-5 ">
                @include('user.user-sidebar')
                </div>
            </div>
        </div>
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="col-md-6" data-name="prkSruuU">
            <div class="kt-portlet" data-name="prkSruuU">
                <div class="kt-portlet__body" data-name="VdCSpNWV">
                    <div class="tabbable tabbable-tabdrop" data-name="YcCSXTyE">
                        <ul class="nav nav-tabs" role="tablist">

                            <?php 
                                $license_attributes = json_decode(getSetting('license_attributes'), true);
                                $license_type = '';
                                if (! empty($license_attributes['package'])) {
                                    $license_type = trim($license_attributes['package']);
                                }

                                $tab = request()->get("t");
                                $profileTab = "";
                                $localeTab = "";
                                $brandingTab = "";
                                if(empty($tab) or $tab == "p") $profileTab = "active";
                                if($tab == "l") $localeTab = "active";
                                if($tab == "b") $brandingTab = "active";
                            ?>

                            <li class="nav-item">
                                <a href="#tab1" class="nav-link active" data-toggle="tab">
                                    {{trans('user_management.profile.view.title')}}
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="#tab2" class="nav-link" data-toggle="tab">
                                    {{trans('common.label.locale')}}
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content" data-name="VotfZrsj">
                            <div class="tab-pane active AsXQAAOwn" id="tab1" data-name="PgJqlMMM">
                                <div class="col-md-12" data-name="AsXQAAOw">
                                    <form action="{{ route('user.profile',  $user->id) }}" method="POST" enctype="multipart/form-data" id="profile-frm" class="kt-form kt-form--label-right" autocomplete="off">
                                        <input type="hidden" id="action" value="profile">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="hidden" id="user-id" value="{{$user->id}}">
                                        <input type="hidden" name="_method" value="PUT">

                                        <div class="kt-portlet__body" data-name="RPszXpdK">
                                            <div class="form-body" data-name="iyskiVEK">
                                                <div class="form-group row" data-name="XESSJOYs">
                                                    <div class="col-md-12" data-name="YvXpotCP">
                                                        <label class="col-form-label">
                                                            {{trans('user_management.profile.form.label.update_avatar')}}
                                                            <span class="required"> * </span>
                                                        </label>
                                                        <div class="avatar-upload">
                                                            <div class="avatar-edit">
                                                                <input name="profile_img" type='file' id="imageUpload" id="profile_img" accept=".png, .jpg, .jpeg" />
                                                                <label for="imageUpload" class="uload-icon"><i class="fa fa-pencil-alt" ></i></label>
                                                            </div>
                                                            <div class="avatar-renmove">
                                                                <span class="remove-image" id="remove-image">
																	<i class="fa fa-times fs-2"></i>
																</span>
                                                                <input type="hidden"  id="remove_image" value="0" name="remove_image" class="form-control" />
                                                            </div>
                                                            <div class="avatar-preview">
                                                                @if ($user->profile_img_store)
                                                                    <div id="imagePreview" style="background-image: url('{{ asset('/storage/' . $user->profile_img_store) }}');"></div>
                                                                @else 
                                                                    <div id="imagePreview" style="background-image: url('/public/img/user.png');"></div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row" data-name="XESSJOYs">
                                                    <div class="col-md-6" data-name="YvXpotCP">
                                                        <label class="col-form-label">
                                                            {{trans('common.label.email_address')}}
                                                            <span class="required"> * </span>
                                                        </label>
                                                        <input type="email" id="email" name="email" value="{{isset($user->email) ? $user->email : '' }}" class="form-control" />
                                                    </div>
                                                    <div class="col-md-6" data-name="SLYNvvrO">
                                                        <label class="col-form-label">{{trans('common.label.name')}}
                                                            <span class="required"> * </span>
                                                        </label>
                                                        <input type="text" name="name" id="name" value="{{isset($user->name) ? $user->name : '' }}" class="form-control" />
                                                    </div>
                                                </div>
                                                @foreach($profile_fields as $data)
                                                    <div class="form-group row" data-name="bfzhhFWb">
                                                       @foreach($data as $field)
                                                           @php
                                                           $tag = $field->tag;
                                                           @endphp
                                                           @if($field->tag=='mobile')
                                                                <div class="col-md-6" data-name="OzggMswM">
                                                                    <label class="col-form-label">{{trans('user_management.profile.form.label.mobile')}}
                                                                       @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                    </label>
                                                                    <input type="text" name="mobile" value="{{isset($user->mobile) ? $user->mobile : '' }}" class="form-control" id="mobile" />
                                                                    <input type="hidden" name="countrycode" value="{{isset($user->countrycode) ? $user->countrycode : '' }}" id="ccode">
                                                                </div>
                                                            @elseif ($field->tag == 'country')
                                                            <div class="col-md-6" data-name="OutJkYzn">
                                                                <label class="col-form-label">{{trans('common.label.country')}}
                                                                    @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                </label>
                                                                <select name="country" class="form-control m-select2"
                                                                        id="country">
                                                                    @foreach ($countries as $country) {
                                                                    <option value="{{$country->country_code}}"
                                                                            {{ (isset($user->country) && $user->country == $country->country_code) ? 'selected' : ''  }}>
                                                                        {{ $country->country_name }}</option>
                                                                    }
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            @elseif ($field->type == 'text')
                                                            <div class="col-md-6" data-name="PciYSkyC">
                                                                <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                    @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                </label>
                                                                <input id="{{$field->tag}}"  type="text" name="{{$field->tag}}" value="{{!empty($user->$tag)?$user->$tag:''}}" class="form-control" />
                                                            </div>
                                                                @elseif($field->type == 'number')
                                                                <div class="col-md-6" data-name="PciYSkyC">
                                                                    <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                        @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                    </label>
                                                                    <input id="{{$field->tag}}" type="number" name="{{$field->tag}}" value="{{!empty($user->$tag)?$user->$tag:''}}" class="form-control" />
                                                                </div>
                                                            @elseif ($field->type == 'textarea')
                                                                <div class="col-md-6" data-name="PciYSkyC">
                                                                <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                    @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                </label>
                                                                <textarea id="{{$field->tag}}" name="{{$field->tag}}" class="form-control" rows="3" {{ $field->is_required ? 'required' : '' }} >{{ !empty($user->$tag)?$user->$tag:'' }}</textarea>
                                                                </div>
                                                            @elseif ($field->type == 'select')
                                                                @if ($field->options != "")
                                                                    <div class="col-md-6" data-name="PciYSkyC">
                                                                    <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                        @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                    </label>
                                                                    <select id="{{$field->tag}}" class="form-control m-select2" name="{{$field->tag}}" {{ $field->is_required ? 'required' : '' }}>
                                                                        <option value="">{{trans('contacts.custom_field.form.placeholder_choose_option')}}</option>
                                                                        @foreach (preg_split('/\r\n|[\r\n]/', $field->options) as $option)
                                                                            <option {{ isset($user->$tag) && $user->$tag == $option ? 'selected' : '' }} value="{{ $option }}" >{{ $option }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                    </div>
                                                                @endif
                                                            @elseif ($field->type == 'checkbox')
                                                                @if ($field->options != "")
                                                                    <div class="col-md-6" data-name="PciYSkyC">
                                                                        <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                            @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                        </label>

                                                                            <select class="mt-multiselect btn btn-default" name="{{$field->tag}}[]" multiple="multiple" data-label="left" id="{{$field->tag}}" data-width="100%" data-filter="true" data-action-onchange="true" data-select-all="true" data-placeholder="{{$field->name}}">
                                                                                @foreach(preg_split('/\r\n|[\r\n]/', $field->options) as $k => $v)
                                                                                    <option @if(!empty($user->$tag) and in_array($v , $user->$tag)) selected @endif value="{{$v}}" >{{$v}}</option>
                                                                                @endforeach
                                                                            </select>
                                                                    </div>
                                                                @endif
                                                            @elseif ($field->type == 'radio')
                                                                @if ($field->options != "")
                                                                    <div class="col-md-6" data-name="PciYSkyC">
                                                                        <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                            @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                        </label>
                                                                    <div class="kt-radio-inline" data-name="VsDzAxho">
                                                                        @foreach (preg_split('/\r\n|[\r\n]/', $field->options) as $option)
                                                                            <label class="kt-radio">
                                                                                <input class="form-control" type="radio" autocomplete="off" name="{{$field->tag}}" value="{{ $option }}"  {{ $field->is_required ? 'required' : '' }} {{ isset($user->$tag) && $user->$tag == $option ? 'checked' : '' }}>{{ $option }}
                                                                                <span></span>
                                                                            </label>
                                                                        @endforeach
                                                                    </div>
                                                                    </div>
                                                                @endif
                                                            @elseif ($field->type == 'date')
                                                                <div class="col-md-6" data-name="PciYSkyC">
                                                                    <label class="col-form-label">{{$field->is_default ? trans('profile_fields.fname.'.$field->tag):$field->name}}
                                                                        @if($field->is_required=='1')<span class="required"> * </span>@endif
                                                                    </label>
                                                                    <input class="form-control datetimepicker-custom" id="{{$field->tag}}" type="text" name="{{$field->tag}}" value="{{ isset($user->$tag) ? str_replace(' 00:00:00','',$user->$tag) : '' }}" {{ $field->is_required ? 'required' : '' }}>
                                                                </div>
                                                            @endif
                                                        @endforeach
                                                    </div>
                                                @endforeach
                                                
                                            </div>
                                            <div class="kt-portlet__foot" data-name="MYjgXlLh">
                                                <div class="form-actions" data-name="iSHiUExt">
                                                    <div class="row" data-name="cdpEhWCD">
                                                        <div class="col-md-12" data-name="zLlxwDde">
                                                            <button type="button" id="update-profile" name="save_add" class="btn btn-success" value="save_add">
                                                                {{trans('common.form.button.save')}}
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2" data-name="XRHiiBhn">
                                <div class="col-md-12" data-name="DhzxMJfK">
                                    <form action="{{ route('user.setting',  $user->id) }}" method="POST" id="profile-frm1" class="kt-form kt-form--label-right" autocomplete="off">
                                        <input type="hidden" id="action" value="profile">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="hidden" id="user-id" value="{{$user->id}}">
                                        <input type="hidden" name="_method" value="PUT">

                                        <div class="kt-portlet__body" data-name="IsoQJgWV">
                                            <div class="form-body" data-name="gKHGwhht">
                                            
                                                <div class="form-group row" data-name="lLaoOCJT">
                                            

                                                    <div class="col-md-6" data-name="wPPlPjgG">
                                                        <label class="col-form-label">{{trans('common.label.time_zone')}} </label>
                                                        <select name="time_zone" class="form-control m-select2"
                                                            id="time_zone">
                                                            @foreach ($timezones as $time_zone => $time_zone_name)
                                                            {
                                                            <option value="{{$time_zone}}"
                                                                {{ ($time_zone == $users->timezone) ? 'selected' : '' }}>
                                                                {{ $time_zone_name }}</option>
                                                            }
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row" data-name="lLaoOCsasJT">
                                            

                                                    <div class="col-md-6" data-name="wPPlPjasasgG">
                                                        <label class="col-form-label">{{ trans('common.label.language') }} </label>
                                                        <select name="locale" class="form-control m-select2" id="language2">
                                                            @foreach($locales as $locale)
                                                                @if(!empty($locale->name))
                                                                <option {{$locale->locale== explode("|" , $user->locale)[0]?'selected':''}}  value="{{$locale->locale}}|{{$locale->fallback_locale}}">{{ strtoupper($locale->name) }}</option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row" data-name="e8iMXdCQid">


                                                    <div class="col-md-6" data-name="p5t7UPRxtN">
                                                        <label class="col-form-label">{{trans('common.label.time_format')}} </label>
                                                        <select name="time_format" class="form-control m-select2"id="time_format">
                                                            @foreach ($time_formats as $key => $time_format)
                                                                {
                                                                <option value="{{$time_format}}"
                                                                        {{ ($time_format == $user_time_format) ? 'selected' : '' }}>
                                                                    {{ $key }}</option>
                                                                }
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                            </div>
                                            <div class="kt-portlet__foot" data-name="lXJrqRqh">
                                                <div class="form-actions" data-name="BvcNhBxO">
                                                    <div class="row" data-name="DnbCtPmu">
                                                        <div class="col-md-12" data-name="lmeoVHTw">
                                                            <button type="submit" name="save_add" class="btn btn-success" value="save_add">
                                                                {{trans('common.form.button.save')}}
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END EXAMPLE TABLE PORTLET-->
            </div>
        </div>
    </div>
</div>
<!-- END FORM-->
@endsection
@section('page_scripts')
<script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
<script src="/themes/default/js/init.js" type="text/javascript"></script>
<script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/intlTelInput.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/validate-form.js" type="text/javascript"></script>

<!-- <script src="/themes/default/js/includes/profile.js" type="text/javascript"></script> -->\
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.10.0/js/bootstrap-datepicker.min.js" integrity="sha512-LsnSViqQyaXpD4mBBdRYeP6sRwJiJveh2ZIbW41EBrNmKxgr/LFZIiWT6yr+nycvhvauz8c2nYMhrP80YhG7Cw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
<script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
<script type="text/javascript">
    function confirmDomain() {
        var domain = $("#primary_domain").val();
        $.ajax({
            url: "{{ url('/') }}"+'/update/profile/verify/'+domain,
            type: 'GET',
            success: function(data) {
                if(data == 'confirm'){
                    $(".DSuccess").show();
                    $(".DFailed").hide();
                    $(".DPending").hide();
                    Command: toastr["success"] ("{{trans('Confirmed Successfully')}}");
                }else{
                    $(".DSuccess").hide();
                    $(".DFailed").show();
                    $(".DPending").hide();
                //    Command: toastr["error"] ("{{trans('primary_domain.error_message.primary_domain_failed')}}");
                }
                // window.location.href = "/profile/{{ $user->id }}?t=b";
            //   window.location.reload()
            }
        });
    }

    $('#branding-frm').submit(function(e){
        $("#bMsg").hide();
        if($("#branding_title").val() == "") {
            $("#branding_title").focus();
            $("#bMsg").show();
           
            return false;
        }
        var form = $('#branding-frm');
        var action = $(this).data('action');
        form.attr('action', action);
        form.submit();
    });

    function removeDisabledAttr() {
        $("#primary_domain").removeAttr('disabled');
        $("#edit_button").hide();
        $("#savee_buttonn").show();
        $("#close_button").show();
    }

    function closeEditing() {
        $("#primary_domain").attr('disabled', 'disabled');
        $("#edit_button").show();
        $("#savee_buttonn").hide();
        $("#close_button").hide();
    }

    $(document).ready(function () {
        $("#remove-image").click(function() {
            $("#imagePreview").attr("style", "background-image: url(/public/img/user.png)");
            $("#avatar").attr("src", "/public/img/user.png")
            var UpdateRemove = $("input[id=remove_image]");
             UpdateRemove.val(1);
            $(this).hide();
        });
        $(".m-select2").select2();
        // $(".btn-file>.fileinput-new").text(" Change ");
        $(".sb-form").click(function (e) {
            btn_id = this.id;
            id = '{{$user->id}}';
                method = "POST";
                route = '{{route('updateProfile')}}';
            
            formId = "#security";
            createOrUpdate(method, route, formId,e,btn_id);
        });
    });

    $('.form-control').on('keypress keyup change', function(e) {
        id = this.id;
        id = '#'+id;
        err_id = '#'+this.id+'-error';
        if(id !="#")
        $(id).removeClass('is-invalid');
        $(err_id).css('display','none');
    });
</script>
    <script type="text/javascript">
    function copyFunction() {
        var range = document.createRange();
        range.selectNode(document.getElementById("bc_code"));
        window.getSelection().removeAllRanges(); // clear current selection
        window.getSelection().addRange(range); // to select text
        document.execCommand("copy");
        window.getSelection().removeAllRanges(); // to deselect
        // console.log("Copied the text: " + range);
        Command: toastr["success"]("@lang('user_management.role.success_message.backup_code_copied')");
    }
    </script>
    <script type="text/javascript">
    $(document).ready(function() {

        $("#update-profile").click(function() {
             var form = $("#profile-frm").serialize();
            $(".form-control").css("border-color", "#bec4d0");
            var error = false;
            var email = $("#email").val();
            var name = $("#name").val();

            if(email == "") {
                $("#email").css("border-color", "red");
                error = true;
            }
            if(name == "") {
                $("#name").css("border-color", "red");
                error = true;
            }
            @foreach($req_profile_fields as $profile_field)
            var {{$profile_field}} =  $("#{{$profile_field}}").val()
            if({{$profile_field}}=="")
            {
                $("#{{$profile_field}}").css("border-color", "red");
                error = true;
            }
                    @endforeach

            if(!error) {
                $("#email").css("border-color", "#bec4d0");
                $("#name").css("border-color", "#bec4d0");
                // Command: toastr["success"] ('Profile updated successfully!');
                $("#profile-frm").submit();
            }
        else
            Command: toastr["error"] ('@lang("common.message.form_error")');

            return false;
            // $("#profile-frm").submit();
        });

        function readURL(input) {
            if (input.files && input.files[0]) {
                var a=(input.files[0].size);
                // alert(a);
                if(a > 2000000) {
                    Command: toastr["error"]("{{ trans('user_management.setting.form.profile_image.alert_message') }}");
                    return false;
                };
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#imagePreview').css('background-image', 'url('+e.target.result +')');
                    $('#imagePreview').hide();
                    $('#imagePreview').fadeIn(650);
                    $('#avatar').attr('src', e.target.result);
                    $('#avatar').hide();
                    $('#avatar').fadeIn(650);
                    $('#profile-image').attr('src', e.target.result);
                    $('#profile-image').hide();
                    $('#profile-image').fadeIn(650);
                    $("#remove-image").fadeIn(650);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $("#imageUpload").change(function() {
            readURL(this);
        });
        $("#logoUpload").change(function() {
            readURL(this);
        });

        $("#mobile").intlTelInput({
            placeholderNumberType: "MOBILE",
            separateDialCode: true,
            utilsScript: '{{ URL("/themes/default/js/includes/utils.js") }}'
        });

        var mobnum = $("#mobile").val();
        var codd = $('#ccode').val();
        $("#mobile").intlTelInput("setNumber", "+" + codd);
        $("#mobile").val(mobnum);
        $("#mobile").on("countrychange", function(e, countryData) {
            $("#ccode").val(countryData.dialCode);
        });

        $("#code-confirm").click(function() {
            $('.blockUI').show();
            setTimeout(function() {
                $(".qr-codeBlk").hide();
                $('.blockUI').show();
                $("form#s_step").show();
                $('.blockUI').hide();
            }, 1000);
        });

        $("#backtocode").click(function() {
            $("form#s_step").hide();
            $(".qr-codeBlk").show();
        });

        if ($("#2fa").is(":checked")) {
            $("#twofaModal .modal-header").html(
                '<i class="la la-info-circle"></i><h5 class="modal-title" id="twoMT"></h5><button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>'
            );
            $("#twoMT").html("@lang('user_management.profile.modal_heading.disable_two_factor')");
            $("#twofaModal .modal-header").addClass("disable2fa");
            $("#twofaModal .modal-footer").hide();
        } else {
            $("#twoMT").html("@lang('user_management.profile.modal_heading.enable_two_factor')");
        }
        $('#time_zone, #country, #time_format','#language2').select2({
            placeholder: "Select option"
        });
        $('#language2').select2({
            placeholder: "Select option"
        });
         

    });


    function addToList()
    {
        ip = $('.ipaddress').text();
     	ips = $('#login_ips').val();
     	if(ips!=="")
         	ips = ips+"\n"+ip;
     	else ips =ip;
     	$('#login_ips').val(ips);
     	$('.bt').prop('disabled',true);
     	
        
    }
    $(document).ready(function() {
    $('.datetimepicker-custom').datepicker({
        format: 'yyyy-mm-dd',
        autoclose: true
    });
    });
    </script>
    @endsection
