@extends(decide_template())

@section('title', $title)

@section('page_styles')
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<link href="/resources/assets/css/spintags-create.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<style>
    button.btn-sm {
        padding: 5px 10px !important;
        font-size: 11px !important;
    }    
    .temp-head {
        display: flex;
        width: 100%;
        align-items: center;
        font-weight: 600 !important;
        font-size: 13px;
        height: 45px;
        border-top: 1px solid #ddd;
    }
    .temp-head, .temp-blk {
        border-left: 1px solid #ddd;
        border-right: 1px solid #ddd;
        background: #FFF;
    }
    .temp-head .tags, .temp-row .tags {
        width: 25%;
    }
    .temp-head .desc, .temp-row .desc {
        width: 65%;
        /* max-width: 65%;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis; */
    }
    .temp-head .acts, .temp-row .acts {
        width: 15%;
        text-align: center;
    }
    .temp-head .acts {
        margin-right: 8px;
    }
    .temp-row {
        display: flex;
        align-items: center;
    }
    button.btn-sm.btn-clone {
        padding: 5px 10px !important;
        font-size: 12px !important;
        min-width: 20px !important;
    }
    .temp-head>div, .temp-row>div {
        padding: 10px;
    }
    .temp-blk .temp-row:nth-of-type(odd) {
        background: #f7f8fa;
    }
    .temp-blk .temp-row {
        border-top: 1px solid #ddd;
    }
    .temp-blk {
        max-height: 190px;
    }
    .temp-blk .temp-row:last-child {
        border-bottom: 1px solid #ddd;
    }
    #templates-blk {
        display:none;
        margin-top: 10px;
    }
    #btn-templates .ct {
        display: none;
    }
    #btn-templates .st {
        display: block;
    }
    #btn-templates.section-close .st {
        display: none;
    }
    #btn-templates.section-close .ct {
        display: block;
    }
    .btn-template {
        font-weight: 500;
        display: inline-table;
        margin-top: 10px;
        margin-bottom: 15px;
    }
    .btn-template:hover {
        color: #333 !important;
    }
    .btn-template i.la {
        rotate: 0deg;
        transition: 0.5s ease all;
        display: inline-block;
        vertical-align: middle;
    }
    .btn-template.section-close i.la {
        rotate: 90deg;
        transition: 0.5s ease all;
    }
    .search-pblock {
        display: flex;
        max-width: 260px;
    }
    .search-pblock input#searchp {
        border-top-right-radius: 0 !important;
        border-bottom-right-radius: 0 !important;
    }
    .search-pblock .btn {
        min-width: 39px;
        padding-left: 0 !important;
        padding-right: 0 !important;
        border-top-left-radius: 0 !important;
        border-bottom-left-radius: 0 !important;
        border-left: 0 !important;
    }
    button#btn-searchp {
        border: 1px solid #a1a8b7 !important;
        color: #a1a8b7;
        cursor: pointer;
        background: #FFF;
        margin-left: 0px;
        border-left: 0 !important;
        min-width: 45px !important;
        margin-bottom: 0;
    }
    .search-pblock .btn i {
        font-size: 16px;
    }
    #btn-searchp2 {
        display: none;
        border: 1px solid #a1a8b7 !important;
        color: #a1a8b7;
        cursor: pointer;
        background: #FFF;
        margin-left: 0px;
        border-left: 0 !important;
        min-width: 45px !important;
        margin-bottom: 0;
    }
</style>
@endsection

@section('page_scripts')
<script src="/themes/default/js/jquery.form.min.js" type="text/javascript"></script>
<script src="/themes/default/js/jquery.validate.js" type="text/javascript"></script>
<script src="/themes/default/js/additional-methods.js" type="text/javascript"></script>
<script src="/themes/default/js/init.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
<script src="/themes/default/js/select2.js" type="text/javascript"></script>
<script src="/themes/default/js/form-controls.js" type="text/javascript"></script>
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script src="/themes/default/js/includes/spin_tags.js" type="text/javascript"></script>
<script>
    var form_error="{{trans('common.message.form_error')}}";
    $(document).ready(function() {
        $(document).on('keyup keypress', 'form input[name="searchp"]', function(e) {
            if(e.which == 13) {
                e.preventDefault();
                return false;
            }
        });
        $('#tagname').on('input', function () {
            var cleaned = $(this).val().replace(/[^a-zA-Z0-9 _]/g, '');
            $(this).val(cleaned);
        });
        $("#btn-templates").click(function() {
            $("#templates-blk").slideToggle();
            $(this).toggleClass("section-close");
        });
        $("#btn-searchp").click(function() {
            $("#btn-searchp").hide();
            $("#btn-searchp2").show();
            var value = $("#searchp").val().toLowerCase();
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        $("#btn-searchp2").click(function() {
            $("#btn-searchp").show();
            $("#btn-searchp2").hide();
            $("#searchp").val("");
            var value = "";
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
        $('#searchp').keyup(function(e){
            if(e.keyCode == 13) {
                $(this).trigger("enterKey");
            }
        });
        $('#searchp').bind("enterKey",function(e){
            var value = $("#searchp").val().toLowerCase();
            $(".temp-blk .temp-row").filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
        });
    });
    function useTemp(tag,desc,values)
    {
        var tags = $("#tagname").val();
        var taglist = $.trim($("#taglist").val())
        var tagdesc = $("#tagdesc").val();
        if(tags != "" || taglist != "" || tagdesc != "") {
            Swal.fire({
                title: "{{trans('spintag.add.alert_confirm_title')}}",
                text: "{{trans('spintag.add.alert_confirm_description')}}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: "{{trans('common.label.confirm')}}"
            }).then((result) => {
                if (result.isConfirmed) {
                    $(".blockUI").show();
                    setTimeout(() => {
                        $("#tagname").val(tag);
                        $("#taglist").val(values.replace(/%%%/g, '\n'));
                        $("#tagdesc").val(desc);
                        $(".blockUI").hide();
                        $("#templates-blk").slideUp();
                        $("#btn-templates").removeClass("section-close");
                        Command: toastr["success"] ("Spintag template successfully added!");
                    }, 1500);
                } else {
                    $("#templates-blk").slideDown();
                    $("#btn-templates").addClass("section-close");
                }
            });
        } else {
            $(".blockUI").show();
            setTimeout(() => {
                $("#tagname").val(tag);
                $("#taglist").val(values.replace(/%%%/g, '\n'));
                $("#tagdesc").val(desc);
                $(".blockUI").hide();
                $("#templates-blk").slideUp();
                $("#btn-templates").removeClass("section-close");
                Command: toastr["success"] ("Spintag template successfully added!");
            }, 1500);
        }
    }
</script>
@endsection

@section(decide_content())

@if($errors->any())
    <!-- For PHP validations errors-->
    <div class="alert alert-danger" data-name="WKugIwZU">
        @foreach($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="rzRBrJQl">
    {{ Session::get('msg') }}
</div>
@endif
<!-- will be used to show any messages -->
<div id="msg" class="display-hide" data-name="iYYJLRYF">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>
<div class="col-md-6 create-form" data-name="qDwPVqxQ">
    <!-- BEGIN FORM-->
@if($action == 'add')
        <form action="" method="POST" id="spintags-frm" class="kt-form kt-form--label-right" autocomplete="off">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <input type="hidden" id="action" value="add">
    @else 
        <form action="{{ route('spintag.update', $spinTag->id) }}" method="POST" id="spintags-frm" autocomplete="off" class="kt-form kt-form--label-right">
        <input type="hidden" id="action" value="edit">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <input type="hidden" id="spintag-id" value="{{$spinTag->id}}">
        <input type="hidden" name="_method" value="PUT">
    @endif
        <div class="row" data-name="CsVHvaMg">
            <div class="kt-portlet kt-portlet--height-fluid" data-name="htrXTgbB">
                <div class="kt-portlet__head" data-name="oxzDIHtQ">
                    <div class="kt-portlet__head-label" data-name="HtSmybcH">
                        <h3 class="kt-portlet__head-title">{{trans('spintag.form_heading')}}</h3>
                    </div>
                </div>
                <div class="kt-portlet__body" data-name="lEEPdWuL">
                    <div class="form-body" data-name="iJyAYkhn">

                        <!-- Name / Placeholder -->
                        {{-- @if(routeAccess('clone_spintag') && $action=='add') --}}
                        @if($action=='add')
                            @if(routeAccess('clone_spintag'))
                        <a href="javascript:;" class="btn-template"  id="btn-templates"> 
                            {{trans('spintag.add.button.pre_define_template')}} <i class="la la-angle-right"></i>
                        </a>
                            @endif
                        <div class="form-group row mb0" id="templates-blk" data-name="oRssRNWB">
                            <div class="col-md-12" data-name="zPiJOnvC">
                                <div class="kt-portlet kt-portlet--bordered" data-name="pJODGrH5" id="run-migrate-block" style="display: block;">
                                    <div class="kt-portlet__head" data-name="qTHZIBmc">
                                        <div class="kt-portlet__head-label" data-name="ATccxBNh">
                                            <h3 class="kt-portlet__head-title" style="">{{ trans("spintag.add.box_title") }}</h3>
                                        </div>
                                        <div class="kt-portlet__head-label">
                                            <div class="search-pblock">
                                                <input type="text" class="form-control" name="searchp" id="searchp">
                                                <button type="button" class="btn btn-secondary btn-sm" id="btn-searchp">
                                                    <i class="fa fa-search"></i>
                                                </button>
                                                <button type="button" class="btn btn-secondary btn-sm" id="btn-searchp2">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="kt-portlet__body" data-name="vztGIoPd">
                                        <div class="temp-head">
                                            <div class="tags">{{trans('spintag.form.name')}}</div>
                                            <div class="desc">{{trans('spintag.form.description')}}</div>
                                            <div class="acts">{{trans('common.table_heading.actions')}}</div>
                                        </div>
                                        <div class="temp-blk scroll">
                                            @foreach($templates as $template)
                                            <div class="temp-row {{$template->place_holder}}">
                                                <div class="tags">{{$template->place_holder}}</div>
                                                <div class="desc">{{$template->description}}</div>
                                                <div class="acts">
                                                    @php
                                                    $words = $buffer = str_replace(["\r\n", "\r", "\n"], "%%%",$template->word_list);
                                                    @endphp
                                                    <button onclick="useTemp('{{$template->place_holder}}','{{$template->description}}','{{$words}}')"  class="btn btn-info btn-sm btn-clone" type="button">{{trans('spintag.add.button.use_this')}}</button>
                                                </div>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                        <!-- Name / Placeholder -->

                        <!-- Name / Placeholder -->
                        <div class="form-group row" data-name="oRssRNWB">
                            <div class="col-md-12" data-name="zPiJOnvC">
                                <label class="col-form-label">{{trans('spintag.form.name')}}
                                    <span class="required"> * </span>
                                     {!! popover( 'spintag.form.name_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="VwyBNeSC">
                                    <input id="tagname" type="text" name="place_holder" class="form-control" {{isset($spinTag->place_holder) ? "readonly" : '' }} value="{{isset($spinTag->place_holder) ? $spinTag->place_holder : '' }}" />
                                </div>
                            </div>
                        </div>
                        <!-- Name / Placeholder -->

                        <!-- List of Words -->
                        <div class="form-group row" data-name="nodWCubL">
                            <div class="col-md-12" data-name="FzsYCeQb">
                                <label class="col-form-label">{{trans('spintag.form.words')}} <span class="required"></span>
                                    {!! popover( 'spintag.form.words_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="CnEEMVhY">
                                    <textarea id="taglist" name="word_list" class="form-control" rows="12">{{@$spinTag->word_list}}</textarea>
                                </div>
                            </div>
                        </div>
                        <!-- List of Words -->        
                        
                        <div class="form-group row" data-name="oRssRNWB">
                            <div class="col-md-12" data-name="zPiJOnvC">
                                <label class="col-form-label">{{trans('spintag.form.description')}}
                                     {!! popover( 'spintag.form.description_description','common.description' ) !!}
                                </label>
                                <div class="input-icon right" data-name="VwyBNeSC">
                                    <input id="tagdesc" type="text" name="description" class="form-control" value="{{@$spinTag->description}}" />
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="kt-portlet__foot" data-name="OxaAdMjo">
                    <div class="form-actions" data-name="YPOFBFiA">
                        <div class="row" data-name="lHKALCdk">
                            <div class="col-md-12" data-name="jGvUwMJD">
                                @if($action == 'add')
                                <!-- save & exit -->
                                <button type="submit" name="save_exit" class="btn btn-success" value="save_exit">{{trans('common.form.button.save')}}</button>
                                @else
                                <!-- save -->
                                <button type="submit" name="edit" class="btn btn-success" value="edit">{{trans('common.form.button.save')}}</button>
                                @endif
                                <!-- cancel -->
                                <a href="{{ route('spintag.index') }}"><button type="button" class="btn btn-default">{{trans('common.form.button.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- END FORM-->
</div>
@endsection
