@extends(decide_template())

@section('title', trans('languages.view.title'))

@section('page_styles')
<link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
<link href="/themes/default/css/code/prism-live.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/themes/default/css/code/prism2.css?v={{$local_version}}" rel="stylesheet" type="text/css">
<link href="/resources/assets/css/update-language.css?v={{$local_version}}" rel="stylesheet" type="text/css">
@endsection

@section('page_scripts')
<script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
<script src="/themes/default/js/code/prism-live.js" type="text/javascript"></script>
<script src="/themes/default/js/code/prism2.js" type="text/javascript"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".btn-block").click(function() {
            var changeIn = $("#changeIn").val();
            if(changeIn == 1) { 
                Swal.fire({
                    // title: "Are you sure?",
                    text: "{{trans('languages.view.alert_confirm.update_title')}}",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    cancelButtonText: "{{trans('common.keep_editing')}}",
                    confirmButtonText: "{{trans('common.leave')}}",
                }).then((result) => {
                if (result.isConfirmed) {
                    $(".btn-block").removeClass("active");
                    $(this).addClass("active");                
                    $("#file_name").val( $(this).attr("data-id") + ".php");
                    $(".blockUI").show();
                    $.ajax({
                        type: "POST",
                        url: "{{ route('language.select') }}",
                        data: {file_name : $(this).attr("data-id") , locale: "<?php echo $language->locale; ?>"},
                        complete: function(result) { 
                            $(".blockUI").hide();
                        },
                        success: function(result) {
                            $("#head_section").text(result);
                            var block = document.getElementById('head_section');
                            Prism.highlightElement(block);
                            Prism.highlightAll();
                            
                            setTimeout(() => {
                                $(".blockUI").hide(); 
                                $("#changeIn").val(0);  
                            }, 500);
                        }
                    });

                }});
            } else {
                $(".blockUI").show();
                $.ajax({
                    type: "POST",
                    url: "{{ route('language.select') }}",
                    data: {file_name : $(this).attr("data-id") , locale: "<?php echo $language->locale; ?>"},
                    complete: function(result) { 
                        $(".blockUI").hide();
                    },
                    success: function(result) {
                        $("#head_section").text(result);
                        var block = document.getElementById('head_section');
                        Prism.highlightElement(block);
                        Prism.highlightAll();
                        
                        setTimeout(() => {
                            $(".blockUI").hide(); 
                            $("#changeIn").val(0);  
                        }, 500);
                    }
                });
            }
            
        });
        $("#cancel").click(function() {
            window.location.href = "/languages";
        });
    });

    $(function () {
        setTimeout(() => {
            $("#changeIn").val(0);
        }, 2000);
    });
    
    $("body").on("click" , "#save" , function() { 
        var form_data = {
            content : $("#head_section").text(),
            language :  $("#language").val(),
            file_name :  $("#file_name").val()
        };
        $(".blockUI").show();
        $.ajax({
            type: "POST",
            url: "{{ route('languages.save') }}",
            data: form_data,
            complete: function(result) { 
                $(".blockUI").hide();
            },
            success: function(result) {
                var obj = JSON.parse(result);
                if(obj["status"] == true) { 
                    Command: toastr["success"] (obj["msg"]);
                } else {
                    Command: toastr["error"] (obj["msg"]);
                }
                
            }
        })
    });

    $("body").on("click" , ".kt-menu__link,.kt-notification__item,.btn-signout", function() { 
          var url = $(this).attr('href');
          
         // return false;
          if(url!=='javascript:;'){
             
            $(".swal2-confirm").css("background-color", "#dd3333");
            $(".swal2-cancel").css("background-color", "#95a0a8");
            Swal.fire({
                title: "",
                text: "{!! trans('broadcasts.form.alert_message.leave_page') !!}",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                cancelButtonText: "{{trans('common.keep_editing')}}",
                confirmButtonText: "{{trans('common.leave')}}",
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = $(this).attr('href');
                    // console.log(url);
                    window.location.href = url;
                }
            }); 
              
              return false;
         }
          
    }); 

    
    $('#head_section').on('DOMSubtreeModified', function(){
        $("#changeIn").val(1);
    });

</script>
@endsection

@section(decide_content())

@if($errors->any())
    <!-- For PHP validations errors-->
    <div class="alert alert-danger" data-name="eNToTnJj">
        @foreach($errors->all() as $error)
            <p>{{ $error }}</p>
        @endforeach
    </div>
@endif
<!-- will be used to show any messages -->
@if (Session::has('msg'))
<div class="alert alert-success" data-name="DJlRjxcu">
    {{ Session::get('msg') }}
</div>
@endif
<!-- will be used to show any messages -->
<div id="msg" class="display-hide" data-name="rQbTOcrq">
    <button class="close" data-close="alert"></button>
    <span id='msg-text'><span>
</div>

<?php 
if(!empty($_GET["file"])) { 
    $fileName = $_GET["file"] . ".php";
} else {
    $files= (Array)$files;
    $fileName = $files[2];
}
$fileContent  = file_get_contents(base_path() . "/resources/lang/" . $language->locale . "/" .  $fileName); //();
?>
<div class="col-md-12" data-name="PvKgzkQt">
    <div class="row" data-name="vehsWUet">
        <div class="kt-portlet kt-portlet--height-fluid" data-name="kxmTfGzI">
            <div class="kt-portlet__head" data-name="rpPuIaVS">
                <div class="kt-portlet__head-label" data-name="EFCDMAaZ">
                    <h3 class="kt-portlet__head-title">{{trans('languages.update.widget_title')}} (<?php echo ucfirst(str_replace(".php", "", str_replace("_", " ", $fileName))); ?>)</h3>
                </div>
            </div>
            <div class="kt-portlet__body" data-name="DHdFBzAq">
                <div class="form-body" data-name="tuBaDhyU">      
                    
                    <p>{{ trans('languages.update.widget_description') }}</p>

                    <div class="form-group row header-code-area" data-name="ZlbNccUH">
                        <div class="col-md-2 pr-0">
                            <div class="btn-blk">
                                 @foreach($files as $file)
                                 @if($file != "." AND $file != "..")
                                 <?php 
                                    $selected = "";
                                    if($fileName == $file) $selected = "active";
                                    $file_name = str_replace(".php" , "" , $file); 
                                 ?>
                                    <button type="button" class="btn btn-default btn-block {{$selected}} " data-id="{{$file_name}}">{{$file_name}}</button>
                                 @endif
                                 @endforeach
                               
                            </div>
                        </div>
                        <div class="col-md-10 pl-0">
                            <pre
                                onPaste="setTimeout(function() {onPaste();}, 0)"
                                id="editable"
                                contenteditable
                            ><code class="prism-live line-numbers language-clike fill" name="head_section" id="head_section">{{$fileContent}}</code></pre>
                            <input type="hidden" id="file_name" value="{{$fileName}}">
                            <input type="hidden" id="language" value="{{$language->locale}}">
                            <input type="hidden" id="changeIn" value="0">
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="kt-portlet__foot" data-name="TwXhLvET">
                <button type="button" class="btn btn-secondary" id="cancel">{{trans('common.form.button.cancel')}}</button>
                <button type="button" class="btn btn-success" id="save">{{trans('common.form.button.update')}}</button>
            </div>
        </div>
    </div>
</div>



@endsection