@extends(decide_template())

@section('title', $pageTitle)

@section('page_styles')
    <link href="/themes/default/css/sweetalert2.min.css" rel="stylesheet" type="text/css">
    <link href="/resources/assets/css/dynamic-content-tags-view.css?v={{$local_version}}" rel="stylesheet" type="text/css">
    <style>
        table#dynamic-content tr th:nth-child(3), table#dynamic-content tr td:nth-child(3) {
            width: 120px;
            text-align: left !important;
            max-width: 300px;
        }
    </style>
@endsection

@section('page_scripts')
    <script src="/themes/default/js/sweetalert2.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/select2.full.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/components-bootstrap-multiselect.min.js" type="text/javascript"></script>
    <script src="/themes/default/js/bootstrap-multiselect.js" type="text/javascript"></script>
    <script src="/themes/default/js/datatables.bundle.js" type="text/javascript"></script>
    <script src="/themes/default/js/includes/common.js" type="text/javascript"></script>
    <script>
        var objTable;
        var record_type = 'our_records';
        $(document).ready(function() {

            $("a#help-article").css("display", "block");
            $("a#help-article").attr("href", "https://support.mumara.com/hc/articles/1/8/16/dynamic-content-tags");

            // function in master2 layout
            var page_limit=show_per_page('','dynamic_content_pageLength',10);  // Params (table,page,default_limit=10)
            var table=$('#dynamic-content').DataTable({
                "aoColumnDefs": [{"bSortable": false, "aTargets": [0,2]}],
                "bProcessing": true,
                "bServerSide": true,
                "aaSorting": [[3, "desc"]],
                "sPaginationType": "full_numbers",
                "sAjaxSource": "{{ url('/getDynamicContentTemplates') }}",
                "pageLength" : page_limit,
                "fnServerParams": function (aoData) {
                    aoData.push({"name": "record_type", "value": record_type});
                    aoData.push({"name": "clients", "value": $("#clients").val()});
                    aoData.push({"name": "admins", "value": $("#admins").val()});
                },
                "aLengthMenu": [[10, 50, 100, 500], [10, 50, 100, 500]]
            });
            objTable = table;
            page_limit=show_per_page(table,'dynamic_content_pageLength');
        });
        // delete Dynamic Content Tags
        function contentDelete(id) {

            var return_list = "";
            document.getElementById("get_users_list").innerHTML="";

            var return_drip = "";
            document.getElementById("get_users_list2").innerHTML="";

            var return_form="";
            document.getElementById("get_users_list3").innerHTML="";

            $.get('/dynamictag/check/running/' + id, function (data) {
                $(".blockUI").show();
                // console.log(data);
                if (data == 'not_exists') {
                    $(".blockUI").show();
                    Swal.fire({
                        title: "{{trans('dynamic_tags.alert_confirm.title_sure')}}",
                        text: "{!! trans('dynamic_tags.alert_confirm.description_not_revert') !!}",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#dd6b55',
                        confirmButtonText: "Yes",
                        cancelButtonColor: '#c1c1c1',
                        cancelButtonText: "No"
                        // confirmButtonText: "{{trans('dynamic_tags.alert_confirm.button.delete')}}"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            $(".blockUI").hide();
                            $.ajax({
                                url: "{{ url('/') }}"+'/dynamictag/'+id,
                                type: "DELETE",
                                data:{'enabled_for_users':1},
                                success: function(result) {
                                    $(".blockUI").hide();
                                    if(result == 'delete') {
                                        $("#row_"+id).attr("style", "display:none");
                                        Swal.fire({
                                            title: "{{trans('dynamic_tags.alert_confirm.message_deleted')}}",
                                            text: "{{trans('dynamic_tags.alert_confirm.description_tag_deleted')}}",
                                            icon: 'success',
                                            showCancelButton: false,
                                            showConfirmButton: false,
                                            buttons: false
                                        });
                                        setTimeout(function () {
                                            Swal.close()
                                            $("#modal-delete").modal("hide");
                                            // location.reload();
                                        }, 2500);
                                    }
                                }
                            });
                        }
                        $(".blockUI").hide();
                    });
                }
                else {
                    $(".blockUI").hide();

                    $("#modal-delete").modal("show");
                    for (var x = 0; x < data[0]['broadcast'].length; x++) {
                        return_list += "<li><a href=\"broadcast/" + data[0]['broadcast'][x]['id'] + "/edit?type=1\" target=\"_blank\"><i class=\"fa fa-angle-double-right\"></i> " + data[0]['broadcast'][x]['name'] + " </a></li>";
                    }
                    var listContainer = document.getElementById("get_users_list");
                    listContainer.innerHTML = "<label class='col-form-label'>Broadcasts</label><ul class='no-list'>" + return_list + "</ul>";

                    for (var y = 0; y < data[0]['drip'].length; y++) {
                        return_drip += "<li><a href=\"drip/" + data[0]['drip'][y]['id'] + "/edit\" target=\"_blank\"><i class=\"fa fa-angle-double-right\"></i> " + data[0]['drip'][y]['name'] + " </a></li>";
                    }
                    var dripContainer = document.getElementById("get_users_list2");
                    dripContainer.innerHTML = "<label class='col-form-label'>Drip Campaigns</label><ul class='no-list'>" + return_drip + "</ul>";

                    for (var z = 0; z < data[0]['form'].length; z++) {
                        return_form += "<li><a href=\"form/" + data[0]['form'][z]['id'] + "/edit\" target=\"_blank\"><i class=\"fa fa-angle-double-right\"></i> " + data[0]['form'][z]['name'] + " </a></li>";
                    }
                    var formContainer = document.getElementById("get_users_list3");
                    formContainer.innerHTML = "<label class='col-form-label'>Webforms</label><ul class='no-list'>" + return_form + "</ul>";
                }
            });







        }
        // delete selected Dynamic Content Tags
        function deleteAll () {
            if(!$('.checkbox-index:checkbox:checked').length){
                Command: toastr["error"] ("{{trans('common.message.alert_no_record')}}");
                return false;
            } else {
                Swal.fire({
                    title: "{{trans('dynamic_tags.alert_confirm.title_sure')}}",
                    text: "{!! trans('common.message.alert_delete') !!}",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#c1c1c1',
                    confirmButtonText: "{{trans('dynamic_tags.alert_confirm.button.delete')}}"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $(".blockUI").show();
                        var dynamic_content = $('input:checkbox:checked').map(function() {
                            return this.value;
                        }).get();
                        $.ajax({
                            type    : "DELETE",
                            url     : "{{ url('/') }}"+"/dynamictag/"+dynamic_content,
                            data    : {ids: dynamic_content},
                            success: function(result) {
                                if(result == 'delete') {
                                    $(".blockUI").hide();
                                    Swal.fire({
                                        title: "{{trans('dynamic_tags.alert_confirm.message_deleted')}}",
                                        text: "{{trans('dynamic_tags.alert_confirm.description_tag_deleted')}}",
                                        icon: 'success',
                                        showCancelButton: false,
                                        showConfirmButton: false,
                                        buttons: false
                                    });
                                    setTimeout(function () {
                                        Swal.close()
                                        location.reload();
                                    }, 2500);
                                    // window.location.href = "{{route('dynamictag.index')}}";
                                }
                            }
                        });
                    }
                });
            }
        }

        function changeStatus(id,class_) {
            var enabled_for_users;
            var enabled = $('.'+class_).is(':checked');
            if(enabled)
                enabled_for_users = 1;
            else
                enabled_for_users = 0;
            $.ajax({
                type   : "PUT",
                url    : "{{ route('dynamictag.update','') }}/"+id,
                data: {'change_status': 1,'enabled_for_users':enabled_for_users},
                success: function(result) {
                    $('.blockUI').hide();
                    if(result.status == "success") {
                        Command: toastr["success"](result.message);
                        objTable.draw();
                    }
                    else
                        Command: toastr["error"] (result.message);
                }
            });
        }
    </script>
@endsection

@section(decide_content())

    <!-- will be used to show any messages -->
    @if (Session::has('msg'))
        <div class="alert alert-success" data-name="LuVxkEHx">
            {{ Session::get('msg') }}
        </div>
    @endif
    <div id="msg" class="display-hide" data-name="znmUMPmB">
        <button class="close" data-close="alert"></button>
        <span id='msg-text' class="alert-text"><span>
    </div>
    <div class="row" data-name="PdftqkBI">
        <div class="col-md-12" data-name="vIUlmmBQ">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="kt-portlet kt-portlet--height-fluid" data-name="ZEdqjGCy">
                <div class="kt-portlet__body" data-name="EtanMTDZ">
                    <div class="table-toolbar" data-name="EvduZWcD">
                        <div class="form-group row" data-name="KPPPDikY">
                            <div class="col-md-6" data-name="UNMHheeu">
                                @if(routeAccess('dynamictag.templates_add'))
                                    <div class="btn-group" data-name="tipwEtVA">
                                        <a href="{{ route('dynamictag.templates_add') }}">
                                            <button id="sample_editable_1_new" class="btn btn-label-success">
                                                <i class="la la-plus"></i> {{trans('common.form.button.add_new')}}
                                            </button></a>
                                    </div>
                                @endif

                            </div>
                            <div class="col-md-6" data-name="kZugaLnm">
                                <div class="btn-group pull-right" data-name="gOxPzZJD">
                                    <button class="btn btn-label-info dropdown-toggle" data-toggle="dropdown">
                                        {{ trans('common.button.bulk_actions') }}
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        @if(routeAccess('dynamictag.destroy'))
                                            <li>
                                                <a href="javascript:;" onclick="deleteAll();"class=""> <i class="fa fa-remove"></i> {{trans('common.form.button.delete')}}  </a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <table class="table table-striped table-hover table-checkable responsive" id="dynamic-content" role="grid" >
                        <thead>
                        <tr role="row">
                            <th style="width: 25px;">
                                <label class="kt-checkbox kt-checkbox--single kt-checkbox--all kt-checkbox--solid">
                                    <input type="checkbox" class="checkboxes checkbox-all-index" autocomplete="off">
                                    <span></span>
                                </label>
                            </th>
                            <th>{{trans('dynamic_tags.view.table_heading.dynamic_tag')}}</th>
                            <th>{{trans('spintag.view.table_heading.description')}}</th>
                            <th>{{trans('spintag.view.table_heading.enable_users')}}</th>
                            <th>{{trans('dynamic_tags.view.table_heading.added_on')}}</th>
                            <th>{{trans('common.table_heading.actions')}}</th>
                        </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>


    <div class="modal fade" id="modal-delete" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"data-keyboard="false" data-backdrop="static" >
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{trans('dynamic_tags.model.delete.widget_heading')}}</h5>
                    <!-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    </button> -->
                </div>
                <form id="form-import" action="#" method="POST" autocomplete="off">
                    <div class="modal-body">

                        <div class="alert alert-warning" id="error-msg">
                        <span class="alert-text" id="error-msg-upload">{!!trans('dynamic_tags.model.delete.alert_message')!!}<span>
                        </div>

                        <div class="row" data-name="igUKVYRO">
                            <div class="col-md-12" data-name="jFQSGZuo">
                                <div id="domain-data" data-name="oyaHdXQR">
                                    <div class="list-block" data-name="bDplkoVS">
                                        <div id="assignedAssets" class="row list-scroll" data-name="BwVlKOtK">
                                            <div class="col-md-12" data-name="ZKtDemZp">

                                                <div id="get_users_list"></div>
                                            </div>
                                            <div class="col-md-12" data-name="ZKtDemZp">

                                                <div id="get_users_list2"></div>

                                            </div>

                                            <div class="col-md-12" data-name="ZKtDemZp">

                                                <div id="get_users_list3"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer" data-name="lCYRZcBU">
                        <button type="button" class="btn btn-secondary btn-sm pull-left" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection