<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["email"]["view"]["title"] = "Email Suppression";
$lang["email"]["view"]["description"] = "Manage and review the list of email addresses that are blocked from receiving your communications. Suppressed emails are excluded from campaigns to comply with unsubscribe requests, manage bounces, or adhere to email deliverability rules, ensuring that your messages only reach valid and active recipients.";
$lang["email"]["view"]["emails_inside"] = "Email suppression for List:";
$lang["email"]["model"]["title"] = "Suppress Email Addresses";
$lang["email"]["model"]["descripton"] = "Importing email addresses into suppression will prevent " . $lang["variables"]["site_title"] . " from sending any further emails to these addresses. You can add emails to the global suppression list or associate them with specific contact lists, ensuring they are excluded from future campaigns.";
$lang["email"]["view"]["table_heading"]["md5"] = "MD5 Hash";
$lang["email"]["view"]["table_heading"]["no_encryption"] = "No Hashing";
$lang["email"]["view"]["table_heading"]["reference"] = "Reference";
$lang["email"]["view"]["table_heading"]["contacts"] = "Associated List";
$lang["email"]["view"]["table_heading"]["users"] = "User";
$lang["email"]["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["email"]["view"]["table_heading"]["email_encryption"] = "Email Hashing";
$lang["email"]["view"]["table_heading"]["email_encryption_desc"] = "Mumara allows you to import a suppression list using MD5 hashing. If your suppression list is already hashed, choose the appropriate hashing type during import to ensure accurate suppression of email addresses.";
$lang["email"]["view"]["table_heading"]["activity"] = "Email Suppression List";
$lang["email"]["view"]["delete_suppression"]["confirm_message"] = "Are you sure you want to unsuppress all emails associated with this reference and remove them from the suppression list?";
$lang["email"]["view"]["delete_suppression"]["delete_refrence_popover"] = "Delete all suppressed emails having this reference and unsuppress them from original lists.";
$lang["export"]["alert_message"]["no_cleint_id_selected"] = "Delete all emails from suppression associated with this reference and unsuppress them from their original lists.";
$lang["domain"]["view"]["title"] = "Domain Suppression";
$lang["domain"]["view"]["description"] = "Suppress entire domains that you no longer want to send emails to. This is useful for domains that generate high complaint rates or deliver poor ROI, ensuring your emails reach only valuable and responsive recipients.";
$lang["domain"]["model"]["update_domain"]["title"] = "Edit Suppressed Domain";
$lang["domain"]["model"]["label"]["contact_list"] = "Contact List";
$lang["domain"]["table_heading"]["actions"]["delete_refrence_link"] = "Flush reference";
$lang["domain"]["model"]["title"] = "Suppress Domains";
$lang["domain"]["model"]["description"] = "Importing domains into suppression will prevent " . $lang["variables"]["site_title"] . " from sending any further emails to addresses associated with these domains. You can add domains to global suppression or link them to specific contact lists for targeted suppression.";
$lang["domain"]["view"]["table_heading"]["domain"] = "Domain";
$lang["domain"]["view"]["table_heading"]["reference"] = "Reference";
$lang["domain"]["view"]["table_heading"]["list"] = "Associated List";
$lang["domain"]["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["domain"]["view"]["table_heading"]["activity"] = "Suppressed Domains List";
$lang["domain"]["view"]["delete_suppression"]["confirm_message"] = "Are you sure you want to delete all domains associated with this reference from the suppression list and unsuppress the corresponding contacts?";
$lang["domain"]["view"]["domain_update"]["success_message"] = "Suppressed domain has been updated successfully.";
$lang["domain"]["view"]["domain_update"]["invalid_message"] = "Invalid domain.";
$lang["domain"]["view"]["domain_update"]["already_exists_message"] = "Domain already exists in suppression.";
$lang["ip"]["view"]["title"] = "IP Suppression";
$lang["ip"]["view"]["description"] = "Automatically suppress contacts that engage from an IP address listed in the IP suppression table. When a contact interacts with your emails, " . $lang["variables"]["site_title"] . " cross-references the IP address with the suppression list. If a match is identified, the contact is suppressed, ensuring no further emails are sent to them.";
$lang["ip"]["view"]["table_heading"]["ip_address"] = "IP Address";
$lang["ip"]["view"]["table_heading"]["contact_list"] = "Associated List";
$lang["ip"]["view"]["table_heading"]["reference"] = "Reference";
$lang["ip"]["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["ip"]["modal"]["label"]["ip_address"] = "IP Address";
$lang["ip"]["modal"]["label"]["ip_address_help"] = "Enter individual IP addresses, subnets, or an IP range to add them to the suppression list, blocking any future email communications associated with these addresses.";
$lang["ip"]["modal"]["label"]["contact_list"] = "Contact List";
$lang["ip"]["modal"]["label"]["reference"] = "Reference";
$lang["ip"]["view"]["delete_suppression"]["confirm_message"] = "Are you sure you want to delete all IPs associated with this reference from the suppression list and unsuppress the corresponding contacts?";
$lang["ip"]["alert_message"]["already_exist"] = "The IP address already exists in suppression.";
$lang["ip"]["alert_message"]["invalid_ips"] = "Invalid or Duplicate IP address:";
$lang["ip"]["alert_message"]["cancel_import"] = "Cancel import";
$lang["view"]["modal"]["select_list"]["option_global"] = "Global";
$lang["view"]["modal"]["upload_file"]["help_description"] = "Upload your file(s) to :path to be shown here";
$lang["ip"]["table_heading"]["actions"]["delete_refrence_link"] = "Flush reference";
$lang["view"]["modal"]["form"]["label"]["select_list"] = "Select List";
$lang["email"]["modal"]["form"]["label"]["select_list_help"] = "Choose the specific list to apply suppression. Contacts will only be suppressed within the selected list, allowing targeted suppression without affecting other contact lists. For system-wide suppression, use global suppression instead.";
$lang["domain"]["modal"]["form"]["label"]["select_list_help"] = "Choose the specific list to apply suppression. Contacts will only be suppressed within the selected list, allowing targeted suppression without affecting other contact lists. For system-wide suppression, use global suppression instead.";
$lang["ip"]["modal"]["form"]["label"]["select_list_help"] = "Choose the specific list to apply suppression. Contacts will only be suppressed within the selected list, allowing targeted suppression without affecting other contact lists. For system-wide suppression, use global suppression instead.";
$lang["view"]["modal"]["form"]["label"]["method"] = "Source";
$lang["view"]["modal"]["form"]["label"]["method_help"] = "Choose how you would like to import the email addresses to suppression.";
$lang["domain"]["modal"]["form"]["label"]["method_help"] = "Choose how you would like to import the domains to suppression.";
$lang["view"]["modal"]["form"]["label"]["upload_csv_file"] = "" . $lang["variables"]["csv_upload"] . "";
$lang["view"]["modal"]["form"]["label"]["method_option_from_server"] = "" . $lang["variables"]["csv_select"] . "";
$lang["email"]["modal"]["form"]["label"]["option_email_input"] = "Input email addresses";
$lang["email"]["modal"]["form"]["label"]["option_domain_input"] = "Input domains";
$lang["view"]["modal"]["form"]["label"]["choose_file"] = "Select file";
$lang["view"]["modal"]["form"]["label"]["max_file_size"] = "Maximum file size";
$lang["view"]["modal"]["form"]["label"]["uploading_file"] = "Uploading file";
$lang["domain"]["modal"]["form"]["label"]["domain"] = "Domains";
$lang["view"]["modal"]["form"]["label"]["reference"] = "Reference";
$lang["email"]["modal"]["form"]["label"]["reference_help"] = "Tag a reason or example explaining why these email addresses are being suppressed.";
$lang["domain"]["modal"]["form"]["label"]["reference_help"] = "Tag a reason or example explaining why these domains are being suppressed.";
$lang["ip"]["modal"]["form"]["label"]["reference_help"] = "Tag a reason or example explaining why these IP addresses are being suppressed.";
$lang["view"]["modal"]["form"]["label"]["line_contains_headers"] = "Includes header?";
$lang["view"]["modal"]["form"]["label"]["line_contains_headers_help"] = "If the first row of file contains headers and it needs to be skipped.";
$lang["view"]["modal"]["form"]["label"]["rocket_speed"] = "Rocket import";
$lang["view"]["modal"]["form"]["button"]["import"] = "Import";
$lang["view"]["alert_message"]["delete_all_files"] = "Are you sure want to delete all uploaded files from the server?";
$lang["view"]["alert_message"]["import_operation_success"] = "<div class='alert alert-success alert-light alert-bold' role='alert' id='resultbar'><b> <div id='imported'>0</div> </b> contacts were imported out of &nbsp; <b> <div id='total_alert'>0</div> </b>&nbsp; contacts.</div>";
$lang["view"]["alert_message"]["delete_with_empty_reference"] = "Can not flush the empty reference.";
$lang["email"]["alert_message"]["sync_suppression_message"] = "After deleting from global suppression, it's suggested to run the Resync Suppression.";
$lang["view"]["alert_message"]["export_command_running_background"] = "The export has been started in the background, you can download the file once the export is complete.";
$lang["domain"]["alert_message"]["file_not_exist"] = "File not found.";
$lang["domain"]["alert_message"]["unautherize_url"] = "You are not authorized to download this file.";
$lang["domain"]["alert_message"]["domain_suppression_limit"] = "You can add up to :limit domain(s) in suppression. The available limit is :left.";
$lang["email"]["alert_message"]["domain_suppression_limit"] = "Suppression resync process cannot be initiated because a suppression process is already in progress.";
$lang["view"]["table_warning"]["suppression_running_time"] = "<b>Note: </b>&nbsp; Suppression list synchronizes every <code>:minutes</code> minutes.";
$lang["view"]["alert_message"]["suppression_running_disable"] = "<b>Note: </b>&nbsp; Suppression processing cron is disabled. Manage &nbsp; <a href='/settings/cron'> crons here</a>.";
$lang["view"]["alert_message"]["suppression_running_disable_user"] = "<b>Note: </b>&nbsp; Suppression processing has disabled by the admin. Contact the administrator for further details.";
$lang["view"]["alert_message"]["importing_txt_div"] = "Importing";
$lang["view"]["alert_message"]["into_txt_div"] = "into";
$lang["email"]["alert_message"]["resync_suppression_button"] = "Re-sync Suppression";
$lang["email"]["alert_message"]["save_txt_button"] = "Save";
$lang["email"]["alert_message"]["operation_successful_msg"] = "Operation completed successfully.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
