<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["title"] = "Administrators";
$lang["view"]["description"] = "Add new administrator accounts, assign or modify roles, and easily delete accounts as needed. This page centralizes control over administrator access, ensuring efficient management of user permissions and system security.";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["view"]["table_heading"]["role"] = "Role";
$lang["add"]["title"] = "Add Administrator";
$lang["add"]["description"] = "Add a new administrator account with specified user details and assigned roles for controlled system access.";
$lang["form_heading"] = "Administrator Details";
$lang["form"]["label"]["name"] = "Name";
$lang["form"]["label"]["name_description"] = "Specify the name of the administrator to be added.";
$lang["form"]["label"]["email_description"] = "Enter the email address for the administrator.";
$lang["form"]["label"]["password"] = "Password";
$lang["form"]["label"]["password_description"] = "Set the password the administrator will use to log in.";
$lang["form"]["label"]["confirm_password"] = "Confirm Password";
$lang["form"]["label"]["confirm_password_description"] = "Re-enter the password to confirm it.";
$lang["form"]["label"]["admin_role"] = "Role";
$lang["form"]["label"]["admin_role_description"] = "Select the role to assign the necessary privileges to the administrator.";
$lang["edit"]["title"] = "Edit Administrator";
$lang["edit"]["description"] = "Update administrator details, modify their assigned roles, and manage their access and settings.";
$lang["role"]["view"]["title"] = "Admin Roles";
$lang["role"]["view"]["description"] = "Admin roles define the permissions and access levels for administrators within the system. Each role is configured with specific privileges, determining what actions the administrator can perform. By assigning roles, you can control who can manage users, settings, content, and other key areas, ensuring secure and efficient system operations.";
$lang["role"]["view"]["table_heading"]["name"] = "Role Name";
$lang["role"]["add"]["title"] = "Add Admin Role";
$lang["role"]["add"]["description"] = "Create a new role with specific permissions to control administrator access and responsibilities.";
$lang["role"]["form_heading"] = "Role Privileges";
$lang["role"]["form"]["label"]["role_name"] = "Role Name";
$lang["role"]["form"]["label"]["role_name_description"] = "Provide a descriptive name for the admin role.";
$lang["role"]["edit"]["title"] = "Edit Admin Role";
$lang["role"]["edit"]["description"] = "Modify an existing admin role by updating its permissions and access levels to better suit the requirements.";
$lang["staff"] = "Admin Management";
$lang["view"]["table_heading"]["actions"]["retry_operation"] = "Retry Operation";
$lang["update"]["notification"]["activity_title"] = "Admin Role";
$lang["view"]["model"]["delete_option"]["assign_assets"] = "Assign assets to another admin?";
$lang["view"]["model"]["delete_option"]["delete_assets"] = "Delete the assigned assets?";
$lang["alert_message"]["soft_delete"] = "<b>Soft Delete:</b> It will delete the account but will not delete the associated data.";
$lang["alert_message"]["hard_delete"] = "<b>Hard Delete:</b> It will delete the account and will also delete the associated data.";
$lang["view"]["model"]["delete"] = "Delete Admin";
$lang["view"]["model"]["delete_placeholder"]["select_admin"] = "Select Admin";
$lang["view"]["model"]["delete_option_contribution_by"] = "All contributions by";
$lang["view"]["model"]["delete_option_reassign_admin"] = "will be re-assigned to the selected admin.";
$lang["view"]["model"]["delete_option_assets_added_by"] = "All assets that were added by";
$lang["view"]["model"]["delete_option_will_be_deleted"] = ", will also be deleted.";
$lang["alert_confirm"]["delete_option_confirm"] = "This process is irrevocable. Are you sure you want to proceed?";
$lang["form"]["label"]["hourly_sending_rate"] = "Hourly sending rate";
$lang["form"]["label"]["hourly_sending_rate_description"] = "If it is not set to any value, there will be no limit on hourly email sending speed for the campaigns scheduled by this admin.";
$lang["form"]["label"]["daily_sending_limit"] = "Daily sending limit";
$lang["form"]["label"]["daily_sending_limit_description"] = "If it is not set to any value, there will be no daily limit on the emails sent by this admin, unless applied by the Application Settings.";
$lang["form"]["label"]["monthly_sending_limit"] = "Monthly sending limit";
$lang["form"]["label"]["monthly_sending_limit_description"] = "If it is not set to any value, there will be no monthly limit on the emails sent by this admin, unless applied by the Application Settings.";
$lang["form"]["input_value"]["value"] = "Value";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
