<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["view"]["title"] = "Drip Campaigns";
$lang["view"]["description"] = "Drip campaigns allow you to automate a series of targeted emails, keeping your audience engaged over time. By setting up timed follow-ups, you can guide leads through their customer journey and increase the chances of conversion, all with minimal manual effort.";
$lang["view"]["button"]["add_group"] = "Drip Groups";
$lang["view"]["button"]["add_drip"] = "Add a Drip";
$lang["view"]["table_heading"]["name"] = "Name";
$lang["view"]["table_heading"]["delay"] = "Delay";
$lang["view"]["table_heading"]["status"] = "Status";
$lang["view"]["table_heading"]["added_on"] = "" . $lang["variables"]["created_on"] . "";
$lang["add"]["title"] = "Add Drip";
$lang["add"]["description"] = "Drips are part of a drip group and are sent when the specified delay criteria is met following an event. For example, you can set a drip to send a follow-up email three hours after a contact is added to your list.";
$lang["campaign"]["form"]["tab_1"]["form_heading"] = "Drip Details";
$lang["campaign"]["form"]["tab_1"]["form_heading_description"] = "Drip name, group and more.";
$lang["campaign"]["form"]["label"]["followup_name"] = "Drip Name";
$lang["campaign"]["form"]["label"]["followup_name_description"] = "Provide a friendly name for easy identification.";
$lang["campaign"]["form"]["label"]["group_description"] = "Select the drip group to add it to.";
$lang["campaign"]["form"]["label"]["status_description"] = "Set the drip to active or inactive. Inactive drips will not be processed.";
$lang["campaign"]["form"]["label"]["send_to_existing"] = "Send to Existing Contacts";
$lang["campaign"]["form"]["label"]["send_to_existing_description"] = "Send this drip to the existing pre-qualified contacts during the next trigger execution. This switch will automatically turn off after the execution.";
$lang["campaign"]["form"]["tab_2"]["form_heading"] = "Interval";
$lang["campaign"]["form"]["tab_2"]["form_heading_description"] = "Time delay for sending this drip";
$lang["campaign"]["form"]["tab_2"]["title"] = "Execution Time";
$lang["campaign"]["form"]["label"]["when_to_send"] = "Specify when this drip should be sent";
$lang["campaign"]["form"]["label"]["when_to_send_description"] = "<ul>
<li><strong>Upon Triggering:</strong>&nbsp; The drip will be queued for sending immediately after the trigger event occurs.</li>
<li><strong>After Triggering:</strong>&nbsp; The drip will be sent after the specified time delay is reached.</li>
</ul>";
$lang["campaign"]["form"]["label"]["when_to_send_option"]["upon_triggering"] = "Upon Triggering";
$lang["campaign"]["form"]["label"]["when_to_send_option"]["after_triggering"] = "After Triggering";
$lang["campaign"]["form"]["tab_3"]["form_heading"] = "Email Content";
$lang["campaign"]["form"]["tab_3"]["form_heading_description"] = "Create the drip email content.";
$lang["campaign"]["form"]["tab_3"]["title"] = "Design the drip email";
$lang["campaign"]["form"]["label"]["email_subject"] = "Email Subject";
$lang["campaign"]["form"]["label"]["email_subject_description"] = "Enter the subject line for the drip email that recipients will receive.";
$lang["campaign"]["form"]["label"]["html_body"] = "HTML Content";
$lang["campaign"]["form"]["label"]["html_body_description"] = "Create the HTML version of the email content.";
$lang["campaign"]["form"]["label"]["text_body"] = "Text Content";
$lang["campaign"]["form"]["label"]["text_body_description"] = "Create the plain text version of the email content.";
$lang["campaign"]["form"]["label"]["domain_to_use_for_preview"] = "Sending domain for preview";
$lang["campaign"]["form"]["label"]["domain_to_use_for_preview_description"] = "The preview email will be sent from the selected domain.";
$lang["campaign"]["form"]["label"]["send_preview_to_email"] = "Email address to send a test preview";
$lang["campaign"]["form"]["label"]["send_preview_to_email_description"] = "Enter the email address where you'd like to receive a test preview of this drip email.";
$lang["campaign"]["form"]["button"]["test_email"] = "Send a Test";
$lang["campaign"]["form"]["button"]["test_email_description"] = "Note: Sending a preview will not convert the variables e.g. first name, last name, web version or unsubscribe links, etc.";
$lang["edit"]["title"] = "Edit Drip:";
$lang["edit"]["description"] = "Modify your drip properties e.g. categorization, execution internal, or customizing the content to fit your needs.";
$lang["group"]["title"] = "Drip Groups";
$lang["group"]["description"] = "View and manage drip groups, add new drips and organize them.";
$lang["group"]["button"]["add_group"] = "Add New Drip Group";
$lang["group"]["button"]["add_new"] = "Add New Drip";
$lang["group"]["table_heading"]["name"] = "Drip Group";
$lang["group"]["table_heading"]["drip_count"] = "Drip Count";
$lang["group"]["table_heading"]["created_date"] = "Creation Date";
$lang["add_group"]["title"] = "Add Drip Group";
$lang["add_group"]["description"] = "A drip group contains a series of drip emails that are sent when a specific event is triggered.";
$lang["add_group"]["notification"]["activity_title"] = "Drip Group";
$lang["add_group"]["page_heading"] = "Drip Group Settings";
$lang["add_group"]["form"]["label"]["smtp_list_description"] = "Select the sending nodes responsible for relaying the drips. Multiple selections will rotate the chosen sending nodes.";
$lang["add_group"]["form"]["label"]["track_opens_description"] = "Enable tracking for when recipients open your drip emails.";
$lang["add_group"]["form"]["label"]["track_clicks_description"] = "Enable tracking for when recipients click on links in your drip emails.";
$lang["add_group"]["form"]["label"]["track_unsubscribe_link_description"] = "Automatically embed an unsubscribe link at the end of drip email.";
$lang["add_group"]["form"]["label"]["sender_info"] = "Sender Details";
$lang["add_group"]["form"]["label"]["sender_info_description"] = "Specify the sender details for the drip email, i.e. sender name, sender email, reply-to address, and return-path.
You can either fetch sender info automatically or use custom details:
<ul>
<li><strong>Use from Sending Node:</strong> Use sender information as specified in the Sending Node settings.</li>
<li><strong>Use from Contact List:</strong> Use sender information as specified in the Contact List settings.</li>
<li><strong>Use Custom:</strong> Manually enter custom sender information for this drip group.</li>
</ul>";
$lang["add_group"]["form"]["label"]["from_name_listed_in_list"] = "Don't Override Sender Name";
$lang["add_group"]["form"]["label"]["from_name_listed_in_smtp"] = "Don't Override Sender Name";
$lang["add_group"]["form"]["label"]["from_domain"] = "Domain";
$lang["edit_group"]["title"] = "Edit Drip Group:";
$lang["edit_group"]["description"] = "Modify the settings for your drip group, including sending nodes, tracking options, and sender information. Customize the drip group to ensure it aligns with your campaign strategy and automation goals";
$lang["view"]["alert_message"]["copy"] = "Duplicate this Drip?";
$lang["add_group"]["form"]["error_message"]["no_smtp_is_selected"] = "Sending Node selection is missing.";
$lang["view"]["success_message"]["unsubscribed"] = "You have been unsubscribed successfully.";
$lang["view"]["success_message"]["drip_copied"] = "Drip has been copied successfully.";
$lang["view"]["success_message"]["datetime_updated"] = "Drip has been updated successfully.";
$lang["group"]["table_heading"]["action"]["view"] = "View Drips";
$lang["update"]["notification"]["activity_title"] = "Drip";
$lang["form"]["label"]["email_campaigns"] = "Email Campaigns";
$lang["form"]["campaign_type_option"]["global"] = "Global All Campaigns";
$lang["form"]["campaign_type_option"]["opened"] = "Opened Email Campaigns";
$lang["form"]["label"]["link_clicked"] = "Link Clicked";
$lang["view"]["alert_message"]["drip_copied"] = "Drip has been copied successfully.";
$lang["view"]["label"]["copy"] = "Make a copy";
$lang["view"]["label"]["upon_triggering"] = "Upon Triggering";
$lang["grouping_blade"]["Drip_name_th"] = "Drip Name";
$lang["grouping_blade"]["group_name_th"] = "Group Name";
$lang["grouping_blade"]["delay_txt_th"] = "Delay";
$lang["grouping_blade"]["status_txt_th"] = "Status";
$lang["grouping_blade"]["added_on_txt_th"] = "Added on";
$lang["grouping_blade"]["actions_txt_th"] = "Actions";
$lang["grouping_blade"]["local_leads_td"] = "Local Leads (Follow up # 3)";
$lang["grouping_blade"]["social_leads_td"] = "Social Leads (Manual)";
$lang["grouping_blade"]["days_txt_td"] = "days";
$lang["grouping_blade"]["local_leads_three_td"] = "Local Leads (Follow up # 2)";
$lang["grouping_blade"]["local_leads_one_td"] = "Local Leads (Follow up # 1)";
$lang["grouping_blade"]["instant_txt_td"] = "Instant";
$lang["grouping_blade"]["test_follow_up_td"] = "Test Follow up - 8 minutes";
$lang["grouping_blade"]["wasif_test_td"] = "Wasif Test";
$lang["grouping_blade"]["minutes_txt_td"] = "minutes";
$lang["grouping_blade"]["after_send_existing_td"] = "After 6 minutes - Send to existing";
$lang["grouping_blade"]["after_twentyfive_send_existing_td"] = "After 25 Minutes - Send to Existing";
$lang["grouping_blade"]["after_ten_send_existing_td"] = "After 10 Minutes (send to existing)";
$lang["grouping_blade"]["thankyou_subscription_td"] = "1- Thank You (Subscription Confirmation)";
$lang["grouping_blade"]["lp_leads_td"] = "LP Leads";
$lang["grouping_blade"]["intro_mumara_campaigns_td"] = "2- Introduction to Mumara Campaigns+";
$lang["grouping_blade"]["your_inquiry_campaigns_td"] = "3- Fwd: Your Inquiry about Mumara Campaigns+";
$lang["grouping_blade"]["after_one_month_td"] = "4- After 1 Month";
$lang["grouping_blade"]["months_txt_td"] = "months";
$lang["grouping_blade"]["after_two_month_td"] = "5- After 2 Months";
$lang["add_group"]["group_help"] = "Name of the new drip group.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
