<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["add"]["title"] = "Add Custom Field";
$lang["add"]["description"] = "Edit and customize your custom field details. You can adjust the field order, type, and assign or reassign it to different lists. Please note that custom field names cannot be changed.";
$lang["edit"]["title"] = "Edit Custom Field";
$lang["form"]["label"]["name"] = "Name";
$lang["form"]["label"]["name_description"] = "The name of the custom field. It will be used as variable in email content as well.";
$lang["form"]["label"]["field_order"] = "Field Order";
$lang["form"]["label"]["field_order_help"] = "The position or order in which the field will appear when adding a contact.";
$lang["form"]["label"]["field_type"] = "Type";
$lang["form"]["label"]["field_type_help"] = "The type of field, such as Text Field, Multiline Text Field, Checkboxes, Dropdown, Radio Options, Date Field, or JSON Field.";
$lang["form"]["label"]["required"] = "Required";
$lang["form"]["label"]["required_help"] = "If set to \"Yes,\" this field becomes mandatory for adding a contact to the associated list.";
$lang["form"]["label"]["list_of_values"] = "List of Values";
$lang["form"]["label"]["list_of_values_help"] = "List the values separated by lines that can be selected when adding contacts.";
$lang["form"]["label"]["contact_list"] = "Assign to Contact Lists";
$lang["form"]["label"]["contact_list_help"] = "Select the contact lists to which this custom field should be assigned now. You can also assign this field when creating or editing a contact list.";
$lang["form"]["label"]["language"] = "Language Text";
$lang["form"]["label"]["language_help"] = "For example: custom_fields.contact_lists.firstname";
$lang["form_heading"] = "Custom Field Details";
$lang["form"]["label"]["check_list"] = "Assign/unassign to the existing contacts";
$lang["form"]["label"]["check_list_message"] = "If you unassign a custom field, the data for that field will be permanently deleted from all contacts of the selected lists.";
$lang["form"]["label"]["name_error_message"] = "Name should be alphanumeric.";
$lang["view"]["pagetitle"] = "Custom Fields";
$lang["view"]["description"] = "Custom fields allow you to store additional information about your leads/contacts beyond just email addresses, such as first and last name, company, country, phone number, etc.";
$lang["message"]["field_exists"] = "Custom field already exists";
$lang["activity_log"]["title"] = "Custom Field";
$lang["view"]["title"]["table_headings"]["name"] = "Name";
$lang["view"]["title"]["table_headings"]["sorting_order"] = "Sorting Order";
$lang["view"]["title"]["table_headings"]["type"] = "Type";
$lang["form"]["duplicate_field"]["message"] = "The custom field with this name already exists.";
$lang["view"]["model_delete"]["label"]["issue_1"] = "The custom field is assigned to one or more contact lists.";
$lang["view"]["model_delete"]["label"]["issue_2"] = "The custom field is not assigned to any contact list, but it contains data.";
$lang["view"]["model_delete"]["alert_warning"]["message_1"] = "<b>Error:</b> This custom field is currently assigned to contact lists. Please unassign it from all associated contact lists before deletion.";
$lang["view"]["model_delete"]["alert_warning"]["message_2"] = "<b>Warning:</b> This custom field is not assigned to any contact list, but it still contains data. Deleting this field will also remove all data associated with it.";
$lang["view"]["model_delete"]["action_description"] = "If you want to proceed with deletion, the following actions are available:";
$lang["view"]["model_delete"]["action_description_check"] = "Unassign this custom field from all linked contact lists and delete it.";
$lang["view"]["model_delete"]["action_alert_message"] = "<b>Note:</b> This action will also remove all data associated with the custom field.";
$lang["view"]["model_delete"]["data_flush_check"] = "I understand that deleting the custom field will remove all data associated with this.";
$lang["view"]["model_delete"]["button_delete"] = "Delete Field";
$lang["form"]["label"]["name_alphabetic_error"] = "The first character must be a letter.";
$lang["form"]["label"]["name_space_error"] = "Only letters, numbers, underscores, and spaces are allowed.";
$lang["form"]["alert"]["forbidden_error"] = "Commas (,) are not allowed in the list of values";
$lang["view"]["delete_field"]["alert_title"] = "Are you sure you want to delete this custom field?";
$lang["view"]["delete_field"]["alert_message"] = "Custom field deleted successfully!";
$lang["contact_lists"]["firstname"] = "First Name";
$lang["contact_lists"]["lastname"] = "Last Name";
$lang["contact_lists"]["dob"] = "Birth Date";
$lang["contact_lists"]["city"] = "City";
$lang["contact_lists"]["state"] = "State";
$lang["contact_lists"]["country"] = "Country";
$lang["contact_lists"]["zip_code"] = "Zip Code";
$lang["contact_lists"]["mobile"] = "Mobile";
$lang["contact_lists"]["phone"] = "Phone";
$lang["contact_lists"]["fax"] = "Fax";
$lang["contact_lists"]["company"] = "Company";
$lang["contact_lists"]["title"] = "Title";
$lang["add_new"]["field"]["type"]["values"]["text"] = "Text Field";
$lang["add_new"]["field"]["type"]["values"]["number"] = "Numeric";
$lang["add_new"]["field"]["type"]["values"]["textarea"] = "Multiline Text Field";
$lang["add_new"]["field"]["type"]["values"]["checkbox"] = "Checkboxes";
$lang["add_new"]["field"]["type"]["values"]["select"] = "Dropdown";
$lang["add_new"]["field"]["type"]["values"]["radio"] = "Radio Options";
$lang["add_new"]["field"]["type"]["values"]["date"] = "Date Field";
$lang["add_new"]["field"]["type"]["values"]["json"] = "Json Field";
$lang["form"]["label"]["default"] = "Default";
$lang["form"]["label"]["default_help"] = "Enabling this will set this custom field as default.";
$lang["view"]["title"]["table_headings"]["default"] = "Default";
$lang["view"]["default_field"]["success_message"] = "This field is now default.";
$lang["view"]["default_field"]["alert_message"] = "Field is no longer default.";
$lang["view"]["title"]["table_headings"]["group"] = "Group Name";
$lang["view"]["title"]["table_headings"]["required"] = "Required";
$lang["form"]["label"]["prioritize_groups"] = "Prioritize Groups";
$lang["form"]["label"]["prioritize_groups_desc"] = "Arrange the order in which groups appear in the dropdown list.";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
