<?php

include("variables.php");

/**
 * Created by Mumara Team
 * Date: 07/04/2025
 */

$lang["add"]["title"] = "Add Contact";
$lang["add"]["description"] = "Add a contact to a list and include additional details by filling out custom fields.";
$lang["form_heading"] = "Contact's Details";
$lang["form"]["label"]["contact_list_help"] = "Select the contact list from the dropdown where you want to organize this contact.";
$lang["form"]["label"]["email_address_help"] = "The email address must be valid; otherwise, " . $lang["variables"]["site_title"] . " may not add it.";
$lang["form"]["label"]["format_help"] = "Specify the format for the broadcast this contact will receive, either HTML or TEXT version.";
$lang["form"]["label"]["bounced"] = "Bounced";
$lang["form"]["label"]["bounced_help"] = "Mark the contact as 'Not Bounced'. Setting it as hard bounced will prevent this contact from receiving emails.";
$lang["form"]["label"]["bounce_option_not_bounced"] = "Not Bounced";
$lang["form"]["label"]["bounce_option_soft_bounced"] = "Soft Bounced";
$lang["form"]["label"]["bounce_option_hard_bounced"] = "Hard Bounced";
$lang["form"]["label"]["unsubscribed"] = "Unsubscribed";
$lang["form"]["label"]["unsubscribed_help"] = "Setting as Unsbuscribed will prevent this contact from receiving any emails for this list.";
$lang["form"]["label"]["confirmation"] = "Confirmation Status";
$lang["form"]["label"]["confirmation_help"] = "Choose whether this contact is a confirmed or unconfirmed subscriber.";
$lang["form"]["label"]["status_help"] = "Set the contact status as Active or Inactive. Inactive contacts will not receive the emails.";
$lang["form"]["label"]["suppressed"] = "Suppressed";
$lang["form"]["label"]["placeholder_choose_list"] = "Choose List";
$lang["edit"]["title"] = "Edit Contact";
$lang["custom_field"]["form_heading"] = "Contact's Information";
$lang["custom_field"]["widget_heading"] = "Custom Fields";
$lang["view"]["title"] = "View/Search Contacts";
$lang["view"]["description"] = "Search, view, or manage contacts based on specific criteria, allowing you to perform actions such as searching, deleting, or editing within a targeted list or across the entire database.";
$lang["view"]["modal"]["heading"]["contact_detail"] = "Contact's Details";
$lang["view"]["button"]["import_contacts"] = "Import Contacts";
$lang["view"]["bulk_actions_dropdown"]["set_soft_bounce"] = "Set as Soft Bounced";
$lang["view"]["bulk_actions_dropdown"]["set_hard_bounce"] = "Set as Hard Bounced";
$lang["view"]["bulk_actions_dropdown"]["set_not_bounce"] = "Set as Not Bounced";
$lang["view"]["bulk_actions_dropdown"]["set_confirmed"] = "Set as Confirmed";
$lang["view"]["bulk_actions_dropdown"]["set_unconfirmed"] = "Set as Unconfirmed";
$lang["view"]["bulk_actions_dropdown"]["set_active"] = "Set as Active";
$lang["view"]["bulk_actions_dropdown"]["set_inactive"] = "Set as inactive";
$lang["view"]["table_heading"]["contact"] = "Contact";
$lang["view"]["table_heading"]["list"] = "List";
$lang["view"]["table_heading"]["bounced"] = "Bounced";
$lang["view"]["table_heading"]["unsubscribed"] = "Unsubscribed";
$lang["view"]["table_heading"]["confirmed"] = "Confirmed";
$lang["view"]["table_heading"]["group_name"] = "Group";
$lang["view"]["table_heading"]["active"] = "Active";
$lang["view"]["table_heading"]["spammed"] = "Spammed";
$lang["view"]["table_heading"]["suppressed"] = "Suppressed";
$lang["view"]["table_heading"]["re_order"] = "Re-order Columns";
$lang["view"]["table_heading"]["pre_columns"] = "Prioritize Columns";
$lang["view"]["table_heading"]["pre_columns_text"] = "Select the columns you want to display for this contact list and rearrange the order to prioritize them.";
$lang["email_history"]["title"] = "Email History";
$lang["email_history"]["description"] = "View the history of emails sent to this contact.";
$lang["email_history"]["widget_heading"] = "Contact Details";
$lang["email_history"]["event_log"] = "Event Log";
$lang["email_history"]["widget_title"]["campaign_table_heading"] = "Campaigns";
$lang["email_history"]["widget_title"]["triggers_table_heading"] = "Triggers";
$lang["email_history"]["table_heading"]["name"] = "Name";
$lang["email_history"]["table_heading"]["sent"] = "Sent";
$lang["email_history"]["table_heading"]["bounced"] = "Bounced";
$lang["email_history"]["table_heading"]["status"] = "Status";
$lang["import"]["alert_message"]["contacts_limit_exceeded"] = "Oops... You are trying to import :total_subscribers contacts, which exceeds the remaining limit of :remaining_limit contacts. Please upload a smaller file or consider upgrading your plan.";
$lang["import"]["alert_message"]["contacts_limit_exceeded_1"] = "Contact limit exceeded";
$lang["import"]["alert_message"]["list_limit_exceeded"] = "This contact list is limited to :subscribers_limit contacts.";
$lang["add"]["form"]["alert_message"]["limit_exceeded_admin"] = "There was an issue adding more contacts. Please contact support for assistance.";
$lang["add"]["form"]["alert_message"]["no_rights_more_contact"] = "You do not have permission to add more contacts.";
$lang["import"]["alert_message"]["limit_exceeded_demo"] = "Contact limit exceeded. The demo version supports 5000 contacts.";
$lang["bulk_update"]["success_message"]["bulk_update_complete"] = "Bulk update completed successfully.";
$lang["import"]["alert_message"]["all_files_deleted"] = "All uploaded files have been deleted.";
$lang["add"]["form"]["alert_message"]["access_denied"] = "Access Denied";
$lang["add"]["form"]["alert_message"]["valid_email"] = "The email address is not valid.";
$lang["add"]["form"]["alert_message"]["contact_email_exists"] = "The contact :email already exists in the contact list :list_name.";
$lang["import"]["form"]["alert_message"]["email_mapping_error"] = "Email address mapping is required to proceed.";
$lang["import"]["form"]["alert_message"]["no_list_error"] = "You need to create a contact list before importing your contacts.";
$lang["edit"]["form"]["alert_message"]["subscriber_not_found"] = "No contact found for this ID or it has been deleted.";
$lang["form"]["custom_fields"]["placeholder_select_country"] = "Select Country";
$lang["form"]["custom_fields"]["placeholder_choose_a_list"] = "Choose a list";
$lang["form"]["add"]["notification"]["activity_title"] = "Contact";
$lang["import"]["title"] = "Import Contacts";
$lang["import"]["description"] = "Easily import large numbers of contacts from a CSV or TEXT file and map custom fields as required.";
$lang["import"]["form_heading"] = "Contact Details";
$lang["import"]["form"]["label"]["import_file"] = "File Source";
$lang["import"]["form"]["label"]["import_file_help"] = "Choose how you'd like to upload your file: from your computer or from files already on the server.";
$lang["import"]["form"]["label"]["email_address_help"] = "Email address of the contact. If the email address has an invalid format, " . $lang["variables"]["site_title"] . " will skip it.";
$lang["import"]["form"]["label"]["select_file_help"] = "Select the file from your computer or server, based on the option chosen above.";
$lang["import"]["form"]["label"]["contact_list_help"] = "Choose the contact list where you want to import the contacts.";
$lang["import"]["form"]["label"]["create_a_list"] = "Create a List";
$lang["import"]["form"]["label"]["import_speed"] = "Import Speed";
$lang["import"]["form"]["label"]["import_speed_help"] = "Speed up the import process by up to 4x with multiple threads.";
$lang["import"]["form"]["label"]["format_help"] = "Choose the format in which these contacts will receive emails, either HTML or TEXT. If HTML is selected, the recipients will receive both versions of the broadcast.";
$lang["import"]["form"]["label"]["file_format"] = "File Format";
$lang["import"]["form"]["label"]["file_format_help"] = "Select the format of the file you're importing.";
$lang["import"]["form"]["label"]["duplicates_help"] = "If duplicate emails are found, choose whether " . $lang["variables"]["site_title"] . " should skip them, update the existing contacts with new information, or overwrite them. Overwriting means the old duplicate contacts will be deleted, and the new ones will be added.";
$lang["import"]["form"]["label"]["contacts_from"] = "Importing Contacts From";
$lang["import"]["form"]["label"]["select_none"] = "None";
$lang["import"]["form"]["label"]["confirmation_status"] = "Confirmation Status";
$lang["import"]["form"]["label"]["confirmation_status_help"] = "Import contacts as confirmed to make sure they receive your emails.";
$lang["import"]["form"]["label"]["contact_status"] = "Contact Status";
$lang["import"]["form"]["label"]["contact_status_help"] = "Import contacts as active so " . $lang["variables"]["site_title"] . " doesn't filter them out before sending emails.";
$lang["import"]["form"]["label"]["line_contains_headers_help"] = "If your CSV file has a header in the first row, " . $lang["variables"]["site_title"] . " will skip that line during import.";
$lang["import"]["form"]["label"]["select_date_format"] = "Select the date format";
$lang["import"]["form"]["label"]["override_creation_date"] = "Override Creation Date";
$lang["import"]["form"]["label"]["override_creation_date_help"] = "This option is helpful if you have triggers or drip campaigns that rely on the contact's creation date.";
$lang["import"]["form"]["label"]["notification"] = "You can leave this page if required. The import will continue running in the background.";
$lang["import"]["form"]["label"]["record_processed"] = "Number of Records Processed";
$lang["import"]["alert_message"]["file_not_exist"] = "The file doesn't exist.";
$lang["import"]["alert_message"]["running_in_background"] = "The import has started in the background.";
$lang["import"]["alert_message"]["email_column_error"] = "The email column is missing.";
$lang["import"]["alert_message"]["list_not_exist"] = "The contact list doesn't exist.";
$lang["add"]["form"]["alert_message"]["contact_admin"] = "There was an issue adding more contacts. Please contact the support.";
$lang["import"]["alert_message"]["file_type"] = "The file must be one of the following types";
$lang["import"]["alert_message"]["echo_file_not_found"] = "File not found";
$lang["bulk_update"]["table_heading"]["total_contact"] = "Total Contacts:";
$lang["bulk_update"]["table_heading"]["imported"] = "Imported:";
$lang["bulk_update"]["table_heading"]["duplicates"] = "Duplicates:";
$lang["bulk_update"]["table_heading"]["invalids"] = "Invalid:";
$lang["bulk_update"]["table_heading"]["cancel_import"] = "Cancel import";
$lang["bulk_update"]["import_progress"]["operation_aborated"] = "The operation has been aborted";
$lang["bulk_update"]["import_progress"]["new_contact"] = "new contacts";
$lang["bulk_update"]["import_progress"]["imported"] = "imported";
$lang["bulk_update"]["import_progress"]["out_of"] = "out of";
$lang["bulk_update"]["import_progress"]["Import_rules"] = "contacts based on your import criteria.";
$lang["bulk_update"]["title"] = "Bulk Update";
$lang["bulk_update"]["description"] = "Bulk Update allows you to modify multiple contacts at once for faster and easier management.";
$lang["bulk_update"]["form"]["label"]["contact_list_help"] = "Select the contact list(s) you want to update.";
$lang["bulk_update"]["form"]["label"]["actions"] = "Action";
$lang["bulk_update"]["form"]["label"]["action_help"] = "Choose an action you’d like to perform from the dropdown.";
$lang["bulk_update"]["form"]["label"]["choose_action"] = "Select Action";
$lang["bulk_update"]["form"]["label"]["action"]["delete_contacts"] = "Delete selected contacts";
$lang["bulk_update"]["form"]["label"]["action"]["update_unsubscribe"] = "Mark contacts as unsubscribed";
$lang["bulk_update"]["form"]["label"]["action"]["update_unsubscribed_as_active"] = "Mark contacts as subscribed";
$lang["bulk_update"]["form"]["label"]["action"]["update_soft_bounce"] = "Mark contacts as soft bounced";
$lang["bulk_update"]["form"]["label"]["action"]["update_hard_bounce"] = "Mark contacts as hard bounced";
$lang["bulk_update"]["form"]["label"]["action"]["update_active"] = "Set contact status to active";
$lang["bulk_update"]["form"]["label"]["action"]["update_inactive"] = "Set contact status to inactive";
$lang["bulk_update"]["form"]["label"]["action"]["update_confirmed"] = "Mark contacts as confirmed";
$lang["bulk_update"]["form"]["label"]["action"]["update_unconfirmed"] = "Mark contacts as unconfirmed";
$lang["bulk_update"]["form"]["label"]["action"]["update_html"] = "Set format to HTML";
$lang["bulk_update"]["form"]["label"]["action"]["update_text"] = "Set format to TEXT";
$lang["bulk_update"]["upload_file"]["alert_message"]["task_scheduled"] = "The bulk update process has been started in the background and will continue automatically.";
$lang["bulk_update"]["page_heading"] = "Update contacts";
$lang["bulk_update"]["table_heading"]["records_in_file"] = "Total records in file";
$lang["bulk_update"]["table_heading"]["records_in_lists"] = "Total records in contact lists";
$lang["bulk_update"]["table_heading"]["processed"] = "Records processed";
$lang["bulk_update"]["alert_message"]["task_updating"] = "Updating";
$lang["bulk_update"]["alert_message"]["task_using"] = "using";
$lang["bulk_update"]["alert_message"]["task_cancel"] = "update has been cancelled";
$lang["bulk_update"]["success_message"]["task_updated"] = "successfully updated with";
$lang["bulk_update"]["alert_message"]["task_preparing"] = "Preparing to start updating";
$lang["bulk_update"]["alert_message"]["task_background"] = "You can leave this page now. The import process will continue running in the background.";
$lang["bulk_update"]["alert_message"]["small_note_confirm_email_subscription"] = "Note: This contact will need to confirm their email subscription before they can start receiving campaigns.";
$lang["custom_field"]["form"]["placeholder_choose_option"] = "Choose an Option";
$lang["import"]["form"]["error_message"]["small_note_confirm_email"] = "Note: These contacts will need to confirm their email subscriptions before they can start receiving campaigns.";
$lang["view"]["button"]["button_contacts_limit"] = "Contacts Limit:";
$lang["view"]["contacts_details"]["json_data"] = "JSON browser support is required for this demo.";
$lang["timeline"]["title"] = "Subscriber Timeline";
$lang["timeline"]["description"] = "View the subscriber's timeline and track their engagement history.";
$lang["not_found"] = "Contact not found";

// Override File Check
$file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "override.php";
if (file_exists($file)) {
    include $file;
}

return $lang;
