<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         $user = \App\Models\Permission::where('default_title','User Management')->where('route_type','api')->first();
        if(!is_null($user)) {
            if(!\App\Models\Permission::where('route_type','api')->where('route','getUser')->exists())
                addChildPermission('Get User', '1', 'api', '0', '0', 'super_admin', '1', 'getUser', $user->id);
            if(!\App\Models\Permission::where('route_type','api')->where('route','getUsers')->exists())
                addChildPermission('Get Users', '1', 'api', '0', '0', 'super_admin', '1', 'getUsers', $user->id);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
