<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $profile_field_parent = addParentPermission('Profile Fields','1','api','0','0','super_admin','10000','0');
        if(!is_null($profile_field_parent))
            addChildPermission('Add Profile Field', '1', 'api', '0', '0', 'super_admin', '1', 'addProfileField', $profile_field_parent->id);
            addChildPermission('Update Profile Field', '1', 'api', '0', '0', 'super_admin', '2', 'updateProfileField', $profile_field_parent->id);
            addChildPermission('Get Profile Fields', '1', 'api', '0', '0', 'super_admin', '3', 'getProfileFields', $profile_field_parent->id);
            addChildPermission('Get Profile Field', '1', 'api', '0', '0', 'super_admin', '4', 'getProfileField', $profile_field_parent->id);
            addChildPermission('Delete Profile Fields', '1', 'api', '0', '0', 'super_admin', '5', 'deleteProfileFields', $profile_field_parent->id);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $profile_field_parent = \App\Models\Permission::where('default_title','Profile Fields')->where('route_type','api')->first();
        if(!is_null($profile_field_parent)){
            \App\Models\Permission::where('parent_id',$profile_field_parent->id)->delete();
            $profile_field_parent->delete();
        }
    }
};
