<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $broadcast_parent = \App\Models\Permission::where('default_title','Broadcast Management')->where('route_type','api')->first();
        if(!is_null($broadcast_parent))
            addChildPermission('Send Template', '1', 'api', '0', '0', 'all', '11', 'sendTemplateViaAPI', $broadcast_parent->id);

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        \App\Models\Permission::where('route_type','api')
            ->where('route','sendTemplateViaAPI')
            ->delete();
    }
};
